/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.FloorRenderer;
import mindustry.graphics.Shaders;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.power.PowerNode;

public class BlockRenderer {
    public static final int crackRegions = 8;
    public static final int maxCrackSize = 7;
    public static boolean drawQuadtreeDebug = false;
    public static final Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.71f);
    public static final Color blendShadowColor = Color.white.cpy().lerp(Color.black, BlockRenderer.shadowColor.a);
    private static final int initialRequests = 1024;
    public final FloorRenderer floor = new FloorRenderer();
    public TextureRegion[][] cracks;
    private Seq<Tile> tileview = new Seq(false, 1024, Tile.class);
    private Seq<Tile> lightview = new Seq(false, 1024, Tile.class);
    private Seq<Floor.UpdateRenderState> updateFloors = new Seq(Floor.UpdateRenderState.class);
    private boolean hadMapLimit;
    private int lastCamX;
    private int lastCamY;
    private int lastRangeX;
    private int lastRangeY;
    private float brokenFade = 0.0f;
    private FrameBuffer shadows = new FrameBuffer();
    private FrameBuffer dark = new FrameBuffer();
    private Seq<Building> outArray2 = new Seq();
    private Seq<Tile> shadowEvents = new Seq();
    private IntSet darkEvents = new IntSet();
    private IntSet procLinks = new IntSet();
    private IntSet procLights = new IntSet();
    private BlockQuadtree blockTree = new BlockQuadtree(new Rect(0.0f, 0.0f, 1.0f, 1.0f));
    private BlockLightQuadtree blockLightTree = new BlockLightQuadtree(new Rect(0.0f, 0.0f, 1.0f, 1.0f));
    private FloorQuadtree floorTree = new FloorQuadtree(new Rect(0.0f, 0.0f, 1.0f, 1.0f));

    public BlockRenderer() {
        Events.on(EventType.ClientLoadEvent.class, e -> {
            this.cracks = new TextureRegion[7][8];
            for (int size = 1; size <= 7; ++size) {
                for (int i = 0; i < 8; ++i) {
                    this.cracks[size - 1][i] = Core.atlas.find("cracks-" + size + "-" + i);
                }
            }
        });
        Events.on(EventType.WorldLoadEvent.class, event -> this.reload());
        Events.run((Object)EventType.Trigger.newGame, () -> {
            if (this.hadMapLimit && !Vars.state.rules.limitMapArea) {
                this.updateDarkness();
                Vars.renderer.minimap.updateAll();
            }
        });
        Events.on(EventType.TilePreChangeEvent.class, event -> {
            if (this.blockTree == null || this.floorTree == null) {
                return;
            }
            if (this.indexBlock(event.tile)) {
                this.blockTree.remove(event.tile);
                this.blockLightTree.remove(event.tile);
            }
            if (this.indexFloor(event.tile)) {
                this.floorTree.remove(event.tile);
            }
        });
        Events.on(EventType.TileChangeEvent.class, event -> {
            boolean visible;
            boolean bl = visible = event.tile.build == null || !event.tile.build.inFogTo(Vars.player.team());
            if (event.tile.build != null) {
                event.tile.build.wasVisible = visible;
            }
            if (visible) {
                this.shadowEvents.add(event.tile);
            }
            int avgx = (int)(Core.camera.position.x / 8.0f);
            int avgy = (int)(Core.camera.position.y / 8.0f);
            int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 2;
            int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 2;
            if (Math.abs(avgx - event.tile.x) <= rangex && Math.abs(avgy - event.tile.y) <= rangey) {
                this.lastCamX = -99;
                this.lastCamY = -99;
            }
            this.invalidateTile(event.tile);
            this.recordIndex(event.tile);
        });
    }

    public void reload() {
        this.blockTree = new BlockQuadtree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
        this.blockLightTree = new BlockLightQuadtree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
        this.floorTree = new FloorQuadtree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
        this.shadowEvents.clear();
        this.updateFloors.clear();
        this.lastCamX = -99;
        this.lastCamY = -99;
        this.hadMapLimit = Vars.state.rules.limitMapArea;
        ((Texture)this.shadows.getTexture()).setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
        this.shadows.resize(Vars.world.width(), Vars.world.height());
        this.shadows.begin();
        Core.graphics.clear(Color.white);
        Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
        Draw.color(blendShadowColor);
        for (Tile tile : Vars.world.tiles) {
            this.recordIndex(tile);
            if (tile.floor().updateRender(tile)) {
                this.updateFloors.add(new Floor.UpdateRenderState(tile, tile.floor()));
            }
            if (tile.overlay().updateRender(tile)) {
                this.updateFloors.add(new Floor.UpdateRenderState(tile, tile.overlay()));
            }
            if (!(tile.build == null || tile.team() != Vars.player.team() && Vars.state.rules.fog && (tile.build.visibleFlags & 1L << Vars.player.team().id) == 0L)) {
                tile.build.wasVisible = true;
            }
            if (!tile.block().displayShadow(tile) || tile.build != null && !tile.build.wasVisible) continue;
            Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
        }
        Draw.flush();
        Draw.color();
        this.shadows.end();
        this.updateDarkness();
    }

    public void updateDarkness() {
        this.darkEvents.clear();
        ((Texture)this.dark.getTexture()).setFilter(Texture.TextureFilter.linear);
        this.dark.resize(Vars.world.width(), Vars.world.height());
        this.dark.begin();
        Core.graphics.clear(Vars.state.rules.limitMapArea ? Color.black : Color.white);
        Draw.proj().setOrtho(0.0f, 0.0f, this.dark.getWidth(), this.dark.getHeight());
        if (Vars.state.rules.limitMapArea) {
            Draw.color(Color.white);
            Fill.crect(Vars.state.rules.limitX, Vars.state.rules.limitY, Vars.state.rules.limitWidth, Vars.state.rules.limitHeight);
        }
        for (Tile tile : Vars.world.tiles) {
            float darkness;
            if (Vars.state.rules.limitMapArea && !Rect.contains(Vars.state.rules.limitX, Vars.state.rules.limitY, Vars.state.rules.limitWidth - 1, Vars.state.rules.limitHeight - 1, tile.x, tile.y) || !((darkness = Vars.world.getDarkness(tile.x, tile.y)) > 0.0f)) continue;
            float dark = 1.0f - Math.min((darkness + 0.5f) / 4.0f, 1.0f);
            Draw.colorl(dark);
            Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
        }
        Draw.flush();
        Draw.color();
        this.dark.end();
    }

    public void invalidateTile(Tile tile) {
        int avgx = (int)(Core.camera.position.x / 8.0f);
        int avgy = (int)(Core.camera.position.y / 8.0f);
        int rangex = (int)(Core.camera.width / 8.0f / 2.0f) + 3;
        int rangey = (int)(Core.camera.height / 8.0f / 2.0f) + 3;
        if (Math.abs(avgx - tile.x) <= rangex && Math.abs(avgy - tile.y) <= rangey) {
            this.lastCamX = -99;
            this.lastCamY = -99;
        }
    }

    public FrameBuffer getShadowBuffer() {
        return this.shadows;
    }

    public void removeFloorIndex(Tile tile) {
        if (this.indexFloor(tile)) {
            this.floorTree.remove(tile);
        }
    }

    public void addFloorIndex(Tile tile) {
        if (this.indexFloor(tile)) {
            this.floorTree.insert(tile);
        }
    }

    boolean indexBlock(Tile tile) {
        Block block = tile.block();
        return tile.isCenter() && block != Blocks.air && block.cacheLayer == CacheLayer.normal;
    }

    boolean indexFloor(Tile tile) {
        return tile.block() == Blocks.air && tile.floor().emitLight && Vars.world.getDarkness(tile.x, tile.y) < 3.0f;
    }

    void recordIndex(Tile tile) {
        if (this.indexBlock(tile)) {
            this.blockTree.insert(tile);
            this.blockLightTree.insert(tile);
        }
        if (this.indexFloor(tile)) {
            this.floorTree.insert(tile);
        }
    }

    public void recacheWall(Tile tile) {
        for (int cx = tile.x - 4; cx <= tile.x + 4; ++cx) {
            for (int cy = tile.y - 4; cy <= tile.y + 4; ++cy) {
                Tile other = Vars.world.tile(cx, cy);
                if (other == null) continue;
                this.darkEvents.add(other.pos());
                this.floor.recacheTile(other);
            }
        }
    }

    public void checkChanges() {
        this.darkEvents.each(pos -> {
            Tile tile = Vars.world.tile(pos);
            if (tile != null && tile.block().fillsTile) {
                tile.data = Vars.world.getWallDarkness(tile);
            }
        });
    }

    public void drawDarkness() {
        if (!this.darkEvents.isEmpty()) {
            Draw.flush();
            this.dark.begin();
            Draw.proj().setOrtho(0.0f, 0.0f, this.dark.getWidth(), this.dark.getHeight());
            this.darkEvents.each(pos -> {
                Tile tile = Vars.world.tile(pos);
                if (tile == null) {
                    return;
                }
                float darkness = Vars.world.getDarkness(tile.x, tile.y);
                Draw.colorl(darkness <= 0.0f ? 1.0f : 1.0f - Math.min((darkness + 0.5f) / 4.0f, 1.0f));
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            });
            Draw.flush();
            Draw.color();
            this.dark.end();
            this.darkEvents.clear();
            Draw.proj(Core.camera);
        }
        Draw.shader(Shaders.darkness);
        Draw.fbo((Texture)this.dark.getTexture(), Vars.world.width(), Vars.world.height(), 8, 4.0f);
        Draw.shader();
    }

    public void drawDestroyed() {
        if (!Core.settings.getBool("destroyedblocks")) {
            return;
        }
        this.brokenFade = Vars.control.input.isPlacing() || Vars.control.input.isBreaking() || Vars.control.input.isRebuildSelecting() && !Core.scene.hasKeyboard() ? Mathf.lerpDelta(this.brokenFade, 1.0f, 0.1f) : Mathf.lerpDelta(this.brokenFade, 0.0f, 0.1f);
        if (this.brokenFade > 0.001f) {
            for (Teams.BlockPlan block : Vars.player.team().data().plans) {
                Block b = block.block;
                if (!Core.camera.bounds(Tmp.r1).grow(16.0f).overlaps(Tmp.r2.setSize(b.size * 8).setCenter((float)(block.x * 8) + b.offset, (float)(block.y * 8) + b.offset))) continue;
                Draw.alpha(0.33f * this.brokenFade);
                Draw.mixcol(Color.white, 0.2f + Mathf.absin(Time.globalTime, 6.0f, 0.2f));
                Draw.rect(b.fullIcon, (float)(block.x * 8) + b.offset, (float)(block.y * 8) + b.offset, b.rotate ? (float)(block.rotation * 90) : 0.0f);
            }
            Draw.reset();
        }
    }

    public void processShadows() {
        if (Core.settings.getInt("blockRenderLevel") == 0) {
            return;
        }
        if (!this.shadowEvents.isEmpty()) {
            Draw.flush();
            this.shadows.begin();
            Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
            for (Tile tile : this.shadowEvents) {
                if (tile == null) continue;
                Draw.color(!tile.block().displayShadow(tile) || Vars.state.rules.fog && tile.build != null && !tile.build.wasVisible ? Color.white : blendShadowColor);
                Fill.rect((float)tile.x + 0.5f, (float)tile.y + 0.5f, 1.0f, 1.0f);
            }
            Draw.flush();
            Draw.color();
            this.shadows.end();
            this.shadowEvents.clear();
            Draw.proj(Core.camera);
        }
    }

    public void drawShadows() {
        this.processShadows();
        float ww = Vars.world.width() * 8;
        float wh = Vars.world.height() * 8;
        float x = Core.camera.position.x + 4.0f;
        float y = Core.camera.position.y + 4.0f;
        float u = (x - Core.camera.width / 2.0f) / ww;
        float v = (y - Core.camera.height / 2.0f) / wh;
        float u2 = (x + Core.camera.width / 2.0f) / ww;
        float v2 = (y + Core.camera.height / 2.0f) / wh;
        Tmp.tr1.set((Texture)this.shadows.getTexture());
        Tmp.tr1.set(u, v2, u2, v);
        Draw.shader(Shaders.darkness);
        Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        Draw.shader();
    }

    public void processBlocks() {
        int avgx = (int)(Core.camera.position.x / 8.0f);
        int avgy = (int)(Core.camera.position.y / 8.0f);
        int rangex = (int)(Core.camera.width / 8.0f / 2.0f);
        int rangey = (int)(Core.camera.height / 8.0f / 2.0f);
        if (!Vars.state.isPaused()) {
            int updates = this.updateFloors.size;
            Floor.UpdateRenderState[] uitems = (Floor.UpdateRenderState[])this.updateFloors.items;
            for (int i = 0; i < updates; ++i) {
                Floor.UpdateRenderState tile2 = uitems[i];
                tile2.floor.renderUpdate(tile2);
            }
        }
        if (avgx == this.lastCamX && avgy == this.lastCamY && this.lastRangeX == rangex && this.lastRangeY == rangey) {
            return;
        }
        this.tileview.clear();
        this.lightview.clear();
        this.procLinks.clear();
        this.procLights.clear();
        Rect bounds = Core.camera.bounds(Tmp.r3).grow(16.0f);
        this.floorTree.intersect(bounds, this.lightview::add);
        this.blockLightTree.intersect(bounds, tile -> {
            if (tile.block().emitLight && (tile.build == null || this.procLights.add(tile.build.pos()))) {
                this.lightview.add((Tile)tile);
            }
        });
        this.blockTree.intersect(bounds, tile -> {
            if (tile.build == null || this.procLinks.add(tile.build.id)) {
                this.tileview.add((Tile)tile);
            }
            if (tile.build != null && tile.build.power != null && tile.build.power.links.size > 0) {
                for (Building other : tile.build.getPowerConnections(this.outArray2)) {
                    if (!(other.block instanceof PowerNode) || !this.procLinks.add(other.id)) continue;
                    this.tileview.add(other.tile);
                }
            }
        });
        this.lastCamX = avgx;
        this.lastCamY = avgy;
        this.lastRangeX = rangex;
        this.lastRangeY = rangey;
    }

    void drawTree(QuadTree<Tile> tree) {
        Draw.color(Color.blue);
        Lines.rect(tree.bounds);
        Draw.color(Color.green);
        for (Tile tile : tree.objects) {
            Block block = tile.block();
            Tmp.r1.setCentered(tile.worldx() + block.offset, tile.worldy() + block.offset, block.clipSize, block.clipSize);
            Lines.rect(Tmp.r1);
        }
        if (!tree.leaf) {
            this.drawTree(tree.botLeft);
            this.drawTree(tree.botRight);
            this.drawTree(tree.topLeft);
            this.drawTree(tree.topRight);
        }
        Draw.reset();
    }

    public void drawBlocks() {
        Tile tile2;
        int i;
        if (Core.settings.getInt("blockRenderLevel") == 0) {
            return;
        }
        Team pteam = Vars.player.team();
        this.drawDestroyed();
        for (i = 0; i < this.tileview.size; ++i) {
            boolean visible;
            tile2 = ((Tile[])this.tileview.items)[i];
            Block block = tile2.block();
            Building build = tile2.build;
            Draw.z(30.0f);
            boolean bl = visible = build == null || !build.inFogTo(pteam);
            if (block != Blocks.air && (visible || build.wasVisible)) {
                if (Core.settings.getInt("blockRenderLevel") > 1) {
                    block.drawBase(tile2);
                }
                Draw.reset();
                Draw.z(30.0f);
                if (block.customShadow) {
                    Draw.z(29.0f);
                    block.drawShadow(tile2);
                    Draw.z(30.0f);
                }
                if (build != null) {
                    if (visible) {
                        build.visibleFlags |= 1L << pteam.id;
                        if (!build.wasVisible) {
                            build.wasVisible = true;
                            this.updateShadow(build);
                            Vars.renderer.minimap.update(tile2);
                        }
                    }
                    if (build.damaged()) {
                        Draw.z(30.1f);
                        build.drawCracks();
                        Draw.z(30.0f);
                    }
                    if (Vars.renderer.drawBars) {
                        build.drawBars();
                        Draw.z(30.0f);
                    }
                    if (build.team != pteam && build.block.drawTeamOverlay) {
                        build.drawTeam();
                        Draw.z(30.0f);
                    }
                    if (Vars.renderer.drawStatus && block.hasConsumers && ARCVars.arcInfoControl(build.team).booleanValue()) {
                        build.drawStatus();
                    }
                    if (Core.settings.getBool("blockdisabled") && ARCVars.arcInfoControl(build.team).booleanValue() && !build.enabled) {
                        build.drawDisabled();
                    }
                }
                Draw.reset();
                continue;
            }
            if (visible) continue;
        }
        if (Vars.renderer.lights.enabled()) {
            for (i = 0; i < this.lightview.size; ++i) {
                tile2 = ((Tile[])this.lightview.items)[i];
                Building entity = tile2.build;
                if (entity != null) {
                    entity.drawLight();
                    continue;
                }
                if (tile2.block().emitLight) {
                    tile2.block().drawEnvironmentLight(tile2);
                    continue;
                }
                if (!tile2.floor().emitLight || tile2.block() != Blocks.air) continue;
                tile2.floor().drawEnvironmentLight(tile2);
            }
        }
        if (drawQuadtreeDebug) {
            Draw.z(120.0f);
            Lines.stroke(1.0f, Color.green);
            this.blockTree.intersect(Core.camera.bounds(Tmp.r1), tile -> Lines.rect(tile.getHitbox(Tmp.r2)));
            Draw.reset();
        }
    }

    public void updateShadow(Building build) {
        if (build.tile == null) {
            return;
        }
        int size = build.block.size;
        int of = build.block.sizeOffset;
        short tx = build.tile.x;
        short ty = build.tile.y;
        for (int x = 0; x < size; ++x) {
            for (int y = 0; y < size; ++y) {
                this.shadowEvents.add(Vars.world.tile(x + tx + of, y + ty + of));
            }
        }
    }

    public void updateShadowTile(Tile tile) {
        this.shadowEvents.add(tile);
    }

    static class BlockQuadtree
    extends QuadTree<Tile> {
        public BlockQuadtree(Rect bounds) {
            super(bounds);
        }

        @Override
        public void hitbox(Tile tile) {
            Block block = tile.block();
            this.tmp.setCentered(tile.worldx() + block.offset, tile.worldy() + block.offset, block.clipSize, block.clipSize);
        }

        @Override
        protected QuadTree<Tile> newChild(Rect rect) {
            return new BlockQuadtree(rect);
        }
    }

    static class BlockLightQuadtree
    extends QuadTree<Tile> {
        public BlockLightQuadtree(Rect bounds) {
            super(bounds);
        }

        @Override
        public void hitbox(Tile tile) {
            Block block = tile.block();
            this.tmp.setCentered(tile.worldx() + block.offset, tile.worldy() + block.offset, block.lightClipSize, block.lightClipSize);
        }

        @Override
        protected QuadTree<Tile> newChild(Rect rect) {
            return new BlockLightQuadtree(rect);
        }
    }

    static class FloorQuadtree
    extends QuadTree<Tile> {
        public FloorQuadtree(Rect bounds) {
            super(bounds);
        }

        @Override
        public void hitbox(Tile tile) {
            Floor floor = tile.floor();
            this.tmp.setCentered(tile.worldx(), tile.worldy(), floor.lightClipSize, floor.lightClipSize);
        }

        @Override
        protected QuadTree<Tile> newChild(Rect rect) {
            return new FloorQuadtree(rect);
        }
    }
}

