/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class UnitControlCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Unit unit;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server() || ARCVars.replayController.writing) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeUnit(WRITE, this.unit);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.unit = TypeIO.readUnit(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.unitControl(player, this.unit);
        Call.unitControl__forward(con, player, this.unit);
    }

    @Override
    public void handleClient() {
        InputHandler.unitControl(this.player, this.unit);
    }
}

