/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.world.Tile;

public class TileTapCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Tile tile;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server() || ARCVars.replayController.writing) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeTile(WRITE, this.tile);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.tile = TypeIO.readTile(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.tileTap(player, this.tile);
    }

    @Override
    public void handleClient() {
        InputHandler.tileTap(this.player, this.tile);
    }
}

