/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.ui.fragments.HudFragment;

public class SetPlayerTeamEditorCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public Team team;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server() || ARCVars.replayController.writing) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeTeam(WRITE, this.team);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.team = TypeIO.readTeam(READ);
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        HudFragment.setPlayerTeamEditor(player, this.team);
        Call.setPlayerTeamEditor__forward(con, player, this.team);
    }

    @Override
    public void handleClient() {
        HudFragment.setPlayerTeamEditor(this.player, this.team);
    }
}

