/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Player;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class RequestDropPayloadCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public float x;
    public float y;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server() || ARCVars.replayController.writing) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        WRITE.f(this.x);
        WRITE.f(this.y);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.x = READ.f();
        this.y = READ.f();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.requestDropPayload(player, this.x, this.y);
    }

    @Override
    public void handleClient() {
        InputHandler.requestDropPayload(this.player, this.x, this.y);
    }
}

