/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Scl;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Ratekeeper;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.ai.UnitCommand;
import mindustry.ai.types.CommandAI;
import mindustry.arcModule.ARCEvents;
import mindustry.arcModule.ARCVars;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.EntityGroup;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.IndexableEntity__player;
import mindustry.gen.IndexableEntity__sync;
import mindustry.gen.Nulls;
import mindustry.gen.Payloadc;
import mindustry.gen.Playerc;
import mindustry.gen.Posc;
import mindustry.gen.Syncc;
import mindustry.gen.Timerc;
import mindustry.gen.Unit;
import mindustry.gen.Unitc;
import mindustry.graphics.Drawf;
import mindustry.io.TypeIO;
import mindustry.net.Administration;
import mindustry.net.NetConnection;
import mindustry.net.Packets;
import mindustry.ui.Fonts;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.storage.CoreBlock;

public class Player
implements Drawc,
Entityc,
IndexableEntity__all,
IndexableEntity__draw,
IndexableEntity__player,
IndexableEntity__sync,
Playerc,
Posc,
Syncc,
Timerc {
    public static final float deathDelay = 60.0f;
    protected transient boolean added;
    public boolean admin;
    public boolean boosting;
    public Color color = new Color();
    @Nullable
    public transient NetConnection con;
    public transient float deathTimer;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__draw = -1;
    protected transient int index__player = -1;
    protected transient int index__sync = -1;
    public transient Ratekeeper itemDepositRate = new Ratekeeper();
    @Nullable
    public transient Unit justSwitchFrom;
    @Nullable
    public transient Unit justSwitchTo;
    @Nullable
    public UnitCommand lastCommand;
    protected transient Unit lastReadUnit = Nulls.unit;
    public transient String lastText = "";
    public transient long lastUpdated;
    public transient String locale = "en";
    public float mouseX;
    public float mouseY;
    public String name = "frog";
    public boolean shooting;
    protected Team team = Team.sharded;
    public transient float textFadeTime;
    public transient Interval timer = new Interval(6);
    public boolean typing;
    protected Unit unit = Nulls.unit;
    public transient long updateSpacing;
    protected transient int wrongReadUnits;
    public float x;
    private transient float x_LAST_;
    private transient float x_TARGET_;
    public float y;
    private transient float y_LAST_;
    private transient float y_TARGET_;

    protected Player() {
    }

    @Override
    @Nullable
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild bestCore() {
        Seq<CoreBlock.CoreBuild> cores = this.team.cores();
        return cores.min(b -> cores.size == 1 || ((CoreBlock)b.block).unitType.supportsEnv(Vars.state.rules.env), Structs.comps(Structs.comparingInt(c -> -c.block.size), Structs.comparingFloat(c -> c.dst2(this.x, this.y))));
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Override
    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    @Override
    public Unit justSwitchFrom() {
        return this.justSwitchFrom;
    }

    @Override
    public Unit justSwitchTo() {
        return this.justSwitchTo;
    }

    @Override
    public Color color() {
        return this.color;
    }

    @Override
    public Interval timer() {
        return this.timer;
    }

    @Override
    public Ratekeeper itemDepositRate() {
        return this.itemDepositRate;
    }

    @Override
    public boolean admin() {
        return this.admin;
    }

    @Override
    public boolean boosting() {
        return this.boosting;
    }

    @Override
    public boolean shooting() {
        return this.shooting;
    }

    @Override
    public boolean typing() {
        return this.typing;
    }

    @Override
    public float deathTimer() {
        return this.deathTimer;
    }

    @Override
    public float mouseX() {
        return this.mouseX;
    }

    @Override
    public float mouseY() {
        return this.mouseY;
    }

    @Override
    public float textFadeTime() {
        return this.textFadeTime;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 12;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public String lastText() {
        return this.lastText;
    }

    @Override
    public String locale() {
        return this.locale;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        return "Player#" + this.id;
    }

    @Override
    public long lastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public long updateSpacing() {
        return this.updateSpacing;
    }

    @Override
    public UnitCommand lastCommand() {
        return this.lastCommand;
    }

    @Override
    public Team team() {
        return this.team;
    }

    @Override
    public NetConnection con() {
        return this.con;
    }

    @Override
    public void admin(boolean admin) {
        this.admin = admin;
    }

    @Override
    public void boosting(boolean boosting) {
        this.boosting = boosting;
    }

    @Override
    public void color(Color color) {
        this.color = color;
    }

    @Override
    public void con(NetConnection con) {
        this.con = con;
    }

    @Override
    public void deathTimer(float deathTimer) {
        this.deathTimer = deathTimer;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void itemDepositRate(Ratekeeper itemDepositRate) {
        this.itemDepositRate = itemDepositRate;
    }

    @Override
    public void justSwitchFrom(Unit justSwitchFrom) {
        this.justSwitchFrom = justSwitchFrom;
    }

    @Override
    public void justSwitchTo(Unit justSwitchTo) {
        this.justSwitchTo = justSwitchTo;
    }

    @Override
    public void lastCommand(UnitCommand lastCommand) {
        this.lastCommand = lastCommand;
    }

    @Override
    public void lastText(String lastText) {
        this.lastText = lastText;
    }

    @Override
    public void lastUpdated(long lastUpdated) {
        this.lastUpdated = lastUpdated;
    }

    @Override
    public void locale(String locale) {
        this.locale = locale;
    }

    @Override
    public void mouseX(float mouseX) {
        this.mouseX = mouseX;
    }

    @Override
    public void mouseY(float mouseY) {
        this.mouseY = mouseY;
    }

    @Override
    public void name(String name) {
        this.name = name;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    @Override
    public void setIndex__player(int index) {
        this.index__player = index;
    }

    @Override
    public void setIndex__sync(int index) {
        this.index__sync = index;
    }

    @Override
    public void shooting(boolean shooting) {
        this.shooting = shooting;
    }

    @Override
    public void textFadeTime(float textFadeTime) {
        this.textFadeTime = textFadeTime;
    }

    @Override
    public void timer(Interval timer) {
        this.timer = timer;
    }

    @Override
    public void typing(boolean typing) {
        this.typing = typing;
    }

    @Override
    public void updateSpacing(long updateSpacing) {
        this.updateSpacing = updateSpacing;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public void read(Reads read) {
        short REV = read.s();
        if (REV == 0) {
            this.admin = read.bool();
            this.boosting = read.bool();
            this.color = TypeIO.readColor(read, this.color);
            this.mouseX = read.f();
            this.mouseY = read.f();
            this.name = TypeIO.readString(read);
            this.shooting = read.bool();
            this.team = TypeIO.readTeam(read);
            this.typing = read.bool();
            this.unit = TypeIO.readUnit(read);
            this.x = read.f();
            this.y = read.f();
        } else if (REV == 1) {
            this.admin = read.bool();
            this.boosting = read.bool();
            this.color = TypeIO.readColor(read, this.color);
            this.lastCommand = TypeIO.readCommand(read);
            this.mouseX = read.f();
            this.mouseY = read.f();
            this.name = TypeIO.readString(read);
            this.shooting = read.bool();
            this.team = TypeIO.readTeam(read);
            this.typing = read.bool();
            this.unit = TypeIO.readUnit(read);
            this.x = read.f();
            this.y = read.f();
        } else {
            throw new IllegalArgumentException("Unknown revision '" + REV + "' for entity type 'PlayerComp'");
        }
        this.afterRead();
    }

    @Override
    public void write(Writes write) {
        write.s(1);
        write.bool(this.admin);
        write.bool(this.boosting);
        TypeIO.writeColor(write, this.color);
        TypeIO.writeCommand(write, this.lastCommand);
        write.f(this.mouseX);
        write.f(this.mouseY);
        TypeIO.writeString(write, this.name);
        write.bool(this.shooting);
        TypeIO.writeTeam(write, this.team);
        write.bool(this.typing);
        TypeIO.writeUnit(write, this.unit);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public Unit unit() {
        return this.unit;
    }

    @Override
    public TextureRegion icon() {
        if (this.dead()) {
            if (this.core() == null) {
                return UnitTypes.alpha.uiIcon;
            }
            CoreBlock.CoreBuild bestCore = this.bestCore();
            if (bestCore == null) {
                return UnitTypes.alpha.uiIcon;
            }
            return ((CoreBlock)bestCore.block).unitType.uiIcon;
        }
        return this.unit.icon();
    }

    @Override
    public boolean dead() {
        return this.unit.isNull() || !this.unit.isValid();
    }

    @Override
    public boolean displayAmmo() {
        return this.unit instanceof BlockUnitc || Vars.state.rules.unitAmmo;
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isBuilder() {
        return this.unit.canBuild();
    }

    @Override
    public boolean isLocal() {
        Unitc u;
        Player player;
        return this == Vars.player || (player = this) instanceof Unitc && (u = (Unitc)((Object)player)).controller() == Vars.player;
    }

    @Override
    public boolean isLogicControllable() {
        return false;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        Player player = this;
        return player instanceof Unitc && (u = (Unitc)((Object)player)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean isSyncHidden(Player player) {
        return false;
    }

    @Override
    public boolean isValidController() {
        return this.isAdded();
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return false;
    }

    @Override
    public boolean timer(int index, float time) {
        if (Float.isInfinite(time)) {
            return false;
        }
        return this.timer.get(index, time);
    }

    @Override
    public float clipSize() {
        return this.unit.isNull() ? 20.0f : this.unit.type.hitSize * 2.0f;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public String coloredName() {
        return "[#" + this.color.toString().toUpperCase() + "]" + this.name;
    }

    @Override
    public String ip() {
        return this.con == null ? "localhost" : this.con.address;
    }

    @Override
    public String plainName() {
        return Strings.stripColors(this.name);
    }

    @Override
    public String usid() {
        return this.con == null ? "[LOCAL]" : this.con.usid;
    }

    @Override
    public String uuid() {
        return this.con == null ? "[LOCAL]" : this.con.uuid;
    }

    @Override
    public Administration.PlayerInfo getInfo() {
        if (this.isLocal()) {
            throw new IllegalArgumentException("Local players cannot be traced and do not have info.");
        }
        return Vars.netServer.admins.getInfo(this.uuid());
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    public static Player create() {
        return new Player();
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__player = Groups.player.addIndex(this);
        this.index__sync = Groups.sync.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.added = true;
        Events.fire(new ARCEvents.PlayerJoin(this));
    }

    @Override
    public void afterRead() {
    }

    @Override
    public void afterReadAll() {
    }

    @Override
    public void afterSync() {
        if (this.isLocal() && this.unit == this.justSwitchFrom && this.justSwitchFrom != null && this.justSwitchTo != null) {
            this.unit = this.justSwitchTo;
            if (++this.wrongReadUnits >= 2) {
                this.justSwitchFrom = null;
                this.wrongReadUnits = 0;
            }
        } else {
            this.justSwitchFrom = null;
            this.justSwitchTo = null;
            this.wrongReadUnits = 0;
        }
        Unit set = this.unit;
        this.unit = this.lastReadUnit;
        this.unit(set);
        this.lastReadUnit = this.unit;
        this.unit.aim(this.mouseX, this.mouseY);
        this.unit.controlWeapons(this.shooting, this.shooting);
        this.unit.controller(this);
    }

    @Override
    public void beforeWrite() {
    }

    @Override
    public void buildDestroyedBlocks() {
        if (this.unit.canBuild()) {
            int count = 0;
            for (Teams.BlockPlan plan : Vars.player.team().data().plans) {
                if (!this.within(plan.x * 8, plan.y * 8, 220.0f)) continue;
                this.unit.addBuild(new BuildPlan(plan.x, plan.y, plan.rotation, plan.block, plan.config));
                if (++count < 255) continue;
                break;
            }
        }
    }

    @Override
    public void checkSpawn() {
        CoreBlock.CoreBuild core = this.bestCore();
        if (core != null) {
            core.requestSpawn(this);
        }
    }

    @Override
    public void clearUnit() {
        this.unit(Nulls.unit);
    }

    @Override
    public void draw() {
        if (this.unit != null && this.name != null && !this.unit.inFogTo(Vars.player.team())) {
            Unit unit;
            if (ARCVars.payloadPreview && this.isLocal() && (unit = this.unit) instanceof Payloadc) {
                Payloadc pay = (Payloadc)((Object)unit);
                Draw.z(150.0f);
                Lines.stroke(1.0f);
                Unit res = Units.closest(this.team, this.x, this.y, this.unit.type.hitSize * 2.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(this.unit, u.hitSize + this.unit.hitSize));
                if (res != null) {
                    Draw.color(Tmp.c1.set(Color.acid).a(0.5f));
                    Lines.square(res.x, res.y, res.type.hitSize, 20.0f);
                } else {
                    Tile tileOn = this.tileOn();
                    if (tileOn != null) {
                        if (tileOn.build != null) {
                            Draw.color(Tmp.c1.set(Color.green).a(0.5f));
                            Lines.square(tileOn.build.x, tileOn.build.y, (float)(tileOn.build.block.size * 8) * 0.9f, 20.0f);
                        } else {
                            Draw.color(Tmp.c1.set(Color.lime).a(0.5f));
                            Lines.square(tileOn.worldx(), tileOn.worldy(), 5.0f, 20.0f);
                        }
                    }
                }
            }
            if (!ARCVars.arcHideName) {
                Draw.z(150.0f);
                float z = Drawf.text();
                Font font = Fonts.outline;
                GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
                float nameHeight = 11.0f;
                float textHeight = 15.0f;
                boolean ints = font.usesIntegerPositions();
                font.setUseIntegerPositions(false);
                font.getData().setScale(0.25f / Scl.scl(1.0f));
                layout.setText(font, this.name);
                if (ARCVars.arcSelfName || !this.isLocal()) {
                    Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
                    Fill.rect(this.unit.x, this.unit.y + 11.0f - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
                    Draw.color();
                    font.setColor(this.color);
                    font.draw(this.name, this.unit.x, this.unit.y + 11.0f, 0.0f, 1, false);
                    if (this.admin) {
                        float s = 3.0f;
                        Draw.color(this.color.r * 0.5f, this.color.g * 0.5f, this.color.b * 0.5f, 1.0f);
                        Draw.rect(Icon.adminSmall.getRegion(), this.unit.x + layout.width / 2.0f + 2.0f + 1.0f, this.unit.y + 11.0f - 1.5f, s, s);
                        Draw.color(this.color);
                        Draw.rect(Icon.adminSmall.getRegion(), this.unit.x + layout.width / 2.0f + 2.0f + 1.0f, this.unit.y + 11.0f - 1.0f, s, s);
                    }
                }
                if (Core.settings.getBool("playerchat") && (this.textFadeTime > 0.0f && this.lastText != null || this.typing)) {
                    String text = this.textFadeTime <= 0.0f || this.lastText == null ? "[lightgray]" + Strings.animated(Time.time, 4, 15.0f, ".") : this.lastText;
                    float width = 100.0f;
                    float visualFadeTime = 1.0f - Mathf.curve(1.0f - this.textFadeTime, 0.9f);
                    font.setColor(1.0f, 1.0f, 1.0f, this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime);
                    layout.setText(font, text, Color.white, width, 4, true);
                    Draw.color(0.0f, 0.0f, 0.0f, 0.3f * (this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime));
                    Fill.rect(this.unit.x, this.unit.y + 15.0f + layout.height - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
                    font.draw(text, this.unit.x - width / 2.0f, this.unit.y + 15.0f + layout.height, width, 1, true);
                }
                Draw.reset();
                Pools.free(layout);
                font.getData().setScale(1.0f);
                font.setColor(Color.white);
                font.setUseIntegerPositions(ints);
                Draw.z(z);
            }
        }
    }

    @Override
    public void dropItems() {
        if (Vars.state.rules.mode() == Gamemode.pvp || Vars.player.unit() == null || Vars.player.unit().stack.amount <= 0) {
            return;
        }
        Vars.indexer.eachBlock(Vars.player.team(), Vars.player.x, Vars.player.y, 220.0f, build -> build.acceptStack(Vars.player.unit().item(), Vars.player.unit().stack.amount, Vars.player.unit()) > 0 && (build.block instanceof BaseTurret || build.block instanceof GenericCrafter), build -> Call.transferInventory(Vars.player, build));
    }

    @Override
    public void handleSyncHidden() {
    }

    @Override
    public void interpolate() {
        if (this.lastUpdated != 0L && this.updateSpacing != 0L) {
            float timeSinceUpdate = Time.timeSinceMillis(this.lastUpdated);
            float alpha = Math.min(timeSinceUpdate / (float)this.updateSpacing, 2.0f);
            this.x = Mathf.lerp(this.x_LAST_, this.x_TARGET_, alpha);
            this.y = Mathf.lerp(this.y_LAST_, this.y_TARGET_, alpha);
        } else if (this.lastUpdated != 0L) {
            this.x = this.x_TARGET_;
            this.y = this.y_TARGET_;
        }
    }

    @Override
    public void kick(String reason) {
        this.con.kick(reason);
    }

    @Override
    public void kick(String reason, long duration) {
        this.con.kick(reason, duration);
    }

    @Override
    public void kick(Packets.KickReason reason) {
        this.con.kick(reason);
    }

    @Override
    public void kick(Packets.KickReason reason, long duration) {
        this.con.kick(reason, duration);
    }

    @Override
    public void readSync(Reads read) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        boolean islocal = this.isLocal();
        this.admin = read.bool();
        if (!islocal) {
            this.boosting = read.bool();
        } else {
            read.bool();
        }
        this.color = TypeIO.readColor(read, this.color);
        if (!islocal) {
            this.mouseX = read.f();
        } else {
            read.f();
        }
        if (!islocal) {
            this.mouseY = read.f();
        } else {
            read.f();
        }
        this.name = TypeIO.readString(read);
        if (!islocal) {
            this.shooting = read.bool();
        } else {
            read.bool();
        }
        this.team = TypeIO.readTeam(read);
        if (!islocal) {
            this.typing = read.bool();
        } else {
            read.bool();
        }
        this.unit = TypeIO.readUnit(read);
        if (!islocal) {
            this.x_LAST_ = this.x;
            this.x_TARGET_ = read.f();
        } else {
            read.f();
            this.x_LAST_ = this.x;
            this.x_TARGET_ = this.x;
        }
        if (!islocal) {
            this.y_LAST_ = this.y;
            this.y_TARGET_ = read.f();
        } else {
            read.f();
            this.y_LAST_ = this.y;
            this.y_TARGET_ = this.y;
        }
        this.afterSync();
    }

    @Override
    public void readSyncManual(FloatBuffer buffer) {
        if (this.lastUpdated != 0L) {
            this.updateSpacing = Time.timeSinceMillis(this.lastUpdated);
        }
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = buffer.get();
        this.y_LAST_ = this.y;
        this.y_TARGET_ = buffer.get();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.player.removeIndex(this, this.index__player);
        this.index__player = -1;
        Groups.sync.removeIndex(this, this.index__sync);
        this.index__sync = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        this.added = false;
        if (!this.unit.isNull()) {
            this.clearUnit();
        }
        Events.fire(new ARCEvents.PlayerLeave(this));
        this.lastReadUnit = Nulls.unit;
        this.justSwitchFrom = null;
        this.justSwitchTo = null;
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
    }

    @Override
    public void reset() {
        this.team = Vars.state.rules.defaultTeam;
        this.typing = false;
        this.admin = false;
        this.textFadeTime = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        if (!this.dead()) {
            this.unit.resetController();
            this.unit = Nulls.unit;
        }
    }

    @Override
    public void sendMessage(String text) {
        this.sendMessage(text, null, null);
    }

    @Override
    public void sendMessage(String text, Player from) {
        this.sendMessage(text, from, null);
    }

    @Override
    public void sendMessage(String text, Player from, String unformatted) {
        if (this.isLocal()) {
            if (Vars.ui != null) {
                Vars.ui.chatfrag.addMessage(text);
            }
        } else {
            Call.sendMessage(this.con, text, unformatted, from);
        }
    }

    @Override
    public void sendUnformatted(Player from, String unformatted) {
        this.sendMessage(Vars.netServer.chatFormatter.format(from, unformatted), from, unformatted);
    }

    @Override
    public void sendUnformatted(String unformatted) {
        this.sendUnformatted(null, unformatted);
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void snapInterpolation() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x;
        this.x_TARGET_ = this.x;
        this.y_LAST_ = this.y;
        this.y_TARGET_ = this.y;
    }

    @Override
    public void snapSync() {
        this.updateSpacing = 16L;
        this.lastUpdated = Time.millis();
        this.x_LAST_ = this.x_TARGET_;
        this.x = this.x_TARGET_;
        this.y_LAST_ = this.y_TARGET_;
        this.y = this.y_TARGET_;
    }

    @Override
    public void team(Team team) {
        this.team = team;
        this.unit.team(team);
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void unit(Unit unit) {
        CommandAI ai;
        if (this.isLocal() && unit == this.justSwitchFrom && this.justSwitchFrom != null && this.justSwitchTo != null) {
            return;
        }
        if (unit == null) {
            throw new IllegalArgumentException("Unit cannot be null. Use clearUnit() instead.");
        }
        if (this.unit == unit) {
            return;
        }
        UnitController unitController = unit.controller();
        if (unitController instanceof CommandAI) {
            ai = (CommandAI)unitController;
            this.lastCommand = ai.command;
        }
        if (this.unit != Nulls.unit) {
            this.unit.resetController();
            if (this.lastCommand != null && (unitController = this.unit.controller()) instanceof CommandAI) {
                ai = (CommandAI)unitController;
                ai.command(this.lastCommand);
            }
        }
        this.unit = unit;
        if (unit != Nulls.unit) {
            unit.team(this.team);
            unit.controller(this);
            if (unit.isRemote()) {
                unit.snapInterpolation();
            }
            if (!Vars.headless && this.isLocal()) {
                Vars.control.input.block = null;
            }
        }
        Events.fire(new EventType.UnitChangeEvent(this, unit));
    }

    @Override
    public void update() {
        if (!this.unit.isValid()) {
            this.clearUnit();
        }
        if (!this.dead()) {
            this.set(this.unit);
            this.unit.team(this.team);
            this.deathTimer = 0.0f;
            if (this.unit.type.canBoost) {
                this.unit.elevation = Mathf.approachDelta(this.unit.elevation, this.unit.onSolid() || this.boosting || this.unit.isFlying() && !this.unit.canLand() ? 1.0f : 0.0f, this.unit.type.riseSpeed);
            }
        } else {
            CoreBlock.CoreBuild core = this.bestCore();
            if (core != null) {
                this.deathTimer += Time.delta;
                if (this.deathTimer >= 60.0f) {
                    core.requestSpawn(this);
                    this.deathTimer = 0.0f;
                }
            }
        }
        this.textFadeTime -= Time.delta / 300.0f;
        if (Vars.net.client() && !this.isLocal() || this.isRemote()) {
            this.interpolate();
        }
    }

    @Override
    public void writeSync(Writes write) {
        write.bool(this.admin);
        write.bool(this.boosting);
        TypeIO.writeColor(write, this.color);
        write.f(this.mouseX);
        write.f(this.mouseY);
        TypeIO.writeString(write, this.name);
        write.bool(this.shooting);
        TypeIO.writeTeam(write, this.team);
        write.bool(this.typing);
        TypeIO.writeUnit(write, this.unit);
        write.f(this.x);
        write.f(this.y);
    }

    @Override
    public void writeSyncManual(FloatBuffer buffer) {
        buffer.put(this.x);
        buffer.put(this.y);
    }
}

