/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.math.geom.Vec2;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.input.InputHandler;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;

public class CommandUnitsCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public Player player;
    public int[] unitIds;
    public Building buildTarget;
    public Unit unitTarget;
    public Vec2 posTarget;
    public boolean queueCommand;
    public boolean finalBatch;

    @Override
    public void write(Writes WRITE) {
        if (Vars.net.server() || ARCVars.replayController.writing) {
            TypeIO.writeEntity(WRITE, this.player);
        }
        TypeIO.writeInts(WRITE, this.unitIds);
        TypeIO.writeBuilding(WRITE, this.buildTarget);
        TypeIO.writeUnit(WRITE, this.unitTarget);
        TypeIO.writeVec2(WRITE, this.posTarget);
        WRITE.bool(this.queueCommand);
        WRITE.bool(this.finalBatch);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        if (Vars.net.client()) {
            this.player = (Player)TypeIO.readEntity(READ);
        }
        this.unitIds = TypeIO.readInts(READ);
        this.buildTarget = TypeIO.readBuilding(READ);
        this.unitTarget = TypeIO.readUnit(READ);
        this.posTarget = TypeIO.readVec2(READ);
        this.queueCommand = READ.bool();
        this.finalBatch = READ.bool();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        InputHandler.commandUnits(player, this.unitIds, this.buildTarget, this.unitTarget, this.posTarget, this.queueCommand, this.finalBatch);
        Call.commandUnits__forward(con, player, this.unitIds, this.buildTarget, this.unitTarget, this.posTarget, this.queueCommand, this.finalBatch);
    }

    @Override
    public void handleClient() {
        InputHandler.commandUnits(this.player, this.unitIds, this.buildTarget, this.unitTarget, this.posTarget, this.queueCommand, this.finalBatch);
    }
}

