/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Prov;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import arc.util.Time;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.content.Loadouts;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.SectorInfo;
import mindustry.gen.Call;
import mindustry.maps.SectorDamage;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.Planet;
import mindustry.type.Sector;
import mindustry.world.blocks.storage.CoreBlock;

public class Universe {
    private int seconds;
    private int netSeconds;
    private float secondCounter;
    private int turn;
    public static float turnCounter;
    @Nullable
    private Schematic lastLoadout;
    private ItemSeq lastLaunchResources = new ItemSeq();

    public Universe() {
        this.load();
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            if (!Vars.net.client() && Vars.state.isCampaign()) {
                Vars.state.getSector().planet.updateBaseCoverage();
            }
        });
    }

    public void updateGlobal() {
        for (Planet planet : Vars.content.planets()) {
            if (planet.parent != null) continue;
            this.updatePlanet(planet);
        }
    }

    public int turn() {
        return this.turn;
    }

    private void updatePlanet(Planet planet) {
        planet.position.setZero();
        planet.addParentOffset(planet.position);
        if (planet.parent != null) {
            planet.position.add(planet.parent.position);
        }
        for (Planet child : planet.children) {
            this.updatePlanet(child);
        }
    }

    public void update() {
        if (!Vars.net.client()) {
            this.secondCounter += Time.delta / 60.0f;
            if ((turnCounter += Time.delta) >= 7200.0f) {
                turnCounter = 0.0f;
                this.runTurn();
            }
            if (this.secondCounter >= 1.0f) {
                this.seconds += (int)this.secondCounter;
                this.secondCounter %= 1.0f;
                if (this.seconds % 10 == 1) {
                    this.save();
                }
            }
        }
        if (Vars.state.hasSector() && Vars.state.getSector().planet.updateLighting && (Vars.state.getSector().preset == null || !Vars.state.getSector().preset.noLighting)) {
            Planet planet = Vars.state.getSector().planet;
            float light = Vars.state.getSector().getLight();
            float alpha = Mathf.clamp(Mathf.map(light, planet.lightSrcFrom, planet.lightSrcTo, planet.lightDstFrom, planet.lightDstTo));
            Vars.state.rules.ambientLight.a = 1.0f - alpha;
            Vars.state.rules.lighting = !Mathf.equal(alpha, 1.0f);
        }
    }

    public void clearLoadoutInfo() {
        this.lastLoadout = null;
        this.lastLaunchResources = new ItemSeq();
        Core.settings.remove("launch-resources-seq");
        Core.settings.remove("lastloadout-core-shard");
        Core.settings.remove("lastloadout-core-nucleus");
        Core.settings.remove("lastloadout-core-foundation");
    }

    public ItemSeq getLaunchResources() {
        this.lastLaunchResources = Core.settings.getJson("launch-resources-seq", ItemSeq.class, ItemSeq::new);
        return this.lastLaunchResources;
    }

    public void updateLaunchResources(ItemSeq stacks) {
        this.lastLaunchResources = stacks;
        Core.settings.putJson("launch-resources-seq", this.lastLaunchResources);
    }

    public void updateLoadout(CoreBlock block) {
        this.updateLoadout(block, new Schematic(Seq.with(new Schematic.Stile(block, 0, 0, null, 0)), new StringMap(), block.size, block.size));
    }

    public void updateLoadout(CoreBlock block, Schematic schem) {
        Core.settings.put("lastloadout-" + block.name, schem.file == null ? "" : schem.file.nameWithoutExtension());
        this.lastLoadout = schem;
    }

    public Schematic getLastLoadout() {
        if (this.lastLoadout == null) {
            this.lastLoadout = Vars.state.rules.sector == null || Vars.state.rules.sector.planet.generator == null ? Loadouts.basicShard : Vars.state.rules.sector.planet.generator.defaultLoadout;
        }
        return this.lastLoadout;
    }

    @Nullable
    public Schematic getLoadout(CoreBlock core) {
        if (Vars.schematics == null) {
            return Loadouts.basicShard;
        }
        String file = Core.settings.getString("lastloadout-" + core.name, "");
        Seq<Schematic> all = Vars.schematics.getLoadouts(core);
        Schematic schem = all.find(s -> s.file != null && s.file.nameWithoutExtension().equals(file));
        return schem == null ? (all.any() ? all.first() : null) : schem;
    }

    public void runTurn() {
        ++this.turn;
        int newSecondsPassed = 120;
        Planet current = Vars.state.getPlanet();
        for (Planet planet : Vars.content.planets()) {
            if (current != null && current.allowWaveSimulation != planet.allowWaveSimulation || !planet.allowWaveSimulation && planet.sectors.contains((Sector)((Object)((Boolf<Sector>)s -> s.hasBase() && !s.isBeingPlayed() && s.isAttacked())))) continue;
            if (planet.campaignRules.legacyLaunchPads) {
                for (Sector sector : planet.sectors) {
                    if (!sector.hasBase() || sector.isBeingPlayed()) continue;
                    sector.info.lastImported.clear();
                }
                for (Sector sector : planet.sectors) {
                    Sector to;
                    if (!sector.hasBase() || sector.isBeingPlayed() || sector.info.destination == null || !(to = sector.info.destination).hasBase() || to.planet != planet) continue;
                    ItemSeq items = new ItemSeq();
                    sector.info.export.each((item, stat) -> items.add((Item)item, (int)(stat.mean * (float)newSecondsPassed * sector.getProductionScale())));
                    to.addItems(items);
                    to.info.lastImported.add(items);
                }
            }
            for (Sector sector : planet.sectors) {
                int count;
                if (!sector.hasBase()) continue;
                if (sector.info.importRateCache != null) {
                    sector.info.refreshImportRates(planet);
                }
                sector.info.minutesCaptured = sector.isAttacked() ? 0.0f : (sector.info.minutesCaptured += 2.0f);
                if (!sector.isBeingPlayed()) {
                    boolean attacked;
                    if (sector.isAttacked()) {
                        sector.info.secondsPassed += 120.0f;
                    }
                    int wavesPassed = (int)(sector.info.secondsPassed * 60.0f / sector.info.waveSpacing);
                    boolean bl = attacked = sector.info.waves && sector.planet.allowWaveSimulation;
                    if (attacked) {
                        sector.info.wavesPassed = wavesPassed;
                    }
                    float damage = attacked ? SectorDamage.getDamage(sector) : 0.0f;
                    sector.info.damage = Math.max(sector.info.damage, damage);
                    if (attacked && damage >= 0.999f) {
                        Events.fire(new EventType.SectorLoseEvent(sector));
                        sector.info.items.clear();
                        sector.info.damage = 1.0f;
                        sector.info.hasCore = false;
                        sector.info.production.clear();
                    } else if (attacked && wavesPassed > 0 && sector.info.winWave > 1 && sector.info.wave + wavesPassed >= sector.info.winWave && !sector.hasEnemyBase()) {
                        sector.info.waves = false;
                        boolean was = sector.info.wasCaptured;
                        sector.info.wasCaptured = true;
                        Events.fire(new EventType.SectorCaptureEvent(sector, !was));
                    }
                    float scl = sector.getProductionScale();
                    sector.info.production.each((item, stat) -> sector.info.items.add((Item)item, Math.min((int)(stat.mean * (float)newSecondsPassed * scl), sector.info.storageCapacity - sector.info.items.get((Item)item))));
                    if (planet.campaignRules.legacyLaunchPads) {
                        sector.info.export.each((item, stat) -> {
                            if (sector.info.items.get((Item)item) <= 0 && ((SectorInfo.ExportStat)((Object)sector.info.production.get((Item)item, (Prov<SectorInfo.ExportStat>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lmindustry/game/SectorInfo$ExportStat;)()))).mean < 0.0f && stat.mean > 0.0f) {
                                stat.mean = Math.min((float)sector.info.lastImported.get((Item)item) / (float)newSecondsPassed, stat.mean);
                            }
                        });
                    }
                    sector.info.items.checkNegative();
                    sector.saveInfo();
                }
                if (sector.isAttacked() || !sector.planet.campaignRules.sectorInvasion || !(sector.info.minutesCaptured > 20.0f) || !sector.info.hasSpawns || (count = sector.near().count(s -> s.hasEnemyBase() && !s.hasBase() && (s.preset == null || !s.preset.requireUnlock))) <= 0 || !Mathf.chance(0.01f * (0.8f + (float)(count - 1) * 0.3f))) continue;
                int waveMax = Math.max(sector.info.winWave, sector.isBeingPlayed() ? Vars.state.wave : sector.info.wave + sector.info.wavesPassed) + Mathf.random(2, 4) * 5;
                if (sector.isBeingPlayed()) {
                    Vars.state.rules.winWave = waveMax;
                    Vars.state.rules.waves = true;
                    Vars.state.rules.attackMode = false;
                    planet.campaignRules.apply(planet, Vars.state.rules);
                    if (Vars.net.server()) {
                        Call.setRules(Vars.state.rules);
                    }
                } else {
                    sector.info.winWave = waveMax;
                    sector.info.waves = true;
                    sector.info.attack = false;
                    sector.saveInfo();
                }
                Events.fire(new EventType.SectorInvasionEvent(sector));
            }
        }
        Events.fire(new EventType.TurnEvent());
        this.save();
    }

    public void updateNetSeconds(int value) {
        this.netSeconds = value;
    }

    public float secondsMod(float mod, float scale) {
        return (float)this.seconds() / scale % mod;
    }

    public int seconds() {
        return Vars.net.client() ? this.netSeconds : this.seconds;
    }

    public void setSeconds(float seconds) {
        this.seconds = (int)seconds;
        this.secondCounter = seconds - (float)this.seconds;
        this.save();
    }

    public float secondsf() {
        return (float)this.seconds() + this.secondCounter;
    }

    private void save() {
        Core.settings.put("utimei", this.seconds);
        Core.settings.put("turn", this.turn);
    }

    private void load() {
        this.seconds = Core.settings.getInt("utimei");
        this.turn = Core.settings.getInt("turn");
    }
}

