/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.arcModule.toolpack.ARCTeam;
import mindustry.game.Rules;
import mindustry.game.Teams;
import mindustry.graphics.Pal;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.modules.ItemModule;

public class Team
implements Comparable<Team>,
Senseable {
    public final int id;
    public final Color color = new Color();
    public final Color[] palette = new Color[]{new Color(), new Color(), new Color()};
    public final int[] palettei = new int[3];
    public boolean ignoreUnitCap = false;
    public String emoji = "";
    public boolean hasPalette;
    public String name;
    public static final Team[] all;
    public static final Team[] baseTeams;
    public ARCTeam.ARCTeamData arcTeamData = new ARCTeam.ARCTeamData(this);
    public static final Team derelict;
    public static final Team sharded;
    public static final Team crux;
    public static final Team malis;
    public static final Team green;
    public static final Team blue;
    public static final Team neoplastic;

    public static Team get(int id) {
        return all[(byte)id & 0xFF];
    }

    protected Team(int id, String name, Color color) {
        this.name = name;
        this.color.set(color);
        this.id = id;
        if (id < 6) {
            Team.baseTeams[id] = this;
        }
        Team.all[id] = this;
        this.setPalette(color);
    }

    protected Team(int id, String name, Color color, Color pal1, Color pal2, Color pal3) {
        this(id, name, color);
        this.setPalette(pal1, pal2, pal3);
        this.color.set(color);
    }

    public ItemModule items() {
        return this.core() == null ? ItemModule.empty : this.core().items;
    }

    public Rules.TeamRule rules() {
        return Vars.state.rules.teams.get(this);
    }

    public Teams.TeamData data() {
        return Vars.state.teams.get(this);
    }

    @Nullable
    public CoreBlock.CoreBuild core() {
        return this.data().core();
    }

    public boolean active() {
        return Vars.state.teams.isActive(this);
    }

    public boolean isAlive() {
        return this.data().isAlive();
    }

    public boolean isAI() {
        return (Vars.state.rules.waves || Vars.state.rules.attackMode || Vars.state.isCampaign()) && this != Vars.state.rules.defaultTeam && !Vars.state.rules.pvp;
    }

    public boolean isOnlyAI() {
        return this.isAI() && this.data().players.size == 0;
    }

    public boolean needsFlowField() {
        return this.isAI() && !this.rules().rtsAi;
    }

    public Seq<CoreBlock.CoreBuild> cores() {
        return Vars.state.teams.cores(this);
    }

    public String localized() {
        return Core.bundle.get("team." + this.name + ".name", this.name);
    }

    public String coloredName() {
        return this.emoji + "[#" + this.color + "]" + this.localized() + "[]";
    }

    public void setPalette(Color color) {
        this.setPalette(color, color.cpy().mul(0.75f), color.cpy().mul(0.5f));
        this.hasPalette = false;
    }

    public void setPalette(Color pal1, Color pal2, Color pal3) {
        this.color.set(pal1);
        this.palette[0].set(pal1);
        this.palette[1].set(pal2);
        this.palette[2].set(pal3);
        for (int i = 0; i < 3; ++i) {
            this.palettei[i] = this.palette[i].rgba();
        }
        this.hasPalette = true;
    }

    @Override
    public int compareTo(Team team) {
        return Integer.compare(this.id, team.id);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public double sense(LAccess sensor) {
        double d;
        switch (sensor) {
            case id: {
                d = this.id;
                break;
            }
            case color: {
                d = this.color.toDoubleBits();
                break;
            }
            default: {
                d = Double.NaN;
            }
        }
        return d;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return Senseable.noSensed;
    }

    static {
        int i;
        all = new Team[256];
        baseTeams = new Team[6];
        derelict = new Team(0, "derelict", Color.valueOf("4d4e58"));
        sharded = new Team(1, "sharded", Pal.accent.cpy(), Color.valueOf("ffd37f"), Color.valueOf("eab678"), Color.valueOf("d4816b"));
        crux = new Team(2, "crux", Color.valueOf("f25555"), Color.valueOf("fc8e6c"), Color.valueOf("f25555"), Color.valueOf("a04553"));
        malis = new Team(3, "malis", Color.valueOf("a27ce5"), Color.valueOf("c7a4f5"), Color.valueOf("896fd6"), Color.valueOf("504cba"));
        green = new Team(4, "green", Color.valueOf("54d67d"));
        blue = new Team(5, "blue", Color.valueOf("6c87fd"));
        neoplastic = new Team(6, "neoplastic", Color.valueOf("e05438"));
        Mathf.rand.setSeed(8L);
        for (i = 0; i < 3; ++i) {
            Mathf.random();
        }
        for (i = 7; i < all.length; ++i) {
            new Team(i, "team#" + i, Color.HSVtoRGB(360.0f * Mathf.random(), 100.0f * Mathf.random(0.4f, 1.0f), 100.0f * Mathf.random(0.6f, 1.0f), 1.0f));
        }
        Mathf.rand.setSeed(new Rand().nextLong());
        Team.neoplastic.ignoreUnitCap = true;
    }
}

