/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.files.Fi;
import arc.func.Boolf;
import arc.struct.ObjectFloatMap;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Nullable;
import java.util.concurrent.atomic.AtomicBoolean;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.mod.Mods;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.Publishable;
import mindustry.world.Block;
import mindustry.world.blocks.power.ConsumeGenerator;
import mindustry.world.blocks.power.ImpactReactor;
import mindustry.world.blocks.power.NuclearReactor;
import mindustry.world.blocks.power.PowerGenerator;
import mindustry.world.blocks.production.Fracker;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.production.Separator;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeItems;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquids;

public class Schematic
implements Publishable,
Comparable<Schematic> {
    public final Seq<Stile> tiles;
    public Seq<String> labels = new Seq();
    public StringMap tags;
    public int width;
    public int height;
    @Nullable
    public Fi file;
    @Nullable
    public Mods.LoadedMod mod;
    public ObjectFloatMap<Item> items;
    public ObjectFloatMap<Liquid> liquids;

    public Schematic(Seq<Stile> tiles, StringMap tags, int width, int height) {
        this.tiles = tiles;
        this.tags = tags;
        this.width = width;
        this.height = height;
    }

    public boolean containsBlock(Block block) {
        AtomicBoolean contains = new AtomicBoolean(false);
        this.tiles.each(t -> {
            if (t.block == block) {
                contains.set(true);
            }
        });
        return contains.get();
    }

    public float powerProduction() {
        return this.tiles.sumf(s -> {
            float f;
            Block patt1688$temp = s.block;
            if (patt1688$temp instanceof PowerGenerator) {
                PowerGenerator p = (PowerGenerator)patt1688$temp;
                f = p.getDisplayedPowerProduction();
            } else {
                f = 0.0f;
            }
            return f;
        });
    }

    public float powerConsumption() {
        return this.tiles.sumf(s -> s.block.consPower != null ? s.block.consPower.usage : 0.0f);
    }

    public void calProduction() {
        this.items = new ObjectFloatMap(Vars.content.items().copy().size << 1);
        this.liquids = new ObjectFloatMap(Vars.content.liquids().copy().size << 1);
        this.tiles.each(t -> {
            block35: {
                block37: {
                    block36: {
                        block34: {
                            if (t.block == null) {
                                return;
                            }
                            Block block = t.block;
                            if (!(block instanceof GenericCrafter)) break block34;
                            GenericCrafter gc = (GenericCrafter)block;
                            for (Consume c : gc.consumeBuilder) {
                                if (c.optional) continue;
                                if (c instanceof ConsumeItems) {
                                    ConsumeItems consumeItems = (ConsumeItems)c;
                                    for (ItemStack itemStack : consumeItems.items) {
                                        Item item = itemStack.item;
                                        this.items.put(item, this.items.get(item, 0.0f) - (float)itemStack.amount * 60.0f / gc.craftTime);
                                    }
                                    continue;
                                }
                                if (c instanceof ConsumeLiquid) {
                                    ConsumeLiquid consumeLiquid = (ConsumeLiquid)c;
                                    LiquidStack[] liquid = consumeLiquid.liquid;
                                    this.liquids.put((Liquid)liquid, this.liquids.get((Liquid)liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                                    continue;
                                }
                                if (!(c instanceof ConsumeLiquids)) continue;
                                ConsumeLiquids consumeLiquids = (ConsumeLiquids)c;
                                for (LiquidStack liquidStack : consumeLiquids.liquids) {
                                    Liquid liquid = liquidStack.liquid;
                                    this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - liquidStack.amount * 60.0f);
                                }
                            }
                            if (gc.outputsItems()) {
                                for (ItemStack itemStack : gc.outputItems) {
                                    Item item = itemStack.item;
                                    this.items.put(item, this.items.get(item, 0.0f) + (float)itemStack.amount * 60.0f / gc.craftTime);
                                }
                            }
                            if (gc.outputLiquids == null) break block35;
                            for (LiquidStack liquidStack : gc.outputLiquids) {
                                Liquid liquid = liquidStack.liquid;
                                this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) + liquidStack.amount * 60.0f);
                            }
                            break block35;
                        }
                        Block block = t.block;
                        if (!(block instanceof Separator)) break block36;
                        Separator s = (Separator)block;
                        for (Consume c : s.consumeBuilder) {
                            if (c.optional) continue;
                            if (c instanceof ConsumeItems) {
                                ConsumeItems consumeItems = (ConsumeItems)c;
                                for (ItemStack stack : consumeItems.items) {
                                    Item item = stack.item;
                                    this.items.put(item, this.items.get(item, 0.0f) - (float)stack.amount * 60.0f / s.craftTime);
                                }
                                continue;
                            }
                            if (!(c instanceof ConsumeLiquid)) continue;
                            ConsumeLiquid consumeLiquid = (ConsumeLiquid)c;
                            Liquid liquid = consumeLiquid.liquid;
                            this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                        }
                        break block35;
                    }
                    Block block = t.block;
                    if (!(block instanceof Fracker)) break block37;
                    Fracker f = (Fracker)block;
                    for (Consume c : f.consumeBuilder) {
                        if (c.optional || !(c instanceof ConsumeItems)) continue;
                        ConsumeItems consumeItems = (ConsumeItems)c;
                        for (ItemStack stack : consumeItems.items) {
                            Item item = stack.item;
                            this.items.put(item, this.items.get(item, 0.0f) - (float)stack.amount * f.itemUseTime / 60.0f);
                        }
                    }
                    break block35;
                }
                if (!(t.block instanceof PowerGenerator)) break block35;
                Block block = t.block;
                if (block instanceof ConsumeGenerator) {
                    ConsumeGenerator consumeGenerator = (ConsumeGenerator)block;
                    for (Consume consume : consumeGenerator.consumeBuilder) {
                        if (consume.optional) continue;
                        if (consume instanceof ConsumeItems) {
                            ConsumeItems consumeItems = (ConsumeItems)consume;
                            for (ItemStack itemStack : consumeItems.items) {
                                Item item = itemStack.item;
                                this.items.put(item, this.items.get(item, 0.0f) - (float)itemStack.amount * 60.0f / consumeGenerator.itemDuration);
                            }
                            continue;
                        }
                        if (consume instanceof ConsumeLiquid) {
                            ConsumeLiquid consumeLiquid = (ConsumeLiquid)consume;
                            Liquid liquid = consumeLiquid.liquid;
                            this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                            continue;
                        }
                        if (!(consume instanceof ConsumeLiquids)) continue;
                        ConsumeLiquids consumeLiquids = (ConsumeLiquids)consume;
                        for (LiquidStack liquidStack : consumeLiquids.liquids) {
                            Liquid liquid = liquidStack.liquid;
                            this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - liquidStack.amount * 60.0f);
                        }
                    }
                } else {
                    Block block2 = t.block;
                    if (block2 instanceof NuclearReactor) {
                        NuclearReactor nr = (NuclearReactor)block2;
                        for (Consume consume : nr.consumeBuilder) {
                            if (consume.optional) continue;
                            if (consume instanceof ConsumeItems) {
                                ConsumeItems consumeItems = (ConsumeItems)consume;
                                for (ItemStack itemStack : consumeItems.items) {
                                    Item item = itemStack.item;
                                    this.items.put(item, this.items.get(item, 0.0f) - (float)itemStack.amount * 60.0f / nr.itemDuration);
                                }
                                continue;
                            }
                            if (consume instanceof ConsumeLiquid) {
                                ConsumeLiquid consumeLiquid = (ConsumeLiquid)consume;
                                Liquid liquid = consumeLiquid.liquid;
                                this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                                continue;
                            }
                            if (!(consume instanceof ConsumeLiquids)) continue;
                            ConsumeLiquids consumeLiquids = (ConsumeLiquids)consume;
                            for (LiquidStack liquidStack : consumeLiquids.liquids) {
                                Liquid liquid = liquidStack.liquid;
                                this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - liquidStack.amount * 60.0f);
                            }
                        }
                    } else {
                        Block block3 = t.block;
                        if (block3 instanceof ImpactReactor) {
                            ImpactReactor ir = (ImpactReactor)block3;
                            for (Consume consume : ir.consumeBuilder) {
                                if (consume.optional) continue;
                                if (consume instanceof ConsumeItems) {
                                    ConsumeItems consumeItems = (ConsumeItems)consume;
                                    for (ItemStack itemStack : consumeItems.items) {
                                        Item item = itemStack.item;
                                        this.items.put(item, this.items.get(item, 0.0f) - (float)itemStack.amount * 60.0f / ir.itemDuration);
                                    }
                                    continue;
                                }
                                if (consume instanceof ConsumeLiquid) {
                                    ConsumeLiquid consumeLiquid = (ConsumeLiquid)consume;
                                    Liquid liquid = consumeLiquid.liquid;
                                    this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - consumeLiquid.amount * 60.0f);
                                    continue;
                                }
                                if (!(consume instanceof ConsumeLiquids)) continue;
                                ConsumeLiquids consumeLiquids = (ConsumeLiquids)consume;
                                for (LiquidStack liquidStack : consumeLiquids.liquids) {
                                    Liquid liquid = liquidStack.liquid;
                                    this.liquids.put(liquid, this.liquids.get(liquid, 0.0f) - liquidStack.amount * 60.0f);
                                }
                            }
                        }
                    }
                }
            }
        });
    }

    public ItemSeq requirements() {
        ItemSeq requirements = new ItemSeq();
        this.tiles.each(t -> {
            for (ItemStack stack : t.block.requirements) {
                requirements.add(stack.item, stack.amount);
            }
        });
        return requirements;
    }

    public boolean hasCore() {
        return this.tiles.contains((Stile)((Object)((Boolf<Stile>)s -> s.block instanceof CoreBlock)));
    }

    public CoreBlock findCore() {
        Stile tile = this.tiles.find(s -> s.block instanceof CoreBlock);
        if (tile == null) {
            throw new IllegalArgumentException("Schematic is missing a core!");
        }
        return (CoreBlock)tile.block;
    }

    public String name() {
        return this.tags.get("name", "unknown");
    }

    public String description() {
        return this.tags.get("description", "");
    }

    public void save() {
        Vars.schematics.saveChanges(this);
    }

    @Override
    public String getSteamID() {
        return (String)this.tags.get("steamid");
    }

    @Override
    public void addSteamID(String id) {
        this.tags.put("steamid", id);
        this.save();
    }

    @Override
    public void removeSteamID() {
        this.tags.remove("steamid");
        this.save();
    }

    @Override
    public String steamTitle() {
        return this.name();
    }

    @Override
    public String steamDescription() {
        return this.description();
    }

    @Override
    public String steamTag() {
        return "schematic";
    }

    @Override
    public Fi createSteamFolder(String id) {
        Fi directory = Vars.tmpDirectory.child("schematic_" + id).child("schematic.msch");
        this.file.copyTo(directory);
        return directory;
    }

    @Override
    public Fi createSteamPreview(String id) {
        Fi preview = Vars.tmpDirectory.child("schematic_preview_" + id + ".png");
        Vars.schematics.savePreview(this, preview);
        return preview;
    }

    @Override
    public int compareTo(Schematic schematic) {
        return this.name().compareTo(schematic.name());
    }

    public static class Stile {
        public Block block;
        public short x;
        public short y;
        public Object config;
        public byte rotation;

        public Stile(Block block, int x, int y, Object config, byte rotation) {
            this.block = block;
            this.x = (short)x;
            this.y = (short)y;
            this.config = config;
            this.rotation = rotation;
        }

        public Stile() {
            this.block = Blocks.air;
        }

        public Stile(Block block, int x, int y) {
            this.block = block;
            this.x = (short)x;
            this.y = (short)y;
        }

        public Stile set(Stile other) {
            this.block = other.block;
            this.x = other.x;
            this.y = other.y;
            this.config = other.config;
            this.rotation = other.rotation;
            return this;
        }

        public Stile copy() {
            return new Stile(this.block, this.x, this.y, this.config, this.rotation);
        }
    }
}

