/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.pattern;

import arc.util.Nullable;
import mindustry.entities.pattern.ShootPattern;

public class ShootMulti
extends ShootPattern {
    public ShootPattern source;
    public ShootPattern[] dest = new ShootPattern[0];

    public ShootMulti(ShootPattern source, ShootPattern ... dest) {
        this.source = source;
        this.dest = dest;
    }

    public ShootMulti() {
    }

    @Override
    public void flip() {
        this.source = this.source.copy();
        this.source.flip();
        this.dest = (ShootPattern[])this.dest.clone();
        for (int i = 0; i < this.dest.length; ++i) {
            this.dest[i] = this.dest[i].copy();
            this.dest[i].flip();
        }
    }

    @Override
    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
        this.source.shoot(totalShots, (x, y, rotation, delay, move) -> {
            for (ShootPattern pattern : this.dest) {
                pattern.shoot(totalShots, (x2, y2, rot2, delay2, mover) -> handler.shoot(x + x2, y + y2, rotation + rot2, delay + delay2, move == null && mover == null ? null : b -> {
                    if (move != null) {
                        move.move(b);
                    }
                    if (mover != null) {
                        mover.move(b);
                    }
                }), null);
            }
        }, barrelIncrementer);
    }

    @Override
    public int totalShots() {
        int total = 0;
        for (ShootPattern p : this.dest) {
            total += p.totalShots();
        }
        return total * this.source.totalShots();
    }
}

