/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.arcModule.RFuncs;
import mindustry.entities.Damage;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.UnitType;

public class SuppressionFieldAbility
extends Ability {
    protected static Rand rand = new Rand();
    public float reload = 90.0f;
    public float maxDelay = 90.0f;
    public float range = 200.0f;
    public float orbRadius = 4.1f;
    public float orbMidScl = 0.33f;
    public float orbSinScl = 8.0f;
    public float orbSinMag = 1.0f;
    public Color color = Pal.suppress;
    public float layer = 110.0f;
    public float x = 0.0f;
    public float y = 0.0f;
    public int particles = 15;
    public float particleSize = 4.0f;
    public float particleLen = 7.0f;
    public float rotateScl = 3.0f;
    public float particleLife = 110.0f;
    public boolean active = true;
    public Interp particleInterp = f -> Interp.circleOut.apply(Interp.slope.apply(f));
    public Color particleColor = Pal.sap.cpy();
    public Color effectColor = Pal.sapBullet;
    public float applyParticleChance = 13.0f;
    protected float timer;

    @Override
    public void init(UnitType type) {
        if (!this.active) {
            this.display = false;
        }
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add(Core.bundle.format("bullet.range", Strings.autoFixed(this.range / 8.0f, 2)));
        t.row();
        t.add(this.abilityStat("duration", Strings.autoFixed(this.reload / 60.0f, 2)));
    }

    @Override
    public void update(Unit unit) {
        float f;
        if (!this.active) {
            return;
        }
        this.timer += Time.delta;
        if (f >= this.maxDelay) {
            Tmp.v1.set(this.x, this.y).rotate(unit.rotation - 90.0f).add(unit);
            Damage.applySuppression(unit.team, Tmp.v1.x, Tmp.v1.y, this.range, this.reload, this.maxDelay, this.applyParticleChance, unit, this.effectColor);
            this.timer = 0.0f;
        }
    }

    @Override
    public String description(UnitType unit) {
        return RFuncs.abilitysFormat("@s~@\u683c", Float.valueOf(this.reload / 60.0f), Float.valueOf(this.range / 8.0f));
    }

    @Override
    public void draw(Unit unit) {
        Draw.z(this.layer);
        float rad = this.orbRadius + Mathf.absin(this.orbSinScl, this.orbSinMag);
        Tmp.v1.set(this.x, this.y).rotate(unit.rotation - 90.0f).add(unit);
        float rx = Tmp.v1.x;
        float ry = Tmp.v1.y;
        float base = Time.time / this.particleLife;
        rand.setSeed(unit.id + this.hashCode());
        Draw.color(this.particleColor);
        for (int i = 0; i < this.particles; ++i) {
            float fin = (rand.random(1.0f) + base) % 1.0f;
            float fout = 1.0f - fin;
            float angle = rand.random(360.0f) + (Time.time / this.rotateScl + unit.rotation) % 360.0f;
            float len = this.particleLen * this.particleInterp.apply(fout);
            Fill.circle(rx + Angles.trnsx(angle, len), ry + Angles.trnsy(angle, len), this.particleSize * Mathf.slope(fin));
        }
        Lines.stroke(2.0f);
        Draw.color(this.color);
        Lines.circle(rx, ry, rad);
        Draw.color(this.color);
        Fill.circle(rx, ry, rad * this.orbMidScl);
        if (this.active) {
            // empty if block
        }
        Draw.reset();
    }
}

