/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.RFuncs;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Puddles;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Puddle;
import mindustry.gen.Unit;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.world.Tile;

public class LiquidRegenAbility
extends Ability {
    public Liquid liquid;
    public float slurpSpeed = 5.0f;
    public float regenPerSlurp = 6.0f;
    public float slurpEffectChance = 0.4f;
    public Effect slurpEffect = Fx.heal;

    @Override
    public String description(UnitType unit) {
        return RFuncs.abilitysFormat("\u6bcf\u683c\u5438\u6536@/s@@~@/s\u56de\u8840~\u6700\u5927@/s", Float.valueOf(this.slurpSpeed), this.liquid.localizedName, this.liquid.emoji(), Float.valueOf(this.slurpSpeed * this.regenPerSlurp), Math.PI * Math.pow(Math.max(unit.hitSize / 8.0f * 0.6f, 1.0f), 2.0) * (double)this.slurpSpeed * (double)this.regenPerSlurp);
    }

    @Override
    public void addStats(Table t) {
        super.addStats(t);
        t.add((this.liquid.hasEmoji() ? this.liquid.emoji() : "") + "[stat]" + this.liquid.localizedName);
        t.row();
        t.add(this.abilityStat("slurpheal", Strings.autoFixed(this.regenPerSlurp, 2)));
    }

    @Override
    public void update(Unit unit) {
        if (unit.damaged() && !unit.isFlying()) {
            boolean healed = false;
            int tx = unit.tileX();
            int ty = unit.tileY();
            int rad = Math.max((int)(unit.hitSize / 8.0f * 0.6f), 1);
            for (int x = -rad; x <= rad; ++x) {
                for (int y = -rad; y <= rad; ++y) {
                    Puddle puddle;
                    Tile tile;
                    if (x * x + y * y > rad * rad || (tile = Vars.world.tile(tx + x, ty + y)) == null || (puddle = Puddles.get(tile)) == null || puddle.liquid != this.liquid) continue;
                    float fractionTaken = Math.min(puddle.amount, this.slurpSpeed * Time.delta);
                    puddle.amount -= Math.min(puddle.amount, this.slurpSpeed * Time.delta);
                    unit.heal(fractionTaken * this.regenPerSlurp);
                    healed = true;
                }
            }
            if (healed && Mathf.chanceDelta(this.slurpEffectChance)) {
                Tmp.v1.rnd(Mathf.random(unit.hitSize / 2.0f));
                this.slurpEffect.at(unit.x + Tmp.v1.x, unit.y + Tmp.v1.y, unit.rotation, unit);
            }
        }
    }
}

