/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.Core;
import arc.scene.ui.layout.Table;
import mindustry.gen.Unit;
import mindustry.type.UnitType;
import mindustry.ui.Styles;

public abstract class Ability
implements Cloneable {
    protected static final float descriptionWidth = 350.0f;
    public boolean display = true;
    public float data;

    public void update(Unit unit) {
    }

    public void draw(Unit unit) {
    }

    public void death(Unit unit) {
    }

    public void created(Unit unit) {
    }

    public void init(UnitType type) {
    }

    public void displayBars(Unit unit, Table bars) {
    }

    public void display(Table t) {
        t.table(Styles.grayPanel, a -> {
            a.add("[accent]" + this.localized()).padBottom(4.0f).center().top().expandX();
            a.row();
            a.left().top().defaults().left();
            this.addStats((Table)a);
        }).pad(5.0f).margin(10.0f).growX().top().uniformX();
    }

    public void addStats(Table t) {
        if (Core.bundle.has(this.getBundle() + ".description")) {
            t.add(Core.bundle.get(this.getBundle() + ".description")).wrap().width(350.0f);
            t.row();
        }
    }

    public String abilityStat(String stat, Object ... values) {
        return Core.bundle.format("ability.stat." + stat, values);
    }

    public Ability copy() {
        try {
            return (Ability)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("java sucks", e);
        }
    }

    public String localized() {
        return Core.bundle.get(this.getBundle());
    }

    public String getBundle() {
        Class<?> type = this.getClass();
        return "ability." + (type.isAnonymousClass() ? type.getSuperclass() : type).getSimpleName().replace("Ability", "").toLowerCase();
    }

    public String description(UnitType unit) {
        return "";
    }
}

