/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities;

import arc.Core;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureAtlas;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.effect.WrapEffect;
import mindustry.gen.Decal;
import mindustry.gen.EffectState;
import mindustry.gen.Posc;
import mindustry.graphics.Pal;
import mindustry.world.Tile;

public class Effect {
    private static final float shakeFalloff = 10000.0f;
    private static final EffectContainer container = new EffectContainer();
    public static final Seq<Effect> all = new Seq();
    private boolean initialized;
    public final int id;
    public Cons<EffectContainer> renderer;
    public float lifetime;
    public float clip;
    public float startDelay;
    public float baseRotation;
    public boolean followParent;
    public boolean rotWithParent;
    public float layer;
    public float layerDuration;

    public Effect(float life, float clipsize, Cons<EffectContainer> renderer) {
        this.renderer = e -> {};
        this.lifetime = 50.0f;
        this.followParent = true;
        this.layer = 110.0f;
        this.id = Effect.all.size;
        this.lifetime = life;
        this.renderer = renderer;
        this.clip = clipsize;
        all.add(this);
    }

    public Effect(float life, Cons<EffectContainer> renderer) {
        this(life, 50.0f, renderer);
    }

    public Effect() {
        this.renderer = e -> {};
        this.lifetime = 50.0f;
        this.followParent = true;
        this.layer = 110.0f;
        this.id = Effect.all.size;
        all.add(this);
    }

    public Effect startDelay(float d) {
        this.startDelay = d;
        return this;
    }

    public void init() {
    }

    public Effect followParent(boolean follow) {
        this.followParent = follow;
        return this;
    }

    public Effect rotWithParent(boolean follow) {
        this.rotWithParent = follow;
        return this;
    }

    public Effect layer(float l) {
        this.layer = l;
        return this;
    }

    public Effect baseRotation(float d) {
        this.baseRotation = d;
        return this;
    }

    public Effect layer(float l, float duration) {
        this.layer = l;
        this.layerDuration = duration;
        return this;
    }

    public WrapEffect wrap(Color color) {
        return new WrapEffect(this, color);
    }

    public WrapEffect wrap(Color color, float rotation) {
        return new WrapEffect(this, color, rotation);
    }

    public void at(Position pos) {
        this.create(pos.getX(), pos.getY(), 0.0f, Color.white, null);
    }

    public void at(Position pos, boolean parentize) {
        this.create(pos.getX(), pos.getY(), 0.0f, Color.white, parentize ? pos : null);
    }

    public void at(Position pos, float rotation) {
        this.create(pos.getX(), pos.getY(), rotation, Color.white, null);
    }

    public void at(Position pos, float rotation, Color color) {
        this.create(pos.getX(), pos.getY(), rotation, color, null);
    }

    public void at(float x, float y) {
        this.create(x, y, 0.0f, Color.white, null);
    }

    public void at(float x, float y, float rotation) {
        this.create(x, y, rotation, Color.white, null);
    }

    public void at(float x, float y, float rotation, Color color) {
        this.create(x, y, rotation, color, null);
    }

    public void at(float x, float y, Color color) {
        this.create(x, y, 0.0f, color, null);
    }

    public void at(float x, float y, float rotation, Color color, Object data) {
        this.create(x, y, rotation, color, data);
    }

    public void at(float x, float y, float rotation, Object data) {
        this.create(x, y, rotation, Color.white, data);
    }

    public boolean shouldCreate() {
        return !Vars.headless && this != Fx.none && Vars.renderer.enableEffects;
    }

    public void create(float x, float y, float rotation, Color color, Object data) {
        if (!this.shouldCreate()) {
            return;
        }
        if (Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(x, y, this.clip))) {
            if (!this.initialized) {
                this.initialized = true;
                this.init();
            }
            if (this.startDelay <= 0.0f) {
                this.add(x, y, rotation, color, data);
            } else {
                Time.run(this.startDelay, () -> this.add(x, y, rotation, color, data));
            }
        }
    }

    public void arcCreate(float x, float y, float rotation, Color color, Object data) {
        if (!this.initialized) {
            this.initialized = true;
            this.init();
        }
        if (this.startDelay <= 0.0f) {
            this.add(x, y, rotation, color, data);
        } else {
            Time.run(this.startDelay, () -> this.add(x, y, rotation, color, data));
        }
    }

    protected void add(float x, float y, float rotation, Color color, Object data) {
        EffectState entity = EffectState.create();
        entity.effect = this;
        entity.rotation = this.baseRotation + rotation;
        entity.data = data;
        entity.lifetime = this.lifetime;
        entity.set(x, y);
        entity.color.set(color);
        if (this.followParent && data instanceof Posc) {
            Posc p;
            entity.parent = p = (Posc)data;
            entity.rotWithParent = this.rotWithParent;
        }
        entity.add();
    }

    public float render(int id, Color color, float life, float lifetime, float rotation, float x, float y, Object data) {
        container.set(id, color, life, lifetime, rotation, x, y, data);
        Draw.z(this.layer);
        Draw.reset();
        this.render(container);
        Draw.reset();
        return Effect.container.lifetime;
    }

    public void render(EffectContainer e) {
        this.renderer.get(e);
    }

    @Nullable
    public static Effect get(int id) {
        return id >= Effect.all.size || id < 0 ? null : all.get(id);
    }

    private static void shake(float intensity, float duration) {
        if (!Vars.headless) {
            Vars.renderer.shake(intensity, duration);
        }
    }

    public static void shake(float intensity, float duration, float x, float y) {
        if (Core.camera == null) {
            return;
        }
        float distance = Core.camera.position.dst(x, y);
        if (distance < 1.0f) {
            distance = 1.0f;
        }
        Effect.shake(Mathf.clamp(1.0f / (distance * distance / 10000.0f)) * intensity, duration);
    }

    public static void shake(float intensity, float duration, Position loc) {
        Effect.shake(intensity, duration, loc.getX(), loc.getY());
    }

    public static void floorDust(float x, float y, float size) {
        Tile tile = Vars.world.tileWorld(x, y);
        if (tile != null) {
            Color color = tile.floor().mapColor;
            Fx.unitLand.at(x, y, size, color);
        }
    }

    public static void floorDustAngle(Effect effect, float x, float y, float angle) {
        Tile tile = Vars.world.tileWorld(x, y);
        if (tile != null) {
            Color color = tile.floor().mapColor;
            effect.at(x, y, angle, color);
        }
    }

    public static void decal(TextureRegion region, float x, float y, float rotation) {
        Effect.decal(region, x, y, rotation, 3600.0f, Pal.rubble);
    }

    public static void decal(TextureRegion region, float x, float y, float rotation, float lifetime, Color color) {
        if (Vars.headless || region == null || !Core.atlas.isFound(region)) {
            return;
        }
        Tile tile = Vars.world.tileWorld(x, y);
        if (tile == null || !tile.floor().hasSurface()) {
            return;
        }
        Decal decal = Decal.create();
        decal.set(x, y);
        decal.rotation(rotation);
        decal.lifetime(lifetime);
        decal.color().set(color);
        decal.region(region);
        decal.add();
    }

    public static void scorch(float x, float y, int size) {
        if (Vars.headless) {
            return;
        }
        size = Mathf.clamp(size, 0, 9);
        TextureAtlas.AtlasRegion region = Core.atlas.find("scorch-" + size + "-" + Mathf.random(2));
        Effect.decal(region, x, y, Mathf.random(4) * 90, 3600.0f, Pal.rubble);
    }

    public static void rubble(float x, float y, int blockSize) {
        if (Vars.headless) {
            return;
        }
        TextureAtlas.AtlasRegion region = Core.atlas.find("rubble-" + blockSize + "-" + (Core.atlas.has("rubble-" + blockSize + "-1") ? Integer.valueOf(Mathf.random(0, 1)) : "0"));
        Effect.decal(region, x, y, Mathf.random(4) * 90, 3600.0f, Pal.rubble);
    }

    public static class EffectContainer
    implements Scaled {
        public float x;
        public float y;
        public float time;
        public float lifetime;
        public float rotation;
        public Color color;
        public int id;
        public Object data;
        private EffectContainer innerContainer;

        public void set(int id, Color color, float life, float lifetime, float rotation, float x, float y, Object data) {
            this.x = x;
            this.y = y;
            this.color = color;
            this.time = life;
            this.lifetime = lifetime;
            this.id = id;
            this.rotation = rotation;
            this.data = data;
        }

        public <T> T data() {
            return (T)this.data;
        }

        public EffectContainer inner() {
            return this.innerContainer == null ? (this.innerContainer = new EffectContainer()) : this.innerContainer;
        }

        public void scaled(float lifetime, Cons<EffectContainer> cons) {
            if (this.innerContainer == null) {
                this.innerContainer = new EffectContainer();
            }
            if (this.time <= lifetime) {
                this.innerContainer.set(this.id, this.color, this.time, lifetime, this.rotation, this.x, this.y, this.data);
                cons.get(this.innerContainer);
            }
        }

        @Override
        public float fin() {
            return this.time / this.lifetime;
        }
    }
}

