/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.func.Intc;
import arc.func.Intp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Point2;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.Label;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Structs;
import arc.util.Time;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.MinerAI;
import mindustry.ai.types.RepairAI;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.toolpack.arcWaveSpawner;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.editor.WaveGraph;
import mindustry.game.SpawnGroup;
import mindustry.game.Waves;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.io.JsonIO;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.type.unit.ErekirUnitType;
import mindustry.type.unit.MissileUnitType;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Tile;

public class arcWaveInfoDialog
extends BaseDialog {
    private int start = 0;
    private int displayed = 20;
    private int graphSpeed = 1;
    private int maxGraphSpeed = 16;
    Seq<SpawnGroup> groups = new Seq();
    private SpawnGroup expandedGroup;
    private Table table;
    private Table nTable;
    private Table oTable;
    private Table iTable;
    private Table eTable;
    private Table uTable;
    private int search = -1;
    private int payLeft;
    private int maxVisible = 30;
    private int filterHealth;
    private int filterBegin = -1;
    private int filterEnd = -1;
    private int filterAmount;
    private int filterAmountWave;
    private boolean expandPane = false;
    private boolean filterHealthMode = false;
    private boolean filterStrict = false;
    private UnitType lastType = UnitTypes.dagger;
    private StatusEffect filterEffect = StatusEffects.none;
    private Sort sort = Sort.begin;
    private boolean reverseSort = false;
    private float updateTimer;
    private float updatePeriod = 1.0f;
    private TextField amountField = new TextField();
    private boolean checkedSpawns;
    private WaveGraph graph = new WaveGraph();
    public int arcWaveIndex = 0;
    private float handerSize = 40.0f;
    private boolean waveInfo = true;
    private float waveMulti = 1.0f;
    Float difficult = Float.valueOf(1.0f);
    Seq<UnitType> spawnUnit = Vars.content.units().copy().retainAll(unitType -> !(unitType instanceof MissileUnitType) && !(unitType.controller instanceof BuilderAI) && !(unitType.controller instanceof MinerAI) && !(unitType.controller instanceof RepairAI));
    Seq<UnitType> allowUnit = Vars.content.units().copy().retainAll(unitType -> !(unitType instanceof MissileUnitType));
    boolean surplusUnit = true;
    boolean ErekirUnit = true;
    boolean showUnitSelect = true;
    boolean flyingUnit = true;
    boolean navalUnit = true;
    boolean supportUnit = true;

    public arcWaveInfoDialog() {
        super("ARC-\u6ce2\u6b21\u7f16\u8f91\u5668");
        this.shown(() -> {
            this.checkedSpawns = false;
            this.setup();
        });
        this.hidden(() -> {
            Vars.state.rules.spawns = this.groups;
        });
        this.addCloseListener();
        this.onResize(this::setup);
        this.addCloseButton();
        this.buttons.button("@waves.edit", Icon.pencil, () -> {
            BaseDialog dialog = new BaseDialog("@waves.edit");
            dialog.addCloseButton();
            dialog.setFillParent(false);
            dialog.cont.table(Tex.button, t -> {
                TextButton.TextButtonStyle style = Styles.flatt;
                t.defaults().size(210.0f, 58.0f);
                t.button("@waves.copy", (Drawable)Icon.copy, style, () -> {
                    Vars.ui.showInfoFade("@waves.copied");
                    Core.app.setClipboardText(Vars.maps.writeWaves(this.groups));
                    dialog.hide();
                }).disabled(b -> this.groups == null).marginLeft(12.0f).row();
                t.button("@waves.load", (Drawable)Icon.download, style, () -> {
                    try {
                        this.groups = Vars.maps.readWaves(Core.app.getClipboardText());
                        this.buildGroups();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Vars.ui.showErrorMessage("@waves.invalid");
                    }
                    dialog.hide();
                }).marginLeft(12.0f).disabled(b -> Core.app.getClipboardText() == null || Core.app.getClipboardText().isEmpty()).row();
                t.button("@settings.reset", (Drawable)Icon.upload, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups = JsonIO.copy(Vars.waves.get());
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f).row();
                t.button("@clear", (Drawable)Icon.cancel, style, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                    this.groups.clear();
                    this.buildGroups();
                    dialog.hide();
                })).marginLeft(12.0f);
            });
            dialog.show();
        }).size(250.0f, 64.0f);
        this.buttons.defaults().width(60.0f);
        this.buttons.button("\u5207\u6362\u663e\u793a\u6a21\u5f0f", () -> {
            this.waveInfo = !this.waveInfo;
            this.waveMulti = 1.0f;
            this.setup();
        }).size(250.0f, 64.0f).disabled(b -> Vars.state.rules.winWave > 50000);
        this.buttons.button("\u968f\u673a", Icon.refresh, () -> this.arcSpawner()).width(200.0f);
    }

    void view(int amount) {
        this.updateTimer += Time.delta;
        if (this.updateTimer >= this.updatePeriod) {
            this.displayed += amount;
            if (this.displayed < 5) {
                this.displayed = 5;
            }
            this.updateTimer = 0.0f;
            this.updateWaves();
        }
    }

    void shift(int amount) {
        this.updateTimer += Time.delta;
        if (this.updateTimer >= this.updatePeriod) {
            this.start += amount;
            if (this.start < 0) {
                this.start = 0;
            }
            this.updateTimer = 0.0f;
            this.updateWaves();
        }
    }

    void setup() {
        if (Vars.state.rules.winWave > 50000) {
            this.waveInfo = true;
        }
        this.groups = JsonIO.copy(Vars.state.rules.spawns.isEmpty() ? Vars.waves.get() : Vars.state.rules.spawns);
        this.cont.clear();
        this.cont.stack(new Table(Tex.clear, main -> {
            main.table((Table s) -> {
                s.image(Icon.zoom).padRight(8.0f);
                s.field(this.search < 0 ? "" : this.search + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                    this.search = !text.isEmpty() ? Math.max(Strings.parseInt(text) - 1, -1) : -1;
                    this.start = Math.max(this.search - this.displayed / 2 - this.displayed % 2, 0);
                    this.buildGroups();
                }).growX().maxTextLength(8).get().setMessageText("@waves.search");
                s.button((Drawable)Icon.filter, Styles.emptyi, this::showFilter).size(46.0f).tooltip("@waves.filter");
            }).fillX().pad(6.0f).row();
            main.pane((Table t) -> {
                this.table = t;
            }).growX().growY().padRight(8.0f).scrollX(false);
            main.row();
            main.table((Table f) -> {
                f.button("@add", () -> {
                    if (this.groups == null) {
                        this.groups = new Seq();
                    }
                    SpawnGroup newGroup = new SpawnGroup(this.lastType);
                    this.groups.add(newGroup);
                    this.expandedGroup = newGroup;
                    this.showUpdate(newGroup, false);
                    this.buildGroups();
                    this.clearFilter();
                }).growX().height(70.0f);
                f.button(Icon.filter, () -> {
                    BaseDialog dialog = new BaseDialog("@waves.sort");
                    dialog.setFillParent(false);
                    dialog.cont.table(Tex.button, t -> {
                        for (Sort s : Sort.all) {
                            t.button("@waves.sort." + (Object)((Object)s), Styles.cleart, () -> {
                                this.sort = s;
                                dialog.hide();
                                this.buildGroups();
                            }).size(150.0f, 60.0f).checked(s == this.sort);
                        }
                    }).row();
                    dialog.cont.check("@waves.sort.reverse", b -> {
                        this.reverseSort = b;
                        this.buildGroups();
                    }).padTop(4.0f).checked(this.reverseSort).padBottom(8.0f);
                    dialog.addCloseButton();
                    dialog.show();
                    this.buildGroups();
                }).size(64.0f, 70.0f).padLeft(4.0f);
            }).fillX();
        }), new Label("@waves.none"){
            {
                this.visible(() -> arcWaveInfoDialog.this.groups.isEmpty());
                this.touchable = Touchable.disabled;
                this.setWrap(true);
                this.setAlignment(1, 1);
            }
        }).width(390.0f).growY();
        this.cont.table((Table tb) -> {
            if (this.waveInfo) {
                tb.table((Table t) -> {
                    t.table((Table buttons) -> {
                        buttons.clear();
                        buttons.button("<<", Styles.cleart, () -> {
                            this.arcWaveIndex -= 10;
                            if (this.arcWaveIndex < 0) {
                                this.arcWaveIndex = 0;
                            }
                            this.setup();
                        }).size(this.handerSize);
                        buttons.button("<", Styles.cleart, () -> {
                            --this.arcWaveIndex;
                            if (this.arcWaveIndex < 0) {
                                this.arcWaveIndex = 1;
                            }
                            this.setup();
                        }).size(this.handerSize);
                        TextField sField = buttons.field(this.arcWaveIndex + 1 + "", text -> {
                            if (Strings.canParseInt(text)) {
                                this.arcWaveIndex = Integer.parseInt(text) - 1;
                                this.setup();
                            }
                        }).get();
                        buttons.button(">", Styles.cleart, () -> {
                            ++this.arcWaveIndex;
                            this.setup();
                        }).size(this.handerSize);
                        buttons.button(">>", Styles.cleart, () -> {
                            this.arcWaveIndex += 10;
                            this.setup();
                        }).size(this.handerSize);
                        buttons.button("\u00d7", Styles.cleart, () -> {
                            this.arcWaveIndex = 0;
                            this.setup();
                        }).size(this.handerSize);
                        buttons.slider(0.0f, this.calWinWave(), 1.0f, res -> {
                            this.arcWaveIndex = (int)res;
                            sField.setText(this.arcWaveIndex + 1 + "");
                        });
                    }).left().row();
                    t.pane((Table waveInfo2) -> {
                        waveInfo2.clear();
                        waveInfo2.table((Table wi) -> {
                            int curInfoWave = this.arcWaveIndex;
                            for (SpawnGroup group : Vars.state.rules.spawns) {
                                int amount = group.getSpawned(curInfoWave);
                                if (amount <= 0) continue;
                                StringBuilder groupInfo = new StringBuilder();
                                groupInfo.append(group.type.emoji()).append("\n");
                                groupInfo.append(amount).append("\n");
                                if (group.getShield(curInfoWave) > 0.0f) {
                                    groupInfo.append(UI.formatAmount((long)group.getShield(curInfoWave))).append("\n");
                                }
                                if (group.effect != null && group.effect != StatusEffects.none) {
                                    groupInfo.append(group.effect.emoji()).append("\n");
                                }
                                wi.button(groupInfo.toString(), Styles.cleart, () -> this.unitSettingDialog(group)).height(130.0f).width(50.0f);
                            }
                        });
                    }).scrollY(false).left();
                }).growX();
                tb.row();
                this.graph = new WaveGraph();
                tb.add(this.graph).grow();
                tb.row();
                tb.table((Table tbt) -> {
                    tbt.button("<", () -> {}).update((T t) -> {
                        if (t.getClickListener().isPressed()) {
                            this.shift(-this.graphSpeed);
                        }
                    }).width(150.0f);
                    tbt.button(">", () -> {}).update((T t) -> {
                        if (t.getClickListener().isPressed()) {
                            this.shift(this.graphSpeed);
                        }
                    }).width(150.0f);
                    tbt.button("-", () -> {}).update((T t) -> {
                        if (t.getClickListener().isPressed()) {
                            this.view(-this.graphSpeed);
                        }
                    }).width(150.0f);
                    tbt.button("+", () -> {}).update((T t) -> {
                        if (t.getClickListener().isPressed()) {
                            this.view(this.graphSpeed);
                        }
                    }).width(150.0f);
                    tbt.button("x" + this.graphSpeed, () -> {
                        this.graphSpeed *= 2;
                        if (this.graphSpeed > this.maxGraphSpeed) {
                            this.graphSpeed = 1;
                        }
                    }).update((T b) -> b.setText("x" + this.graphSpeed)).width(150.0f);
                }).growX();
            } else {
                tb.pane((Table p) -> {
                    arcWaveSpawner.initArcWave((int)((float)this.calWinWave() * this.waveMulti + 1.0f));
                    p.table(Tex.button, t -> {
                        p.margin(0.0f).defaults().pad(5.0f).growX();
                        t.add("\ue86d \u4e3a\u5355\u4f4d\u6570\u91cf\uff1b\ue813 \u4e3a\u5355\u4f4d\u8840+\u76fe\uff1b\ue810 \u4e3a\u8ba1\u7b97buff\u7684\u8840+\u76fe\uff1b\ue86e \u4e3a\u9884\u4f30DPS\u3002\u5728\u6e38\u620f\u4e2d\u65f6\u4f1a\u8003\u8651\u5730\u56fe\u51fa\u602a\u70b9\u6570\u76ee").color(ARCVars.getThemeColor());
                    }).scrollX(false).growX().row();
                    int wave = 0;
                    while ((float)wave < (float)this.calWinWave() * this.waveMulti) {
                        arcWaveSpawner.waveInfo thisWave = arcWaveSpawner.arcWave.get(wave);
                        thisWave.specLoc(-1, group -> true);
                        int finalWave = wave++;
                        p.table(Tex.button, t -> {
                            t.table((Table tt) -> {
                                tt.add("\u7b2c[accent]" + (finalWave + 1) + "[]\u6ce2");
                                tt.row();
                                float firstWaveTime = Vars.state.rules.initialWaveSpacing <= 0.0f ? 2.0f * Vars.state.rules.waveSpacing : Vars.state.rules.initialWaveSpacing;
                                int thisTime = (int)((float)finalWave * Vars.state.rules.waveSpacing + firstWaveTime);
                                tt.add(RFuncs.fixedTime(thisTime, false)).row();
                                Label waveTime = tt.add("").get();
                                tt.update(() -> {
                                    if (!Vars.state.isGame()) {
                                        waveTime.setText("");
                                    } else {
                                        int deltaTime = thisTime - (int)(Vars.state.wave <= 1 ? firstWaveTime - Vars.state.wavetime : firstWaveTime + Vars.state.rules.waveSpacing * (float)(Vars.state.wave - 1) - Vars.state.wavetime);
                                        waveTime.setText(RFuncs.arcColorTime(deltaTime, false));
                                    }
                                });
                            }).width(120.0f).left();
                            if (thisWave.amount == 0) {
                                t.add("\u8be5\u6ce2\u6b21\u6ca1\u6709\u654c\u4eba");
                            } else {
                                t.add(thisWave.proTable(true));
                                t.pane(thisWave.unitTable(-1, group -> true, Vars.mobile ? 8 : 15)).scrollX(true).scrollY(false).growX();
                            }
                        }).growX().row();
                        p.margin(0.0f).defaults().pad(5.0f).growX();
                    }
                }).scrollX(false).growX().row();
                tb.table((Table tbb) -> {
                    tbb.button("\u5237\u65b0\u6ce2\u6b21\u663e\u793a", this::setup).width(200.0f);
                    TextField sField = tbb.field(this.calWinWave() * (int)this.waveMulti + "", text -> {
                        this.waveMulti = Float.parseFloat(text) / (float)this.calWinWave();
                    }).valid(Strings::canParsePositiveFloat).width(200.0f).get();
                    tbb.slider(0.25f, 10.0f, 0.25f, 1.0f, t -> {
                        this.waveMulti = t;
                        sField.setText(this.calWinWave() * (int)this.waveMulti + "");
                    }).width(300.0f);
                });
            }
        }).grow();
        this.buildGroups();
    }

    void buildGroups() {
        this.table.clear();
        this.table.top();
        this.table.margin(10.0f);
        if (this.groups != null) {
            this.groups.sort(this.sort.sort);
            if (this.reverseSort) {
                this.groups.reverse();
            }
            for (SpawnGroup group : this.groups) {
                if (this.search >= 0 && group.getSpawned(this.search) <= 0) continue;
                if (this.filterHealth != 0) {
                    if (this.filterHealthMode) {
                        float f = group.type.health;
                        int n = this.search >= 0 ? group.getSpawned(this.search) : 1;
                        if (!(f * (float)n > (float)this.filterHealth)) continue;
                    } else {
                        float f = group.type.health;
                        int n = this.search >= 0 ? group.getSpawned(this.search) : 1;
                        if (!(f * (float)n < (float)this.filterHealth)) continue;
                    }
                }
                if (this.filterBegin >= 0 && !(this.filterStrict ? group.begin == this.filterBegin : group.begin - 2 <= this.filterBegin && group.begin + 2 >= this.filterBegin) || this.filterEnd >= 0 && !(this.filterStrict ? group.end == this.filterEnd : group.end - 2 <= this.filterEnd && group.end + 2 >= this.filterEnd) || this.filterAmount != 0 && !(this.filterStrict ? group.getSpawned(this.filterAmountWave) == this.filterAmount : this.filterAmount - 5 <= group.getSpawned(this.filterAmountWave) && this.filterAmount + 5 >= group.getSpawned(this.filterAmountWave)) || this.filterEffect != StatusEffects.none && group.effect != this.filterEffect) continue;
                this.table.table(Tex.button, t -> {
                    t.margin(0.0f).defaults().pad(3.0f).padLeft(5.0f).growX().left();
                    t.button((Button b) -> {
                        b.left();
                        b.image(group.type.uiIcon).size(32.0f).padRight(3.0f).scaling(Scaling.fit);
                        b.add(group.type.typeColor() + group.type.localizedName);
                        if (group.effect != null && group.effect != StatusEffects.none) {
                            b.image(group.effect.uiIcon).size(20.0f).padRight(3.0f).scaling(Scaling.fit);
                        }
                        if (group.items != null && group.items.amount > 0) {
                            b.image(group.items.item.uiIcon).size(20.0f).padRight(3.0f).scaling(Scaling.fit);
                        }
                        if (group.payloads != null && group.payloads.size > 0) {
                            b.image(Icon.uploadSmall).size(20.0f).padRight(3.0f).scaling(Scaling.fit);
                        }
                        b.add().growX();
                        b.label(() -> {
                            StringBuilder builder = new StringBuilder();
                            builder.append("[lightgray]").append(group.begin + 1);
                            if (group.begin == group.end) {
                                return builder.toString();
                            }
                            if (group.end > 999999) {
                                builder.append("+");
                            } else {
                                builder.append("~").append(group.end + 1);
                            }
                            if (group.spacing > 1) {
                                builder.append("[white]|[lightgray]" + group.spacing);
                            }
                            return builder.append("  ").toString();
                        }).minWidth(45.0f).labelAlign(8).left();
                        b.button((Drawable)Icon.settingsSmall, Styles.emptyi, () -> this.unitSettingDialog(group)).pad(-6.0f).size(46.0f);
                        b.button((Drawable)Icon.unitsSmall, Styles.emptyi, () -> this.showUpdate(group, false)).pad(-6.0f).size(46.0f);
                        b.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                            if (this.expandedGroup == group) {
                                this.expandedGroup = null;
                            }
                            this.groups.remove(group);
                            this.table.getCell(t).pad(0.0f);
                            t.remove();
                            this.buildGroups();
                        }).pad(-6.0f).size(46.0f).padRight(-12.0f);
                    }, () -> {
                        this.expandedGroup = this.expandedGroup == group ? null : group;
                        this.buildGroups();
                    }).height(46.0f).pad(-6.0f).padBottom(0.0f).row();
                    if (this.expandedGroup == group) {
                        t.table((Table spawns) -> {
                            spawns.field("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.begin = Strings.parseInt(text) - 1;
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            spawns.add("@waves.to").padLeft(4.0f).padRight(4.0f);
                            spawns.field(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.end = Strings.parseInt(text) - 1;
                                    this.updateWaves();
                                } else if (text.isEmpty()) {
                                    group.end = Integer.MAX_VALUE;
                                    this.updateWaves();
                                }
                            }).width(100.0f).get().setMessageText("\u221e");
                        }).row();
                        t.table((Table p) -> {
                            p.add("@waves.every").padRight(4.0f);
                            p.field(group.spacing + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text) && Strings.parseInt(text) > 0) {
                                    group.spacing = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(100.0f);
                            p.add("@waves.waves").padLeft(4.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.unitAmount = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add(" + ");
                            a.field(Strings.fixed(Math.max(Mathf.zero(group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), 2), TextField.TextFieldFilter.floatsOnly, (String text) -> {
                                if (Strings.canParsePositiveFloat(text)) {
                                    group.unitScaling = 1.0f / Strings.parseFloat(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.perspawn").padLeft(4.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field(group.max + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.max = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.max").padLeft(5.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.field((int)group.shields + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.shields = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add(" + ");
                            a.field((int)group.shieldScaling + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                                if (Strings.canParsePositiveInt(text)) {
                                    group.shieldScaling = Strings.parseInt(text);
                                    this.updateWaves();
                                }
                            }).width(80.0f);
                            a.add("@waves.shields").padLeft(4.0f);
                        }).row();
                        t.table((Table a) -> {
                            a.add("@waves.spawn").padRight(8.0f);
                            a.button("", () -> {
                                if (!this.checkedSpawns) {
                                    Vars.spawner.reset();
                                    this.checkedSpawns = true;
                                }
                                BaseDialog dialog = new BaseDialog("@waves.spawn.select");
                                dialog.cont.pane((Table p) -> {
                                    p.background(Tex.button).margin(10.0f);
                                    int i = 0;
                                    int cols = 4;
                                    int max = 20;
                                    if (Vars.spawner.getSpawns().size >= max) {
                                        p.add("[lightgray](first " + max + ")").colspan(cols).padBottom(4.0f).row();
                                    }
                                    for (Tile spawn : Vars.spawner.getSpawns()) {
                                        p.button(spawn.x + ", " + spawn.y, Styles.flatTogglet, () -> {
                                            group.spawn = Point2.pack(spawn.x, spawn.y);
                                            dialog.hide();
                                        }).size(110.0f, 45.0f).checked(spawn.pos() == group.spawn);
                                        if (++i % cols == 0) {
                                            p.row();
                                        }
                                        if (i < 20) continue;
                                        break;
                                    }
                                    p.button("@waves.spawn.all", Styles.flatTogglet, () -> {
                                        group.spawn = -1;
                                        dialog.hide();
                                    }).size(110.0f, 45.0f).checked(-1 == group.spawn);
                                    if (Vars.spawner.getSpawns().isEmpty()) {
                                        p.add("@waves.spawn.none");
                                    }
                                });
                                dialog.setFillParent(false);
                                dialog.addCloseButton();
                                dialog.show();
                            }).width(160.0f).height(36.0f).get().getLabel().setText(() -> group.spawn == -1 ? "@waves.spawn.all" : Point2.x(group.spawn) + ", " + Point2.y(group.spawn));
                        }).padBottom(8.0f).row();
                    }
                }).width(350.0f).pad(8.0f);
                this.table.row();
            }
        } else {
            this.table.add("@editor.default");
        }
        this.updateWaves();
    }

    void showUpdate(SpawnGroup group, boolean payloads) {
        BaseDialog dialog = new BaseDialog("");
        dialog.setFillParent(true);
        if (payloads && group.payloads == null) {
            group.payloads = Seq.with(new UnitType[0]);
        }
        if (payloads) {
            dialog.cont.table((Table e) -> {
                this.uTable = e;
                this.updateIcons(group);
            }).padBottom(6.0f).row();
        }
        dialog.cont.pane((Table p) -> {
            int i = 0;
            for (UnitType type : Vars.content.units()) {
                if (type.internal || type.isHidden() && !Core.settings.getBool("developmode")) continue;
                p.button((Button t) -> {
                    t.left();
                    t.image(type.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    t.add(type.localizedName);
                }, () -> {
                    if (payloads) {
                        group.payloads.add(type);
                        this.updateIcons(group);
                    } else {
                        group.type = this.lastType = type;
                        this.updateIcons(group);
                        dialog.hide();
                    }
                    if (group.payloads != null && group.type.payloadCapacity <= 8.0f) {
                        group.payloads.clear();
                    }
                    if (group.items != null) {
                        group.items.amount = Mathf.clamp(group.items.amount, 0, group.type.itemCapacity);
                    }
                    this.buildGroups();
                }).pad(2.0f).margin(12.0f).fillX();
                if (++i % 5 != 0) continue;
                p.row();
            }
        });
        dialog.addCloseButton();
        dialog.show();
    }

    void showEffect(SpawnGroup group) {
        BaseDialog dialog = new BaseDialog("");
        dialog.setFillParent(true);
        dialog.cont.pane((Table p) -> {
            int i = 0;
            for (StatusEffect effect : Vars.content.statusEffects()) {
                if (effect != StatusEffects.none && effect.reactive) continue;
                p.button((Button t) -> {
                    t.left();
                    if (effect.uiIcon != null && effect != StatusEffects.none) {
                        t.image(effect.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    } else {
                        t.image(Icon.none).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    }
                    if (effect != StatusEffects.none) {
                        t.add(effect.localizedName);
                    } else {
                        t.add("@settings.resetKey");
                    }
                }, () -> {
                    if (group == null) {
                        this.filterEffect = effect;
                    } else {
                        group.effect = effect;
                    }
                    this.updateIcons(group);
                    dialog.hide();
                    this.buildGroups();
                }).pad(2.0f).margin(12.0f).fillX();
                if (++i % 3 != 0) continue;
                p.row();
            }
        });
        dialog.addCloseButton();
        dialog.show();
    }

    void showItems(SpawnGroup group) {
        BaseDialog dialog = new BaseDialog("");
        dialog.setFillParent(true);
        dialog.cont.table((Table items) -> {
            items.add(Core.bundle.get("filter.option.amount") + ":");
            this.amountField = items.field(group.items != null ? group.items.amount + "" : "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                if (Strings.canParsePositiveInt(text) && group.items != null) {
                    group.items.amount = Strings.parseInt(text) <= 0 ? group.type.itemCapacity : Mathf.clamp(Strings.parseInt(text), 0, group.type.itemCapacity);
                }
            }).width(120.0f).pad(2.0f).margin(12.0f).maxTextLength((group.type.itemCapacity + "").length() + 1).get();
            this.amountField.setMessageText(group.type.itemCapacity + "");
        }).padBottom(6.0f).row();
        dialog.cont.pane((Table p) -> {
            int i = 1;
            p.defaults().pad(2.0f).margin(12.0f).minWidth(200.0f).fillX();
            p.button((Button icon) -> {
                icon.left();
                icon.image(Icon.none).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                icon.add("@settings.resetKey");
            }, () -> {
                group.items = null;
                this.updateIcons(group);
                dialog.hide();
                this.buildGroups();
            });
            for (Item item : Vars.content.items()) {
                p.button((Button t) -> {
                    t.left();
                    if (item.uiIcon != null) {
                        t.image(item.uiIcon).size(32.0f).scaling(Scaling.fit).padRight(2.0f);
                    }
                    t.add(item.localizedName);
                }, () -> {
                    group.items = new ItemStack(item, Strings.parseInt(this.amountField.getText()) <= 0 ? group.type.itemCapacity : Mathf.clamp(Strings.parseInt(this.amountField.getText()), 0, group.type.itemCapacity));
                    this.updateIcons(group);
                    dialog.hide();
                    this.buildGroups();
                });
                if (++i % 3 != 0) continue;
                p.row();
            }
        });
        dialog.addCloseButton();
        dialog.show();
    }

    void showFilter() {
        BaseDialog dialog = new BaseDialog("@waves.filter");
        dialog.setFillParent(false);
        dialog.cont.defaults().size(210.0f, 64.0f);
        dialog.cont.add(Core.bundle.get("waves.sort.health") + ":");
        dialog.cont.table((Table filter) -> {
            filter.button(">", Styles.cleart, () -> {
                this.filterHealthMode = !this.filterHealthMode;
                this.buildGroups();
            }).update((T b) -> b.setText(this.filterHealthMode ? ">" : "<")).size(40.0f).padRight(4.0f);
            filter.defaults().width(170.0f);
            this.numField("", (Table)filter, f -> {
                this.filterHealth = f;
            }, () -> this.filterHealth, 15);
        }).row();
        dialog.cont.add("@waves.filter.begin");
        dialog.cont.table((Table filter) -> {
            filter.defaults().maxWidth(120.0f);
            this.numField("", (Table)filter, f -> {
                this.filterBegin = f - 1;
            }, () -> this.filterBegin + 1, 8);
            this.numField("@waves.to", (Table)filter, f -> {
                this.filterEnd = f - 1;
            }, () -> this.filterEnd + 1, 8);
        }).row();
        dialog.cont.add(Core.bundle.get("waves.filter.amount") + ":");
        dialog.cont.table((Table filter) -> {
            filter.defaults().maxWidth(120.0f);
            this.numField("", (Table)filter, f -> {
                this.filterAmount = f;
            }, () -> this.filterAmount, 12);
            this.numField("@waves.filter.onwave", (Table)filter, f -> {
                this.filterAmountWave = f;
            }, () -> this.filterAmountWave, 8);
        }).row();
        dialog.cont.table((Table t) -> {
            this.eTable = t;
            this.updateIcons(null);
        }).row();
        dialog.row();
        dialog.check("@waves.filter.strict", b -> {
            this.filterStrict = b;
            this.buildGroups();
        }).checked(this.filterStrict).padBottom(10.0f).row();
        dialog.table((Table p) -> {
            p.defaults().size(210.0f, 64.0f).padLeft(4.0f).padRight(4.0f);
            p.button("@back", Icon.left, dialog::hide);
            p.button("@clear", Icon.refresh, () -> {
                this.clearFilter();
                this.buildGroups();
                dialog.hide();
            });
        });
        dialog.addCloseListener();
        dialog.show();
    }

    void unitSettingDialog(SpawnGroup group) {
        BaseDialog dialog = new BaseDialog("\u8bbe\u7f6e\u51fa\u602a\u7ec4");
        dialog.setFillParent(false);
        dialog.cont.table(Tex.button, a -> {
            this.nTable = a;
        }).row();
        dialog.cont.table(Tex.button, a -> {
            this.oTable = a;
        }).row();
        dialog.cont.table(Tex.button, a -> {
            this.iTable = a;
        }).row();
        dialog.cont.table((Table c) -> {
            c.defaults().size(210.0f, 64.0f).pad(2.0f);
            c.button("@waves.duplicate", Icon.copy, () -> {
                SpawnGroup newGroup = group.copy();
                this.groups.add(newGroup);
                this.expandedGroup = newGroup;
                this.buildGroups();
                dialog.hide();
            });
            c.button("@settings.resetKey", Icon.refresh, () -> Vars.ui.showConfirm("@confirm", "@settings.clear.confirm", () -> {
                group.effect = StatusEffects.none;
                group.payloads = Seq.with(new UnitType[0]);
                group.items = null;
                this.buildGroups();
                dialog.hide();
            }));
        });
        this.buildGroups();
        this.updateIcons(group);
        dialog.addCloseButton();
        dialog.show();
    }

    void updateIcons(SpawnGroup group) {
        if (this.nTable != null && group != null) {
            this.nTable.clear();
            this.nTable.defaults().size(400.0f, 50.0f).pad(2.0f);
            this.nTable.table((Table t) -> {
                t.image(group.type.uiIcon).size(32.0f).padRight(5.0f).scaling(Scaling.fit).get();
                t.add(group.type.localizedName).padRight(20.0f).color(Pal.accent);
                t.button((Drawable)Icon.units, Styles.emptyi, () -> this.showUpdate(group, false)).pad(-6.0f).size(50.0f);
            }).growX().row();
        }
        if (this.oTable != null && group != null) {
            this.oTable.clear();
            this.oTable.defaults().size(400.0f, 250.0f).pad(2.0f);
            this.oTable.table((Table t) -> {
                t.table((Table spawns) -> {
                    spawns.field("" + (group.begin + 1), TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.begin = Strings.parseInt(text) - 1;
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    spawns.add("@waves.to").padLeft(4.0f).padRight(4.0f);
                    spawns.field(group.end == Integer.MAX_VALUE ? "" : group.end + 1 + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.end = Strings.parseInt(text) - 1;
                            this.updateWaves();
                        } else if (text.isEmpty()) {
                            group.end = Integer.MAX_VALUE;
                            this.updateWaves();
                        }
                    }).width(150.0f).get().setMessageText("\u221e");
                }).row();
                t.table((Table p) -> {
                    p.add("@waves.every").padRight(4.0f);
                    p.field(group.spacing + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text) && Strings.parseInt(text) > 0) {
                            group.spacing = Strings.parseInt(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    p.add("@waves.waves").padLeft(4.0f);
                }).row();
                t.table((Table a) -> {
                    a.field(group.unitAmount + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.unitAmount = Strings.parseInt(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    a.add(" + ");
                    a.field(Strings.fixed(Math.max(Mathf.zero(group.unitScaling) ? 0.0f : 1.0f / group.unitScaling, 0.0f), 2), TextField.TextFieldFilter.floatsOnly, (String text) -> {
                        if (Strings.canParsePositiveFloat(text)) {
                            group.unitScaling = 1.0f / Strings.parseFloat(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    a.add("@waves.perspawn").padLeft(4.0f);
                }).row();
                t.table((Table a) -> {
                    a.field(group.max + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.max = Strings.parseInt(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    a.add("@waves.max").padLeft(5.0f);
                }).row();
                t.table((Table a) -> {
                    a.field((int)group.shields + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.shields = Strings.parseInt(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    a.add(" + ");
                    a.field((int)group.shieldScaling + "", TextField.TextFieldFilter.digitsOnly, (String text) -> {
                        if (Strings.canParsePositiveInt(text)) {
                            group.shieldScaling = Strings.parseInt(text);
                            this.updateWaves();
                        }
                    }).width(150.0f);
                    a.add("@waves.shields").padLeft(4.0f);
                }).row();
                t.table((Table a) -> {
                    a.add("@waves.spawn").padRight(8.0f);
                    a.button("", () -> {
                        if (!this.checkedSpawns) {
                            Vars.spawner.reset();
                            this.checkedSpawns = true;
                        }
                        BaseDialog dialog = new BaseDialog("@waves.spawn.select");
                        dialog.cont.pane((Table p) -> {
                            p.background(Tex.button).margin(10.0f);
                            int i = 0;
                            int cols = 4;
                            int max = 20;
                            if (Vars.spawner.getSpawns().size >= max) {
                                p.add("[lightgray](first " + max + ")").colspan(cols).padBottom(4.0f).row();
                            }
                            for (Tile spawn : Vars.spawner.getSpawns()) {
                                p.button(spawn.x + ", " + spawn.y, Styles.flatTogglet, () -> {
                                    group.spawn = Point2.pack(spawn.x, spawn.y);
                                    dialog.hide();
                                }).size(110.0f, 45.0f).checked(spawn.pos() == group.spawn);
                                if (++i % cols == 0) {
                                    p.row();
                                }
                                if (i < 20) continue;
                                break;
                            }
                            p.button("@waves.spawn.all", Styles.flatTogglet, () -> {
                                group.spawn = -1;
                                dialog.hide();
                            }).size(110.0f, 45.0f).checked(-1 == group.spawn);
                            if (Vars.spawner.getSpawns().isEmpty()) {
                                p.add("@waves.spawn.none");
                            }
                        });
                        dialog.setFillParent(false);
                        dialog.addCloseButton();
                        dialog.show();
                    }).width(160.0f).height(36.0f).get().getLabel().setText(() -> group.spawn == -1 ? "@waves.spawn.all" : Point2.x(group.spawn) + ", " + Point2.y(group.spawn));
                }).padBottom(8.0f).row();
            }).growX().row();
        }
        if (this.iTable != null && group != null) {
            this.iTable.clear();
            this.iTable.defaults().size(200.0f, 60.0f).pad(2.0f);
            this.iTable.button((Button icon) -> {
                icon.add("\u72b6\u6001");
                if (group.effect != null && group.effect != StatusEffects.none) {
                    icon.image(group.effect.uiIcon).padLeft(6.0f);
                } else {
                    icon.image(Icon.logic).padLeft(6.0f);
                }
            }, (Button.ButtonStyle)Styles.cleart, () -> this.showEffect(group));
            if (group.type.payloadCapacity > 0.0f) {
                this.iTable.button("\u6dfb\u52a0\u8f7d\u8377", Styles.cleart, () -> this.showUpdate(group, true));
            }
            this.iTable.button((Button icon) -> {
                icon.add("\u7269\u54c1");
                if (group.items != null) {
                    icon.image(group.items.item.uiIcon).padLeft(6.0f);
                    icon.add("" + group.items.amount).padLeft(6.0f);
                } else {
                    icon.image(Icon.effect).padLeft(6.0f);
                }
            }, (Button.ButtonStyle)Styles.cleart, () -> this.showItems(group));
        }
        if (this.eTable != null) {
            this.eTable.clear();
            this.eTable.add(Core.bundle.get("waves.filter.effect") + ":");
            this.eTable.button(this.filterEffect != null && this.filterEffect != StatusEffects.none ? new TextureRegionDrawable(this.filterEffect.uiIcon) : Icon.logic, () -> this.showEffect(null)).padLeft(30.0f).size(60.0f);
        }
        if (this.uTable != null && group != null && group.payloads != null) {
            this.uTable.clear();
            this.uTable.left();
            this.uTable.defaults().pad(3.0f);
            this.payLeft = (int)group.type.payloadCapacity;
            this.uTable.table((Table units) -> {
                int i = 0;
                for (UnitType payl : group.payloads) {
                    if (i < this.maxVisible || this.expandPane) {
                        units.table(Tex.button, s -> {
                            s.image(payl.uiIcon).size(45.0f);
                            s.button((Drawable)Icon.cancelSmall, Styles.emptyi, () -> {
                                group.payloads.remove(payl);
                                this.updateIcons(group);
                                this.buildGroups();
                            }).size(20.0f).padRight(-9.0f).padLeft(-6.0f);
                        }).pad(2.0f).margin(12.0f).fillX();
                    }
                    this.payLeft = (int)((float)this.payLeft - payl.hitSize * payl.hitSize);
                    if (++i % 10 != 0) continue;
                    units.row();
                }
            });
            this.uTable.table((Table b) -> {
                b.defaults().pad(2.0f);
                if (group.payloads.size > 1) {
                    b.button(Icon.cancel, () -> {
                        group.payloads.clear();
                        this.updateIcons(group);
                        this.buildGroups();
                    }).tooltip("@clear").row();
                }
                if (group.payloads.size > this.maxVisible) {
                    b.button(this.expandPane ? Icon.eyeSmall : Icon.eyeOffSmall, () -> {
                        this.expandPane = !this.expandPane;
                        this.updateIcons(group);
                    }).size(45.0f).tooltip(this.expandPane ? "@server.shown" : "@server.hidden");
                }
            }).padLeft(6.0f);
        }
    }

    void numField(String text, Table t, Intc cons, Intp prov, int maxLength) {
        if (!text.isEmpty()) {
            t.add(text);
        }
        t.field(prov.get() + "", TextField.TextFieldFilter.digitsOnly, (String input) -> {
            if (Strings.canParsePositiveInt(input)) {
                cons.get(!input.isEmpty() ? Strings.parseInt(input) : 0);
                this.buildGroups();
            }
        }).maxTextLength(maxLength);
    }

    void clearFilter() {
        this.filterAmountWave = 0;
        this.filterAmount = 0;
        this.filterHealth = 0;
        this.filterHealthMode = false;
        this.filterStrict = false;
        this.filterEnd = -1;
        this.filterBegin = -1;
        this.filterEffect = StatusEffects.none;
    }

    void updateWaves() {
        this.graph.groups = this.groups;
        this.graph.from = this.start;
        this.graph.to = this.start + this.displayed;
        this.graph.rebuild();
    }

    void arcSpawner() {
        BaseDialog dialog = new BaseDialog("ARC-\u968f\u673a\u751f\u6210\u5668");
        Table table = dialog.cont;
        Runnable[] rebuild = new Runnable[]{null};
        rebuild[0] = () -> {
            table.clear();
            table.table((Table c) -> {
                c.table((Table ct) -> {
                    ct.add("\u96be\u5ea6\uff1a").width(100.0f);
                    ct.field(this.difficult + "", text -> {
                        this.difficult = Float.valueOf(Float.parseFloat(text));
                    }).valid(Strings::canParsePositiveFloat).width(200.0f);
                }).width(300.0f);
                c.row();
                c.button("\u5355\u4f4d\u8bbe\u7f6e", (Drawable)(this.showUnitSelect ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                    this.showUnitSelect = !this.showUnitSelect;
                    rebuild[0].run();
                }).fillX().minWidth(400.0f).row();
                c.row();
                if (this.showUnitSelect) {
                    c.table((Table list) -> {
                        for (UnitType unit : Vars.content.units()) {
                            if (unit.internal) continue;
                            list.button(unit.emoji(), Styles.flatToggleMenut, () -> {
                                if (this.spawnUnit.contains(unit)) {
                                    this.spawnUnit.remove(unit);
                                } else {
                                    this.spawnUnit.add(unit);
                                }
                                rebuild[0].run();
                            }).tooltip(unit.localizedName).checked(this.spawnUnit.contains(unit)).size(50.0f);
                            if (list.getChildren().size % 8 != 0) continue;
                            list.row();
                        }
                    }).row();
                    c.table((Table ct) -> {
                        ct.add("\u73af\u5883").width(50.0f);
                        ct.button("Surplus", Styles.flatToggleMenut, () -> {
                            this.surplusUnit = !this.surplusUnit;
                            for (UnitType unit : this.allowUnit.copy().retainAll(unitType -> !(unitType instanceof ErekirUnitType))) {
                                this.filterUnit(unit, this.surplusUnit);
                            }
                            rebuild[0].run();
                        }).checked(this.surplusUnit).width(120.0f);
                        ct.button("Erekir", Styles.flatToggleMenut, () -> {
                            this.ErekirUnit = !this.ErekirUnit;
                            for (UnitType unit : this.allowUnit.copy().retainAll(unitType -> unitType instanceof ErekirUnitType)) {
                                this.filterUnit(unit, this.ErekirUnit);
                            }
                            rebuild[0].run();
                        }).checked(this.ErekirUnit).width(120.0f);
                    });
                    c.row();
                    c.table((Table ct) -> {
                        ct.add("\u5175\u79cd").width(50.0f);
                        ct.button("\u7a7a\u519b", Styles.flatToggleMenut, () -> {
                            this.flyingUnit = !this.flyingUnit;
                            for (UnitType unit : this.allowUnit.copy().retainAll(unitType -> unitType.flying)) {
                                this.filterUnit(unit, this.flyingUnit);
                            }
                            rebuild[0].run();
                        }).checked(this.flyingUnit).width(70.0f);
                        ct.button("\u6d77\u519b", Styles.flatToggleMenut, () -> {
                            this.navalUnit = !this.navalUnit;
                            for (UnitType unit : this.allowUnit.copy().retainAll(unitType -> unitType.naval)) {
                                this.filterUnit(unit, this.navalUnit);
                            }
                            rebuild[0].run();
                        }).checked(this.navalUnit).width(70.0f);
                        ct.button("\u652f\u63f4", Styles.flatToggleMenut, () -> {
                            this.supportUnit = !this.supportUnit;
                            for (UnitType unit : this.allowUnit.copy().retainAll(unitType -> unitType.controller instanceof BuilderAI || unitType.controller instanceof MinerAI || unitType.controller instanceof RepairAI)) {
                                this.filterUnit(unit, this.supportUnit);
                            }
                            rebuild[0].run();
                        }).checked(this.supportUnit).width(70.0f);
                    });
                }
                c.row();
                c.button("\u751f\u6210\uff01", () -> {
                    this.groups.clear();
                    this.groups = Waves.generate(this.difficult.floatValue() / 10.0f, this.flyingUnit, this.navalUnit, this.supportUnit);
                    this.updateWaves();
                    this.buildGroups();
                }).width(300.0f);
            });
        };
        rebuild[0].run();
        dialog.addCloseButton();
        dialog.show();
        Vars.ui.announce("\u529f\u80fd\u5236\u4f5c\u4e2d..\u8bf7\u7b49\u5f85\u5b8c\u6210\n[orange]\u76ee\u524d\u53ef\u8c03\u6574\uff1a\u96be\u5ea6|\u7a7a|\u6d77|\u8f85\uff0c\u5176\u4ed6\u529f\u80fd\u5747\u65e0\u6548", 15.0f);
    }

    private void filterUnit(UnitType unit, boolean filter) {
        if (filter && !this.spawnUnit.contains(unit)) {
            this.spawnUnit.add(unit);
        } else if (!filter && this.spawnUnit.contains(unit)) {
            this.spawnUnit.remove(unit);
        }
    }

    public Seq<SpawnGroup> arcGenerate(final float difficulty) {
        UnitType[][] species;
        final Rand rand = new Rand();
        UnitType[][] fspec = species = new UnitType[][]{{UnitTypes.dagger, UnitTypes.mace, UnitTypes.fortress, UnitTypes.scepter, UnitTypes.reign}, {UnitTypes.nova, UnitTypes.pulsar, UnitTypes.quasar, UnitTypes.vela, UnitTypes.corvus}, {UnitTypes.crawler, UnitTypes.atrax, UnitTypes.spiroct, UnitTypes.arkyid, UnitTypes.toxopid}, {UnitTypes.risso, UnitTypes.minke, UnitTypes.bryde, UnitTypes.sei, UnitTypes.omura}, {UnitTypes.retusa, UnitTypes.oxynoe, UnitTypes.cyerce, UnitTypes.aegires, UnitTypes.navanax}, {UnitTypes.flare, UnitTypes.horizon, UnitTypes.zenith, UnitTypes.antumbra, UnitTypes.eclipse}, {UnitTypes.mono, UnitTypes.poly, UnitTypes.mega, UnitTypes.quad, UnitTypes.oct}, {UnitTypes.stell, UnitTypes.locus, UnitTypes.precept, UnitTypes.vanquish, UnitTypes.conquer}, {UnitTypes.merui, UnitTypes.cleroi, UnitTypes.anthicus, UnitTypes.tecta, UnitTypes.collaris}, {UnitTypes.elude, UnitTypes.avert, UnitTypes.obviate, UnitTypes.quell, UnitTypes.disrupt}};
        Seq<SpawnGroup> out = new Seq<SpawnGroup>();
        final int cap = 150;
        float shieldStart = 30.0f;
        final float shieldsPerWave = 20.0f + difficulty * 30.0f;
        final float[] scaling = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        Intc createProgression = start -> {
            UnitType[] curSpecies = (UnitType[])Structs.random(fspec);
            int curTier = 0;
            int i = start;
            while (i < cap) {
                final int f = i;
                final int next = rand.random(8, 16) + (int)Mathf.lerp(5.0f, 0.0f, difficulty) + curTier * 4;
                final float shieldAmount = Math.max(((float)i - shieldStart) * shieldsPerWave, 0.0f);
                final int space = start == 0 ? 1 : rand.random(1, 2);
                final int ctier = curTier;
                out.add(new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(type);
                        this.unitAmount = f == start ? 1 : 6 / (int)scaling[ctier];
                        this.begin = f;
                        this.end = f + next >= cap ? Integer.MAX_VALUE : f + next;
                        this.max = 13;
                        this.unitScaling = (difficulty < 0.4f ? rand.random(2.5f, 5.0f) : rand.random(1.0f, 4.0f)) * scaling[ctier];
                        this.shields = shieldAmount;
                        this.shieldScaling = shieldsPerWave;
                        this.spacing = space;
                    }
                });
                out.add(new SpawnGroup(curSpecies[Math.min(curTier, curSpecies.length - 1)]){
                    {
                        super(type);
                        this.unitAmount = 3 / (int)scaling[ctier];
                        this.begin = f + next - 1;
                        this.end = f + next + rand.random(6, 10);
                        this.max = 6;
                        this.unitScaling = rand.random(2.0f, 4.0f);
                        this.spacing = rand.random(2, 4);
                        this.shields = shieldAmount / 2.0f;
                        this.shieldScaling = shieldsPerWave;
                    }
                });
                i += next + 1;
                if (curTier < 3 || rand.chance(0.05) && (double)difficulty > 0.8) {
                    ++curTier;
                }
                curTier = Math.min(curTier, 3);
                if (!rand.chance(0.3)) continue;
                curSpecies = (UnitType[])Structs.random(fspec);
            }
        };
        createProgression.get(0);
        for (int step = 5 + rand.random(5); step <= cap; step += (int)((float)rand.random(15, 30) * Mathf.lerp(1.0f, 0.5f, difficulty))) {
            createProgression.get(step);
        }
        final int bossWave = (int)((float)rand.random(50, 70) * Mathf.lerp(1.0f, 0.5f, difficulty));
        final int bossSpacing = (int)((float)rand.random(25, 40) * Mathf.lerp(1.0f, 0.5f, difficulty));
        int bossTier = (double)difficulty < 0.6 ? 3 : 4;
        out.add(new SpawnGroup(((UnitType[])Structs.random(species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = bossWave;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        out.add(new SpawnGroup(((UnitType[])Structs.random(species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = bossWave + rand.random(3, 5) * bossSpacing;
                this.spacing = bossSpacing;
                this.end = Integer.MAX_VALUE;
                this.max = 16;
                this.unitScaling = bossSpacing;
                this.shieldScaling = shieldsPerWave;
                this.effect = StatusEffects.boss;
            }
        });
        final int finalBossStart = 120 + rand.random(30);
        out.add(new SpawnGroup(((UnitType[])Structs.random(species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = finalBossStart;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        out.add(new SpawnGroup(((UnitType[])Structs.random(species))[bossTier]){
            {
                super(type);
                this.unitAmount = 1;
                this.begin = finalBossStart + 15;
                this.spacing = bossSpacing / 2;
                this.end = Integer.MAX_VALUE;
                this.unitScaling = bossSpacing;
                this.shields = 500.0f;
                this.shieldScaling = shieldsPerWave * 4.0f;
                this.effect = StatusEffects.boss;
            }
        });
        if (this.supportUnit && (double)difficulty >= 0.5) {
            int amount = Mathf.random(1, 3 + (int)(difficulty * 2.0f));
            for (int i = 0; i < amount; ++i) {
                final int wave = Mathf.random(3, 20);
                out.add(new SpawnGroup(UnitTypes.mega){
                    {
                        super(type);
                        this.unitAmount = 1;
                        this.begin = wave;
                        this.end = wave;
                        this.max = 16;
                    }
                });
            }
        }
        int shift = Math.max((int)(difficulty * 14.0f - 5.0f), 0);
        for (SpawnGroup group : out) {
            group.begin -= shift;
            group.end -= shift;
        }
        return out;
    }

    public int calWinWave() {
        if (Vars.state.rules.winWave >= 1) {
            return Vars.state.rules.winWave;
        }
        int maxwave = 0;
        for (SpawnGroup group : Vars.state.rules.spawns) {
            if (group.end > 99999) continue;
            maxwave = Math.max(maxwave, group.end);
        }
        if (maxwave > 5000) {
            return 200;
        }
        if (maxwave < 2 && Vars.state.rules.waveSpacing > 30.0f) {
            return (int)(1800000.0f / Vars.state.rules.waveSpacing);
        }
        return maxwave + 1;
    }

    static enum Sort {
        begin(Structs.comps(Structs.comparingFloat(g -> g.begin), Structs.comparingFloat(g -> g.type.id))),
        health(Structs.comps(Structs.comparingFloat(g -> g.type.health), Structs.comparingFloat(g -> g.begin))),
        type(Structs.comps(Structs.comparingFloat(g -> g.type.id), Structs.comparingFloat(g -> g.begin)));

        static final Sort[] all;
        final Comparator<SpawnGroup> sort;

        private Sort(Comparator<SpawnGroup> sort) {
            this.sort = sort;
        }

        static {
            all = Sort.values();
        }
    }
}

