/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.math.Mathf;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.ui.dialogs.BaseDialog;

public class MapResizeDialog
extends BaseDialog {
    public static int minSize = 10;
    public static int maxSize = 9999;
    public static int increment = 50;
    int width;
    int height;
    int shiftX;
    int shiftY;

    public MapResizeDialog(ResizeListener cons) {
        super("@editor.resizemap");
        this.closeOnBack();
        this.shown(() -> {
            this.cont.clear();
            this.width = Vars.editor.width();
            this.height = Vars.editor.height();
            Table table = new Table();
            for (boolean w : Mathf.booleans) {
                table.add(w ? "@width" : "@height").padRight(8.0f);
                table.defaults().height(60.0f).padTop(8.0f);
                table.field((w ? this.width : this.height) + "", TextField.TextFieldFilter.digitsOnly, (String value) -> {
                    int val = Integer.parseInt(value);
                    if (w) {
                        this.width = val;
                    } else {
                        this.height = val;
                    }
                }).valid(value -> Strings.canParsePositiveInt(value) && Integer.parseInt(value) <= maxSize && Integer.parseInt(value) >= minSize).maxTextLength(4);
                table.row();
            }
            for (boolean x : Mathf.booleans) {
                table.add(x ? "@editor.shiftx" : "@editor.shifty").padRight(8.0f);
                table.defaults().height(60.0f).padTop(8.0f);
                table.field((x ? this.shiftX : this.shiftY) + "", value -> {
                    int val = Integer.parseInt(value);
                    if (x) {
                        this.shiftX = val;
                    } else {
                        this.shiftY = val;
                    }
                }).valid(Strings::canParseInt).maxTextLength(4);
                table.row();
            }
            this.cont.row();
            this.cont.add(table);
        });
        this.buttons.defaults().size(200.0f, 50.0f);
        this.buttons.button("@cancel", this::hide);
        this.buttons.button("@ok", () -> {
            cons.get(this.width, this.height, this.shiftX, this.shiftY);
            this.hide();
        });
    }

    public static interface ResizeListener {
        public void get(int var1, int var2, int var3, int var4);
    }
}

