/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.Core;
import arc.scene.style.Drawable;
import arc.scene.ui.TextArea;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import mindustry.Vars;
import mindustry.editor.MapGenerateDialog;
import mindustry.editor.MapLocalesDialog;
import mindustry.editor.MapObjectivesDialog;
import mindustry.editor.MapProcessorsDialog;
import mindustry.editor.arcWaveInfoDialog;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.io.JsonIO;
import mindustry.maps.filters.GenerateFilter;
import mindustry.type.MapLocales;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.CustomRulesDialog;

public class MapInfoDialog
extends BaseDialog {
    private final arcWaveInfoDialog waveInfo;
    private final MapGenerateDialog generate;
    private final CustomRulesDialog ruleInfo = new CustomRulesDialog();
    private final MapObjectivesDialog objectives = new MapObjectivesDialog();
    private MapLocalesDialog locales = new MapLocalesDialog();
    private MapProcessorsDialog processors = new MapProcessorsDialog();

    public MapInfoDialog() {
        super("@editor.mapinfo");
        this.waveInfo = new arcWaveInfoDialog();
        this.generate = new MapGenerateDialog(false);
        this.addCloseButton();
        this.shown(this::setup);
    }

    public void setup() {
        this.cont.clear();
        StringMap tags = Vars.editor.tags;
        this.cont.pane((Table t) -> {
            t.add("@editor.mapname").padRight(8.0f).left();
            t.defaults().padTop(15.0f);
            TextField name = t.field(Vars.state.isPlaying() ? Vars.state.map.name() : tags.get("name", ""), text -> tags.put("name", text)).size(400.0f, 55.0f).maxTextLength(50).get();
            name.setMessageText("@unknown");
            t.row();
            t.add("@editor.description").padRight(8.0f).left();
            TextArea description = t.area(Vars.state.isPlaying() ? Vars.state.map.description() : tags.get("description", ""), Styles.areaField, text -> tags.put("description", text)).size(400.0f, 140.0f).maxTextLength(1000).get();
            t.row();
            t.add("[acid]\u5730\u56fe\u6a21\u5f0f\u6807\u7b7e").padRight(8.0f).left();
            TextField modeName = t.field(Vars.state.isPlaying() ? Vars.state.rules.modeName : tags.get("modeName", ""), Styles.areaField, (String text) -> tags.put("modeName", text)).size(400.0f, 55.0f).maxTextLength(1000).get();
            if (Core.settings.getBool("arcPlayerList")) {
                t.row();
                t.add("[cyan]\u670d\u52a1\u5668\u6807\u7b7e").padRight(8.0f).left();
                t.button("\u7f16\u8f91...", () -> {
                    BaseDialog dialog = new BaseDialog("\u5730\u56fe\u6807\u7b7e");
                    dialog.cont.pane((Table td) -> {
                        td.add("[cyan]\u5fae\u6cfd\u7cfb\u670d\u52a1\u5668\u6807\u7b7e\u7f16\u8f91\u5668 \n[white]BY [violet]Lucky Clover\n\n[white]\u7528\u4e8e\u56fd\u5185\u65b0\u7248\u5fae\u6cfd\u7cfb\u63d2\u4ef6\u6807\u7b7e\u3002\n[orange]\u5982\u679c\u60a8\u53d1\u73b0\u6807\u7b7e\u65e0\u6548\uff0c\u53ef\u80fd\u662f\u60a8\u6240\u5728\u7684\u670d\u52a1\u5668\u63d2\u4ef6\u7248\u672c\u8fc7\u4f4e\u3002\u8bf7\u8054\u7cfb\u670d\u4e3b\u66f4\u65b0\u63d2\u4ef6\n\u6240\u6709\u6807\u7b7e\u4e0e\u4e3b\u670d\u540c\u6b65\n\n[red]\u9700\u8981\u9000\u51fa\u5730\u56fe\u754c\u9762\u540e\u91cd\u65b0\u6253\u5f00\u624d\u4f1a\u66f4\u65b0\n\n[white]\u5982\u679c\u6709bug\u6b22\u8fce\u63d0\u51fa");
                        td.row();
                        td.row();
                        td.add("PVP\u4fdd\u62a4\u65f6\u95f4(s)").left();
                        td.field(this.arcReadStringLabel("@pvpProtect"), pama -> this.arcAddStringLabel((String)pama, "@pvpProtect")).maxTextLength(5).left();
                        td.row();
                        td.add("\u7981\u7528\u961f\u4f0d(\u59821,2,3...)").left();
                        td.field(this.arcReadStringLabel("@banTeam"), pama -> this.arcAddStringLabel((String)pama, "@banTeam")).maxTextLength(5).left();
                        td.row();
                        td.add("\u63d2\u4ef6\u9009\u62e9").left();
                        td.field(this.arcReadStringLabel("@mapScript"), pama -> this.arcAddStringLabel((String)pama, "@mapScript")).maxTextLength(6).left();
                        td.row();
                        td.check("\u7a7a\u57df\u7ba1\u5236 [acid]\u654c\u65b9\u6838\u5fc3\u4fdd\u62a4\u533a\u5185\u7981\u6b62\u7a7a\u519b", this.arcreadBoolLable("[@limitAir]"), islimit -> this.arcAddBoolLable(islimit, "[@limitAir]")).left();
                        td.row();
                        td.check("\u5854\u9632\u6a21\u5f0f [acid]\u602a\u7269\u4ec5\u4f1a\u5728\u51fa\u751f\u70b9\u5730\u677f\u79fb\u52a8\uff0c\u4e0d\u4f1a\u653b\u51fb", this.arcreadBoolLable("[@towerDefend]"), islimit -> this.arcAddBoolLable(islimit, "[@towerDefend]")).left();
                        td.row();
                        td.check("\u654c\u4eba\u6389\u843d [acid]\u975e\u5854\u9632\u6a21\u5f0f\u4e0b\uff0c\u6253\u602a\u6389\u843d\u8d44\u6e90", this.arcreadBoolLable("[@TDDrop]"), islimit -> this.arcAddBoolLable(islimit, "[@TDDrop]")).left();
                        td.row();
                        td.check("\u6c34\u6f2b\u91d1\u5c71 [acid]\u84dd\u961f\u6838\u5fc3\u4f1a\u91ca\u653e\u6d2a\u6c34\u6df9\u6ca1\u4f60\u7684\u6838\u5fc3", this.arcreadBoolLable("[@floodV2]"), islimit -> this.arcAddBoolLable(islimit, "[@flood]")).left();
                    }).left();
                    dialog.row();
                    dialog.addCloseButton();
                    dialog.margin(16.0f);
                    dialog.show();
                }).left().width(200.0f);
            }
            t.row();
            t.add("@editor.author").padRight(8.0f).left();
            TextField author = t.field(Vars.state.isPlaying() ? Vars.state.map.author() : tags.get("author", ""), text -> tags.put("author", text)).size(400.0f, 55.0f).maxTextLength(50).get();
            author.setMessageText("@unknown");
            t.row();
            t.table(Tex.button, r -> {
                r.defaults().width(230.0f).height(60.0f);
                TextButton.TextButtonStyle style = Styles.flatt;
                r.button("@editor.rules", (Drawable)Icon.list, style, () -> {
                    this.ruleInfo.show(Vars.state.rules, () -> {
                        Vars.state.rules = new Rules();
                        return Vars.state.rules;
                    });
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.waves", (Drawable)Icon.units, style, () -> {
                    this.waveInfo.show();
                    this.hide();
                }).marginLeft(10.0f);
                r.row();
                r.button("@editor.objectives", (Drawable)Icon.info, style, () -> {
                    this.objectives.show(Vars.state.rules.objectives.all, Vars.state.rules.objectives.all::set);
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.generation", (Drawable)Icon.terrain, style, () -> {
                    Seq<GenerateFilter> res = Vars.maps.readFilters(Vars.editor.tags.get("genfilters", ""));
                    res.each(GenerateFilter::randomize);
                    this.generate.show(res, (Seq<GenerateFilter> filters) -> {
                        filters.each(f -> {
                            f.seed = 0;
                        });
                        Vars.editor.tags.put("genfilters", JsonIO.write(filters));
                    });
                    this.hide();
                }).marginLeft(10.0f);
                r.row();
                r.button("@editor.locales", (Drawable)Icon.fileText, style, () -> {
                    try {
                        MapLocales res = JsonIO.read(MapLocales.class, Vars.editor.tags.get("locales", "{}"));
                        this.locales.show(res);
                    }
                    catch (Throwable e) {
                        this.locales.show(new MapLocales());
                        Vars.ui.showException(e);
                    }
                    this.hide();
                }).marginLeft(10.0f);
                r.button("@editor.worldprocessors", (Drawable)Icon.logic, style, () -> {
                    this.hide();
                    this.processors.show();
                }).marginLeft(10.0f);
            }).colspan(2).center();
            name.change();
            description.change();
            modeName.change();
            author.change();
            t.margin(16.0f);
        });
    }

    private String arcReadStringLabel(String labelName) {
        StringMap tags = Vars.editor.tags;
        String des = tags.get("description", "");
        try {
            int i;
            int strLength = des.length();
            int stopindex = 0;
            for (i = 0; i < strLength; ++i) {
                if (!des.substring(i, i + 2 + labelName.length()).equals("[" + labelName + "=")) continue;
                stopindex = i;
                break;
            }
            for (i = stopindex; i < strLength; ++i) {
                if (des.charAt(i) != ']') continue;
                return des.substring(stopindex + 2 + labelName.length(), i);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "<\u672a\u8bbe\u5b9a\u53c2\u6570>";
    }

    private void arcAddStringLabel(String parameter, String labelName) {
        StringMap tags = Vars.editor.tags;
        String des = tags.get("description", "");
        if (des.contains(labelName)) {
            try {
                int i;
                int strLength = des.length();
                int stopindex = 0;
                for (i = 0; i < strLength; ++i) {
                    if (!des.substring(i, i + 2 + labelName.length()).equals("[" + labelName + "=")) continue;
                    stopindex = i;
                    break;
                }
                for (i = stopindex; i < strLength; ++i) {
                    if (des.charAt(i) != ']') continue;
                    des = des.substring(0, stopindex + 2 + labelName.length()) + parameter + des.substring(i, strLength + 1);
                    tags.put("description", des);
                }
            }
            catch (Exception exception) {}
        } else {
            tags.put("description", des.concat("[" + labelName + "=" + parameter + "]"));
        }
    }

    private boolean arcreadBoolLable(String labelname) {
        StringMap tags = Vars.editor.tags;
        if (tags.get("description", "").contains(labelname)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void arcAddBoolLable(Boolean isadd, String labelname) {
        StringMap tags = Vars.editor.tags;
        String des = tags.get("description", "");
        if (des.contains(labelname) && !isadd.booleanValue()) {
            tags.put("description", des.replace(labelname, ""));
        } else if (!des.contains(labelname) && isadd.booleanValue()) {
            tags.put("description", des.concat(labelname));
        }
    }
}

