/*
 * Decompiled with CFR 0.152.
 */
package mindustry.editor;

import arc.func.Prov;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.TileOp;
import mindustry.graphics.CacheLayer;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OreBlock;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.modules.ItemModule;
import mindustry.world.modules.LiquidModule;
import mindustry.world.modules.PowerModule;

public class EditorTile
extends Tile {
    public EditorTile(int x, int y, int floor, int overlay, int wall) {
        super(x, y, floor, overlay, wall);
    }

    @Override
    public void setFloor(Floor type) {
        if (this.skip()) {
            super.setFloor(type);
            return;
        }
        if (type instanceof OverlayFloor) {
            if (this.floor.hasSurface() || !type.needsSurface) {
                this.setOverlay(type);
            }
            return;
        }
        if (this.floor == type) {
            return;
        }
        this.op(0, this.floor.id);
        this.floor = type;
        type.floorChanged(this);
    }

    @Override
    public boolean isEditorTile() {
        return true;
    }

    @Override
    public void setBlock(Block type, Team team, int rotation, Prov<Building> entityprov) {
        EditorTile prevCenter;
        Block prev = this.block;
        Tile tile2 = prevCenter = this.build == null ? this : this.build.tile;
        if (this.skip()) {
            super.setBlock(type, team, rotation, entityprov);
            return;
        }
        if (this.block == type && (this.build == null || this.build.rotation == rotation)) {
            return;
        }
        if (!this.isCenter()) {
            EditorTile cen = (EditorTile)this.build.tile;
            cen.op(2, (byte)this.build.rotation);
            cen.op(3, (byte)this.build.team.id);
            cen.op(1, this.block.id);
            this.updateStatic();
        } else {
            if (this.build != null) {
                this.op(2, (byte)this.build.rotation);
            }
            if (this.build != null) {
                this.op(3, (byte)this.build.team.id);
            }
            this.op(1, this.block.id);
        }
        super.setBlock(type, team, rotation, entityprov);
        if (this.requiresBlockUpdate(type) || this.requiresBlockUpdate(prev)) {
            if (prev.size > 1) {
                prevCenter.getLinkedTilesAs(prev, (Tile tile) -> Vars.editor.renderer.updateBlock((Tile)tile));
            }
            this.getLinkedTiles((Tile tile) -> Vars.editor.renderer.updateBlock((Tile)tile));
        } else {
            Vars.renderer.blocks.updateShadowTile(this);
        }
    }

    @Override
    public void setTeam(Team team) {
        if (this.skip()) {
            super.setTeam(team);
            return;
        }
        if (this.getTeamID() == team.id || !this.synthetic()) {
            return;
        }
        this.op(3, (byte)this.getTeamID());
        super.setTeam(team);
        this.getLinkedTiles((Tile t) -> Vars.editor.renderer.updateBlock(t.x, t.y));
    }

    @Override
    public void setOverlay(Block overlay) {
        if (this.skip()) {
            super.setOverlay(overlay);
            return;
        }
        if (!this.floor.hasSurface() && overlay.asFloor().needsSurface && (overlay instanceof OreBlock || !this.floor.supportsOverlay)) {
            return;
        }
        if (this.overlay == overlay) {
            return;
        }
        this.op(4, this.overlay.id);
        super.setOverlay(overlay);
    }

    @Override
    protected void fireChanged() {
        if (this.skip()) {
            super.fireChanged();
        } else {
            this.updateStatic();
        }
    }

    @Override
    protected void firePreChanged() {
        if (this.skip()) {
            super.firePreChanged();
        } else {
            this.updateStatic();
        }
    }

    @Override
    public void recache() {
        if (this.skip()) {
            super.recache();
        }
    }

    @Override
    protected void changed() {
        if (Vars.state.isGame()) {
            super.changed();
        }
    }

    @Override
    protected void changeBuild(Team team, Prov<Building> entityprov, int rotation) {
        Block block;
        if (this.skip()) {
            super.changeBuild(team, entityprov, rotation);
            return;
        }
        this.build = null;
        if (this.block == null) {
            this.block = Blocks.air;
        }
        if (this.floor == null) {
            this.floor = (Floor)Blocks.air;
        }
        if ((block = this.block()).hasBuilding()) {
            this.build = entityprov.get().init(this, team, false, rotation);
            if (block.hasItems) {
                this.build.items = new ItemModule();
            }
            if (block.hasLiquids) {
                this.build.liquids = new LiquidModule();
            }
            if (block.hasPower) {
                this.build.power = new PowerModule();
            }
        }
    }

    @Override
    public boolean isDarkened() {
        return this.skip() && super.isDarkened();
    }

    private boolean requiresBlockUpdate(Block block) {
        return block != Blocks.air && block.cacheLayer == CacheLayer.normal;
    }

    private void updateStatic() {
        Vars.editor.renderer.updateStatic(this.x, this.y);
    }

    private boolean skip() {
        return Vars.state.isGame() || Vars.editor.isLoading() || Vars.world.isGenerating();
    }

    private void op(int type, short value) {
        Vars.editor.addTileOp(TileOp.get(this.x, this.y, (byte)type, value));
    }
}

