/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.AssetDescriptor;
import arc.assets.loaders.TextureLoader;
import arc.audio.Music;
import arc.files.Fi;
import arc.graphics.Camera;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.PixmapIO;
import arc.graphics.Texture;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.FrameBuffer;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Buffers;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.ScreenUtils;
import arc.util.Threads;
import arc.util.Time;
import arc.util.Tmp;
import java.nio.Buffer;
import mindustry.Vars;
import mindustry.core.PerfCounter;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.gen.Drawc;
import mindustry.gen.Groups;
import mindustry.graphics.BlockRenderer;
import mindustry.graphics.CacheLayer;
import mindustry.graphics.DebugCollisionRenderer;
import mindustry.graphics.EnvRenderers;
import mindustry.graphics.FogRenderer;
import mindustry.graphics.LightRenderer;
import mindustry.graphics.MinimapRenderer;
import mindustry.graphics.OverlayRenderer;
import mindustry.graphics.Pixelator;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.graphics.g3d.PlanetRenderer;
import mindustry.maps.MapPreviewLoader;
import mindustry.world.blocks.LaunchAnimator;

public class Renderer
implements ApplicationListener {
    public boolean fogEnabled = true;
    public static float laserOpacity = 0.5f;
    public static float unitLaserOpacity = 1.0f;
    public static float bridgeOpacity = 0.75f;
    public final BlockRenderer blocks = new BlockRenderer();
    public final FogRenderer fog = new FogRenderer();
    public final MinimapRenderer minimap = new MinimapRenderer();
    public final OverlayRenderer overlays = new OverlayRenderer();
    public final LightRenderer lights = new LightRenderer();
    public final Pixelator pixelator = new Pixelator();
    public PlanetRenderer planets;
    @Nullable
    public Bloom bloom;
    @Nullable
    public FrameBuffer backgroundBuffer;
    public FrameBuffer effectBuffer = new FrameBuffer();
    public boolean drawBars = true;
    public boolean animateShields;
    public boolean animateWater;
    public boolean drawWeather = true;
    public boolean drawStatus;
    public boolean enableEffects;
    public boolean drawDisplays = true;
    public boolean drawLight = true;
    public boolean pixelate = false;
    public float weatherAlpha;
    public float minZoom = 0.25f;
    public float maxZoom = 20.0f;
    public float minZoomInGame = 0.5f;
    public float maxZoomInGame = 6.0f;
    public Seq<EnvRenderer> envRenderers = new Seq();
    public ObjectMap<String, Runnable> customBackgrounds = new ObjectMap();
    public TextureRegion[] bubbles = new TextureRegion[16];
    public TextureRegion[] splashes = new TextureRegion[12];
    public TextureRegion[][] fluidFrames;
    @Nullable
    private LaunchAnimator launchAnimator;
    private Color clearColor = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public float targetscale;
    public float camerascale = this.targetscale = Scl.scl(4.0f);
    public float landTime;
    public float shakeIntensity;
    public float shakeReduction;
    public float shakeTime;
    private boolean launching;
    private Vec2 camShakeOffset = new Vec2();
    private int glErrors;

    public Renderer() {
        Core.camera = new Camera();
        Shaders.init();
        Events.on(EventType.ResetEvent.class, e -> {
            this.shakeReduction = 0.0f;
            this.shakeIntensity = 0.0f;
            this.shakeTime = 0.0f;
            this.camShakeOffset.setZero();
        });
    }

    public void shake(float intensity, float duration) {
        this.shakeIntensity = Math.max(this.shakeIntensity, Mathf.clamp(intensity, 0.0f, 100.0f));
        this.shakeTime = Math.max(this.shakeTime, duration);
        this.shakeReduction = this.shakeIntensity / this.shakeTime;
    }

    public void addEnvRenderer(int mask, Runnable render) {
        this.envRenderers.add(new EnvRenderer(mask, render));
    }

    public void addCustomBackground(String name, Runnable render) {
        this.customBackgrounds.put(name, render);
    }

    @Override
    public void init() {
        int i;
        this.planets = new PlanetRenderer();
        if (Core.settings.getBool("bloom", true)) {
            this.setupBloom();
        }
        EnvRenderers.init();
        for (i = 0; i < this.bubbles.length; ++i) {
            this.bubbles[i] = Core.atlas.find("bubble-" + i);
        }
        for (i = 0; i < this.splashes.length; ++i) {
            this.splashes[i] = Core.atlas.find("splash-" + i);
        }
        this.loadFluidFrames();
        Events.on(EventType.ClientLoadEvent.class, e -> this.loadFluidFrames());
        Core.assets.load((String)"sprites/clouds.png", Texture.class).loaded = t -> {
            t.setWrap(Texture.TextureWrap.repeat);
            t.setFilter(Texture.TextureFilter.linear);
        };
        Events.on(EventType.WorldLoadEvent.class, e -> {
            if (this.backgroundBuffer != null) {
                this.backgroundBuffer.dispose();
                this.backgroundBuffer = null;
            }
        });
    }

    public void loadFluidFrames() {
        this.fluidFrames = new TextureRegion[2][50];
        String[] fluidTypes = new String[]{"liquid", "gas"};
        for (int i = 0; i < fluidTypes.length; ++i) {
            for (int j = 0; j < 50; ++j) {
                this.fluidFrames[i][j] = Core.atlas.find("fluid-" + fluidTypes[i] + "-" + j);
            }
        }
    }

    public TextureRegion[][] getFluidFrames() {
        if (this.fluidFrames == null || this.fluidFrames[0][0].texture.isDisposed()) {
            this.loadFluidFrames();
        }
        return this.fluidFrames;
    }

    @Override
    public void update() {
        int error;
        PerfCounter.render.begin();
        Color.white.set(1.0f, 1.0f, 1.0f, 1.0f);
        float baseTarget = this.targetscale;
        if (Vars.control.input.logicCutscene) {
            baseTarget = Mathf.lerp(this.minZoom, this.maxZoom, Vars.control.input.logicCutsceneZoom);
        }
        float dest = Mathf.clamp(Mathf.round(baseTarget, 0.1f), this.minScale(), this.maxScale());
        this.camerascale = Mathf.lerpDelta(this.camerascale, dest, 0.1f);
        if (Mathf.equal(this.camerascale, dest, 0.001f)) {
            this.camerascale = dest;
        }
        unitLaserOpacity = (float)Core.settings.getInt("unitlaseropacity") / 100.0f;
        laserOpacity = (float)Core.settings.getInt("lasersopacity") / 100.0f;
        bridgeOpacity = (float)Core.settings.getInt("bridgeopacity") / 100.0f;
        this.animateShields = Core.settings.getBool("animatedshields");
        this.animateWater = Core.settings.getBool("animatedwater");
        this.drawStatus = Core.settings.getBool("blockstatus");
        this.enableEffects = Core.settings.getBool("effects");
        this.drawDisplays = !Core.settings.getBool("hidedisplays");
        this.drawBars = Core.settings.getBool("blockBars");
        this.maxZoomInGame = Core.settings.getFloat("maxzoomingamemultiplier", 1.0f) * this.maxZoom;
        this.minZoomInGame = this.minZoom / Core.settings.getFloat("minzoomingamemultiplier", 1.0f);
        this.drawLight = Core.settings.getBool("drawlight", true);
        this.pixelate = Core.settings.getBool("pixelate");
        if (this.launchAnimator == null) {
            this.landTime = 0.0f;
        }
        if (this.landTime > 0.0f) {
            if (!Vars.state.isPaused()) {
                this.launchAnimator.updateLaunch();
            }
            this.weatherAlpha = 0.0f;
            this.camerascale = this.launchAnimator.zoomLaunch();
            if (!Vars.state.isPaused()) {
                this.landTime -= Time.delta;
            }
        } else {
            this.weatherAlpha = Mathf.lerpDelta(this.weatherAlpha, 1.0f, 0.08f);
        }
        if (this.launchAnimator != null && this.landTime <= 0.0f) {
            this.launchAnimator.endLaunch();
            this.launchAnimator = null;
        }
        Core.camera.width = (float)Core.graphics.getWidth() / this.camerascale;
        Core.camera.height = (float)Core.graphics.getHeight() / this.camerascale;
        if (Vars.state.isMenu()) {
            this.landTime = 0.0f;
            Core.graphics.clear(Color.black);
        } else {
            this.minimap.update();
            if (this.shakeTime > 0.0f) {
                float intensity = this.shakeIntensity * ((float)Core.settings.getInt("screenshake", 4) / 4.0f) * 0.75f;
                this.camShakeOffset.setToRandomDirection().scl(Mathf.random(intensity));
                Core.camera.position.add(this.camShakeOffset);
                this.shakeIntensity -= this.shakeReduction * Time.delta;
                this.shakeTime -= Time.delta;
                this.shakeIntensity = Mathf.clamp(this.shakeIntensity, 0.0f, 100.0f);
            } else {
                this.camShakeOffset.setZero();
                this.shakeIntensity = 0.0f;
            }
            if (Vars.renderer.pixelate) {
                this.pixelator.drawPixelate();
            } else {
                this.draw();
            }
            Core.camera.position.sub(this.camShakeOffset);
        }
        if (this.glErrors < 100 && Core.graphics.getFrameId() % 10L == 0L && (error = Gl.getError()) != 0) {
            String string;
            switch (error) {
                case 1281: {
                    string = "invalid value";
                    break;
                }
                case 1282: {
                    string = "invalid operation";
                    break;
                }
                case 1286: {
                    string = "invalid framebuffer operation";
                    break;
                }
                case 1280: {
                    string = "invalid enum";
                    break;
                }
                case 1285: {
                    string = "out of memory";
                    break;
                }
                default: {
                    string = "unknown error (" + error + ")";
                }
            }
            String message = string;
            Log.err("[GL] Error: @", message);
            ++this.glErrors;
        }
        PerfCounter.render.end();
    }

    public void updateAllDarkness() {
        this.blocks.updateDarkness();
        this.minimap.updateAll();
    }

    public boolean isCutscene() {
        return this.landTime > 0.0f;
    }

    public float landScale() {
        return this.landTime > 0.0f ? this.camerascale : 1.0f;
    }

    @Override
    public void dispose() {
        Events.fire(new EventType.DisposeEvent());
    }

    @Override
    public void resume() {
        if (Core.settings.getBool("bloom") && this.bloom != null) {
            this.bloom.resume();
        }
    }

    void setupBloom() {
        try {
            if (this.bloom != null) {
                this.bloom.dispose();
                this.bloom = null;
            }
            this.bloom = new Bloom(true);
        }
        catch (Throwable e) {
            Core.settings.put("bloom", false);
            Vars.ui.showErrorMessage("@error.bloom");
            Log.err(e);
        }
    }

    public void toggleBloom(boolean enabled) {
        if (enabled) {
            if (this.bloom == null) {
                this.setupBloom();
            }
        } else if (this.bloom != null) {
            this.bloom.dispose();
            this.bloom = null;
        }
    }

    public void draw() {
        block14: {
            block15: {
                Events.fire(EventType.Trigger.preDraw);
                MapPreviewLoader.checkPreviews();
                Core.camera.update();
                if (Float.isNaN(Core.camera.position.x) || Float.isNaN(Core.camera.position.y)) {
                    Core.camera.position.set(Vars.player);
                }
                Core.graphics.clear(this.clearColor);
                Draw.reset();
                if (this.animateWater || this.animateShields) {
                    this.effectBuffer.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                }
                Draw.proj(Core.camera);
                this.blocks.checkChanges();
                this.blocks.floor.checkChanges();
                this.blocks.processBlocks();
                Draw.sort(true);
                Events.fire(EventType.Trigger.draw);
                MapPreviewLoader.checkPreviews();
                if (Vars.renderer.pixelate) {
                    this.pixelator.register();
                }
                Draw.draw(-10.0f, this::drawBackground);
                Draw.draw(0.0f, this.blocks.floor::drawFloor);
                Draw.draw(29.0f, this.blocks::drawShadows);
                Draw.draw(29.91f, () -> {
                    this.blocks.floor.beginDraw();
                    this.blocks.floor.drawLayer(CacheLayer.walls);
                });
                Draw.drawRange(40.0f, () -> Draw.shader(Shaders.blockbuild, true), Draw::shader);
                for (EnvRenderer renderer : this.envRenderers) {
                    if ((renderer.env & Vars.state.rules.env) != renderer.env) continue;
                    renderer.renderer.run();
                }
                if (Vars.state.rules.lighting && this.drawLight) {
                    Draw.draw(140.0f, this.lights::draw);
                }
                if (Core.settings.getBool("forceEnableDarkness") && Vars.enableDarkness) {
                    Draw.draw(80.0f, this.blocks::drawDarkness);
                }
                if (this.bloom != null) {
                    this.bloom.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
                    this.bloom.setBloomIntensity((float)Core.settings.getInt("bloomintensity", 6) / 4.0f + 1.0f);
                    this.bloom.blurPasses = Core.settings.getInt("bloomblur", 1);
                    Draw.draw(99.98f, this.bloom::capture);
                    Draw.draw(110.02f, this.bloom::render);
                }
                Vars.control.input.drawCommanded();
                Draw.draw(85.0f, this.overlays::drawBottom);
                if (this.animateShields && Shaders.shield != null) {
                    Draw.drawRange(125.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                        this.effectBuffer.end();
                        this.effectBuffer.blit(Core.settings.getBool("staticShieldsBorder") ? Shaders.staticShield : Shaders.shield);
                    });
                    Draw.drawRange(127.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                        this.effectBuffer.end();
                        this.effectBuffer.blit(Core.settings.getBool("staticShieldsBorder") ? Shaders.staticShield : Shaders.shield);
                    });
                    Draw.drawRange(122.0f, 1.0f, () -> this.effectBuffer.begin(Color.clear), () -> {
                        this.effectBuffer.end();
                        this.effectBuffer.blit(Shaders.buildBeam);
                    });
                }
                float scaleFactor = 4.0f / Vars.renderer.getDisplayScale();
                Vars.state.rules.objectives.eachRunning(obj -> {
                    for (MapObjectives.ObjectiveMarker marker : obj.markers) {
                        if (!marker.world) continue;
                        marker.draw(marker.autoscale ? scaleFactor : 1.0f);
                    }
                });
                for (MapObjectives.ObjectiveMarker marker : Vars.state.markers) {
                    if (!marker.world) continue;
                    marker.draw(marker.autoscale ? scaleFactor : 1.0f);
                }
                Draw.reset();
                Draw.draw(120.0f, this.overlays::drawTop);
                if (!Vars.state.rules.fog) break block14;
                if (this.fogEnabled) break block15;
                if (!Vars.state.rules.pvp || Vars.player.team().id == 255) break block14;
            }
            Draw.draw(155.0f, this.fog::drawFog);
        }
        Draw.draw(160.0f, () -> {
            if (this.launchAnimator == null || this.landTime <= 0.0f) {
                return;
            }
            this.launchAnimator.drawLaunch();
        });
        if (this.launchAnimator != null) {
            Draw.z(160.0f);
            this.launchAnimator.drawLaunchGlobalZ();
            Draw.reset();
        }
        Events.fire(EventType.Trigger.drawOver);
        this.blocks.drawBlocks();
        Groups.draw.draw(Drawc::draw);
        if (Vars.drawDebugHitboxes) {
            DebugCollisionRenderer.draw();
        }
        Draw.reset();
        Draw.flush();
        Draw.sort(false);
        Events.fire(EventType.Trigger.postDraw);
    }

    protected void drawBackground() {
        if (!(Vars.state.rules.backgroundTexture == null || Vars.state.rules.planetBackground != null && Vars.state.rules.planetBackground.drawSkybox)) {
            float size;
            if (!Core.assets.isLoaded(Vars.state.rules.backgroundTexture, Texture.class)) {
                Fi file = Core.assets.getFileHandleResolver().resolve(Vars.state.rules.backgroundTexture);
                if (!file.exists() || !file.extEquals("png")) {
                    return;
                }
                AssetDescriptor<Texture> desc = Core.assets.load(Vars.state.rules.backgroundTexture, Texture.class, new TextureLoader.TextureParameter(){
                    {
                        this.wrapU = this.wrapV = Texture.TextureWrap.mirroredRepeat;
                        this.magFilter = this.minFilter = Texture.TextureFilter.linear;
                    }
                });
                Core.assets.finishLoadingAsset(desc);
            }
            Texture tex = Core.assets.get(Vars.state.rules.backgroundTexture, Texture.class);
            Tmp.tr1.set(tex);
            Tmp.tr1.u = 0.0f;
            Tmp.tr1.v = 0.0f;
            float ratio = Core.camera.width / Core.camera.height;
            Tmp.tr1.u2 = size = Vars.state.rules.backgroundScl;
            Tmp.tr1.v2 = size / ratio;
            float sx = 0.0f;
            float sy = 0.0f;
            if (!Mathf.zero(Vars.state.rules.backgroundSpeed)) {
                sx = Core.camera.position.x / Vars.state.rules.backgroundSpeed;
                sy = Core.camera.position.y / Vars.state.rules.backgroundSpeed;
            }
            Tmp.tr1.scroll(sx + Vars.state.rules.backgroundOffsetX, -sy + Vars.state.rules.backgroundOffsetY);
            Draw.rect(Tmp.tr1, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        }
        if (Vars.state.rules.planetBackground != null) {
            int size = Math.max(Core.graphics.getWidth(), Core.graphics.getHeight());
            boolean resized = false;
            if (this.backgroundBuffer == null) {
                resized = true;
                this.backgroundBuffer = new FrameBuffer(size, size);
            }
            if (resized || this.backgroundBuffer.resizeCheck(size, size)) {
                this.backgroundBuffer.begin(Color.clear);
                PlanetParams params = Vars.state.rules.planetBackground;
                params.viewW = size;
                params.viewH = size;
                params.alwaysDrawAtmosphere = true;
                params.drawUi = false;
                this.planets.render(params);
                this.backgroundBuffer.end();
            }
            float drawSize = Math.max(Core.camera.width, Core.camera.height);
            Draw.rect(Draw.wrap((Texture)this.backgroundBuffer.getTexture()), Core.camera.position.x, Core.camera.position.y, drawSize, -drawSize);
        }
        if (Vars.state.rules.customBackgroundCallback != null && this.customBackgrounds.containsKey(Vars.state.rules.customBackgroundCallback)) {
            this.customBackgrounds.get(Vars.state.rules.customBackgroundCallback).run();
        }
    }

    public void scaleCamera(float amount) {
        this.targetscale *= amount / 6.0f + 1.0f;
        this.clampScale();
    }

    public void clampScale() {
        this.targetscale = Mathf.clamp(this.targetscale, this.minScale(), this.maxScale());
    }

    public float getDisplayScale() {
        return this.camerascale;
    }

    public float minScale() {
        if (Vars.control.input.logicCutscene) {
            return Scl.scl(this.minZoom);
        }
        return Scl.scl(this.minZoomInGame);
    }

    public float maxScale() {
        if (Vars.control.input.logicCutscene) {
            return Mathf.round(Scl.scl(this.maxZoom));
        }
        return Mathf.round(Scl.scl(this.maxZoomInGame));
    }

    public float getScale() {
        return this.targetscale;
    }

    public void setScale(float scl) {
        this.targetscale = scl;
        this.clampScale();
    }

    public boolean isLaunching() {
        return this.launching;
    }

    public float getLandTime() {
        return this.landTime;
    }

    public float getLandTimeIn() {
        if (this.launchAnimator == null) {
            return 0.0f;
        }
        float fin = this.landTime / this.launchAnimator.launchDuration();
        if (!this.launching) {
            fin = 1.0f - fin;
        }
        return fin;
    }

    public void showLanding(LaunchAnimator landCore) {
        this.launchAnimator = landCore;
        this.launching = false;
        this.landTime = landCore.launchDuration();
        landCore.beginLaunch(false);
        this.camerascale = landCore.zoomLaunch();
    }

    public void showLaunch(LaunchAnimator landCore) {
        Vars.control.input.config.hideConfig();
        Vars.control.input.planConfig.hide();
        Vars.control.input.inv.hide();
        this.launchAnimator = landCore;
        this.launching = true;
        this.landTime = landCore.launchDuration();
        Music music = landCore.launchMusic();
        music.stop();
        music.play();
        music.setVolume((float)Core.settings.getInt("musicvol") / 100.0f);
        landCore.beginLaunch(true);
    }

    public void takeMapScreenshot() {
        int w = Vars.world.width() * 8;
        int h = Vars.world.height() * 8;
        int memory = w * h * 4 / 1024 / 1024;
        if (Vars.checkScreenshotMemory && memory >= (Vars.mobile ? 65 : 120)) {
            Vars.ui.showInfo("@screenshot.invalid");
            return;
        }
        FrameBuffer buffer = new FrameBuffer(w, h);
        this.drawWeather = false;
        float vpW = Core.camera.width;
        float vpH = Core.camera.height;
        float px = Core.camera.position.x;
        float py = Core.camera.position.y;
        Vars.disableUI = true;
        Core.camera.width = w;
        Core.camera.height = h;
        Core.camera.position.x = (float)w / 2.0f + 4.0f;
        Core.camera.position.y = (float)h / 2.0f + 4.0f;
        buffer.begin();
        this.draw();
        Draw.flush();
        byte[] lines = ScreenUtils.getFrameBufferPixels(0, 0, w, h, true);
        buffer.end();
        Vars.disableUI = false;
        Core.camera.width = vpW;
        Core.camera.height = vpH;
        Core.camera.position.set(px, py);
        this.drawWeather = true;
        buffer.dispose();
        Threads.thread(() -> {
            for (int i = 0; i < lines.length; i += 4) {
                lines[i + 3] = -1;
            }
            Pixmap fullPixmap = new Pixmap(w, h);
            Buffers.copy(lines, 0, (Buffer)fullPixmap.pixels, lines.length);
            Fi file = Vars.screenshotDirectory.child("screenshot-" + Time.millis() + ".png");
            PixmapIO.writePng(file, fullPixmap);
            fullPixmap.dispose();
            Core.app.post(() -> Vars.ui.showInfoFade(Core.bundle.format("screenshot", file.toString())));
        });
    }

    public static class EnvRenderer {
        public final int env;
        public final Runnable renderer;

        public EnvRenderer(int env, Runnable renderer) {
            this.env = env;
            this.renderer = renderer;
        }
    }
}

