/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.audio.Sound;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.CommandHandler;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.ReusableByteInStream;
import arc.util.serialization.Base64Coder;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.zip.InflaterInputStream;
import mindustry.Vars;
import mindustry.arcModule.ARCEvents;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.player.AutoFill;
import mindustry.arcModule.ui.XiBao;
import mindustry.arcModule.ui.dialogs.USIDDialog;
import mindustry.core.GameState;
import mindustry.core.Version;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.game.MapObjectives;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Call;
import mindustry.gen.EntityMapping;
import mindustry.gen.Groups;
import mindustry.gen.Mechc;
import mindustry.gen.Nulls;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Syncc;
import mindustry.gen.Unit;
import mindustry.io.JsonIO;
import mindustry.logic.GlobalVars;
import mindustry.net.Administration;
import mindustry.net.NetworkIO;
import mindustry.net.Packets;
import mindustry.net.ValidateException;
import mindustry.world.Tile;
import mindustry.world.modules.ItemModule;

public class NetClient
implements ApplicationListener {
    private static final long entitySnapshotTimeout = 20000L;
    private static final float dataTimeout = 1800.0f;
    private static final float playerSyncTime = 4.0f;
    private static final Reads dataReads = new Reads(null);
    private static final JsonValue tmpJsonMap = new JsonValue(JsonValue.ValueType.object);
    private long ping;
    private Interval timer = new Interval(5);
    private boolean connecting = false;
    private boolean quiet = false;
    private boolean quietReset = false;
    private float timeoutTime = 0.0f;
    private long lastSnapshotTimestamp;
    private int lastSent;
    private IntSet removed = new IntSet();
    private ReusableByteInStream byteStream = new ReusableByteInStream();
    private DataInputStream dataStream = new DataInputStream(this.byteStream);
    private ObjectMap<String, Seq<Cons<String>>> customPacketHandlers = new ObjectMap();
    private ObjectMap<String, Seq<Cons<byte[]>>> customBinaryPacketHandlers = new ObjectMap();

    public NetClient() {
        Vars.net.handleClient(Packets.Connect.class, packet -> {
            Vars.player.name = Core.settings.getString("name");
            Vars.player.color.set(Core.settings.getInt("color-0"));
            Log.info("Connecting to server: @", packet.addressTCP);
            String ip = packet.addressTCP;
            if (ip.contains("/")) {
                ip = ip.substring(ip.indexOf("/") + 1);
            }
            if (!ip.startsWith("steam:") && USIDDialog.chooseUSID && Core.settings.getString("usid-" + ip, null) == null && !ARCVars.replaying) {
                this.disconnectQuietly();
                USIDDialog.showSet(ip);
                return;
            }
            Vars.player.admin = false;
            this.reset();
            if (!Vars.net.client()) {
                Log.info("Connection canceled.");
                this.disconnectQuietly();
                return;
            }
            Vars.ui.loadfrag.hide();
            Vars.ui.loadfrag.show("@connecting.data");
            Vars.ui.loadfrag.setButton(() -> {
                Vars.ui.loadfrag.hide();
                this.disconnectQuietly();
            });
            String locale = Core.settings.getString("locale");
            if (locale.equals("default")) {
                locale = Locale.getDefault().toString();
            }
            Packets.ConnectPacket c = new Packets.ConnectPacket();
            c.name = Vars.player.name;
            c.locale = locale;
            c.mods = Vars.mods.getModStrings();
            c.mobile = Vars.mobile;
            c.versionType = Version.type;
            c.color = Vars.player.color.rgba();
            c.usid = this.getUsid(packet.addressTCP);
            c.uuid = Vars.platform.getUUID();
            if (c.uuid == null) {
                Vars.ui.showErrorMessage("@invalidid");
                Vars.ui.loadfrag.hide();
                this.disconnectQuietly();
                return;
            }
            ARCVars.replayController.createReplay(packet.addressTCP);
            Vars.net.send(c, true);
        });
        Vars.net.handleClient(Packets.Disconnect.class, packet -> {
            Events.fire(new ARCEvents.Disconnected(packet.reason));
            if (this.quietReset) {
                return;
            }
            ARCVars.replayController.stop();
            this.connecting = false;
            Vars.logic.reset();
            Vars.platform.updateRPC();
            Vars.player.name = Core.settings.getString("name");
            Vars.player.color.set(Core.settings.getInt("color-0"));
            Vars.ui.listfrag.blackList.clear();
            if (this.quiet) {
                return;
            }
            Time.runTask(3.0f, Vars.ui.loadfrag::hide);
            if (packet.reason != null) {
                String string;
                switch (packet.reason) {
                    case "closed": {
                        string = "@disconnect.closed";
                        break;
                    }
                    case "timeout": {
                        string = "@disconnect.timeout";
                        break;
                    }
                    default: {
                        string = "@disconnect.error";
                    }
                }
                Vars.ui.showSmall(string, "@disconnect.closed");
            } else {
                Vars.ui.showErrorMessage("@disconnect");
            }
        });
        Vars.net.handleClient(Packets.WorldStream.class, data -> {
            Log.info("Received world data: @ bytes.", data.stream.available());
            if (ARCVars.replaying) {
                NetClient.worldDataBegin();
            }
            NetworkIO.loadWorld(new InflaterInputStream(data.stream));
            this.finishConnecting();
            if (!Core.settings.getBool("arcAnonymity")) {
                Call.serverPacketReliable("ARC", ARCVars.arcVersion);
                Call.serverPacketReliable("ARC-build", Version.arcBuild + "");
                Call.serverPacketReliable("CheatOverride", ARCVars.arcCheatServer + "");
            }
        });
    }

    public void addPacketHandler(String type, Cons<String> handler) {
        ((Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons<String>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons<String>> getPacketHandlers(String type) {
        return (Seq)((Object)this.customPacketHandlers.get(type, (Seq<Cons<String>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public void addBinaryPacketHandler(String type, Cons<byte[]> handler) {
        ((Seq)((Object)this.customBinaryPacketHandlers.get(type, (Seq<Cons<byte[]>>)((Object)((Prov<Seq>)Seq::new))))).add(handler);
    }

    public Seq<Cons<byte[]>> getBinaryPacketHandlers(String type) {
        return (Seq)((Object)this.customBinaryPacketHandlers.get(type, (Seq<Cons<byte[]>>)((Object)((Prov<Seq>)Seq::new))));
    }

    public static void clientBinaryPacketReliable(String type, byte[] contents) {
        Seq<Cons<byte[]>> arr = Vars.netClient.customBinaryPacketHandlers.get(type);
        if (arr != null) {
            for (Cons<byte[]> c : arr) {
                c.get(contents);
            }
        }
    }

    public static void clientBinaryPacketUnreliable(String type, byte[] contents) {
        NetClient.clientBinaryPacketReliable(type, contents);
    }

    public static void clientPacketReliable(String type, String contents) {
        if (Vars.netClient.customPacketHandlers.containsKey(type)) {
            for (Cons<String> c : Vars.netClient.customPacketHandlers.get(type)) {
                c.get(contents);
            }
        }
    }

    public static void clientPacketUnreliable(String type, String contents) {
        NetClient.clientPacketReliable(type, contents);
    }

    public static void sound(Sound sound, float volume, float pitch, float pan) {
        if (sound == null || Vars.headless) {
            return;
        }
        sound.play(Mathf.clamp(volume, 0.0f, 8.0f) * (float)Core.settings.getInt("sfxvol") / 100.0f, Mathf.clamp(pitch, 0.0f, 20.0f), pan, false, false);
    }

    public static void soundAt(Sound sound, float x, float y, float volume, float pitch) {
        if (sound == null || Vars.headless) {
            return;
        }
        sound.at(x, y, Mathf.clamp(pitch, 0.0f, 20.0f), Mathf.clamp(volume, 0.0f, 4.0f));
    }

    public static void effect(Effect effect, float x, float y, float rotation, Color color) {
        if (effect == null) {
            return;
        }
        effect.at(x, y, rotation, color);
    }

    public static void effect(Effect effect, float x, float y, float rotation, Color color, Object data) {
        if (effect == null) {
            return;
        }
        effect.at(x, y, rotation, color, data);
    }

    public static void effectReliable(Effect effect, float x, float y, float rotation, Color color) {
        NetClient.effect(effect, x, y, rotation, color);
    }

    public static void sendMessage(String message, @Nullable String unformatted, @Nullable Player playersender) {
        if (message != null) {
            if (playersender == null) {
                if (message.contains("You are interacting with blocks too quickly.") || message.contains("You are interacting with too many blocks.")) {
                    AutoFill.INSTANCE.interactionTooFastWarning();
                }
            } else if (Vars.ui.listfrag.blackList.contains(playersender)) {
                return;
            }
        }
        if (Vars.ui != null) {
            Vars.ui.chatfrag.addMessage(message, playersender);
            Sounds.chatMessage.play();
        }
        if (playersender != null && unformatted != null) {
            playersender.lastText(unformatted);
            playersender.textFadeTime(1.0f);
            Events.fire(new EventType.PlayerChatEvent(playersender, unformatted));
        }
    }

    public static void sendMessage(String message) {
        if (Vars.ui != null) {
            StringBuilder stringBuilder = new StringBuilder(message);
            if (Vars.ui.listfrag.blackList.find(player1 -> player1.name.equals(stringBuilder.substring(0, player1.name.length()))) != null) {
                return;
            }
            Vars.ui.chatfrag.addMessage(message, true);
            Sounds.chatMessage.play();
        }
    }

    public static void sendChatMessage(Player player, String message) {
        String text;
        if (!(!Vars.net.server() || player == null || player.con == null || Time.timeSinceMillis(player.con.connectTime) >= 500L && player.con.hasConnected && player.isAdded())) {
            return;
        }
        if (player != null && player.con != null && !player.con.chatRate.allow(2000L, Administration.Config.chatSpamLimit.num())) {
            player.con.kick(Packets.KickReason.kick);
            Vars.netServer.admins.blacklistDos(player.con.address);
            return;
        }
        if (message == null) {
            return;
        }
        if (message.length() > 150) {
            throw new ValidateException(player, "Player has sent a message above the text limit.");
        }
        message = message.replace("\n", "");
        Events.fire(new EventType.PlayerChatEvent(player, message));
        if (message.startsWith(Vars.netServer.clientCommands.getPrefix()) && Administration.Config.logCommands.bool()) {
            Log.info("<&fi@: @&fr>", "&lk" + player.plainName(), "&lw" + message);
        }
        CommandHandler.CommandResponse response = Vars.netServer.clientCommands.handleMessage(message, player);
        if (response.type == CommandHandler.ResponseType.noCommand) {
            if ((message = Vars.netServer.admins.filterMessage(player, message)) == null) {
                return;
            }
            if (!Vars.headless) {
                NetClient.sendMessage(Vars.netServer.chatFormatter.format(player, message), message, player);
            }
            Log.info("&fi@: @", "&lc" + player.plainName(), "&lw" + message);
            Call.sendMessage(Vars.netServer.chatFormatter.format(player, message), message, player);
        } else if (response.type != CommandHandler.ResponseType.valid && (text = Vars.netServer.invalidHandler.handle(player, response)) != null) {
            player.sendMessage(text);
        }
    }

    public static void connect(String ip, int port) {
        if (!Vars.steam && ip.startsWith("steam:")) {
            return;
        }
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        Vars.ui.join.connect(ip, port);
    }

    public static void ping(Player player, long time) {
        Call.pingResponse(player.con, time);
    }

    public static void pingResponse(long time) {
        Vars.netClient.ping = Time.timeSinceMillis(time);
    }

    public static void traceInfo(Player player, Administration.TraceInfo info) {
        if (player != null) {
            Vars.ui.traces.show(player, info);
        }
    }

    public static void kick(Packets.KickReason reason) {
        if (Core.settings.getBool("xibaoOnKick")) {
            Vars.ui.loadfrag.hide();
            if (!reason.quiet) {
                if (reason.extraText() != null) {
                    new XiBao().show(reason.toString(), reason.extraText());
                } else {
                    new XiBao().show("@disconnect", reason.toString());
                }
            }
            return;
        }
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        if (reason == Packets.KickReason.serverRestarting) {
            Vars.ui.join.reconnect();
            return;
        }
        if (!reason.quiet) {
            if (reason.extraText() != null) {
                Vars.ui.showText(reason.toString(), reason.extraText());
            } else {
                Vars.ui.showText("@disconnect", reason.toString());
            }
        }
        Vars.ui.loadfrag.hide();
    }

    public static void kick(String reason) {
        if (Core.settings.getBool("xibaoOnKick")) {
            Vars.ui.loadfrag.hide();
            new XiBao().show("@disconnect", reason);
            return;
        }
        Vars.netClient.disconnectQuietly();
        Vars.logic.reset();
        Vars.ui.showText("@disconnect", reason, 8);
        Vars.ui.loadfrag.hide();
    }

    public static void setRules(Rules rules) {
        Vars.state.rules = rules;
    }

    public static void setRule(String rule, String jsonData) {
        try {
            NetClient.tmpJsonMap.child = null;
            tmpJsonMap.addChild(rule, new JsonReader().parse(jsonData));
            JsonIO.json.readField(Vars.state.rules, rule, tmpJsonMap);
        }
        catch (Throwable error) {
            Log.err("Failed to read rule", error);
        }
    }

    public static void setObjectives(MapObjectives executor) {
        Vars.state.rules.objectives = executor;
    }

    public static void clearObjectives() {
        Vars.state.rules.objectives.clear();
    }

    public static void completeObjective(int index) {
        MapObjectives.MapObjective obj = Vars.state.rules.objectives.get(index);
        if (obj != null) {
            obj.done();
        }
    }

    public static void worldDataBegin() {
        Groups.clear();
        Vars.netClient.removed.clear();
        Vars.logic.reset();
        Vars.netClient.connecting = true;
        Vars.net.setClientLoaded(false);
        Vars.ui.loadfrag.show("@connecting.data");
        Vars.ui.loadfrag.setButton(() -> {
            Vars.ui.loadfrag.hide();
            Vars.netClient.disconnectQuietly();
        });
    }

    public static void setPosition(float x, float y) {
        if (Vars.player.dead()) {
            return;
        }
        Vars.player.unit().set(x, y);
        Vars.player.set(x, y);
    }

    public static void setCameraPosition(float x, float y) {
        if (Core.camera != null) {
            Core.camera.position.set(x, y);
        }
    }

    public static void playerDisconnect(int playerid) {
        if (Vars.netClient != null) {
            Vars.netClient.addRemovedEntity(playerid);
        }
        Groups.player.removeByID(playerid);
    }

    public static void readSyncEntity(DataInputStream input, Reads read) throws IOException {
        int id = input.readInt();
        byte typeID = input.readByte();
        Syncc entity = Groups.sync.getByID(id);
        boolean add = false;
        boolean created = false;
        if (entity == null && id == Vars.player.id()) {
            entity = Vars.player;
            add = true;
        }
        if (entity == null) {
            entity = (Syncc)EntityMapping.map(typeID & 0xFF).get();
            entity.id(id);
            if (!Vars.netClient.isEntityUsed(entity.id())) {
                add = true;
            }
            created = true;
        }
        entity.readSync(read);
        if (created) {
            entity.snapSync();
        }
        if (add) {
            entity.add();
            Vars.netClient.addRemovedEntity(entity.id());
        }
    }

    public static void entitySnapshot(short amount, byte[] data) {
        try {
            Vars.netClient.lastSnapshotTimestamp = Time.millis();
            Vars.netClient.byteStream.setBytes(data);
            DataInputStream input = Vars.netClient.dataStream;
            for (int j = 0; j < amount; ++j) {
                NetClient.readSyncEntity(input, Reads.get(input));
            }
        }
        catch (Exception e) {
            Log.err("Error reading entity snapshot", e);
        }
    }

    public static void hiddenSnapshot(IntSeq ids) {
        for (int i = 0; i < ids.size; ++i) {
            int id = ids.items[i];
            Syncc entity = Groups.sync.getByID(id);
            if (entity == null) continue;
            entity.handleSyncHidden();
        }
    }

    public static void blockSnapshot(short amount, byte[] data) {
        try {
            Vars.netClient.byteStream.setBytes(data);
            DataInputStream input = Vars.netClient.dataStream;
            for (int i = 0; i < amount; ++i) {
                int pos = input.readInt();
                short block = input.readShort();
                Tile tile = Vars.world.tile(pos);
                if (tile == null || tile.build == null) {
                    Log.warn("Missing entity at @. Skipping block snapshot.", tile);
                    break;
                }
                if (tile.build.block.id != block) {
                    Log.warn("Block ID mismatch at @: @ != @. Skipping block snapshot.", tile, tile.build.block.id, block);
                    break;
                }
                tile.build.readSync(Reads.get(input), tile.build.version());
            }
        }
        catch (Exception e) {
            Log.err(e);
        }
    }

    public static void stateSnapshot(float waveTime, int wave, int enemies, boolean paused, boolean gameOver, int timeData, byte tps, long rand0, long rand1, byte[] coreData) {
        try {
            if (wave > Vars.state.wave) {
                Vars.state.wave = wave;
                Events.fire(new EventType.WaveEvent());
            }
            Vars.state.gameOver = gameOver;
            Vars.state.wavetime = waveTime;
            Vars.state.wave = wave;
            Vars.state.enemies = enemies;
            if (!Vars.state.isMenu()) {
                Vars.state.set(paused ? GameState.State.paused : GameState.State.playing);
            }
            Vars.state.serverTps = tps & 0xFF;
            GlobalVars.rand.seed0 = rand0;
            GlobalVars.rand.seed1 = rand1;
            Vars.universe.updateNetSeconds(timeData);
            Vars.netClient.byteStream.setBytes(coreData);
            DataInputStream input = Vars.netClient.dataStream;
            NetClient.dataReads.input = input;
            int teams = input.readUnsignedByte();
            for (int i = 0; i < teams; ++i) {
                int team = input.readUnsignedByte();
                Teams.TeamData data = Team.all[team].data();
                if (data.cores.any()) {
                    data.cores.first().items.read(dataReads);
                    continue;
                }
                new ItemModule().read(dataReads);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update() {
        if (!Vars.net.client()) {
            return;
        }
        if (Vars.state.isGame()) {
            if (!this.connecting) {
                this.sync();
                if (this.lastSnapshotTimestamp > 0L && Time.timeSinceMillis(this.lastSnapshotTimestamp) > 20000L) {
                    Log.err("Timed out after not received UDP snapshots.", new Object[0]);
                    this.quiet = true;
                    Vars.ui.showErrorMessage("@disconnect.snapshottimeout");
                    Vars.net.disconnect();
                    this.lastSnapshotTimestamp = 0L;
                }
            }
        } else if (!this.connecting) {
            Vars.net.disconnect();
        } else {
            this.timeoutTime += Time.delta;
            if (this.timeoutTime > 1800.0f) {
                Log.err("Failed to load data!", new Object[0]);
                Vars.ui.loadfrag.hide();
                this.quiet = true;
                Vars.ui.showErrorMessage("@disconnect.data");
                Vars.net.disconnect();
                this.timeoutTime = 0.0f;
            }
        }
    }

    public void resetTimeout() {
        this.timeoutTime = 0.0f;
    }

    public boolean isConnecting() {
        return this.connecting;
    }

    public int getPing() {
        return (int)this.ping;
    }

    private void finishConnecting() {
        Vars.state.set(GameState.State.playing);
        this.connecting = false;
        Vars.ui.join.hide();
        Vars.net.setClientLoaded(true);
        Core.app.post(Call::connectConfirm);
        Time.runTask(40.0f, Vars.platform::updateRPC);
        Core.app.post(Vars.ui.loadfrag::hide);
        this.lastSnapshotTimestamp = Time.millis();
    }

    private void reset() {
        Vars.net.setClientLoaded(false);
        this.removed.clear();
        this.timeoutTime = 0.0f;
        this.connecting = true;
        this.quietReset = false;
        this.quiet = false;
        this.lastSent = 0;
        this.lastSnapshotTimestamp = 0L;
        Groups.clear();
        Vars.ui.chatfrag.clearMessages();
    }

    public void beginConnecting() {
        this.connecting = true;
    }

    public void disconnectQuietly() {
        this.quiet = true;
        this.connecting = false;
        Vars.net.disconnect();
    }

    public void disconnectNoReset() {
        this.quietReset = true;
        this.quiet = true;
        Vars.net.disconnect();
    }

    public void setQuiet() {
        this.quiet = true;
    }

    public void clearRemovedEntity(int id) {
        this.removed.remove(id);
    }

    public void addRemovedEntity(int id) {
        this.removed.add(id);
    }

    public boolean isEntityUsed(int id) {
        return this.removed.contains(id);
    }

    void sync() {
        if (this.timer.get(0, 4.0f)) {
            float f;
            Unit unit = Vars.player.dead() ? Nulls.unit : Vars.player.unit();
            int uid = Vars.player.dead() ? -1 : unit.id;
            boolean bl = Vars.player.dead();
            float f2 = Vars.player.dead() ? Vars.player.x : unit.x;
            float f3 = Vars.player.dead() ? Vars.player.y : unit.y;
            float f4 = Vars.player.unit().aimX();
            float f5 = Vars.player.unit().aimY();
            float f6 = unit.rotation;
            if (unit instanceof Mechc) {
                Mechc m = (Mechc)((Object)unit);
                f = m.baseRotation();
            } else {
                f = 0.0f;
            }
            Call.clientSnapshot(this.lastSent++, uid, bl, f2, f3, f4, f5, f6, f, unit.vel.x, unit.vel.y, Vars.player.unit().mineTile, Vars.player.boosting, Vars.player.shooting, Vars.ui.chatfrag.shown(), Vars.control.input.isBuilding, Vars.player.isBuilder() ? Vars.player.unit().plans : null, Core.camera.position.x, Core.camera.position.y, Core.camera.width, Core.camera.height);
        }
        if (this.timer.get(1, 60.0f)) {
            Call.ping(Time.millis());
        }
    }

    String getUsid(String ip) {
        if (ip.contains("/")) {
            ip = ip.substring(ip.indexOf("/") + 1);
        }
        if (Core.settings.getString("usid-" + ip, null) != null) {
            return Core.settings.getString("usid-" + ip, null);
        }
        byte[] bytes = new byte[8];
        new Rand().nextBytes(bytes);
        String result = new String(Base64Coder.encode(bytes));
        Core.settings.put("usid-" + ip, result);
        return result;
    }
}

