/*
 * Decompiled with CFR 0.152.
 */
package mindustry.core;

import arc.ApplicationListener;
import arc.Core;
import arc.Events;
import arc.assets.Loadable;
import arc.audio.Music;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.scene.actions.Actions;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Dialog;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.OS;
import arc.util.Time;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.DrawUtilities;
import mindustry.audio.SoundControl;
import mindustry.content.Fx;
import mindustry.content.TechTree;
import mindustry.core.GameState;
import mindustry.entities.Effect;
import mindustry.game.AttackIndicators;
import mindustry.game.EventType;
import mindustry.game.Objectives;
import mindustry.game.Rules;
import mindustry.game.Saves;
import mindustry.game.Schematics;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.input.Binding;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.input.MobileInput;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.SectorDamage;
import mindustry.net.WorldReloader;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class Control
implements ApplicationListener,
Loadable {
    public Saves saves;
    public SoundControl sound;
    public InputHandler input;
    public AttackIndicators indicators;
    private Interval timer = new Interval(2);
    private boolean hiscore = false;
    private boolean wasPaused = false;
    private boolean backgroundPaused = false;
    private Seq<Building> toBePlaced = new Seq(false);
    public static boolean bossKeyPressing;
    public static boolean bossKeyValid;
    private BaseDialog calcDialog;
    private final StringBuilder formula = new StringBuilder();
    private String resultString = "";

    public Control() {
        this.saves = new Saves();
        this.sound = new SoundControl();
        this.indicators = new AttackIndicators();
        Events.on(EventType.BuildDamageEvent.class, e -> {
            if (e.build.team == Vars.player.team()) {
                this.indicators.add(e.build.tileX(), e.build.tileY());
            }
        });
        Events.on(EventType.ClientLoadEvent.class, e -> {
            if (Vars.mods.skipModLoading() && Vars.mods.list().any()) {
                Time.runTask(4.0f, () -> Vars.ui.showInfo("@mods.initfailed"));
            }
            this.checkAutoUnlocks();
            if (OS.isWindows && !OS.is64Bit && !Core.settings.getBool("nowarn32bit", false)) {
                BaseDialog dialog = new BaseDialog("@warn.32bit.title");
                dialog.buttons.button("@ok", dialog::hide).size(120.0f, 64.0f);
                dialog.cont.add("@warn.32bit").labelAlign(1, 1).wrap().grow().row();
                dialog.cont.check("@dontshowagain", val -> Core.settings.put("nowarn32bit", val));
                dialog.show();
            }
        });
        Events.on(EventType.StateChangeEvent.class, event -> {
            block3: {
                block2: {
                    if (event.from == GameState.State.playing && event.to == GameState.State.menu) break block2;
                    if (event.from != GameState.State.menu || event.to == GameState.State.menu) break block3;
                }
                Time.runTask(5.0f, Vars.platform::updateRPC);
            }
        });
        Events.on(EventType.PlayEvent.class, event -> {
            Vars.player.team(Vars.netServer.assignTeam(Vars.player));
            Vars.player.add();
            Vars.state.set(GameState.State.playing);
        });
        Events.on(EventType.WorldLoadEvent.class, event -> {
            if (Mathf.zero(Vars.player.x) && Mathf.zero(Vars.player.y)) {
                CoreBlock.CoreBuild core = Vars.player.bestCore();
                if (core != null) {
                    Vars.player.set(core);
                    Core.camera.position.set(core);
                }
            } else {
                Core.camera.position.set(Vars.player);
            }
        });
        Events.on(EventType.SaveLoadEvent.class, event -> this.input.checkUnit());
        Events.on(EventType.ResetEvent.class, event -> {
            Vars.player.reset();
            this.toBePlaced.clear();
            this.indicators.clear();
            this.hiscore = false;
            this.saves.resetSave();
        });
        Events.on(EventType.WaveEvent.class, event -> {
            if (Vars.state.map.getHightScore() < Vars.state.wave) {
                this.hiscore = true;
                Vars.state.map.setHighScore(Vars.state.wave);
            }
            Sounds.wave.play();
        });
        Events.on(EventType.GameOverEvent.class, event -> {
            Vars.state.stats.wavesLasted = Vars.state.wave;
            Effect.shake(5.0f, 6.0f, Core.camera.position.x, Core.camera.position.y);
            Call.gameOver(event.winner);
        });
        Events.on(EventType.WorldLoadEvent.class, e -> {
            Vars.player.add();
            if (Vars.net.active() && Vars.net.server()) {
                Vars.player.admin = true;
            }
        });
        Events.on(EventType.WorldLoadEvent.class, event -> Core.app.post(() -> {
            if (Vars.state.rules.pvp && !Vars.net.active()) {
                try {
                    Vars.net.host(6567);
                    Vars.player.admin = true;
                }
                catch (IOException e) {
                    Vars.ui.showException("@server.error", e);
                    Vars.state.set(GameState.State.menu);
                }
            }
        }));
        Events.on(EventType.UnlockEvent.class, e -> {
            if (e.content.showUnlock()) {
                Vars.ui.hudfrag.showUnlock(e.content);
            }
            this.checkAutoUnlocks();
            if (e.content instanceof SectorPreset) {
                for (TechTree.TechNode node : TechTree.all) {
                    if (node.content.unlocked() || !node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> {
                        if (!(o instanceof Objectives.SectorComplete)) return false;
                        Objectives.SectorComplete sec = (Objectives.SectorComplete)o;
                        if (sec.preset != e.content) return false;
                        return true;
                    }))) || node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> !o.complete())))) continue;
                    Vars.ui.hudfrag.showToast(new TextureRegionDrawable(node.content.uiIcon), 40.0f, Core.bundle.get("available"));
                }
            }
        });
        Events.on(EventType.SectorCaptureEvent.class, e -> {
            Core.app.post(this::checkAutoUnlocks);
            if (!Vars.net.client() && e.sector.preset != null && e.sector.preset.isLastSector && e.initialCapture) {
                Time.run(120.0f, () -> Vars.ui.campaignComplete.show(e.sector.planet));
            }
        });
        Events.on(EventType.GameOverEvent.class, e -> {
            if (Vars.state.isCampaign() && !Vars.net.client() && !Vars.headless && this.saves.getCurrent() != null) {
                this.saves.getCurrent().save();
            }
        });
        Events.run((Object)EventType.Trigger.newGame, () -> {
            CoreBlock.CoreBuild core = Vars.player.bestCore();
            if (core == null) {
                return;
            }
            Core.camera.position.set(core);
            Vars.player.set(core);
            float coreDelay = 0.0f;
            if (!Core.settings.getBool("skipcoreanimation") && !Vars.state.rules.pvp) {
                coreDelay = core.launchDuration();
                Vars.player.deathTimer = 60.0f - core.launchDuration();
                if (Core.settings.getInt("musicvol") > 0) {
                    Music music = core.landMusic();
                    music.stop();
                    music.play();
                    music.setVolume((float)Core.settings.getInt("musicvol") / 100.0f);
                }
                Vars.renderer.showLanding(core);
            }
            if (Vars.state.isCampaign()) {
                if (Vars.state.rules.sector.info.importRateCache != null) {
                    Vars.state.rules.sector.info.refreshImportRates(Vars.state.rules.sector.planet);
                }
                if (Vars.state.rules.sector.planet.prebuildBase) {
                    this.toBePlaced.clear();
                    float unitsPerTick = 2.0f;
                    float buildRadius = Vars.state.rules.enemyCoreBuildRadius * 1.5f;
                    boolean anyBuilds = false;
                    for (Building build : Vars.state.rules.defaultTeam.data().buildings.copy()) {
                        CoreBlock.CoreBuild ccore;
                        if (build instanceof CoreBlock.CoreBuild || build.block.privileged || (ccore = build.closestCore()) == null) continue;
                        anyBuilds = true;
                        if (!Vars.net.active()) {
                            build.pickedUp();
                            build.tile.remove();
                            this.toBePlaced.add(build);
                            Time.run(build.dst(ccore) / unitsPerTick + coreDelay, () -> {
                                if (build.tile.build != build) {
                                    this.placeLandBuild(build);
                                    this.toBePlaced.remove(build);
                                }
                            });
                            continue;
                        }
                        Fx.coreBuildBlock.at(build.x, build.y, 0.0f, build.block);
                        build.block.placeEffect.at(build.x, build.y, build.block.size);
                        DrawUtilities.arcBuildEffect(build);
                    }
                    if (anyBuilds) {
                        for (CoreBlock.CoreBuild ccore : Vars.state.rules.defaultTeam.data().cores) {
                            Time.run(coreDelay, () -> Fx.coreBuildShockwave.at(ccore.x, ccore.y, buildRadius));
                        }
                    }
                }
            }
        });
        Events.on(EventType.SaveWriteEvent.class, e -> this.forcePlaceAll());
        Events.on(EventType.HostEvent.class, e -> this.forcePlaceAll());
        Events.on(EventType.HostEvent.class, e -> Vars.state.set(GameState.State.playing));
    }

    private void forcePlaceAll() {
        for (Building build : this.toBePlaced) {
            this.placeLandBuild(build);
        }
        this.toBePlaced.clear();
    }

    private void placeLandBuild(Building build) {
        build.tile.setBlock(build.block, build.team, build.rotation, () -> build);
        build.dropped();
        Fx.coreBuildBlock.at(build.x, build.y, 0.0f, build.block);
        build.block.placeEffect.at(build.x, build.y, build.block.size);
        DrawUtilities.arcBuildEffect(build);
    }

    @Override
    public void loadAsync() {
        Draw.scl = 1.0f / (float)Core.atlas.find((String)"scale_marker").width;
        Core.input.setCatch(KeyCode.back, true);
        Core.settings.defaults("ip", "localhost", "color-0", Vars.playerColors[8].rgba(), "name", "", "lastBuild", 0);
        this.saves.load();
    }

    @Override
    public void loadSync() {
        this.createPlayer();
    }

    public void checkAutoUnlocks() {
        if (Vars.net.client()) {
            return;
        }
        for (TechTree.TechNode node : TechTree.all) {
            if (node.content.unlocked() || node.parent != null && !node.parent.content.unlocked() || node.requirements.length != 0 || node.objectives.contains((Objectives.Objective)((Object)((Boolf<Objectives.Objective>)o -> !o.complete())))) continue;
            node.content.unlock();
        }
    }

    void createPlayer() {
        Vars.player = Player.create();
        Vars.player.name = Core.settings.getString("name");
        String locale = Core.settings.getString("locale");
        if (locale.equals("default")) {
            locale = Locale.getDefault().toString();
        }
        Vars.player.locale = locale;
        Vars.player.color.set(Core.settings.getInt("color-0"));
        this.input = Vars.mobile ? new MobileInput() : new DesktopInput();
        if (Vars.state.isGame()) {
            Vars.player.add();
        }
        Events.on(EventType.ClientLoadEvent.class, e -> this.input.add());
    }

    public void setInput(InputHandler newInput) {
        Block block = this.input.block;
        boolean added = Core.input.getInputProcessors().contains(this.input);
        this.input.remove();
        this.input = newInput;
        newInput.block = block;
        if (added) {
            newInput.add();
        }
    }

    public void playMap(Map map, Rules rules) {
        this.playMap(map, rules, false);
    }

    public void playMap(Map map, Rules rules, boolean playtest) {
        Vars.ui.loadAnd(() -> {
            Vars.logic.reset();
            Vars.world.loadMap(map, rules);
            Vars.state.rules = rules;
            if (playtest) {
                Vars.state.playtestingMap = map;
            }
            Vars.state.rules.sector = null;
            Vars.state.rules.editor = false;
            Vars.logic.play();
            if (Core.settings.getBool("savecreate") && !Vars.world.isInvalidMap() && !playtest) {
                Vars.control.saves.addSave(map.name() + " " + new SimpleDateFormat("MMM dd h:mm", Locale.getDefault()).format(new Date()));
            }
            Events.fire(EventType.Trigger.newGame);
            if (Vars.world.isInvalidMap() && playtest) {
                Dialog current = Core.scene.getDialog();
                Vars.ui.editor.resumeAfterPlaytest(map);
                if (current != null) {
                    current.update(current::toFront);
                }
            }
        });
    }

    public void playSector(Sector sector) {
        this.playSector(sector, sector);
    }

    public void playSector(@Nullable Sector origin, Sector sector) {
        this.playSector(origin, sector, new WorldReloader());
    }

    void playSector(@Nullable Sector origin, Sector sector, WorldReloader reloader) {
        Vars.ui.loadAnd(() -> {
            if (this.saves.getCurrent() != null && Vars.state.isGame()) {
                Vars.control.saves.getCurrent().save();
                Vars.control.saves.resetSave();
            }
            if (sector.preset != null) {
                sector.preset.quietUnlock();
            }
            Vars.ui.planet.hide();
            Saves.SaveSlot slot = sector.save;
            sector.planet.setLastSector(sector);
            if (slot != null && !Vars.clearSectors && (!sector.planet.clearSectorOnLose && !sector.info.hasWorldProcessor || sector.info.hasCore)) {
                try {
                    boolean hadNoCore = !sector.info.hasCore;
                    reloader.begin();
                    slot.load(Vars.world.makeSectorContext(sector));
                    slot.setAutosave(true);
                    Vars.state.rules.sector = sector;
                    Vars.state.rules.cloudColor = sector.planet.landCloudColor;
                    if (Vars.state.rules.defaultTeam.cores().isEmpty() || hadNoCore) {
                        if (sector.planet.clearSectorOnLose || sector.info.hasWorldProcessor) {
                            this.playNewSector(origin, sector, reloader);
                        } else {
                            if (sector.info.spawnPosition == 0) {
                                sector.save = null;
                                slot.delete();
                                this.playSector(origin, sector, reloader);
                                return;
                            }
                            Tile spawn = Vars.world.tile(sector.info.spawnPosition);
                            spawn.setBlock(sector.planet.defaultCore, Vars.state.rules.defaultTeam);
                            SectorDamage.apply(1.0f);
                            Vars.state.wave = 1;
                            Vars.state.wavetime = Vars.state.rules.initialWaveSpacing <= 0.0f ? Vars.state.rules.waveSpacing * (sector.preset == null ? 2.0f : sector.preset.startWaveTimeMultiplier) : Vars.state.rules.initialWaveSpacing;
                            Vars.state.wavetime *= sector.planet.campaignRules.difficulty.waveTimeMultiplier;
                            sector.info.wasCaptured = false;
                            if (Vars.state.rules.sector.planet.allowWaves) {
                                Vars.state.rules.waves = true;
                                int n = Vars.state.rules.attackMode ? -1 : (sector.preset != null && sector.preset.captureWave > 0 ? sector.preset.captureWave : (Vars.state.rules.winWave = Vars.state.rules.winWave > Vars.state.wave ? Vars.state.rules.winWave : 30));
                            }
                            if (Vars.state.rules.attackMode) {
                                for (Teams.BlockPlan plan : Vars.state.rules.waveTeam.data().plans) {
                                    Tile tile = Vars.world.tile(plan.x, plan.y);
                                    if (tile == null) continue;
                                    tile.setBlock(plan.block, Vars.state.rules.waveTeam, plan.rotation);
                                    if (plan.config == null || tile.build == null) continue;
                                    tile.build.configureAny(plan.config);
                                }
                                Vars.state.rules.waveTeam.data().plans.clear();
                            }
                            Groups.unit.clear();
                            Groups.fire.clear();
                            Groups.puddle.clear();
                            Vars.state.rules.defaultTeam.data().unitCap = 0;
                            Schematics.placeLaunchLoadout(spawn.x, spawn.y);
                            Vars.player.set(spawn.x * 8, spawn.y * 8);
                            Core.camera.position.set(Vars.player);
                            Events.fire(new EventType.SectorLaunchEvent(sector));
                            Events.fire(EventType.Trigger.newGame);
                            Vars.state.set(GameState.State.playing);
                            reloader.end();
                        }
                    } else {
                        Vars.state.set(GameState.State.playing);
                        reloader.end();
                    }
                }
                catch (SaveIO.SaveException e) {
                    Log.err(e);
                    sector.save = null;
                    Time.runTask(10.0f, () -> Vars.ui.showErrorMessage("@save.corrupted"));
                    slot.delete();
                    this.playSector(origin, sector);
                }
                Vars.ui.planet.hide();
            } else {
                this.playNewSector(origin, sector, reloader);
            }
        });
    }

    public void playNewSector(@Nullable Sector origin, Sector sector, WorldReloader reloader) {
        reloader.begin();
        Vars.world.loadSector(sector);
        Vars.state.rules.sector = sector;
        sector.info.origin = origin;
        sector.info.destination = origin;
        Vars.logic.play();
        Vars.control.saves.saveSector(sector);
        Events.fire(new EventType.SectorLaunchEvent(sector));
        Events.fire(EventType.Trigger.newGame);
        reloader.end();
        Vars.state.set(GameState.State.playing);
    }

    public boolean isHighScore() {
        return this.hiscore;
    }

    @Override
    public void dispose() {
        if (this.saves != null && this.saves.getCurrent() != null && this.saves.getCurrent().isAutosave() && !Vars.net.client() && !Vars.state.isMenu() && !Vars.state.gameOver) {
            try {
                SaveIO.save(Vars.control.saves.getCurrent().file);
                Core.settings.forceSave();
                Log.info("Saved on exit.");
            }
            catch (Throwable t) {
                Log.err(t);
            }
        }
        for (Music music : Core.assets.getAll(Music.class, new Seq())) {
            music.stop();
        }
        Vars.net.dispose();
    }

    @Override
    public void pause() {
        if (Core.settings.getBool("backgroundpause", true) && !Vars.net.active()) {
            this.backgroundPaused = true;
            this.wasPaused = Vars.state.is(GameState.State.paused);
            if (Vars.state.is(GameState.State.playing)) {
                Vars.state.set(GameState.State.paused);
            }
        }
    }

    @Override
    public void resume() {
        if (Vars.state.is(GameState.State.paused) && !this.wasPaused && Core.settings.getBool("backgroundpause", true) && !Vars.net.active()) {
            Vars.state.set(GameState.State.playing);
        }
        this.backgroundPaused = false;
    }

    @Override
    public void init() {
        Vars.platform.updateRPC();
        if (Core.settings.getBool("uiscalechanged", false)) {
            Core.app.post(() -> Core.app.post(() -> {
                BaseDialog dialog = new BaseDialog("@confirm");
                dialog.setFillParent(true);
                float[] countdown = new float[]{1860.0f};
                Runnable exit = () -> {
                    Core.settings.put("uiscale", 100);
                    Core.settings.put("uiscalechanged", false);
                    dialog.hide();
                    Core.app.exit();
                };
                dialog.cont.label(() -> {
                    if (countdown[0] <= 0.0f) {
                        exit.run();
                    }
                    Object[] objectArray = new Object[1];
                    countdown[0] = countdown[0] - Time.delta;
                    objectArray[0] = (int)(countdown[0] / 60.0f);
                    return Core.bundle.format("uiscale.reset", objectArray);
                }).pad(10.0f).expand().center();
                dialog.buttons.defaults().size(200.0f, 60.0f);
                dialog.buttons.button("@uiscale.cancel", exit);
                dialog.buttons.button("@ok", () -> {
                    Core.settings.put("uiscalechanged", false);
                    dialog.hide();
                });
                dialog.show();
            }));
        }
        bossKeyPressing = false;
        if (!Core.app.isMobile()) {
            Events.on(EventType.ClientLoadEvent.class, e -> this.initCalc());
        }
    }

    private void initCalc() {
        this.calcDialog = new BaseDialog("");
        this.calcDialog.setBackground(Styles.black);
        this.calcDialog.shown(this::buildCalc);
        this.calcDialog.resized(this::buildCalc);
        this.calcDialog.update(() -> this.calcDialog.toFront());
    }

    private void buildCalc() {
        float width = (float)Core.graphics.getWidth() * 0.9f;
        this.calcDialog.cont.clear();
        this.calcDialog.cont.label(() -> this.formula.toString()).width(width).get().setAlignment(16);
        this.calcDialog.cont.row();
        this.calcDialog.cont.label(() -> this.resultString).width(width).get().setAlignment(16);
        this.calcDialog.cont.row();
        HashMap<String, Runnable> map = new HashMap<String, Runnable>();
        map.put("AC", () -> {
            this.formula.setLength(0);
            this.resultString = "";
        });
        map.put("<-", () -> {
            if (this.formula.length() == 0) {
                return;
            }
            this.formula.deleteCharAt(this.formula.length() - 1);
        });
        String[][] buttons = new String[][]{{"(", ")", "AC", "<-"}, {"7", "8", "9", "-"}, {"4", "5", "6", "+"}, {"1", "2", "3", "*"}, {"0", ".", "e", "/"}, {"&", "^", "|", "%"}};
        this.calcDialog.cont.table(t -> {
            String[][] stringArray = buttons;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] arr;
                for (String button : arr = stringArray[i]) {
                    Runnable replace = (Runnable)map.get(button);
                    if (replace == null) {
                        t.button(button, () -> this.formula.append(button)).width(width / 4.0f);
                        continue;
                    }
                    t.button(button, replace).width(width / 4.0f);
                }
                t.row();
            }
        });
        this.calcDialog.cont.row();
        this.calcDialog.cont.button("\u8ba1\u7b97", () -> {
            this.resultString = Vars.mods.getScripts().runConsole(this.formula.toString());
        }).width(width);
    }

    public void loadIcon(String path) {
        Vars.mods.getScripts().runConsole("Vars.mods.getScripts().runConsole(\"{let p=new Pixmap(Core.files.get(\\\"" + path + "\\\",Files.FileType.internal));let s=Packages.arc.backend.sdl.jni.SDL.SDL_CreateRGBSurfaceFrom(p.pixels,p.width,p.height);Packages.arc.backend.sdl.jni.SDL.SDL_SetWindowIcon(Core.app.window,s);Packages.arc.backend.sdl.jni.SDL.SDL_FreeSurface(s);p.dispose()}\")");
    }

    @Override
    public void update() {
        if (Core.assets == null) {
            return;
        }
        this.saves.update();
        try {
            Core.assets.update();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.input.updateState();
        this.sound.update();
        if (Core.input.keyTap(Binding.fullscreen)) {
            boolean full = Core.settings.getBool("fullscreen");
            if (full) {
                Core.graphics.setWindowedMode(Core.graphics.getWidth(), Core.graphics.getHeight());
            } else {
                Core.graphics.setFullscreen();
            }
            Core.settings.put("fullscreen", !full);
        }
        if (Float.isNaN(Vars.player.x) || Float.isNaN(Vars.player.y)) {
            Vars.player.set(0.0f, 0.0f);
            if (!Vars.player.dead()) {
                Vars.player.unit().kill();
            }
        }
        if (Float.isNaN(Core.camera.position.x)) {
            Core.camera.position.x = (float)Vars.world.unitWidth() / 2.0f;
        }
        if (Float.isNaN(Core.camera.position.y)) {
            Core.camera.position.y = (float)Vars.world.unitHeight() / 2.0f;
        }
        if (this.calcDialog != null && bossKeyValid && Vars.clientLoaded && Core.input.keyTap(Binding.bossKey)) {
            if (Core.input.keyDown(KeyCode.controlLeft)) {
                if (!bossKeyPressing) {
                    return;
                }
                this.calcDialog.hide();
                this.loadIcon("icons/arc.png");
                bossKeyPressing = false;
            } else {
                if (bossKeyPressing) {
                    return;
                }
                bossKeyPressing = true;
                this.loadIcon("icons/calc.png");
                Core.settings.put("musicvol", 0);
                Core.settings.put("sfxvol", 0);
                Core.settings.put("ambientvol", 0);
                ARCVars.arcui.MusicDialog.vol = 0.0f;
                ARCVars.arcui.MusicDialog.player.setVolume(0.0f);
                ARCVars.arcui.MusicDialog.sounds.setVolume(0.0f);
                this.calcDialog.show(Core.scene, Actions.alpha(1.0f));
                Vars.mods.getScripts().runConsole("Packages.arc.backend.sdl.jni.SDL.SDL_SetWindowFullscreen(Core.app.window,0);\nPackages.arc.backend.sdl.jni.SDL.SDL_SetWindowSize(Core.app.window,220,430);\nTimer.schedule(()=>Packages.arc.backend.sdl.jni.SDL.SDL_MinimizeWindow(Core.app.window),0.15)\n");
            }
        }
        if (Vars.state.isGame()) {
            this.input.update();
            if (!Vars.state.isPaused()) {
                this.indicators.update();
            }
            if (this.timer.get(0, 300.0f)) {
                Vars.platform.updateRPC();
            }
            CoreBlock.CoreBuild core = Vars.state.rules.defaultTeam.core();
            if (!Vars.net.client() && core != null && Vars.state.isCampaign()) {
                core.items.each((i, a) -> i.unlock());
            }
            if (this.backgroundPaused && Core.settings.getBool("backgroundpause") && !Vars.net.active()) {
                Vars.state.set(GameState.State.paused);
            }
            if (Vars.state.isPaused() && Vars.renderer.isCutscene()) {
                Vars.state.set(GameState.State.playing);
            }
            if (!(Vars.net.client() || !Core.input.keyTap(Binding.pause) || Vars.state.isCampaign() && Vars.state.afterGameOver || Vars.renderer.isCutscene() || Core.scene.hasDialog() || Core.scene.hasKeyboard() || Vars.ui.restart.isShown() || !Vars.state.is(GameState.State.paused) && !Vars.state.is(GameState.State.playing))) {
                Vars.state.set(Vars.state.isPaused() ? GameState.State.playing : GameState.State.paused);
            }
            if (Vars.state.isCampaign() && Vars.state.afterGameOver) {
                Vars.state.set(GameState.State.paused);
            }
            if (Core.input.keyTap(Binding.menu) && !Vars.ui.restart.isShown() && !Vars.ui.minimapfrag.shown()) {
                if (Vars.ui.chatfrag.shown()) {
                    Vars.ui.chatfrag.hide();
                } else if (!Vars.ui.paused.isShown() && !Core.scene.hasDialog()) {
                    Vars.ui.paused.show();
                    if (!Vars.net.active()) {
                        Vars.state.set(GameState.State.paused);
                    }
                }
            }
            if (!Vars.mobile && Core.input.keyTap(Binding.screenshot) && !Core.scene.hasField() && !Core.scene.hasKeyboard()) {
                Vars.renderer.takeMapScreenshot();
            }
        } else {
            if (!Vars.state.isPaused()) {
                Time.update();
            }
            if (!Core.scene.hasDialog() && !Core.scene.root.getChildren().isEmpty() && !(Core.scene.root.getChildren().peek() instanceof Dialog) && Core.input.keyTap(KeyCode.back)) {
                Vars.platform.hide();
            }
        }
    }
}

