/*
 * Decompiled with CFR 0.152.
 */
package mindustry.content;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.content.Liquids;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.entities.LegDestroyData;
import mindustry.entities.abilities.ForceFieldAbility;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Fire;
import mindustry.gen.Icon;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.units.UnitAssembler;

public class Fx {
    public static final Rand rand = new Rand();
    public static final Vec2 v = new Vec2();
    public static final Effect none = new Effect(0.0f, 0.0f, e -> {});
    public static final Effect blockCrash = new Effect(90.0f, e -> {
        Object patt867$temp = e.data;
        if (!(patt867$temp instanceof Block)) {
            return;
        }
        Block block = (Block)patt867$temp;
        Draw.alpha(e.fin() + 0.5f);
        float offset = Mathf.lerp(0.0f, 180.0f, e.fout());
        Draw.color(0.0f, 0.0f, 0.0f, 0.44f);
        Draw.rect(block.fullIcon, e.x - offset * 4.0f, e.y, (float)block.size * 8.0f, (float)block.size * 8.0f);
        Draw.color(Color.white);
        Draw.rect(block.fullIcon, e.x + offset, e.y + offset * 5.0f, (float)block.size * 8.0f, (float)block.size * 8.0f);
    });
    public static final Effect trailFade = new Effect(400.0f, e -> {
        Object patt1331$temp = e.data;
        if (!(patt1331$temp instanceof Trail)) {
            return;
        }
        Trail trail = (Trail)patt1331$temp;
        e.lifetime = (float)trail.length * 1.4f;
        if (!Vars.state.isPaused()) {
            trail.shorten();
        }
        trail.drawCap(e.color, e.rotation);
        trail.draw(e.color, e.rotation);
    });
    public static final Effect unitSpawn = new Effect(30.0f, e -> {
        Object patt1699$temp = e.data;
        if (!(patt1699$temp instanceof UnitType)) {
            return;
        }
        UnitType unit = (UnitType)patt1699$temp;
        TextureRegion region = unit.fullIcon;
        float scl = (1.0f + e.fout() * 2.0f) * region.scl();
        Draw.alpha(e.fout());
        Draw.mixcol(Color.white, e.fin());
        Draw.rect(region, e.x, e.y, 180.0f);
        Draw.reset();
        Draw.alpha(e.fin());
        Draw.rect(region, e.x, e.y, (float)region.width * scl, (float)region.height * scl, e.rotation - 90.0f);
    });
    public static final Effect unitCapKill = new Effect(80.0f, e -> {
        Draw.color(Color.scarlet);
        Draw.alpha(e.fout(Interp.pow4Out));
        float size = 10.0f + e.fout(Interp.pow10In) * 25.0f;
        Draw.rect(Icon.warning.getRegion(), e.x, e.y, size, size);
    });
    public static final Effect unitEnvKill = new Effect(80.0f, e -> {
        Draw.color(Color.scarlet);
        Draw.alpha(e.fout(Interp.pow4Out));
        float size = 10.0f + e.fout(Interp.pow10In) * 25.0f;
        Draw.rect(Icon.cancel.getRegion(), e.x, e.y, size, size);
    });
    public static final Effect unitControl = new Effect(30.0f, e -> {
        Object patt2633$temp = e.data;
        if (!(patt2633$temp instanceof Unit)) {
            return;
        }
        Unit select = (Unit)patt2633$temp;
        boolean block = select instanceof BlockUnitc;
        Draw.mixcol(Pal.accent, 1.0f);
        Draw.alpha(e.fout());
        Draw.rect(block ? ((BlockUnitc)((Object)select)).tile().block.fullIcon : select.type.fullIcon, select.x, select.y, block ? 0.0f : select.rotation - 90.0f);
        Draw.alpha(1.0f);
        Lines.stroke(e.fslope());
        Lines.square(select.x, select.y, e.fout() * select.hitSize * 2.0f, 45.0f);
        Lines.stroke(e.fslope() * 2.0f);
        Lines.square(select.x, select.y, e.fout() * select.hitSize * 3.0f, 45.0f);
        Draw.reset();
    });
    public static final Effect unitDespawn = new Effect(100.0f, e -> {
        Unit select;
        block3: {
            block2: {
                Object patt3261$temp = e.data;
                if (!(patt3261$temp instanceof Unit)) break block2;
                select = (Unit)patt3261$temp;
                if (select.type != null) break block3;
            }
            return;
        }
        float scl = e.fout(Interp.pow2Out);
        float p = Draw.scl;
        Draw.scl *= scl;
        Draw.mixcol(Pal.accent, 1.0f);
        Draw.rect(select.type.fullIcon, select.x, select.y, select.rotation - 90.0f);
        Draw.reset();
        Draw.scl = p;
    });
    public static final Effect unitSpirit = new Effect(17.0f, e -> {
        Object patt3636$temp = e.data;
        if (!(patt3636$temp instanceof Position)) {
            return;
        }
        Position to = (Position)patt3636$temp;
        Draw.color(Pal.accent);
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow2In);
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        float size = 2.5f * e.fin();
        Fill.square(x, y, 1.5f * size, 45.0f);
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow5In);
        x = Tmp.v1.x;
        y = Tmp.v1.y;
        Fill.square(x, y, size, 45.0f);
    });
    public static final Effect itemTransfer = new Effect(12.0f, e -> {
        Object patt4142$temp = e.data;
        if (!(patt4142$temp instanceof Position)) {
            return;
        }
        Position to = (Position)patt4142$temp;
        Tmp.v1.set(e.x, e.y).interpolate(Tmp.v2.set(to), e.fin(), (Interp)Interp.pow3).add(Tmp.v2.sub(e.x, e.y).nor().rotate90(1).scl(Mathf.randomSeedRange(e.id, 1.0f) * e.fslope() * 10.0f));
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        float size = 1.0f;
        Draw.color(Pal.accent);
        Fill.circle(x, y, e.fslope() * 3.0f * size);
        Draw.color(e.color);
        Fill.circle(x, y, e.fslope() * 1.5f * size);
    });
    public static final Effect pointBeam = new Effect(25.0f, 300.0f, e -> {
        Object patt4662$temp = e.data;
        if (!(patt4662$temp instanceof Position)) {
            return;
        }
        Position pos = (Position)patt4662$temp;
        Draw.color(e.color, e.fout());
        Lines.stroke(1.5f);
        Lines.line(e.x, e.y, pos.getX(), pos.getY());
        Drawf.light(e.x, e.y, pos.getX(), pos.getY(), 20.0f, e.color, 0.6f * e.fout());
    });
    public static final Effect pointHit = new Effect(8.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 6.0f);
    });
    public static final Effect lightning = new Effect(10.0f, 500.0f, e -> {
        if (!(e.data instanceof Seq)) {
            return;
        }
        Seq lines = (Seq)e.data();
        Lines.stroke(3.0f * e.fout());
        Draw.color(e.color, Color.white, e.fin());
        for (int i = 0; i < lines.size - 1; ++i) {
            Vec2 cur = (Vec2)lines.get(i);
            Vec2 next = (Vec2)lines.get(i + 1);
            Lines.line(cur.x, cur.y, next.x, next.y, false);
        }
        for (Vec2 p : lines) {
            Fill.circle(p.x, p.y, Lines.getStroke() / 2.0f);
        }
    });
    public static final Effect coreBuildShockwave = new Effect(120.0f, 500.0f, e -> {
        e.lifetime = e.rotation;
        Draw.color(Pal.command);
        Lines.stroke(e.fout(Interp.pow5Out) * 4.0f);
        Lines.circle(e.x, e.y, e.fin() * e.rotation * 2.0f);
    });
    public static final Effect coreBuildBlock = new Effect(80.0f, e -> {
        Object patt5890$temp = e.data;
        if (!(patt5890$temp instanceof Block)) {
            return;
        }
        Block block = (Block)patt5890$temp;
        Draw.mixcol(Pal.accent, 1.0f);
        Draw.alpha(e.fout());
        Draw.rect(block.fullIcon, e.x, e.y);
    }).layer(45.0f);
    public static final Effect pointShockwave = new Effect(20.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, e.finpow() * e.rotation);
        Angles.randLenVectors(e.id + 1, 8, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect moveCommand = new Effect(20.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(e.fout() * 5.0f);
        Lines.circle(e.x, e.y, 6.0f + e.fin() * 2.0f);
    }).layer(120.0f);
    public static final Effect attackCommand = new Effect(20.0f, e -> {
        Draw.color(Pal.remove);
        Lines.stroke(e.fout() * 5.0f);
        Lines.poly(e.x, e.y, 4, 7.0f + e.fin() * 2.0f);
    }).layer(120.0f);
    public static final Effect commandSend = new Effect(28.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * e.rotation);
    });
    public static final Effect upgradeCore = new Effect(120.0f, e -> {
        Object patt6961$temp = e.data;
        if (!(patt6961$temp instanceof Block)) {
            return;
        }
        Block block = (Block)patt6961$temp;
        Draw.mixcol(Tmp.c1.set(Color.white).lerp(Pal.accent, e.fin()), 1.0f);
        Draw.alpha(e.fout());
        Draw.rect(block.fullIcon, e.x, e.y);
    }).layer(45.0f);
    public static final Effect upgradeCoreBloom = new Effect(80.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(4.0f * e.fout());
        Lines.square(e.x, e.y, 4.0f * e.rotation + 2.0f);
    });
    public static final Effect placeBlock = new Effect(16.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.square(e.x, e.y, 4.0f * e.rotation + e.fin() * 3.0f);
    });
    public static final Effect coreLaunchConstruct = new Effect(35.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(4.0f - e.fin() * 3.0f);
        Lines.square(e.x, e.y, 4.0f * e.rotation * 1.2f + e.fin() * 5.0f);
        Angles.randLenVectors(e.id, 5 + (int)(e.rotation * 5.0f), e.rotation * 3.0f + 8.0f * e.rotation * e.finpow() * 1.5f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * (4.0f + e.rotation)));
    });
    public static final Effect tapBlock = new Effect(12.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + 5.3333335f * e.rotation * e.fin());
    });
    public static final Effect breakBlock = new Effect(12.0f, e -> {
        Draw.color(Pal.remove);
        Lines.stroke(3.0f - e.fin() * 2.0f);
        Lines.square(e.x, e.y, 4.0f * e.rotation + e.fin() * 3.0f);
        Angles.randLenVectors(e.id, 3 + (int)(e.rotation * 3.0f), e.rotation * 2.0f + 8.0f * e.rotation * e.finpow(), (x, y) -> Fill.square(e.x + x, e.y + y, 1.0f + e.fout() * (3.0f + e.rotation)));
    });
    public static final Effect payloadDeposit = new Effect(30.0f, e -> {
        Object patt8625$temp = e.data;
        if (!(patt8625$temp instanceof UnitAssembler.YeetData)) {
            return;
        }
        UnitAssembler.YeetData data = (UnitAssembler.YeetData)patt8625$temp;
        Tmp.v1.set(e.x, e.y).lerp(data.target, e.finpow());
        float x = Tmp.v1.x;
        float y = Tmp.v1.y;
        Draw.scl(e.fout(Interp.pow3Out) * 1.05f);
        UnlockableContent patt8829$temp = data.item;
        if (patt8829$temp instanceof Block) {
            Block block = (Block)patt8829$temp;
            Drawf.squareShadow(x, y, (float)(block.size * 8) * 1.85f, 1.0f);
        } else {
            UnlockableContent patt8954$temp = data.item;
            if (patt8954$temp instanceof UnitType) {
                UnitType unit = (UnitType)patt8954$temp;
                unit.drawSoftShadow(e.x, e.y, e.rotation, 1.0f);
            }
        }
        Draw.mixcol(Pal.accent, e.fin());
        Draw.rect(data.item.fullIcon, x, y, data.item instanceof Block ? 0.0f : e.rotation - 90.0f);
    }).layer(85.0f);
    public static final Effect select = new Effect(23.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(e.fout() * 3.0f);
        Lines.circle(e.x, e.y, 3.0f + e.fin() * 14.0f);
    });
    public static final Effect smoke = new Effect(100.0f, e -> {
        Draw.color(Color.gray, Pal.darkishGray, e.fin());
        Fill.circle(e.x, e.y, (7.0f - e.fin() * 7.0f) / 2.0f);
    });
    public static final Effect fallSmoke = new Effect(110.0f, e -> {
        Draw.color(Color.gray, Color.darkGray, e.rotation);
        Fill.circle(e.x, e.y, e.fout() * 3.5f);
    });
    public static final Effect unitWreck = new Effect(200.0f, e -> {
        Object patt9738$temp = e.data;
        if (!(patt9738$temp instanceof TextureRegion)) {
            return;
        }
        TextureRegion reg = (TextureRegion)patt9738$temp;
        Draw.mixcol(Pal.rubble, 1.0f);
        float vel = e.fin(Interp.pow5Out) * 2.0f * Mathf.randomSeed(e.id, 1.0f);
        float totalRot = Mathf.randomSeed(e.id + 1, 10.0f);
        Tmp.v1.trns(Mathf.randomSeed(e.id + 2, 360.0f), vel);
        Draw.z(Mathf.lerp(90.0f, 20.0f, e.fin()));
        Draw.alpha(e.fout(Interp.pow5Out));
        Draw.rect(reg, e.x + Tmp.v1.x, e.y + Tmp.v1.y, e.rotation - 90.0f + totalRot * e.fin(Interp.pow5Out));
    });
    public static final Effect rocketSmoke = new Effect(120.0f, e -> {
        Draw.color(Color.gray);
        Draw.alpha(Mathf.clamp(e.fout() * 1.6f - Interp.pow3In.apply(e.rotation) * 1.2f));
        Fill.circle(e.x, e.y, 1.0f + 6.0f * e.rotation - e.fin() * 2.0f);
    });
    public static final Effect rocketSmokeLarge = new Effect(220.0f, e -> {
        Draw.color(Color.gray);
        Draw.alpha(Mathf.clamp(e.fout() * 1.6f - Interp.pow3In.apply(e.rotation) * 1.2f));
        Fill.circle(e.x, e.y, 1.0f + 6.0f * e.rotation * 1.3f - e.fin() * 2.0f);
    });
    public static final Effect magmasmoke = new Effect(110.0f, e -> {
        Draw.color(Color.gray);
        Fill.circle(e.x, e.y, e.fslope() * 6.0f);
    });
    public static final Effect spawn = new Effect(30.0f, e -> {
        Lines.stroke(2.0f * e.fout());
        Draw.color(Pal.accent);
        Lines.poly(e.x, e.y, 4, 5.0f + e.fin() * 12.0f);
    });
    public static final Effect unitAssemble = new Effect(70.0f, e -> {
        Object patt11051$temp = e.data;
        if (!(patt11051$temp instanceof UnitType)) {
            return;
        }
        UnitType type = (UnitType)patt11051$temp;
        Draw.alpha(e.fout());
        Draw.mixcol(Pal.accent, e.fout());
        Draw.rect(type.fullIcon, e.x, e.y, e.rotation);
    }).layer(120.0f);
    public static final Effect padlaunch = new Effect(10.0f, e -> {
        Lines.stroke(4.0f * e.fout());
        Draw.color(Pal.accent);
        Lines.poly(e.x, e.y, 4, 5.0f + e.fin() * 60.0f);
    });
    public static final Effect breakProp = new Effect(23.0f, e -> {
        float scl = Math.max(e.rotation, 1.0f);
        Draw.color(Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors(e.id, 6, 19.0f * e.finpow() * scl, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.5f * scl + 0.3f));
    }).layer(20.0f);
    public static final Effect unitDrop = new Effect(30.0f, e -> {
        Draw.color(Pal.lightishGray);
        Angles.randLenVectors(e.id, 9, 3.0f + 20.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.4f));
    }).layer(20.0f);
    public static final Effect unitLand = new Effect(30.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors(e.id, 6, 17.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.3f));
    }).layer(20.0f);
    public static final Effect unitDust = new Effect(30.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.3f));
        Angles.randLenVectors(e.id, 3, 8.0f * e.finpow(), e.rotation, 30.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.3f));
    }).layer(20.0f);
    public static final Effect unitLandSmall = new Effect(30.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.1f));
        Angles.randLenVectors(e.id, (int)(6.0f * e.rotation), 12.0f * e.finpow() * e.rotation, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.1f));
    }).layer(20.0f);
    public static final Effect unitPickup = new Effect(18.0f, e -> {
        Draw.color(Pal.lightishGray);
        Lines.stroke(e.fin() * 2.0f);
        Lines.poly(e.x, e.y, 4, 13.0f * e.fout());
    }).layer(20.0f);
    public static final Effect crawlDust = new Effect(35.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).mul(1.6f));
        Angles.randLenVectors(e.id, 2, 10.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fslope() * 4.0f + 0.3f));
    }).layer(20.0f);
    public static final Effect landShock = new Effect(12.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Lines.stroke(e.fout() * 3.0f);
        Lines.poly(e.x, e.y, 12, 20.0f * e.fout());
    }).layer(20.0f);
    public static final Effect pickup = new Effect(18.0f, e -> {
        Draw.color(Pal.lightishGray);
        Lines.stroke(e.fout() * 2.0f);
        Lines.spikes(e.x, e.y, 1.0f + e.fin() * 6.0f, e.fout() * 4.0f, 6);
    });
    public static final Effect sparkExplosion = new Effect(30.0f, 160.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 3.0f);
        float circleRad = 6.0f + e.finpow() * e.rotation;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 16; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Lines.lineAngle(e.x, e.y, angle, e.foutpow() * e.rotation * 0.8f * rand.random(1.0f, 0.6f) + 2.0f, e.finpow() * e.rotation * 1.2f * lenRand + 6.0f);
        }
    });
    public static final Effect titanExplosion = new Effect(30.0f, 160.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 3.0f);
        float circleRad = 6.0f + e.finpow() * 60.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 16; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Lines.lineAngle(e.x, e.y, angle, e.foutpow() * 50.0f * rand.random(1.0f, 0.6f) + 2.0f, e.finpow() * 70.0f * lenRand + 6.0f);
        }
    });
    public static final Effect titanExplosionLarge = new Effect(45.0f, 220.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 3.0f);
        float circleRad = 6.0f + e.finpow() * 110.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 21; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Lines.lineAngle(e.x, e.y, angle, e.foutpow() * 50.0f * rand.random(1.0f, 0.6f) + 2.0f, e.finpow() * 100.0f * lenRand + 6.0f);
        }
    });
    public static final Effect titanExplosionSmall = new Effect(22.0f, 120.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 3.0f);
        float circleRad = 6.0f + e.finpow() * 45.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 12; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Lines.lineAngle(e.x, e.y, angle, e.foutpow() * 50.0f * rand.random(1.0f, 0.6f) + 2.0f, e.finpow() * 50.0f * lenRand + 6.0f);
        }
    });
    public static final Effect titanExplosionFrag = new Effect(20.0f, 50.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        float circleRad = 6.0f + e.finpow() * 20.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 8; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Tmp.v1.trns(angle, circleRad);
            for (int s : Mathf.signs) {
                Drawf.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, e.foutpow() * 15.0f, e.fout() * 20.0f * lenRand + 6.0f, angle + 90.0f + (float)s * 90.0f);
            }
        }
    });
    public static final Effect titanSmoke = new Effect(300.0f, 300.0f, b -> {
        float intensity = 3.0f;
        Draw.color(b.color, 0.7f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 22.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    });
    public static final Effect titanSmokeLarge = new Effect(400.0f, 400.0f, b -> {
        float intensity = 4.0f;
        Draw.color(b.color, 0.65f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 26.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    });
    public static final Effect titanSmokeSmall = new Effect(200.0f, 200.0f, b -> {
        float intensity = 2.5f;
        Draw.color(b.color, 0.7f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 18.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    });
    public static final Effect smokeAoeCloud = new Effect(180.0f, 250.0f, e -> {
        Draw.color(e.color, 0.65f);
        Angles.randLenVectors(e.id, 80, 90.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 6.0f * Mathf.clamp(e.fin() / 0.1f) * Mathf.clamp(e.fout() / 0.1f)));
    });
    public static final Effect missileTrailSmoke = new Effect(180.0f, 300.0f, b -> {
        float intensity = 2.0f;
        Draw.color(b.color, 0.7f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 13.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    }).layer(99.0f);
    public static final Effect missileTrailSmokeSmall = new Effect(120.0f, 200.0f, b -> {
        float intensity = 1.3f;
        Draw.color(b.color, 0.7f);
        int i = 0;
        while (i < 3) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 13.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    }).layer(99.0f);
    public static final Effect neoplasmSplat = new Effect(400.0f, 300.0f, b -> {
        float intensity = 3.0f;
        Draw.color(Pal.neoplasm1);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(5.0f * intensity), 22.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 1.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, b.color, 0.5f);
            }));
        }
    }).layer(98.0f);
    public static final Effect scatheExplosion = new Effect(60.0f, 160.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 5.0f);
        float circleRad = 6.0f + e.finpow() * 60.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 16; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Tmp.v1.trns(angle, circleRad);
            for (int s : Mathf.signs) {
                Drawf.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, e.foutpow() * 40.0f, e.fout() * 30.0f * lenRand + 6.0f, angle + 90.0f + (float)s * 90.0f);
            }
        }
    });
    public static final Effect scatheExplosionSmall = new Effect(40.0f, 160.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 4.0f);
        float circleRad = 6.0f + e.finpow() * 40.0f;
        Lines.circle(e.x, e.y, circleRad);
        rand.setSeed(e.id);
        for (int i = 0; i < 16; ++i) {
            float angle = rand.random(360.0f);
            float lenRand = rand.random(0.5f, 1.0f);
            Tmp.v1.trns(angle, circleRad);
            for (int s : Mathf.signs) {
                Drawf.tri(e.x + Tmp.v1.x, e.y + Tmp.v1.y, e.foutpow() * 30.0f, e.fout() * 25.0f * lenRand + 6.0f, angle + 90.0f + (float)s * 90.0f);
            }
        }
    });
    public static final Effect scatheLight = new Effect(60.0f, 160.0f, e -> {
        float circleRad = 6.0f + e.finpow() * 60.0f;
        Draw.color(e.color, e.foutpow());
        Fill.circle(e.x, e.y, circleRad);
    }).layer(102.0f);
    public static final Effect scatheLightSmall = new Effect(60.0f, 160.0f, e -> {
        float circleRad = 6.0f + e.finpow() * 40.0f;
        Draw.color(e.color, e.foutpow());
        Fill.circle(e.x, e.y, circleRad);
    }).layer(102.0f);
    public static final Effect titanLightSmall = new Effect(40.0f, 100.0f, e -> {
        float circleRad = 6.0f + e.finpow() * 20.0f;
        Draw.color(e.color, e.foutpow());
        Fill.circle(e.x, e.y, circleRad);
    }).layer(102.0f);
    public static final Effect scatheSlash = new Effect(40.0f, 160.0f, e -> {
        Draw.color(e.color);
        for (int s : Mathf.signs) {
            Drawf.tri(e.x, e.y, e.fout() * 25.0f, e.foutpow() * 66.0f + 6.0f, e.rotation + (float)s * 90.0f);
        }
    });
    public static final Effect dynamicSpikes = new Effect(40.0f, 100.0f, e -> {
        int i;
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        float circleRad = 4.0f + e.finpow() * e.rotation;
        Lines.circle(e.x, e.y, circleRad);
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 6.0f, e.rotation * 1.5f * e.fout(), i * 90);
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 3.0f, e.rotation * 1.45f / 3.0f * e.fout(), i * 90);
        }
        Drawf.light(e.x, e.y, circleRad * 1.6f, Pal.heal, e.fout());
    });
    public static final Effect greenBomb = new Effect(40.0f, 100.0f, e -> {
        int i;
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        float circleRad = 4.0f + e.finpow() * 65.0f;
        Lines.circle(e.x, e.y, circleRad);
        Draw.color(Pal.heal);
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 6.0f, 100.0f * e.fout(), i * 90);
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 3.0f, 35.0f * e.fout(), i * 90);
        }
        Drawf.light(e.x, e.y, circleRad * 1.6f, Pal.heal, e.fout());
    });
    public static final Effect greenLaserCharge = new Effect(80.0f, 100.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.fout() * 100.0f);
        Fill.circle(e.x, e.y, e.fin() * 20.0f);
        Angles.randLenVectors(e.id, 20, 40.0f * e.fout(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fin() * 5.0f);
            Drawf.light(e.x + x, e.y + y, e.fin() * 15.0f, Pal.heal, 0.7f);
        });
        Draw.color();
        Fill.circle(e.x, e.y, e.fin() * 10.0f);
        Drawf.light(e.x, e.y, e.fin() * 20.0f, Pal.heal, 0.7f);
    }).followParent(true).rotWithParent(true);
    public static final Effect greenLaserChargeSmall = new Effect(40.0f, 100.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, e.fout() * 50.0f);
    }).followParent(true).rotWithParent(true);
    public static final Effect greenCloud = new Effect(80.0f, e -> {
        Draw.color(Pal.heal);
        Angles.randLenVectors((long)e.id, e.fin(), 7, 9.0f, (x, y, fin, fout) -> Fill.circle(e.x + x, e.y + y, 5.0f * fout));
    });
    public static final Effect healWaveDynamic = new Effect(22.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * e.rotation);
    });
    public static final Effect healWave = new Effect(22.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 60.0f);
    });
    public static final Effect heal = new Effect(11.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 2.0f + e.finpow() * 7.0f);
    });
    public static final Effect dynamicWave = new Effect(22.0f, e -> {
        Draw.color(e.color, 0.7f);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * e.rotation);
    });
    public static final Effect shieldWave = new Effect(22.0f, e -> {
        Draw.color(e.color, 0.7f);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 60.0f);
    });
    public static final Effect shieldApply = new Effect(11.0f, e -> {
        Draw.color(e.color, 0.7f);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 2.0f + e.finpow() * 7.0f);
    });
    public static final Effect disperseTrail = new Effect(13.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(0.6f + e.fout() * 1.7f);
        rand.setSeed(e.id);
        for (int i = 0; i < 2; ++i) {
            float rot = e.rotation + rand.range(15.0f) + 180.0f;
            v.trns(rot, rand.random(e.fin() * 27.0f));
            Lines.lineAngle(e.x + Fx.v.x, e.y + Fx.v.y, rot, e.fout() * rand.random(2.0f, 7.0f) + 1.5f);
        }
    });
    public static final Effect hitBulletSmall = new Effect(14.0f, e -> {
        Draw.color(Color.white, Pal.lightOrange, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 5.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 5, e.fin() * 15.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
        Drawf.light(e.x, e.y, 20.0f, Pal.lightOrange, 0.6f * e.fout());
    });
    public static final Effect hitBulletColor = new Effect(14.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 5.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 5, e.fin() * 15.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
        Drawf.light(e.x, e.y, 20.0f, e.color, 0.6f * e.fout());
    });
    public static final Effect hitSquaresColor = new Effect(14.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 5.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 5, e.fin() * 17.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Fill.square(e.x + x, e.y + y, e.fout() * 3.2f, ang);
        });
        Drawf.light(e.x, e.y, 20.0f, e.color, 0.6f * e.fout());
    });
    public static final Effect hitFuse = new Effect(14.0f, e -> {
        Draw.color(Color.white, Pal.surge, e.fin());
        e.scaled(7.0f, s -> {
            Lines.stroke(0.5f + s.fout());
            Lines.circle(e.x, e.y, s.fin() * 7.0f);
        });
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 6, e.fin() * 15.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitBulletBig = new Effect(13.0f, e -> {
        Draw.color(Color.white, Pal.lightOrange, e.fin());
        Lines.stroke(0.5f + e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 30.0f, e.rotation, 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.5f);
        });
    });
    public static final Effect hitFlameSmall = new Effect(14.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 15.0f, e.rotation, 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitFlamePlasma = new Effect(14.0f, e -> {
        Draw.color(Color.white, Pal.heal, e.fin());
        Lines.stroke(0.5f + e.fout());
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 15.0f, e.rotation, 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 3.0f + 1.0f);
        });
    });
    public static final Effect hitLiquid = new Effect(16.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 5, 1.0f + e.fin() * 15.0f, e.rotation, 60.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f));
    });
    public static final Effect hitLaserBlast = new Effect(12.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 17.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitEmpSpark = new Effect(40.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 1.6f);
        Angles.randLenVectors(e.id, 18, e.finpow() * 27.0f, e.rotation, 360.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 6.0f + 1.0f);
        });
    });
    public static final Effect hitLancer = new Effect(12.0f, e -> {
        Draw.color(Color.white);
        Lines.stroke(e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 8, e.finpow() * 17.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitBeam = new Effect(12.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitFlameBeam = new Effect(19.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 7, e.finpow() * 11.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f));
    });
    public static final Effect hitMeltdown = new Effect(12.0f, e -> {
        Draw.color(Pal.meltdownHit);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect hitMeltHeal = new Effect(12.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 6, e.finpow() * 18.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect instBomb = new Effect(15.0f, 100.0f, e -> {
        int i;
        Draw.color(Pal.bulletYellowBack);
        Lines.stroke(e.fout() * 4.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 20.0f);
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 6.0f, 80.0f * e.fout(), i * 90 + 45);
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri(e.x, e.y, 3.0f, 30.0f * e.fout(), i * 90 + 45);
        }
        Drawf.light(e.x, e.y, 150.0f, Pal.bulletYellowBack, 0.9f * e.fout());
    });
    public static final Effect instTrail = new Effect(30.0f, e -> {
        for (int i = 0; i < 2; ++i) {
            Draw.color(i == 0 ? Pal.bulletYellowBack : Pal.bulletYellow);
            float m = i == 0 ? 1.0f : 0.5f;
            float rot = e.rotation + 180.0f;
            float w = 15.0f * e.fout() * m;
            Drawf.tri(e.x, e.y, w, (30.0f + Mathf.randomSeedRange(e.id, 15.0f)) * m, rot);
            Drawf.tri(e.x, e.y, w, 10.0f * m, rot + 180.0f);
        }
        Drawf.light(e.x, e.y, 60.0f, Pal.bulletYellowBack, 0.6f * e.fout());
    });
    public static final Effect instShoot = new Effect(24.0f, e -> {
        e.scaled(10.0f, b -> {
            Draw.color(Color.white, Pal.bulletYellowBack, b.fin());
            Lines.stroke(b.fout() * 3.0f + 0.2f);
            Lines.circle(b.x, b.y, b.fin() * 50.0f);
        });
        Draw.color(Pal.bulletYellowBack);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 50.0f, e.rotation + 20.0f * (float)i);
        }
        Drawf.light(e.x, e.y, 180.0f, Pal.bulletYellowBack, 0.9f * e.fout());
    });
    public static final Effect instHit = new Effect(20.0f, 200.0f, e -> {
        Draw.color(Pal.bulletYellowBack);
        for (int i = 0; i < 2; ++i) {
            Draw.color(i == 0 ? Pal.bulletYellowBack : Pal.bulletYellow);
            float m = i == 0 ? 1.0f : 0.5f;
            for (int j = 0; j < 5; ++j) {
                float rot = e.rotation + Mathf.randomSeedRange(e.id + j, 50.0f);
                float w = 23.0f * e.fout() * m;
                Drawf.tri(e.x, e.y, w, (80.0f + Mathf.randomSeedRange(e.id + j, 40.0f)) * m, rot);
                Drawf.tri(e.x, e.y, w, 20.0f * m, rot + 180.0f);
            }
        }
        e.scaled(10.0f, c -> {
            Draw.color(Pal.bulletYellow);
            Lines.stroke(c.fout() * 2.0f + 0.2f);
            Lines.circle(e.x, e.y, c.fin() * 30.0f);
        });
        e.scaled(12.0f, c -> {
            Draw.color(Pal.bulletYellowBack);
            Angles.randLenVectors(e.id, 25, 5.0f + e.fin() * 80.0f, e.rotation, 60.0f, (x, y) -> Fill.square(e.x + x, e.y + y, c.fout() * 3.0f, 45.0f));
        });
    });
    public static final Effect hitLaser = new Effect(8.0f, e -> {
        Draw.color(Color.white, Pal.heal, e.fin());
        Lines.stroke(0.5f + e.fout());
        Lines.circle(e.x, e.y, e.fin() * 5.0f);
        Drawf.light(e.x, e.y, 23.0f, Pal.heal, e.fout() * 0.7f);
    });
    public static final Effect hitLaserColor = new Effect(8.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(0.5f + e.fout());
        Lines.circle(e.x, e.y, e.fin() * 5.0f);
        Drawf.light(e.x, e.y, 23.0f, e.color, e.fout() * 0.7f);
    });
    public static final Effect despawn = new Effect(12.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.gray, e.fin());
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id, 7, e.fin() * 7.0f, e.rotation, 40.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 2.0f + 1.0f);
        });
    });
    public static final Effect airBubble = new Effect(100.0f, e -> Angles.randLenVectors(e.id, 1, e.fin() * 12.0f, (x, y) -> Draw.rect(Vars.renderer.bubbles[Math.min((int)((float)Vars.renderer.bubbles.length * Mathf.curveMargin(e.fin(), 0.11f, 0.06f)), Vars.renderer.bubbles.length - 1)], e.x + x, e.y + y))).layer(91.0f);
    public static final Effect flakExplosion = new Effect(20.0f, e -> {
        Draw.color(Pal.bulletYellow);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 10.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 5, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.5f));
        Draw.color(Pal.lighterOrange);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
        Drawf.light(e.x, e.y, 50.0f, Pal.lighterOrange, 0.8f * e.fout());
    });
    public static final Effect plasticExplosion = new Effect(24.0f, e -> {
        Draw.color(Pal.plastaniumFront);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 24.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 7, 2.0f + 28.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.plastaniumBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 25.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
        Drawf.light(e.x, e.y, 50.0f, Pal.plastaniumBack, 0.8f * e.fout());
    });
    public static final Effect plasticExplosionFlak = new Effect(28.0f, e -> {
        Draw.color(Pal.plastaniumFront);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 34.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 7, 2.0f + 30.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.plastaniumBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 30.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect blastExplosion = new Effect(22.0f, e -> {
        Draw.color(Pal.missileYellow);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 15.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 5, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.missileYellowBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
        Drawf.light(e.x, e.y, 45.0f, Pal.missileYellowBack, 0.8f * e.fout());
    });
    public static final Effect sapExplosion = new Effect(25.0f, e -> {
        Draw.color(Pal.sapBullet);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 80.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 9, 2.0f + 70.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.sapBulletBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 8, 1.0f + 60.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
        Drawf.light(e.x, e.y, 90.0f, Pal.sapBulletBack, 0.8f * e.fout());
    });
    public static final Effect massiveExplosion = new Effect(30.0f, e -> {
        Draw.color(Pal.missileYellow);
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 4.0f + i.fin() * 30.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 8, 2.0f + 30.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.missileYellowBack);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 6, 1.0f + 29.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 4.0f));
        Drawf.light(e.x, e.y, 50.0f, Pal.missileYellowBack, 0.8f * e.fout());
    });
    public static final Effect artilleryTrail = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    }).layer(99.99f);
    public static final Effect incendTrail = new Effect(50.0f, e -> {
        Draw.color(Pal.lightOrange);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    });
    public static final Effect missileTrail = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    }).layer(99.999f);
    public static final Effect missileTrailShort = new Effect(22.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    }).layer(99.999f);
    public static final Effect colorTrail = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, e.rotation * e.fout());
    });
    public static final Effect absorb = new Effect(12.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(2.0f * e.fout());
        Lines.circle(e.x, e.y, 5.0f * e.fout());
    });
    public static final Effect forceShrink = new Effect(20.0f, e -> {
        Draw.color(e.color, e.fout());
        if (Vars.renderer.animateShields) {
            Fill.poly(e.x, e.y, 6, e.rotation * e.fout());
        } else {
            Lines.stroke(1.5f);
            Draw.alpha(0.09f);
            Fill.poly(e.x, e.y, 6, e.rotation * e.fout());
            Draw.alpha(1.0f);
            Lines.poly(e.x, e.y, 6, e.rotation * e.fout());
        }
    }).layer(125.0f);
    public static final Effect flakExplosionBig = new Effect(30.0f, e -> {
        Draw.color(Pal.bulletYellowBack);
        e.scaled(6.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 25.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 2.0f + 23.0f * e.finpow(), (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f + 0.5f));
        Draw.color(Pal.bulletYellow);
        Lines.stroke(e.fout());
        Angles.randLenVectors(e.id + 1, 4, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
        Drawf.light(e.x, e.y, 60.0f, Pal.bulletYellowBack, 0.7f * e.fout());
    });
    public static final Effect burning = new Effect(35.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 3, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.1f + e.fout() * 1.4f));
    });
    public static final Effect fireRemove = new Effect(70.0f, e -> {
        if (Fire.regions[0] == null) {
            return;
        }
        Draw.alpha(e.fout());
        Draw.rect(Fire.regions[(int)(e.rotation + e.fin() * 40.0f) % 40], e.x + Mathf.randomSeedRange((int)e.y, 2.0f), e.y + Mathf.randomSeedRange((int)e.x, 2.0f));
        Drawf.light(e.x, e.y, 50.0f + Mathf.absin(5.0f, 5.0f), Pal.lightFlame, 0.6f * e.fout());
    });
    public static final Effect fire = new Effect(50.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 9.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
        Draw.color();
        Drawf.light(e.x, e.y, 20.0f * e.fslope(), Pal.lightFlame, 0.5f);
    });
    public static final Effect fireHit = new Effect(35.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 3, 2.0f + e.fin() * 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.6f));
        Draw.color();
    });
    public static final Effect fireSmoke = new Effect(35.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 1, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
    });
    public static final Effect neoplasmHeal = new Effect(120.0f, e -> {
        Draw.color(Pal.neoplasm1, Pal.neoplasm2, e.fin());
        Angles.randLenVectors(e.id, 1, e.fin() * 3.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 2.0f));
    }).followParent(true).rotWithParent(true).layer(98.0f);
    public static final Effect steam = new Effect(35.0f, e -> {
        Draw.color(Color.lightGray);
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fslope() * 1.5f));
    });
    public static final Effect ventSteam = new Effect(140.0f, e -> {
        Draw.color(e.color, Pal.vent2, e.fin());
        Draw.alpha(e.fslope() * 0.78f);
        float length = 3.0f + e.finpow() * 10.0f;
        rand.setSeed(e.id);
        for (int i = 0; i < rand.random(3, 5); ++i) {
            v.trns(rand.random(360.0f), rand.random(length));
            Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, rand.random(1.2f, 3.5f) + e.fslope() * 1.1f);
        }
    }).layer(79.0f);
    public static final Effect drillSteam = new Effect(220.0f, e -> {
        float length = 3.0f + e.finpow() * 20.0f;
        rand.setSeed(e.id);
        for (int i = 0; i < 13; ++i) {
            v.trns(rand.random(360.0f), rand.random(length));
            float sizer = rand.random(1.3f, 3.7f);
            e.scaled(e.lifetime * rand.random(0.5f, 1.0f), b -> {
                Draw.color(Color.gray, b.fslope() * 0.93f);
                Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, sizer + b.fslope() * 1.2f);
            });
        }
    }).startDelay(30.0f);
    public static final Effect fluxVapor = new Effect(140.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout() * 0.7f);
        Angles.randLenVectors(e.id, 2, 3.0f + e.finpow() * 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.6f + e.fin() * 5.0f));
    }).layer(99.0f);
    public static final Effect corrosionVapor = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(Interp.pow2Out.apply(e.fslope()) * 0.5f);
        Angles.randLenVectors(e.id, 2, 8.0f + e.finpow() * 3.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 3.0f));
    });
    public static final Effect vapor = new Effect(110.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout());
        Angles.randLenVectors(e.id, 3, 2.0f + e.finpow() * 11.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.6f + e.fin() * 5.0f));
    });
    public static final Effect vaporSmall = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout());
        Angles.randLenVectors(e.id, 4, 2.0f + e.finpow() * 5.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 1.0f + e.fin() * 4.0f));
    });
    public static final Effect fireballsmoke = new Effect(25.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 1, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.5f));
    });
    public static final Effect ballfire = new Effect(25.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, e.fin());
        Angles.randLenVectors(e.id, 2, 2.0f + e.fin() * 7.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.5f));
    });
    public static final Effect freezing = new Effect(40.0f, e -> {
        Draw.color(Liquids.cryofluid.color);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 1.2f));
    });
    public static final Effect melting = new Effect(40.0f, e -> {
        Draw.color(Liquids.slag.color, Color.white, e.fout() / 5.0f + Mathf.randomSeedRange(e.id, 0.12f));
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 3.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.2f + e.fout() * 1.2f));
    });
    public static final Effect wet = new Effect(80.0f, e -> {
        Draw.color(Liquids.water.color);
        Draw.alpha(Mathf.clamp(e.fin() * 2.0f));
        Fill.circle(e.x, e.y, e.fout());
    });
    public static final Effect muddy = new Effect(80.0f, e -> {
        Draw.color(Pal.muddy);
        Draw.alpha(Mathf.clamp(e.fin() * 2.0f));
        Fill.circle(e.x, e.y, e.fout());
    });
    public static final Effect sapped = new Effect(40.0f, e -> {
        Draw.color(Pal.sap);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fslope() * 1.1f, 45.0f));
    });
    public static final Effect electrified = new Effect(40.0f, e -> {
        Draw.color(Pal.heal);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fslope() * 1.1f, 45.0f));
    });
    public static final Effect sporeSlowed = new Effect(40.0f, e -> {
        Draw.color(Pal.spore);
        Fill.circle(e.x, e.y, e.fslope() * 1.1f);
    });
    public static final Effect oily = new Effect(42.0f, e -> {
        Draw.color(Liquids.oil.color);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout()));
    });
    public static final Effect overdriven = new Effect(20.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 2, 1.0f + e.fin() * 2.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.3f + 0.5f));
    });
    public static final Effect overclocked = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Fill.square(e.x, e.y, e.fslope() * 2.0f, 45.0f);
    });
    public static final Effect dropItem = new Effect(20.0f, e -> {
        float length = 20.0f * e.finpow();
        float size = 7.0f * e.fout();
        Object patt48322$temp = e.data;
        if (!(patt48322$temp instanceof Item)) {
            return;
        }
        Item item = (Item)patt48322$temp;
        Draw.rect(item.fullIcon, e.x + Angles.trnsx(e.rotation, length), e.y + Angles.trnsy(e.rotation, length), size, size);
    });
    public static final Effect shockwave = new Effect(10.0f, 80.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 2.0f + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 28.0f);
    });
    public static final Effect bigShockwave = new Effect(10.0f, 80.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 3.0f);
        Lines.circle(e.x, e.y, e.fin() * 50.0f);
    });
    public static final Effect spawnShockwave = new Effect(20.0f, 400.0f, e -> {
        Draw.color(Color.white, Color.lightGray, e.fin());
        Lines.stroke(e.fout() * 3.0f + 0.5f);
        Lines.circle(e.x, e.y, e.fin() * (e.rotation + 50.0f));
    });
    public static final Effect podLandShockwave = new Effect(12.0f, 80.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(e.fout() * 2.0f + 0.2f);
        Lines.circle(e.x, e.y, e.fin() * 26.0f);
    });
    public static final Effect explosion = new Effect(30.0f, e -> {
        e.scaled(7.0f, i -> {
            Lines.stroke(3.0f * i.fout());
            Lines.circle(e.x, e.y, 3.0f + i.fin() * 10.0f);
        });
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 2.0f + 19.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f + 0.5f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
        Draw.color(Pal.lighterOrange, Pal.lightOrange, Color.gray, e.fin());
        Lines.stroke(1.5f * e.fout());
        Angles.randLenVectors(e.id + 1, 8, 1.0f + 23.0f * e.finpow(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + e.fout() * 3.0f));
    });
    public static final Effect dynamicExplosion = new Effect(30.0f, 500.0f, b -> {
        float intensity = b.rotation;
        float baseLifetime = 26.0f + intensity * 15.0f;
        b.lifetime = 43.0f + intensity * 35.0f;
        Draw.color(Color.gray);
        Draw.alpha(0.9f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.4f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(3.0f * intensity), 14.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                Fill.circle(e.x + x, e.y + y, fout * ((2.0f + intensity) * 1.8f));
            }));
        }
        b.scaled(baseLifetime, e -> {
            e.scaled(5.0f + intensity * 2.5f, i -> {
                Lines.stroke((3.1f + intensity / 5.0f) * i.fout());
                Lines.circle(e.x, e.y, (3.0f + i.fin() * 14.0f) * intensity);
                Drawf.light(e.x, e.y, i.fin() * 14.0f * 2.0f * intensity, Color.white, 0.9f * e.fout());
            });
            Draw.color(Pal.lighterOrange, Pal.lightOrange, Color.gray, e.fin());
            Lines.stroke(1.7f * e.fout() * (1.0f + (intensity - 1.0f) / 2.0f));
            Draw.z(110.001f);
            Angles.randLenVectors((long)(e.id + 1), e.finpow() + 0.001f, (int)(9.0f * intensity), 40.0f * intensity, (x, y, in, out) -> {
                Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + out * 4.0f * (3.0f + intensity));
                Drawf.light(e.x + x, e.y + y, out * 4.0f * (3.0f + intensity) * 3.5f, Draw.getColor(), 0.8f);
            });
        });
    });
    public static final Effect reactorExplosion = new Effect(30.0f, 500.0f, b -> {
        float intensity = 6.8f;
        float baseLifetime = 25.0f + intensity * 11.0f;
        b.lifetime = 50.0f + intensity * 65.0f;
        Draw.color(Pal.reactorPurple2);
        Draw.alpha(0.7f);
        int i = 0;
        while (i < 4) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.4f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.9f * intensity), 22.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.5f, Pal.reactorPurple, 0.5f);
            }));
        }
        b.scaled(baseLifetime, e -> {
            Draw.color();
            e.scaled(5.0f + intensity * 2.0f, i -> {
                Lines.stroke((3.1f + intensity / 5.0f) * i.fout());
                Lines.circle(e.x, e.y, (3.0f + i.fin() * 14.0f) * intensity);
                Drawf.light(e.x, e.y, i.fin() * 14.0f * 2.0f * intensity, Color.white, 0.9f * e.fout());
            });
            Draw.color(Pal.lighterOrange, Pal.reactorPurple, e.fin());
            Lines.stroke(2.0f * e.fout());
            Draw.z(110.001f);
            Angles.randLenVectors((long)(e.id + 1), e.finpow() + 0.001f, (int)(8.0f * intensity), 28.0f * intensity, (x, y, in, out) -> {
                Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + out * 4.0f * (4.0f + intensity));
                Drawf.light(e.x + x, e.y + y, out * 4.0f * (3.0f + intensity) * 3.5f, Draw.getColor(), 0.8f);
            });
        });
    });
    public static final Effect impactReactorExplosion = new Effect(30.0f, 500.0f, b -> {
        float intensity = 8.0f;
        float baseLifetime = 25.0f + intensity * 15.0f;
        b.lifetime = 50.0f + intensity * 64.0f;
        Draw.color(Pal.lighterOrange);
        Draw.alpha(0.8f);
        int i = 0;
        while (i < 5) {
            rand.setSeed(b.id * 2 + i);
            float lenScl = rand.random(0.25f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), e.fin(Interp.pow10Out), (int)(2.8f * intensity), 25.0f * intensity, (x, y, in, out) -> {
                float fout = e.fout(Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle(e.x + x, e.y + y, rad);
                Drawf.light(e.x + x, e.y + y, rad * 2.6f, Pal.lighterOrange, 0.7f);
            }));
        }
        b.scaled(baseLifetime, e -> {
            Draw.color();
            e.scaled(5.0f + intensity * 2.0f, i -> {
                Lines.stroke((3.1f + intensity / 5.0f) * i.fout());
                Lines.circle(e.x, e.y, (3.0f + i.fin() * 14.0f) * intensity);
                Drawf.light(e.x, e.y, i.fin() * 14.0f * 2.0f * intensity, Color.white, 0.9f * e.fout());
            });
            Draw.color(Color.white, Pal.lighterOrange, e.fin());
            Lines.stroke(2.0f * e.fout());
            Draw.z(110.001f);
            Angles.randLenVectors((long)(e.id + 1), e.finpow() + 0.001f, (int)(8.0f * intensity), 30.0f * intensity, (x, y, in, out) -> {
                Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), 1.0f + out * 4.0f * (4.0f + intensity));
                Drawf.light(e.x + x, e.y + y, out * 4.0f * (3.0f + intensity) * 3.5f, Draw.getColor(), 0.8f);
            });
        });
    });
    public static final Effect blockExplosionSmoke = new Effect(30.0f, e -> {
        Draw.color(Color.gray);
        Angles.randLenVectors(e.id, 6, 4.0f + 30.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
    });
    public static final Effect steamCoolSmoke = new Effect(35.0f, e -> {
        Draw.color(Pal.water, Color.lightGray, e.fin(Interp.pow2Out));
        Draw.alpha(e.fout(Interp.pow3Out));
        Angles.randLenVectors(e.id, 4, e.finpow() * 7.0f, e.rotation, 30.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, Math.max(e.fout(), Math.min(1.0f, e.fin() * 8.0f)) * 2.8f));
    });
    public static final Effect smokePuff = new Effect(30.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 6, 4.0f + 30.0f * e.finpow(), (x, y) -> {
            Fill.circle(e.x + x, e.y + y, e.fout() * 3.0f);
            Fill.circle(e.x + x / 2.0f, e.y + y / 2.0f, e.fout());
        });
    });
    public static final Effect shootSmall = new Effect(8.0f, e -> {
        Draw.color(Pal.lighterOrange, Pal.lightOrange, e.fin());
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 15.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 3.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootSmallColor = new Effect(8.0f, e -> {
        Draw.color(e.color, Color.gray, e.fin());
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 15.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 3.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootHeal = new Effect(8.0f, e -> {
        Draw.color(Pal.heal);
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 17.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootHealYellow = new Effect(8.0f, e -> {
        Draw.color(Pal.lightTrail);
        float w = 1.0f + 5.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 17.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootSmallSmoke = new Effect(20.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 5, e.finpow() * 6.0f, e.rotation, 20.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 1.5f));
    });
    public static final Effect shootBig = new Effect(9.0f, e -> {
        Draw.color(Pal.lighterOrange, Pal.lightOrange, e.fin());
        float w = 1.2f + 7.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 25.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 4.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootBig2 = new Effect(10.0f, e -> {
        Draw.color(Pal.lightOrange, Color.gray, e.fin());
        float w = 1.2f + 8.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 29.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 5.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootBigColor = new Effect(11.0f, e -> {
        Draw.color(e.color, Color.gray, e.fin());
        float w = 1.2f + 9.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 32.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 3.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootTitan = new Effect(10.0f, e -> {
        Draw.color(Pal.lightOrange, e.color, e.fin());
        float w = 1.3f + 10.0f * e.fout();
        Drawf.tri(e.x, e.y, w, 35.0f * e.fout(), e.rotation);
        Drawf.tri(e.x, e.y, w, 6.0f * e.fout(), e.rotation + 180.0f);
    });
    public static final Effect shootBigSmoke = new Effect(17.0f, e -> {
        Draw.color(Pal.lighterOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 8, e.finpow() * 19.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f + 0.2f));
    });
    public static final Effect shootBigSmoke2 = new Effect(18.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 9, e.finpow() * 23.0f, e.rotation, 20.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.4f + 0.2f));
    });
    public static final Effect shootSmokeDisperse = new Effect(25.0f, e -> {
        Draw.color(Pal.lightOrange, Color.white, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 9, e.finpow() * 29.0f, e.rotation, 18.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 2.2f + 0.1f));
    });
    public static final Effect shootSmokeSquare = new Effect(20.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        rand.setSeed(e.id);
        for (int i = 0; i < 6; ++i) {
            float rot = e.rotation + rand.range(22.0f);
            v.trns(rot, rand.random(e.finpow() * 21.0f));
            Fill.poly(e.x + Fx.v.x, e.y + Fx.v.y, 4, e.fout() * 2.0f + 0.2f, rand.random(360.0f));
        }
    });
    public static final Effect shootSmokeSquareSparse = new Effect(30.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        rand.setSeed(e.id);
        for (int i = 0; i < 2; ++i) {
            float rot = e.rotation + rand.range(30.0f);
            v.trns(rot, rand.random(e.finpow() * 27.0f));
            Fill.poly(e.x + Fx.v.x, e.y + Fx.v.y, 4, e.fout() * 3.8f + 0.2f, rand.random(360.0f));
        }
    });
    public static final Effect shootSmokeSquareBig = new Effect(32.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        rand.setSeed(e.id);
        for (int i = 0; i < 13; ++i) {
            float rot = e.rotation + rand.range(26.0f);
            v.trns(rot, rand.random(e.finpow() * 30.0f));
            Fill.poly(e.x + Fx.v.x, e.y + Fx.v.y, 4, e.fout() * 4.0f + 0.2f, rand.random(360.0f));
        }
    });
    public static final Effect shootSmokeTitan = new Effect(70.0f, e -> {
        rand.setSeed(e.id);
        for (int i = 0; i < 13; ++i) {
            v.trns(e.rotation + rand.range(30.0f), rand.random(e.finpow() * 40.0f));
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                Draw.color(e.color, Pal.lightishGray, b.fin());
                Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, b.fout() * 3.4f + 0.3f);
            });
        }
    });
    public static final Effect shootSmokeSmite = new Effect(70.0f, e -> {
        rand.setSeed(e.id);
        for (int i = 0; i < 13; ++i) {
            float a = e.rotation + rand.range(30.0f);
            v.trns(a, rand.random(e.finpow() * 50.0f));
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                Draw.color(e.color);
                Lines.stroke(b.fout() * 3.0f + 0.5f);
                Lines.lineAngle(e.x + Fx.v.x, e.y + Fx.v.y, a, b.fout() * 8.0f + 0.4f);
            });
        }
    });
    public static final Effect shootSmokeMissile = new Effect(130.0f, 300.0f, e -> {
        Draw.color(Pal.redLight);
        Draw.alpha(0.5f);
        rand.setSeed(e.id);
        for (int i = 0; i < 35; ++i) {
            v.trns(e.rotation + 180.0f + rand.range(21.0f), rand.random(e.finpow() * 90.0f)).add(rand.range(3.0f), rand.range(3.0f));
            e.scaled(e.lifetime * rand.random(0.2f, 1.0f), b -> Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, b.fout() * 9.0f + 0.3f));
        }
    });
    public static final Effect shootSmokeMissileColor = new Effect(130.0f, 300.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(0.5f);
        rand.setSeed(e.id);
        for (int i = 0; i < 35; ++i) {
            v.trns(e.rotation + 180.0f + rand.range(21.0f), rand.random(e.finpow() * 90.0f)).add(rand.range(3.0f), rand.range(3.0f));
            e.scaled(e.lifetime * rand.random(0.2f, 1.0f), b -> Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, b.fout() * 9.0f + 0.3f));
        }
    });
    public static final Effect regenParticle = new Effect(100.0f, e -> {
        Draw.color(Pal.regen);
        Fill.square(e.x, e.y, e.fslope() * 1.5f + 0.14f, 45.0f);
    });
    public static final Effect regenSuppressParticle = new Effect(35.0f, e -> {
        Draw.color(e.color, Color.white, e.fin());
        Lines.stroke(e.fout() * 1.4f + 0.5f);
        Angles.randLenVectors(e.id, 4, 17.0f * e.fin(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 3.0f + 0.5f));
    });
    public static final Effect regenSuppressSeek = new Effect(140.0f, e -> {
        e.lifetime = Mathf.randomSeed((long)e.id, 120.0f, 200.0f);
        Object patt62818$temp = e.data;
        if (!(patt62818$temp instanceof Position)) {
            return;
        }
        Position to = (Position)patt62818$temp;
        Tmp.v2.set(to).sub(e.x, e.y).nor().rotate90(1).scl(Mathf.randomSeedRange(e.id, 1.0f) * 50.0f);
        Tmp.bz2.set(Tmp.v1.set(e.x, e.y), Tmp.v2.add(e.x, e.y), Tmp.v3.set(to));
        Tmp.bz2.valueAt(Tmp.v4, e.fout());
        Draw.color(e.color);
        Fill.circle(Tmp.v4.x, Tmp.v4.y, e.fslope() * 2.0f + 0.1f);
    }).followParent(false).rotWithParent(false);
    public static final Effect surgeCruciSmoke = new Effect(160.0f, e -> {
        Draw.color(Pal.slagOrange);
        Draw.alpha(0.6f);
        rand.setSeed(e.id);
        for (int i = 0; i < 3; ++i) {
            float len = rand.random(6.0f);
            float rot = rand.range(40.0f) + e.rotation;
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                v.trns(rot, len * b.finpow());
                Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, 2.0f * b.fslope() + 0.2f);
            });
        }
    });
    public static final Effect neoplasiaSmoke = new Effect(280.0f, e -> {
        Draw.color(Pal.neoplasmMid);
        Draw.alpha(0.6f);
        rand.setSeed(e.id);
        for (int i = 0; i < 6; ++i) {
            float len = rand.random(10.0f);
            float rot = rand.range(120.0f) + e.rotation;
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                v.trns(rot, len * b.finpow());
                Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, 3.3f * b.fslope() + 0.2f);
            });
        }
    });
    public static final Effect heatReactorSmoke = new Effect(180.0f, e -> {
        Draw.color(Color.gray);
        rand.setSeed(e.id);
        for (int i = 0; i < 5; ++i) {
            float len = rand.random(6.0f);
            float rot = rand.range(50.0f) + e.rotation;
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                Draw.alpha(0.9f * b.fout());
                v.trns(rot, len * b.finpow());
                Fill.circle(e.x + Fx.v.x, e.y + Fx.v.y, 2.4f * b.fin() + 0.6f);
            });
        }
    });
    public static final Effect circleColorSpark = new Effect(21.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.1f + 0.5f);
        Angles.randLenVectors((long)e.id, 9, 27.0f * e.fin(), 9.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 5.0f + 0.5f));
    });
    public static final Effect colorSpark = new Effect(21.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.1f + 0.5f);
        Angles.randLenVectors(e.id, 5, 27.0f * e.fin(), e.rotation, 9.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 5.0f + 0.5f));
    });
    public static final Effect colorSparkBig = new Effect(25.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.3f + 0.7f);
        Angles.randLenVectors(e.id, 8, 41.0f * e.fin(), e.rotation, 10.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 6.0f + 0.5f));
    });
    public static final Effect randLifeSpark = new Effect(24.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.5f + 0.5f);
        rand.setSeed(e.id);
        for (int i = 0; i < 15; ++i) {
            float ang = e.rotation + rand.range(9.0f);
            float len = rand.random(90.0f * e.finpow());
            e.scaled(e.lifetime * rand.random(0.5f, 1.0f), p -> {
                v.trns(ang, len);
                Lines.lineAngle(e.x + Fx.v.x, e.y + Fx.v.y, ang, p.fout() * 7.0f + 0.5f);
            });
        }
    });
    public static final Effect shootPayloadDriver = new Effect(30.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(0.5f + 0.5f * e.fout());
        float spread = 9.0f;
        rand.setSeed(e.id);
        for (int i = 0; i < 20; ++i) {
            float ang = e.rotation + rand.range(17.0f);
            v.trns(ang, rand.random(e.fin() * 55.0f));
            Lines.lineAngle(e.x + Fx.v.x + rand.range(spread), e.y + Fx.v.y + rand.range(spread), ang, e.fout() * 5.0f * rand.random(1.0f) + 1.0f);
        }
    });
    public static final Effect shootSmallFlame = new Effect(32.0f, 80.0f, e -> {
        Draw.color(Pal.lightFlame, Pal.darkFlame, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 8, e.finpow() * 60.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.65f + e.fout() * 1.5f));
    });
    public static final Effect shootPyraFlame = new Effect(33.0f, 80.0f, e -> {
        Draw.color(Pal.lightPyraFlame, Pal.darkPyraFlame, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 10, e.finpow() * 70.0f, e.rotation, 10.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.65f + e.fout() * 1.6f));
    });
    public static final Effect shootLiquid = new Effect(15.0f, 80.0f, e -> {
        Draw.color(e.color);
        Angles.randLenVectors(e.id, 2, e.finpow() * 15.0f, e.rotation, 11.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, 0.5f + e.fout() * 2.5f));
    });
    public static final Effect casing1 = new Effect(30.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.3f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (2.0f + e.finpow() * 6.0f) * (float)i;
        float lr = rot + e.fin() * 30.0f * (float)i;
        Fill.rect(e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 1.0f, 2.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing2 = new Effect(34.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (2.0f + e.finpow() * 10.0f) * (float)i;
        float lr = rot + e.fin() * 20.0f * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.0f, 3.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing3 = new Effect(40.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (4.0f + e.finpow() * 9.0f) * (float)i;
        float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.5f, 4.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing4 = new Effect(45.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        int i = -Mathf.sign(e.rotation);
        float len = (4.0f + e.finpow() * 9.0f) * (float)i;
        float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
        Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 3.0f, 6.0f, rot + e.fin() * 50.0f * (float)i);
    }).layer(100.0f);
    public static final Effect casing2Double = new Effect(34.0f, e -> {
        Draw.color(Pal.lightOrange, Color.lightGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        for (int i : Mathf.signs) {
            float len = (2.0f + e.finpow() * 10.0f) * (float)i;
            float lr = rot + e.fin() * 20.0f * (float)i;
            Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.0f, 3.0f, rot + e.fin() * 50.0f * (float)i);
        }
    }).layer(100.0f);
    public static final Effect casing3Double = new Effect(40.0f, e -> {
        Draw.color(Pal.lightOrange, Pal.lightishGray, Pal.lightishGray, e.fin());
        Draw.alpha(e.fout(0.5f));
        float rot = Math.abs(e.rotation) + 90.0f;
        for (int i : Mathf.signs) {
            float len = (4.0f + e.finpow() * 9.0f) * (float)i;
            float lr = rot + Mathf.randomSeedRange(e.id + i + 6, 20.0f * e.fin()) * (float)i;
            Draw.rect(Core.atlas.find("casing"), e.x + Angles.trnsx(lr, len) + Mathf.randomSeedRange(e.id + i + 7, 3.0f * e.fin()), e.y + Angles.trnsy(lr, len) + Mathf.randomSeedRange(e.id + i + 8, 3.0f * e.fin()), 2.5f, 4.0f, rot + e.fin() * 50.0f * (float)i);
        }
    }).layer(100.0f);
    public static final Effect railShoot = new Effect(24.0f, e -> {
        e.scaled(10.0f, b -> {
            Draw.color(Color.white, Color.lightGray, b.fin());
            Lines.stroke(b.fout() * 3.0f + 0.2f);
            Lines.circle(b.x, b.y, b.fin() * 50.0f);
        });
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 13.0f * e.fout(), 85.0f, e.rotation + 90.0f * (float)i);
        }
    });
    public static final Effect railTrail = new Effect(16.0f, e -> {
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 10.0f * e.fout(), 24.0f, e.rotation + 90.0f + 90.0f * (float)i);
        }
        Drawf.light(e.x, e.y, 60.0f * e.fout(), Pal.orangeSpark, 0.5f);
    });
    public static final Effect railHit = new Effect(18.0f, 200.0f, e -> {
        Draw.color(Pal.orangeSpark);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 10.0f * e.fout(), 60.0f, e.rotation + 140.0f * (float)i);
        }
    });
    public static final Effect lancerLaserShoot = new Effect(21.0f, e -> {
        Draw.color(Pal.lancerLaser);
        for (int i : Mathf.signs) {
            Drawf.tri(e.x, e.y, 4.0f * e.fout(), 29.0f, e.rotation + 90.0f * (float)i);
        }
    });
    public static final Effect lancerLaserShootSmoke = new Effect(26.0f, e -> {
        Draw.color(Color.white);
        float length = !(e.data instanceof Float) ? 70.0f : ((Float)e.data).floatValue();
        Angles.randLenVectors(e.id, 7, length, e.rotation, 0.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fout() * 9.0f));
    });
    public static final Effect lancerLaserCharge = new Effect(38.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Angles.randLenVectors(e.id, 14, 1.0f + 20.0f * e.fout(), e.rotation, 120.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 3.0f + 1.0f));
    });
    public static final Effect lancerLaserChargeBegin = new Effect(60.0f, e -> {
        float margin = 1.0f - Mathf.curve(e.fin(), 0.9f);
        float fin = Math.min(margin, e.fin());
        Draw.color(Pal.lancerLaser);
        Fill.circle(e.x, e.y, fin * 3.0f);
        Draw.color();
        Fill.circle(e.x, e.y, fin * 2.0f);
    });
    public static final Effect lightningCharge = new Effect(38.0f, e -> {
        Draw.color(Pal.lancerLaser);
        Angles.randLenVectors(e.id, 2, 1.0f + 20.0f * e.fout(), e.rotation, 120.0f, (x, y) -> Drawf.tri(e.x + x, e.y + y, e.fslope() * 3.0f + 1.0f, e.fslope() * 3.0f + 1.0f, Mathf.angle(x, y)));
    });
    public static final Effect sparkShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, e.color, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.6f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 3.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 5.0f + 0.5f));
    });
    public static final Effect lightningShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, Pal.lancerLaser, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.5f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 50.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 5.0f + 2.0f));
    });
    public static final Effect thoriumShoot = new Effect(12.0f, e -> {
        Draw.color(Color.white, Pal.thoriumPink, e.fin());
        Lines.stroke(e.fout() * 1.2f + 0.5f);
        Angles.randLenVectors(e.id, 7, 25.0f * e.finpow(), e.rotation, 50.0f, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 5.0f + 2.0f));
    });
    public static final Effect reactorsmoke = new Effect(17.0f, e -> Angles.randLenVectors(e.id, 4, e.fin() * 8.0f, (x, y) -> {
        float size = 1.0f + e.fout() * 5.0f;
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect redgeneratespark = new Effect(90.0f, e -> {
        Draw.color(Pal.redSpark);
        Draw.alpha(e.fslope());
        rand.setSeed(e.id);
        for (int i = 0; i < 2; ++i) {
            v.trns(rand.random(360.0f), rand.random(e.finpow() * 9.0f)).add(e.x, e.y);
            Fill.circle(Fx.v.x, Fx.v.y, rand.random(1.4f, 2.4f));
        }
    }).layer(99.0f);
    public static final Effect turbinegenerate = new Effect(100.0f, e -> {
        Draw.color(Pal.vent);
        Draw.alpha(e.fslope() * 0.8f);
        rand.setSeed(e.id);
        for (int i = 0; i < 3; ++i) {
            v.trns(rand.random(360.0f), rand.random(e.finpow() * 14.0f)).add(e.x, e.y);
            Fill.circle(Fx.v.x, Fx.v.y, rand.random(1.4f, 3.4f));
        }
    }).layer(99.0f);
    public static final Effect generatespark = new Effect(18.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.orangeSpark, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, e.fout() * 4.0f / 2.0f);
    }));
    public static final Effect fuelburn = new Effect(23.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 9.0f, (x, y) -> {
        Draw.color(Color.lightGray, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, e.fout() * 2.0f);
    }));
    public static final Effect incinerateSlag = new Effect(34.0f, e -> Angles.randLenVectors(e.id, 4, e.finpow() * 5.0f, (x, y) -> {
        Draw.color(Pal.slagOrange, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, e.fout() * 1.7f);
    }));
    public static final Effect coreBurn = new Effect(23.0f, e -> Angles.randLenVectors(e.id, 5, e.fin() * 9.0f, (x, y) -> {
        float len = e.fout() * 4.0f;
        Draw.color(Pal.accent, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, len / 2.0f);
    }));
    public static final Effect plasticburn = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 5.0f, (x, y) -> {
        Draw.color(Pal.plasticBurn, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, e.fout());
    }));
    public static final Effect conveyorPoof = new Effect(35.0f, e -> {
        Draw.color(Pal.plasticBurn, Color.gray, e.fin());
        Angles.randLenVectors(e.id, 4, 3.0f + e.fin() * 4.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() * 1.11f));
    });
    public static final Effect pulverize = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeRed = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.redDust, Pal.stoneGray, e.fin());
        Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeSmall = new Effect(30.0f, e -> Angles.randLenVectors(e.id, 3, e.fin() * 5.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() + 0.5f, 45.0f);
    }));
    public static final Effect pulverizeMedium = new Effect(30.0f, e -> Angles.randLenVectors(e.id, 5, 3.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.stoneGray);
        Fill.square(e.x + x, e.y + y, e.fout() + 0.5f, 45.0f);
    }));
    public static final Effect producesmoke = new Effect(12.0f, e -> Angles.randLenVectors(e.id, 8, 4.0f + e.fin() * 18.0f, (x, y) -> {
        Draw.color(Color.white, Pal.accent, e.fin());
        Fill.square(e.x + x, e.y + y, 1.0f + e.fout() * 3.0f, 45.0f);
    }));
    public static final Effect artilleryTrailSmoke = new Effect(50.0f, e -> {
        Draw.color(e.color);
        rand.setSeed(e.id);
        for (int i = 0; i < 13; ++i) {
            float fin = e.fin() / rand.random(0.5f, 1.0f);
            float fout = 1.0f - fin;
            float angle = rand.random(360.0f);
            float len = rand.random(0.5f, 1.0f);
            if (!(fin <= 1.0f)) continue;
            Tmp.v1.trns(angle, fin * 24.0f * len);
            Draw.alpha((0.5f - Math.abs(fin - 0.5f)) * 2.0f);
            Fill.circle(e.x + Tmp.v1.x, e.y + Tmp.v1.y, 0.5f + fout * 4.0f);
        }
    });
    public static final Effect smokeCloud = new Effect(70.0f, e -> Angles.randLenVectors((long)e.id, e.fin(), 30, 30.0f, (x, y, fin, fout) -> {
        Draw.color(Color.gray);
        Draw.alpha((0.5f - Math.abs(fin - 0.5f)) * 2.0f);
        Fill.circle(e.x + x, e.y + y, 0.5f + fout * 4.0f);
    }));
    public static final Effect smeltsmoke = new Effect(15.0f, e -> Angles.randLenVectors(e.id, 6, 4.0f + e.fin() * 5.0f, (x, y) -> {
        Draw.color(Color.white, e.color, e.fin());
        Fill.square(e.x + x, e.y + y, 0.5f + e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect coalSmeltsmoke = new Effect(40.0f, e -> Angles.randLenVectors((long)e.id, 0.2f + e.fin(), 4, 6.3f, (x, y, fin, out) -> {
        Draw.color(Color.darkGray, Pal.coalBlack, e.finpowdown());
        Fill.circle(e.x + x, e.y + y, out * 2.0f + 0.35f);
    }));
    public static final Effect formsmoke = new Effect(40.0f, e -> Angles.randLenVectors(e.id, 6, 5.0f + e.fin() * 8.0f, (x, y) -> {
        Draw.color(Pal.plasticSmoke, Color.lightGray, e.fin());
        Fill.square(e.x + x, e.y + y, 0.2f + e.fout() * 2.0f, 45.0f);
    }));
    public static final Effect blastsmoke = new Effect(26.0f, e -> Angles.randLenVectors(e.id, 12, 1.0f + e.fin() * 23.0f, (x, y) -> {
        float size = 2.0f + e.fout() * 6.0f;
        Draw.color(Color.lightGray, Color.darkGray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect lava = new Effect(18.0f, e -> Angles.randLenVectors(e.id, 3, 1.0f + e.fin() * 10.0f, (x, y) -> {
        float size = e.fslope() * 4.0f;
        Draw.color(Color.orange, Color.gray, e.fin());
        Fill.circle(e.x + x, e.y + y, size / 2.0f);
    }));
    public static final Effect dooropen = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, e.rotation * 8.0f / 2.0f + e.fin() * 2.0f);
    });
    public static final Effect doorclose = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, e.rotation * 8.0f / 2.0f + e.fout() * 2.0f);
    });
    public static final Effect dooropenlarge = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 8.0f + e.fin() * 2.0f);
    });
    public static final Effect doorcloselarge = new Effect(10.0f, e -> {
        Lines.stroke(e.fout() * 1.6f);
        Lines.square(e.x, e.y, 8.0f + e.fout() * 2.0f);
    });
    public static final Effect generate = new Effect(11.0f, e -> {
        Draw.color(Color.orange, Color.yellow, e.fin());
        Lines.stroke(1.0f);
        Lines.spikes(e.x, e.y, e.fin() * 5.0f, 2.0f, 8);
    });
    public static final Effect mineWallSmall = new Effect(50.0f, e -> {
        Draw.color(e.color, Color.darkGray, e.fin());
        Angles.randLenVectors(e.id, 2, e.fin() * 6.0f, (x, y) -> Fill.circle(e.x + x, e.y + y, e.fout() + 0.5f));
    });
    public static final Effect mineSmall = new Effect(30.0f, e -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Angles.randLenVectors(e.id, 3, e.fin() * 5.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() + 0.5f, 45.0f));
    });
    public static final Effect mine = new Effect(20.0f, e -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Angles.randLenVectors(e.id, 6, 3.0f + e.fin() * 6.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.0f, 45.0f));
    });
    public static final Effect mineBig = new Effect(30.0f, e -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Angles.randLenVectors(e.id, 6, 4.0f + e.fin() * 8.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.2f, 45.0f));
    });
    public static final Effect mineHuge = new Effect(40.0f, e -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Angles.randLenVectors(e.id, 8, 5.0f + e.fin() * 10.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.0f + 0.5f, 45.0f));
    });
    public static final Effect mineImpact = new Effect(90.0f, e -> {
        Draw.color(e.color, Color.lightGray, e.fin());
        Angles.randLenVectors(e.id, 12, 5.0f + e.finpow() * 22.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.5f + 0.5f, 45.0f));
    });
    public static final Effect mineImpactWave = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 1.5f);
        Angles.randLenVectors(e.id, 12, 4.0f + e.finpow() * e.rotation, (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fout() * 5.0f + 1.0f));
        e.scaled(30.0f, b -> {
            Lines.stroke(5.0f * b.fout());
            Lines.circle(e.x, e.y, b.finpow() * 28.0f);
        });
    });
    public static final Effect payloadReceive = new Effect(30.0f, e -> {
        Draw.color(Color.white, Pal.accent, e.fin());
        Angles.randLenVectors(e.id, 12, 7.0f + e.fin() * 13.0f, (x, y) -> Fill.square(e.x + x, e.y + y, e.fout() * 2.1f + 0.5f, 45.0f));
    });
    public static final Effect teleportActivate = new Effect(50.0f, e -> {
        Draw.color(e.color);
        e.scaled(8.0f, e2 -> {
            Lines.stroke(e2.fout() * 4.0f);
            Lines.circle(e2.x, e2.y, 4.0f + e2.fin() * 27.0f);
        });
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 30, 4.0f + 40.0f * e.fin(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 4.0f + 1.0f));
    });
    public static final Effect teleport = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fin() * 2.0f);
        Lines.circle(e.x, e.y, 7.0f + e.fout() * 8.0f);
        Angles.randLenVectors(e.id, 20, 6.0f + 20.0f * e.fout(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fin() * 4.0f + 1.0f));
    });
    public static final Effect teleportOut = new Effect(20.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 7.0f + e.fin() * 8.0f);
        Angles.randLenVectors(e.id, 20, 4.0f + 20.0f * e.fin(), (x, y) -> Lines.lineAngle(e.x + x, e.y + y, Mathf.angle(x, y), e.fslope() * 4.0f + 1.0f));
    });
    public static final Effect ripple = new Effect(30.0f, e -> {
        e.lifetime = 30.0f * e.rotation;
        Draw.color(Tmp.c1.set(e.color).mul(1.5f));
        Lines.stroke(e.fout() * 1.4f);
        Lines.circle(e.x, e.y, (2.0f + e.fin() * 4.0f) * e.rotation);
    }).layer(20.0f);
    public static final Effect bubble = new Effect(20.0f, e -> {
        Draw.color(Tmp.c1.set(e.color).shiftValue(0.1f));
        Lines.stroke(e.fout() + 0.2f);
        Angles.randLenVectors(e.id, 2, e.rotation * 0.9f, (x, y) -> Lines.circle(e.x + x, e.y + y, 1.0f + e.fin() * 3.0f));
    });
    public static final Effect launchAccelerator = new Effect(22.0f, e -> {
        Draw.color(Pal.accent);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 160.0f);
    });
    public static final Effect launch = new Effect(28.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, 4.0f + e.finpow() * 120.0f);
    });
    public static final Effect launchPod = new Effect(50.0f, e -> {
        Draw.color(Pal.engine);
        e.scaled(25.0f, f -> {
            Lines.stroke(f.fout() * 2.0f);
            Lines.circle(e.x, e.y, 4.0f + f.finpow() * 30.0f);
        });
        Lines.stroke(e.fout() * 2.0f);
        Angles.randLenVectors(e.id, 24, e.finpow() * 50.0f, (x, y) -> {
            float ang = Mathf.angle(x, y);
            Lines.lineAngle(e.x + x, e.y + y, ang, e.fout() * 4.0f + 1.0f);
        });
    });
    public static final Effect healWaveMend = new Effect(40.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout() * 2.0f);
        Lines.circle(e.x, e.y, e.finpow() * e.rotation);
    });
    public static final Effect overdriveWave = new Effect(50.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(e.fout());
        Lines.circle(e.x, e.y, e.finpow() * e.rotation);
    });
    public static final Effect healBlock = new Effect(20.0f, e -> {
        Draw.color(Pal.heal);
        Lines.stroke(2.0f * e.fout() + 0.5f);
        Lines.square(e.x, e.y, 1.0f + (e.fin() * e.rotation * 8.0f / 2.0f - 1.0f));
    });
    public static final Effect healBlockFull = new Effect(20.0f, e -> {
        Object patt85834$temp = e.data;
        if (!(patt85834$temp instanceof Block)) {
            return;
        }
        Block block = (Block)patt85834$temp;
        Draw.mixcol(e.color, 1.0f);
        Draw.alpha(e.fout());
        Draw.rect(block.fullIcon, e.x, e.y);
    });
    public static final Effect rotateBlock = new Effect(30.0f, e -> {
        Draw.color(Pal.accent);
        Draw.alpha(e.fout() * 1.0f);
        Fill.square(e.x, e.y, e.rotation * 8.0f / 2.0f);
    });
    public static final Effect lightBlock = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fout() * 1.0f);
        Fill.square(e.x, e.y, e.rotation * 8.0f / 2.0f);
    });
    public static final Effect overdriveBlockFull = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Draw.alpha(e.fslope() * 0.4f);
        Fill.square(e.x, e.y, e.rotation * 8.0f);
    });
    public static final Effect shieldBreak = new Effect(40.0f, e -> {
        Draw.color(e.color);
        Lines.stroke(3.0f * e.fout());
        Object patt86581$temp = e.data;
        if (patt86581$temp instanceof ForceFieldAbility) {
            ForceFieldAbility ab = (ForceFieldAbility)patt86581$temp;
            Lines.poly(e.x, e.y, ab.sides, e.rotation + e.fin(), ab.rotation);
            return;
        }
        Lines.poly(e.x, e.y, 6, e.rotation + e.fin());
    }).followParent(true);
    public static final Effect arcShieldBreak = new Effect(40.0f, e -> {
        Lines.stroke(3.0f * e.fout(), e.color);
        Object patt86914$temp = e.data;
        if (patt86914$temp instanceof Unit) {
            Unit u = (Unit)patt86914$temp;
            ShieldArcAbility ab = (ShieldArcAbility)Structs.find(u.abilities, a -> a instanceof ShieldArcAbility);
            if (ab != null) {
                Vec2 pos = Tmp.v1.set(ab.x, ab.y).rotate(u.rotation - 90.0f).add(u);
                Lines.arc(pos.x, pos.y, ab.radius + ab.width / 2.0f, ab.angle / 360.0f, u.rotation + ab.angleOffset - ab.angle / 2.0f);
                Lines.arc(pos.x, pos.y, ab.radius - ab.width / 2.0f, ab.angle / 360.0f, u.rotation + ab.angleOffset - ab.angle / 2.0f);
                for (int i : Mathf.signs) {
                    float px = pos.x + Angles.trnsx(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i, ab.radius + ab.width / 2.0f);
                    float py = pos.y + Angles.trnsy(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i, ab.radius + ab.width / 2.0f);
                    float px1 = pos.x + Angles.trnsx(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i, ab.radius - ab.width / 2.0f);
                    float py1 = pos.y + Angles.trnsy(u.rotation + ab.angleOffset - ab.angle / 2.0f * (float)i, ab.radius - ab.width / 2.0f);
                    Lines.line(px, py, px1, py1);
                }
            }
        }
    }).followParent(true);
    public static final Effect coreLandDust = new Effect(100.0f, e -> {
        Draw.color(e.color, e.fout(0.1f));
        rand.setSeed(e.id);
        Tmp.v1.trns(e.rotation, e.finpow() * 90.0f * rand.random(0.2f, 1.0f));
        Fill.circle(e.x + Tmp.v1.x, e.y + Tmp.v1.y, 8.0f * rand.random(0.6f, 1.0f) * e.fout(0.2f));
    }).layer(61.0f);
    public static final Effect podLandDust = new Effect(70.0f, e -> {
        Draw.color(e.color, e.fout(0.1f));
        rand.setSeed(e.id);
        Tmp.v1.trns(e.rotation, e.finpow() * 35.0f * rand.random(0.2f, 1.0f));
        Fill.circle(e.x + Tmp.v1.x, e.y + Tmp.v1.y, 5.0f * rand.random(0.6f, 1.0f) * e.fout(0.2f));
    }).layer(61.0f);
    public static final Effect unitShieldBreak = new Effect(35.0f, e -> {
        Object patt88823$temp = e.data;
        if (!(patt88823$temp instanceof Unit)) {
            return;
        }
        Unit unit = (Unit)patt88823$temp;
        float radius = unit.hitSize() * 1.3f;
        e.scaled(16.0f, c -> {
            Draw.color(e.color, 0.9f);
            Lines.stroke(c.fout() * 2.0f + 0.1f);
            Angles.randLenVectors(e.id, (int)(radius * 1.2f), radius / 2.0f + c.finpow() * radius * 1.25f, (x, y) -> Lines.lineAngle(c.x + x, c.y + y, Mathf.angle(x, y), c.fout() * 5.0f + 1.0f));
        });
        Draw.color(e.color, e.fout() * 0.9f);
        Lines.stroke(e.fout());
        Lines.circle(e.x, e.y, radius);
    });
    public static final Effect chainLightning = new Effect(20.0f, 300.0f, e -> {
        Object patt89412$temp = e.data;
        if (!(patt89412$temp instanceof Position)) {
            return;
        }
        Position p = (Position)patt89412$temp;
        float tx = p.getX();
        float ty = p.getY();
        float dst = Mathf.dst(e.x, e.y, tx, ty);
        Tmp.v1.set(p).sub(e.x, e.y).nor();
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float range = 6.0f;
        int links = Mathf.ceil(dst / range);
        float spacing = dst / (float)links;
        Lines.stroke(2.5f * e.fout());
        Draw.color(Color.white, e.color, e.fin());
        Lines.beginLine();
        Lines.linePoint(e.x, e.y);
        rand.setSeed(e.id);
        for (int i = 0; i < links; ++i) {
            float ny;
            float nx;
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
                nx = e.x + normx * len + Tmp.v1.x;
                ny = e.y + normy * len + Tmp.v1.y;
            }
            Lines.linePoint(nx, ny);
        }
        Lines.endLine();
    }).followParent(false).rotWithParent(false);
    public static final Effect chainEmp = new Effect(30.0f, 300.0f, e -> {
        Object patt90493$temp = e.data;
        if (!(patt90493$temp instanceof Position)) {
            return;
        }
        Position p = (Position)patt90493$temp;
        float tx = p.getX();
        float ty = p.getY();
        float dst = Mathf.dst(e.x, e.y, tx, ty);
        Tmp.v1.set(p).sub(e.x, e.y).nor();
        float normx = Tmp.v1.x;
        float normy = Tmp.v1.y;
        float range = 6.0f;
        int links = Mathf.ceil(dst / range);
        float spacing = dst / (float)links;
        Lines.stroke(4.0f * e.fout());
        Draw.color(Color.white, e.color, e.fin());
        Lines.beginLine();
        Lines.linePoint(e.x, e.y);
        rand.setSeed(e.id);
        for (int i = 0; i < links; ++i) {
            float ny;
            float nx;
            if (i == links - 1) {
                nx = tx;
                ny = ty;
            } else {
                float len = (float)(i + 1) * spacing;
                Tmp.v1.setToRandomDirection(rand).scl(range / 2.0f);
                nx = e.x + normx * len + Tmp.v1.x;
                ny = e.y + normy * len + Tmp.v1.y;
            }
            Lines.linePoint(nx, ny);
        }
        Lines.endLine();
    }).followParent(false).rotWithParent(false);
    public static final Effect legDestroy = new Effect(90.0f, 100.0f, e -> {
        Object patt91574$temp = e.data;
        if (!(patt91574$temp instanceof LegDestroyData)) {
            return;
        }
        LegDestroyData data = (LegDestroyData)patt91574$temp;
        rand.setSeed(e.id);
        e.lifetime = rand.random(70.0f, 130.0f);
        Tmp.v1.trns(rand.random(360.0f), rand.random((float)data.region.width / 8.0f) * e.finpow());
        float ox = Tmp.v1.x;
        float oy = Tmp.v1.y;
        Draw.alpha(e.foutpowdown());
        Lines.stroke((float)data.region.height * Draw.scl);
        Lines.line(data.region, data.a.x + ox, data.a.y + oy, data.b.x + ox, data.b.y + oy, false);
    }).layer(65.0f);
    public static final Effect debugLine = new Effect(90.0f, 1.0E12f, e -> {
        Object patt92107$temp = e.data;
        if (!(patt92107$temp instanceof Vec2[])) {
            return;
        }
        Vec2[] vec = (Vec2[])patt92107$temp;
        Draw.color(e.color);
        Lines.stroke(2.0f);
        if (vec.length == 2) {
            Lines.line(vec[0].x, vec[0].y, vec[1].x, vec[1].y);
        } else {
            Lines.beginLine();
            for (Vec2 v : vec) {
                Lines.linePoint(v.x, v.y);
            }
            Lines.endLine();
        }
        Draw.reset();
    });
    public static final Effect debugRect = new Effect(90.0f, 1.0E12f, e -> {
        Object patt92554$temp = e.data;
        if (!(patt92554$temp instanceof Rect)) {
            return;
        }
        Rect rect = (Rect)patt92554$temp;
        Draw.color(e.color);
        Lines.stroke(2.0f);
        Lines.rect(rect);
        Draw.reset();
    });
    public static final Effect arcMarker = new Effect(1800.0f, e -> {
        Draw.color(Pal.command);
        Lines.stroke(2.0f);
        Lines.circle(e.x, e.y, 8.0f);
        Lines.stroke(e.fout() * 1.5f + 0.5f);
        Lines.circle(e.x, e.y, 8.0f + e.finpow() * 92.0f);
    });
    public static final Effect arcGatherMarker = new Effect(1800.0f, e -> {
        Draw.color(Color.cyan, 0.8f);
        Lines.stroke(2.0f);
        Lines.circle(e.x, e.y, 32.0f);
        Lines.stroke(1.0f);
        Lines.circle(e.x, e.y, 32.0f * (e.finpow() * 8.0f - (float)((int)(e.finpow() * 8.0f))));
        for (int j = 0; j < 4; ++j) {
            if (!(e.fout() * 3.0f < (float)j)) continue;
            for (int i = 0; i < 8; ++i) {
                float rot = (float)i * 45.0f;
                float radius = 32.0f + (float)j * 6.0f + 4.0f;
                Drawf.simpleArrow(e.x + Angles.trnsx(rot, radius), e.y + Angles.trnsy(rot, radius), e.x, e.y, 4.0f, 2.0f, Color.cyan, Math.min(1.0f, (float)j - e.fout() * 3.0f));
            }
        }
    });
    public static final Effect arcAttackMarker = new Effect(1800.0f, e -> {
        Draw.color(Pal.attackMark);
        Lines.stroke(2.0f);
        Lines.circle(e.x, e.y, 8.0f);
        float radius = 20.0f + e.finpow() * 80.0f;
        Lines.circle(e.x, e.y, radius);
        for (int i = 0; i < 4; ++i) {
            float rot = (float)i * 90.0f + 45.0f + -Time.time % 360.0f;
            Drawf.simpleArrow(e.x + Angles.trnsx(rot, radius), e.y + Angles.trnsy(rot, radius), e.x, e.y, 6.0f + 4.0f * e.finpow(), 2.0f + 4.0f * e.finpow(), Pal.attackMark);
        }
    });
    public static final Effect arcDefenseMarker = new Effect(1800.0f, e -> {
        Draw.color(Pal.heal);
        if (e.fin() < 0.2f) {
            Lines.circle(e.x, e.y, 20.0f + e.fin() * 400.0f);
            return;
        }
        Lines.circle(e.x, e.y, 101.0f);
        Lines.circle(e.x, e.y, 93.0f);
        for (int i = 0; i < 16; ++i) {
            float rot = (float)i * 22.5f;
            if (!((e.fin() - 0.2f) * 50.0f > (float)i)) continue;
            Drawf.simpleArrow(e.x, e.y, e.x + Angles.trnsx(rot, 120.0f), e.y + Angles.trnsy(rot, 120.0f), 96.0f, 4.0f, Pal.heal);
        }
    });
    public static final Effect arcQuesMarker = new Effect(1200.0f, e -> {
        Draw.color(Color.violet);
        Lines.stroke(2.0f);
        Draw.alpha(Math.min(e.fin() * 5.0f, 1.0f));
        Lines.arc(e.x, e.y + 25.0f, 10.0f, 0.75f, 270.0f);
        Lines.line(e.x, e.y + 15.0f, e.x, e.y + 7.0f);
        Lines.circle(e.x, e.y, 3.0f);
        Lines.circle(e.x, e.y + 18.5f, 27.0f);
    });
    public static final Effect simpleCircle = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Fill.circle(e.x, e.y, 2.0f * e.fout());
    });
    public static final Effect simpleRect = new Effect(60.0f, e -> {
        Draw.color(e.color);
        Fill.square(e.x, e.y, 2.0f * e.fout(), 45.0f);
    });
    public static final Effect arcIndexer = new Effect(120.0f, e -> {
        Draw.color(ARCVars.getThemeColor());
        Lines.circle(e.x, e.y, 8.0f);
        for (int i = 0; i < 3; ++i) {
            float rot = (float)i * 120.0f + 90.0f;
            Drawf.simpleArrow(e.x, e.y, e.x + Angles.trnsx(rot, 120.0f), e.y + Angles.trnsy(rot, 120.0f), 100.0f - 80.0f * e.fin(), -4.0f, ARCVars.getThemeColor());
        }
    });
}

