/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.window;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Tmp;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ui.window.WindowEvents;
import mindustry.arcModule.ui.window.WindowManager;
import mindustry.gen.Icon;
import mindustry.ui.Styles;

public class Window {
    public WindowTable table;
    WindowManager manager;
    String title;
    Table cont;
    Drawable icon;
    public Image iconImage;
    public boolean removed = false;
    public boolean added = false;
    public boolean minSized = false;
    public boolean resizable = true;
    public boolean maxSizable = true;
    public boolean minSizable = true;
    public boolean closable = true;
    boolean cursorRestored = true;
    boolean closeToRemove = true;
    float minWidth = 200.0f;
    float minHeight = 200.0f;
    private final ObjectMap<Enum<WindowEvents>, Seq<Cons<Window>>> events = new ObjectMap();
    private static Window front = null;

    public Window() {
        this(ARCVars.arcui.WindowManager);
    }

    public Window(WindowManager manager) {
        this("Title", manager);
    }

    public Window(String title, WindowManager manager) {
        this(title, 600.0f, 400.0f, manager);
    }

    public Window(String title, float width, float height, WindowManager manager) {
        this(title, width, height, (TextureRegionDrawable)Core.atlas.getDrawable("error"), manager);
    }

    public Window(String title, float width, float height, TextureRegion icon, WindowManager manager) {
        this(title, width, height, new TextureRegionDrawable(icon), manager);
    }

    public Window(String title, float width, float height, Drawable icon, WindowManager manager) {
        this.iconImage = new Image(icon);
        this.iconImage.setScaling(Scaling.fit);
        this.manager = manager;
        this.title = title;
        this.icon = icon;
        this.table = new WindowTable(width, height);
    }

    public void add() {
        if (this.added && !this.closeToRemove) {
            this.table.visible = true;
            this.fire(WindowEvents.open);
            return;
        }
        this.added = true;
        this.fire(WindowEvents.open);
        this.manager.addWindow(this);
        front = this;
        this.fadeIn();
    }

    public void fadeIn() {
        this.table.actions(Actions.sequence((Action)Actions.alpha(0.0f), (Action)Actions.fadeIn(0.16666667f)));
    }

    public void fadeOut() {
        this.table.touchable = Touchable.disabled;
        this.table.actions(Actions.sequence((Action)Actions.alpha(1.0f), (Action)Actions.fadeOut(0.16666667f), (Action)Actions.remove()));
    }

    public Window setIcon(TextureRegion icon) {
        this.iconImage.setDrawable(icon);
        this.fire(WindowEvents.iconChanged);
        return this;
    }

    public Window setTitle(String title) {
        this.title = title;
        this.table.lastLabelWidth = 0.0f;
        this.fire(WindowEvents.titleChanged);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setBody(Table body) {
        this.cont.clear();
        this.cont.add(body).grow();
        this.fire(WindowEvents.bodyChanged);
    }

    public void posX(float x) {
        this.table.x = x;
    }

    public float posX() {
        return this.table.x;
    }

    public void posY(float y) {
        this.table.y = y;
    }

    public float posY() {
        return this.table.y;
    }

    public void pos(float x, float y) {
        this.table.x = x;
        this.table.y = y;
    }

    public void center() {
        this.pos((this.table.parent.getWidth() - this.table.getWidth()) / 2.0f, (this.table.parent.getHeight() - this.table.getHeight()) / 2.0f);
    }

    public boolean visible() {
        return this.table.visible && !this.removed;
    }

    public void remove() {
        if (this.removed) {
            return;
        }
        if (this.closeToRemove) {
            this.removed = true;
            this.fire(WindowEvents.close);
        }
        this.table.remove();
    }

    public void closeToRemove(boolean toggle) {
        this.closeToRemove = toggle;
    }

    public void setMinSize(float width, float height) {
        this.minWidth = width;
        this.minHeight = height;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }

    public boolean isMaxSizable() {
        return this.maxSizable;
    }

    public void setMaxSizable(boolean maxSizable) {
        this.maxSizable = maxSizable;
        if (!maxSizable) {
            this.table.cancelMaximize();
        }
    }

    public boolean isMinSizable() {
        return this.minSizable;
    }

    public void setMinSizable(boolean minSizable) {
        this.minSizable = minSizable;
        if (!minSizable) {
            this.table.cancelMinimize();
        }
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public boolean maximize(boolean maximize) {
        if (!this.maxSizable) {
            return false;
        }
        if (maximize) {
            return this.table.maximize();
        }
        return this.table.cancelMaximize();
    }

    public boolean minimize(boolean minimize) {
        if (!this.minSizable) {
            return false;
        }
        if (minimize) {
            return this.table.minimize();
        }
        return this.table.cancelMinimize();
    }

    public float getWidth() {
        return this.table.getWidth();
    }

    public float getHeight() {
        return this.table.getHeight();
    }

    public void setWidth(float width) {
        this.table.setWidth(width);
    }

    public void setHeight(float height) {
        this.table.setHeight(height);
    }

    public void setSize(float w, float h) {
        this.table.setSize(w, h);
    }

    public void update(Runnable r) {
        this.table.update(r);
    }

    public void addListener(Enum<WindowEvents> type, Cons<Window> listener) {
        ((Seq)((Object)this.events.get(type, (Seq<Cons<Window>>)((Object)((Prov<Seq>)() -> new Seq(Cons.class)))))).add(listener);
    }

    public void fire(Enum<WindowEvents> type) {
        Seq<Cons<Window>> listeners = this.events.get(type);
        if (listeners != null) {
            int len = listeners.size;
            Cons[] items = (Cons[])listeners.items;
            for (int i = 0; i < len; ++i) {
                items[i].get(this);
            }
        }
    }

    public class WindowTable
    extends Table {
        private boolean resizing = false;
        private byte resizeDirection;
        private float lastX;
        private float lastY;
        private float lastHeight;
        private float lastWidth;
        private final Label layoutLabel = new Label("");
        private float lastLabelWidth = 0.0f;
        String cachedTitle = "";

        public WindowTable(float width, float height) {
            this.setClip(true);
            this.setColor(new Color(127.0f, 127.0f, 127.0f, 255.0f));
            this.margin(0.0f);
            this.touchable = Touchable.childrenOnly;
            this.add(new Table(t -> {
                t.add(Window.this.iconImage).size(12.0f).pad(10.0f, 12.0f, 10.0f, 12.0f);
                t.table((Table tt) -> {
                    tt.add("").update((T l) -> {
                        l.setText(this.calcString(Window.this.title, l.getWidth()));
                        l.setColor(front == Window.this ? Color.white : Color.gray);
                    }).grow();
                    tt.addListener(new InputListener(){
                        float lastX;
                        float lastY;

                        @Override
                        public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                            if (WindowTable.this.fillParent) {
                                return true;
                            }
                            Vec2 v = WindowTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                            this.lastX = v.x;
                            this.lastY = v.y;
                            WindowTable.this.toFront();
                            return true;
                        }

                        @Override
                        public void touchDragged(InputEvent event, float x, float y, int pointer) {
                            if (WindowTable.this.resizing || WindowTable.this.fillParent) {
                                return;
                            }
                            Vec2 v = WindowTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                            WindowTable.this.x += v.x - this.lastX;
                            WindowTable.this.y += v.y - this.lastY;
                            this.lastX = v.x;
                            this.lastY = v.y;
                        }
                    });
                }).grow();
                t.button("\u4e00", Styles.cleart, () -> {
                    if (Window.this.minSized) {
                        this.cancelMinimize();
                    } else {
                        this.minimize();
                    }
                }).size(46.0f, 28.0f).pad(1.0f).disabled(e -> !Window.this.minSizable).right();
                t.button((Drawable)Icon.copySmall, Styles.clearNonei, () -> {
                    if (this.fillParent) {
                        this.cancelMaximize();
                    } else {
                        this.maximize();
                    }
                }).size(46.0f, 28.0f).pad(1.0f).disabled(e -> !Window.this.maxSizable).right();
                t.button((Drawable)Icon.cancelSmall, Styles.clearNonei, this::remove).size(46.0f, 28.0f).pad(1.0f).disabled(e -> !Window.this.closable).right();
                t.touchable = Touchable.enabled;
            }){

                @Override
                public void draw() {
                    Draw.color(front == Window.this ? ARCVars.getThemeColor() : Color.white);
                    Fill.rect(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width, this.height);
                    super.draw();
                    Draw.reset();
                }
            }).height(32.0f).top().growX().row();
            this.table((Table tt) -> {
                tt.align(8);
                tt.add().grow();
                Window.this.cont = tt;
                tt.touchable = Touchable.enabled;
            }).grow().pad(1.0f);
            this.addListener(new InputListener(){
                float lastX;
                float lastY;

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                    if (WindowTable.this.fillParent || Window.this.minSized || !Window.this.resizable) {
                        return false;
                    }
                    Vec2 v = WindowTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                    this.lastX = v.x;
                    this.lastY = v.y;
                    WindowTable.this.toFront();
                    front = Window.this;
                    if (x < 7.0f && y < 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.BOTTOM_LEFT;
                    } else if (x > WindowTable.this.getWidth() - 7.0f && y < 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.BOTTOM_RIGHT;
                    } else if (x < 7.0f && y > WindowTable.this.getHeight() - 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.TOP_LEFT;
                    } else if (x > WindowTable.this.getWidth() - 7.0f && y > WindowTable.this.getHeight() - 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.TOP_RIGHT;
                    } else if (x < 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.LEFT;
                    } else if (x > WindowTable.this.getWidth() - 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.RIGHT;
                    } else if (y < 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.BOTTOM;
                    } else if (y > WindowTable.this.getHeight() - 7.0f) {
                        WindowTable.this.resizing = true;
                        WindowTable.this.resizeDirection = ResizeDirection.TOP;
                    } else {
                        WindowTable.this.resizing = false;
                        return false;
                    }
                    Window.this.fire(WindowEvents.resizeStart);
                    WindowTable.this.touchable = Touchable.disabled;
                    return true;
                }

                @Override
                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    if (!WindowTable.this.resizing) {
                        return;
                    }
                    Vec2 v = WindowTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                    float deltaX = 0.0f;
                    float deltaY = 0.0f;
                    float transX = 0.0f;
                    float transY = 0.0f;
                    if ((WindowTable.this.resizeDirection & ResizeDirection.X) != 0) {
                        if ((WindowTable.this.resizeDirection & ResizeDirection.FlipX) == 0) {
                            deltaX = v.x - this.lastX;
                        } else {
                            deltaX = this.lastX - v.x;
                            transX = v.x - this.lastX;
                        }
                    }
                    if ((WindowTable.this.resizeDirection & ResizeDirection.Y) != 0) {
                        if ((WindowTable.this.resizeDirection & ResizeDirection.FlipY) == 0) {
                            deltaY = v.y - this.lastY;
                        } else {
                            deltaY = this.lastY - v.y;
                            transY = v.y - this.lastY;
                        }
                    }
                    if (WindowTable.this.getWidth() + deltaX < Window.this.minWidth) {
                        deltaX = 0.0f;
                        transX = 0.0f;
                    } else {
                        this.lastX = v.x;
                    }
                    if (WindowTable.this.getHeight() + deltaY < Window.this.minHeight) {
                        deltaY = 0.0f;
                        transY = 0.0f;
                    } else {
                        this.lastY = v.y;
                    }
                    WindowTable.this.x += transX;
                    WindowTable.this.y += transY;
                    WindowTable.this.setSize(WindowTable.this.getWidth() + deltaX, WindowTable.this.getHeight() + deltaY);
                    Window.this.fire(WindowEvents.resizing);
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                    WindowTable.this.resizing = false;
                    WindowTable.this.touchable = Touchable.enabled;
                    Window.this.fire(WindowEvents.resizeFinish);
                }

                @Override
                public boolean mouseMoved(InputEvent event, float x, float y) {
                    if (WindowTable.this.fillParent || Window.this.minSized || !Window.this.resizable) {
                        return true;
                    }
                    if (x < 7.0f && y < 7.0f || x > WindowTable.this.getWidth() - 7.0f && y > WindowTable.this.getHeight() - 7.0f) {
                        Core.graphics.cursor(ARCVars.arcui.resizeRightCursor);
                    } else if (x > WindowTable.this.getWidth() - 7.0f && y < 7.0f || x < 7.0f && y > WindowTable.this.getHeight() - 7.0f) {
                        Core.graphics.cursor(ARCVars.arcui.resizeLeftCursor);
                    } else if (x < 7.0f || x > WindowTable.this.getWidth() - 7.0f) {
                        Core.graphics.cursor(ARCVars.arcui.resizeHorizontalCursor);
                    } else if (y < 7.0f || y > WindowTable.this.getHeight() - 7.0f) {
                        Core.graphics.cursor(ARCVars.arcui.resizeVerticalCursor);
                    } else if (!Window.this.cursorRestored) {
                        Core.graphics.restoreCursor();
                        Window.this.cursorRestored = true;
                        return true;
                    }
                    Window.this.cursorRestored = false;
                    return true;
                }

                @Override
                public void exit(InputEvent event, float x, float y, int pointer, Element toActor) {
                    if (pointer == -1 && !Window.this.cursorRestored) {
                        Core.graphics.restoreCursor();
                        Window.this.cursorRestored = true;
                    }
                }
            });
            this.setWidth(width);
            this.setHeight(height);
            this.update(() -> {
                if (this.fillParent) {
                    this.toFront();
                }
            });
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(front == Window.this ? ARCVars.getThemeColor() : Color.gray);
            Lines.rect(this.x - 1.0f, this.y - 1.0f, this.width + 1.0f, this.height + 1.0f);
        }

        @Override
        public boolean remove() {
            if (Window.this.closeToRemove) {
                if (Window.this.removed) {
                    return super.remove();
                }
                Window.this.removed = true;
                Window.this.manager.removeWindow(Window.this);
                Window.this.fadeOut();
                return true;
            }
            this.visible = false;
            return false;
        }

        private String calcString(String input, float width) {
            if (width == this.lastLabelWidth) {
                return this.cachedTitle;
            }
            this.lastLabelWidth = width;
            if (input.length() == 0) {
                return "";
            }
            this.layoutLabel.setText("....");
            float p = this.layoutLabel.getPrefWidth();
            int l = input.length();
            for (int i = 1; i < l; ++i) {
                this.layoutLabel.setText(input.substring(0, i));
                if (!(this.layoutLabel.getPrefWidth() + p > width)) continue;
                this.cachedTitle = (i - 1 > 0 ? input.substring(0, i - 1) : "") + "...";
                return this.cachedTitle;
            }
            this.cachedTitle = input;
            return this.cachedTitle;
        }

        private void savePos() {
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastWidth = this.getWidth();
            this.lastHeight = this.getHeight();
        }

        private void loadPos() {
            this.x = this.lastX;
            this.y = this.lastY;
            this.setWidth(this.lastWidth);
            this.setHeight(this.lastHeight);
        }

        private boolean maximize() {
            if (this.fillParent) {
                return false;
            }
            this.savePos();
            this.y = 0.0f;
            this.x = 0.0f;
            this.setFillParent(true);
            Window.this.fire(WindowEvents.maximize);
            return true;
        }

        private boolean cancelMaximize() {
            if (!this.fillParent) {
                return false;
            }
            this.loadPos();
            this.setFillParent(false);
            Window.this.fire(WindowEvents.restoreSize);
            return true;
        }

        private boolean minimize() {
            if (Window.this.minSized) {
                return false;
            }
            Window.this.minSized = true;
            if (this.fillParent) {
                this.setFillParent(false);
            } else {
                this.savePos();
            }
            Window.this.cont.visible = false;
            this.setHeight(32.0f);
            this.setWidth(200.0f);
            Window.this.fire(WindowEvents.minimize);
            return true;
        }

        private boolean cancelMinimize() {
            if (!Window.this.minSized) {
                return false;
            }
            Window.this.minSized = false;
            if (this.fillParent) {
                this.setFillParent(true);
            } else {
                this.loadPos();
            }
            Window.this.cont.visible = true;
            Window.this.fire(WindowEvents.restoreSize);
            return true;
        }
    }

    private static class ResizeDirection {
        public static byte X = 1;
        public static byte Y = (byte)2;
        public static byte FlipX = (byte)4;
        public static byte FlipY = (byte)8;
        public static byte RIGHT = X;
        public static byte TOP = Y;
        public static byte LEFT = (byte)(RIGHT | FlipX);
        public static byte BOTTOM = (byte)(TOP | FlipY);
        public static byte BOTTOM_LEFT = (byte)(BOTTOM | LEFT);
        public static byte BOTTOM_RIGHT = (byte)(BOTTOM | RIGHT);
        public static byte TOP_LEFT = (byte)(TOP | LEFT);
        public static byte TOP_RIGHT = (byte)(TOP | RIGHT);

        private ResizeDirection() {
        }
    }
}

