/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.quickTool;

import arc.Core;
import arc.Events;
import arc.func.Boolc;
import arc.scene.Element;
import arc.scene.event.Touchable;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ElementUtils;
import mindustry.content.StatusEffects;
import mindustry.game.EventType;
import mindustry.gen.Call;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class HudSettingsTable
extends ElementUtils.ToolTable {
    protected Seq<Setting> list = new Seq();
    private int unitTransparency = Core.settings.getInt("unitTransparency");

    public HudSettingsTable() {
        this.icon = String.valueOf('\ue87c');
        this.rebuild();
        Events.on(EventType.WorldLoadEvent.class, e -> Core.settings.put("removeLogicLock", false));
    }

    @Override
    protected void buildTable() {
        this.list.clear();
        Table sets = new Table();
        this.sliderPref("turretShowRange", 0, 0, 3, 1, (int s) -> {
            if (s == 0) {
                return "\u5173\u95ed";
            }
            if (s == 1) {
                return "\u4ec5\u5bf9\u5730";
            }
            if (s == 2) {
                return "\u4ec5\u5bf9\u7a7a";
            }
            if (s == 3) {
                return "\u5168\u90e8";
            }
            return s + "";
        });
        this.checkPref("unitHealthBar", false);
        this.sliderPref("unitTransparency", 100, 0, 100, 5, (int i) -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.sliderPref("unitDrawMinHealth", 0, 0, 2500, 50, (int i) -> i + "[red]HP");
        this.sliderPref("unitBarDrawMinHealth", 0, 0, 2500, 100, (int i) -> i + "[red]HP");
        this.sliderPref("unitWeaponRange", 0, 0, 100, 1, (int i) -> i > 0 ? i + "%" : "\u5173\u95ed");
        this.checkPref("alwaysShowUnitRTSAi", false);
        this.checkPref("unitLogicMoveLine", true);
        this.checkPref("unitWeaponTargetLine", true);
        this.checkPref("blockWeaponTargetLine", true);
        this.checkPref("unitbuildplan", false);
        for (Setting setting : this.list) {
            setting.add(sets);
        }
        ScrollPane pane = this.pane((Table sp) -> {
            sp.background(Styles.black6);
            sp.table((Table t) -> {
                t.button("[cyan]S", ElementUtils.NCtextStyle, () -> Call.sendChatMessage("/sync")).size(30.0f).tooltip("\u540c\u6b65\u4e00\u6ce2");
                t.button("[cyan]\u89c2", ElementUtils.NCtextStyle, () -> Call.sendChatMessage("/ob")).size(30.0f).tooltip("\u89c2\u5bdf\u8005\u6a21\u5f0f");
                t.button("[cyan]\u6280", ElementUtils.NCtextStyle, () -> Call.sendChatMessage("/skill")).size(30.0f).tooltip("\u6280\u80fd\uff01");
                t.button("[cyan]\u7248", ElementUtils.NCtextStyle, () -> Call.sendChatMessage("/broad")).size(30.0f).tooltip("\u670d\u52a1\u5668\u4fe1\u606f\u7248");
                t.button("[red]\u7248", ElementUtils.textStyle, () -> Core.settings.put("ShowInfoPopup", !Core.settings.getBool("ShowInfoPopup"))).checked(a -> Core.settings.getBool("ShowInfoPopup")).size(30.0f, 30.0f).tooltip("\u5173\u95ed\u6240\u6709\u4fe1\u606f\u7248");
                t.button("[white]\u6cd5", ElementUtils.NCtextStyle, () -> Vars.ui.showConfirm("\u53d7\u4e0d\u4e86\uff0c\u76f4\u63a5\u6295\u964d\uff1f", () -> Call.sendChatMessage("/vote gameover"))).size(30.0f, 30.0f).tooltip("\u6cd5\u56fd\u519b\u793c");
                if (Core.settings.getInt("arcQuickMsg", 0) == 0) {
                    t.button("\ue87c", ElementUtils.NCtextStyle, this::arcQuickMsgTable).size(30.0f, 30.0f).tooltip("\u5feb\u6377\u6d88\u606f");
                }
            }).left();
            sp.row();
            if (Core.settings.getInt("arcQuickMsg") > 0) {
                sp.table((Table t) -> {
                    for (int i = 0; i < Core.settings.getInt("arcQuickMsg"); ++i) {
                        if (i % Core.settings.getInt("arcQuickMsgKey", 8) == 0) {
                            t.row();
                        }
                        int finalI = i;
                        t.button(Core.settings.getString(this.getArcQuickMsgShortName(i)), ElementUtils.NCtextStyle, () -> {
                            if (Core.settings.getBool(this.getArcQuickMsgJs(finalI))) {
                                Vars.mods.getScripts().runConsole(Core.settings.getString(this.getArcQuickMsgName(finalI)));
                            } else {
                                Call.sendChatMessage(Core.settings.getString(this.getArcQuickMsgName(finalI)));
                            }
                        }).size(30.0f);
                    }
                    t.button("\ue87c", ElementUtils.NCtextStyle, this::arcQuickMsgTable).size(30.0f, 30.0f).tooltip("\u5feb\u6377\u6d88\u606f");
                }).left();
                sp.row();
            }
            sp.table((Table t) -> {
                t.button("[cyan]\u5757", ElementUtils.textStyle, () -> {
                    int blockRenderLevel = Core.settings.getInt("blockRenderLevel");
                    Core.settings.put("blockRenderLevel", (blockRenderLevel + 1) % 3);
                }).size(30.0f, 30.0f).tooltip("\u5efa\u7b51\u663e\u793a");
                t.button("[cyan]\u5175", ElementUtils.textStyle, this::forceHideUnit).checked(a -> !ARCVars.unitHide).size(30.0f, 30.0f).tooltip("\u5175\u79cd\u663e\u793a");
                t.button("[cyan]\u7bb1", ElementUtils.textStyle, () -> Core.settings.put("unithitbox", !Core.settings.getBool("unithitbox"))).checked(a -> Core.settings.getBool("unithitbox")).size(30.0f, 30.0f).tooltip("\u78b0\u649e\u7bb1\u663e\u793a");
                t.button("[cyan]\u5f39", ElementUtils.textStyle, () -> Core.settings.put("bulletShow", !Core.settings.getBool("bulletShow"))).checked(a -> Core.settings.getBool("bulletShow")).size(30.0f, 30.0f).tooltip("\u5b50\u5f39\u663e\u793a");
                t.button("[violet]\u9501", ElementUtils.textStyle, () -> {
                    Core.settings.put("removeLogicLock", !Core.settings.getBool("removeLogicLock"));
                    Vars.control.input.logicCutscene = false;
                    ARCVars.arcui.arcInfo("\u5df2\u79fb\u9664\u903b\u8f91\u89c6\u89d2\u9501\u5b9a");
                }).checked(a -> Core.settings.getBool("removeLogicLock")).size(30.0f, 30.0f).tooltip("\u903b\u8f91\u9501\u5b9a");
                t.button("[violet]\u4e22", ElementUtils.textStyle, () -> {
                    boolean block = Core.settings.getBool("blockDrop");
                    Core.settings.put("blockDrop", !block);
                    ARCVars.arcui.arcInfo("\u5df2" + (block ? "\u5f00\u542f" : "\u5173\u95ed") + "\u4e22\u5f03\u7269\u54c1");
                }).checked(a -> !Core.settings.getBool("blockDrop")).size(30.0f, 30.0f).tooltip("\u5141\u8bb8\u4e22\u5f03\u7269\u54c1");
                t.button("[cyan]\u540d", ElementUtils.textStyle, () -> Core.settings.put("arcHideName", !ARCVars.arcHideName)).checked(a -> !ARCVars.arcHideName).size(30.0f, 30.0f).tooltip("\u663e\u793a\u73a9\u5bb6\u540d");
                t.button("[cyan]\u96fe", ElementUtils.textStyle, () -> {
                    if (!Vars.state.rules.pvp || Vars.player.team().id == 255) {
                        Vars.renderer.fogEnabled = !Vars.renderer.fogEnabled;
                    }
                }).checked(a -> Vars.renderer.fogEnabled).size(30.0f, 30.0f).tooltip("\u6218\u4e89\u8ff7\u96fe").visible(() -> !Vars.state.rules.pvp || Vars.player.team().id == 255);
            }).left();
            sp.row();
            sp.table((Table t) -> {
                t.button("[red]\u706f", ElementUtils.textStyle, () -> Core.settings.put("drawlight", !Core.settings.getBool("drawlight"))).checked(a -> Vars.state.rules.lighting).size(30.0f, 30.0f).name("\u706f\u5149").tooltip("[cyan]\u5f00\u706f\u554a\uff01");
                t.button("[acid]\u6548", ElementUtils.textStyle, () -> Core.settings.put("effects", !Core.settings.getBool("effects"))).checked(a -> Core.settings.getBool("effects")).size(30.0f, 30.0f).tooltip("\u7279\u6548\u663e\u793a");
                t.button("[acid]\u5149", ElementUtils.textStyle, () -> {
                    Core.settings.put("bloom", !Core.settings.getBool("bloom"));
                    Vars.renderer.toggleBloom(Core.settings.getBool("bloom"));
                }).checked(a -> Core.settings.getBool("bloom")).size(30.0f, 30.0f).tooltip("\u5149\u6548\u663e\u793a");
                t.button("[acid]\u5899", ElementUtils.textStyle, () -> Core.settings.put("forceEnableDarkness", !Core.settings.getBool("forceEnableDarkness"))).checked(a -> Core.settings.getBool("forceEnableDarkness")).size(30.0f, 30.0f).tooltip("\u5899\u4f53\u9634\u5f71\u663e\u793a");
                t.button("[acid]\u5929", ElementUtils.textStyle, () -> Core.settings.put("showweather", !Core.settings.getBool("showweather"))).checked(a -> Core.settings.getBool("showweather")).size(30.0f, 30.0f).tooltip("\u5929\u6c14\u663e\u793a");
                if (Core.settings.getBool("developMode")) {
                    t.button(StatusEffects.burning.emoji(), ElementUtils.textStyle, () -> {
                        Vars.state.rules.fire = !Vars.state.rules.fire;
                    }).checked(a -> Vars.state.rules.fire).size(30.0f, 30.0f).tooltip("\u592a\u71c3\u4e86");
                }
                t.button("[cyan]\u626b", ElementUtils.textStyle, () -> {
                    Vars.control.input.arcScanMode = !Vars.control.input.arcScanMode;
                }).checked(a -> Vars.control.input.arcScanMode).size(30.0f, 30.0f).tooltip("\u626b\u63cf\u6a21\u5f0f");
                if (Core.app.isMobile()) {
                    t.button("[cyan]\u5e26", ElementUtils.textStyle, () -> Core.settings.put("quickBelt", !ARCVars.quickBelt)).checked(a -> !ARCVars.quickBelt).size(30.0f, 30.0f).tooltip("\u5feb\u901f\u62c9\u4f20\u9001\u5e26\uff08\u4e0d\u9700\u8981\u957f\u6309\uff09");
                }
            }).left();
            sp.row();
            sp.add(sets);
            sp.getChildren().each(t -> {
                if (t instanceof Table) {
                    Table table = (Table)t;
                    table.getChildren().each(b -> ElementUtils.addKey(b));
                }
            });
        }).maxSize(800.0f, 300.0f).get();
        pane.update(() -> {
            Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
            if (e != null && e.isDescendantOf(pane)) {
                pane.requestScroll();
            } else if (pane.hasScroll()) {
                Core.scene.setScrollFocus(null);
            }
        });
    }

    private void arcQuickMsgTable() {
        BaseDialog dialog = new BaseDialog("\u5feb\u6377\u4fe1\u606f");
        dialog.cont.table((Table t) -> {
            t.add("\u5728\u6b64\u7f16\u8f91\u5feb\u901f\u6d88\u606f\uff0c\u53ef\u5728\u5feb\u6377\u8bbe\u7f6e\u9762\u677f\u663e\u793a\u3002\u5982\u8bbe\u7f6e\uff1a\n[white]\u6cd5 /vote gameover\n\u8fd9\u4e00\u6307\u4ee4\u4f1a\u6dfb\u52a0\u4e00\u4e2a\u201c[white]\u6cd5\u7684\u6309\u94ae\uff0c\u70b9\u51fb\u4f1a\u81ea\u52a8\u8f93\u5165/vote gameover\u3002\n\u7531\u4e8e\u61d2\u5f97\u5199\u66f4\u65b0\uff0c\u8bf7\u4fee\u6539\u6ed1\u5757\u540e[orange]\u5173\u95ed\u6b64\u7a97\u53e3\u540e\u518d\u6253\u5f00\u4e00\u6b21[white]\n\u5feb\u6377\u8bbe\u7f6e\u9762\u677f\u540c\u6837\u9700\u8981[orange]\u5173\u95ed\u540e\u518d\u6253\u5f00\u4e00\u6b21[white]\u624d\u80fd\u751f\u6548").center().fillX().row();
            t.table((Table tt) -> {
                tt.add("\u5feb\u6377\u6d88\u606f\u4e2a\u6570\uff1a ");
                Label label = tt.add(String.valueOf(Core.settings.getInt("arcQuickMsg", 0))).get();
                tt.slider(0.0f, 50.0f, 1.0f, Core.settings.getInt("arcQuickMsg", 0), i -> {
                    Core.settings.put("arcQuickMsg", (int)i);
                    label.setText(String.valueOf(Core.settings.getInt("arcQuickMsg")));
                }).width(200.0f).row();
                tt.add("\u6bcf\u884c\u591a\u5c11\u4e2a\u6309\u952e\uff1a ");
                Label label2 = tt.add(String.valueOf(Core.settings.getInt("arcQuickMsgKey", 0))).get();
                tt.slider(3.0f, 10.0f, 1.0f, Core.settings.getInt("arcQuickMsgKey", 0), i -> {
                    Core.settings.put("arcQuickMsgKey", (int)i);
                    label2.setText(String.valueOf(Core.settings.getInt("arcQuickMsgKey")));
                }).width(200.0f);
            }).row();
            t.pane((Table tt) -> {
                tt.add("\u7b2ci\u4e2a").width(50.0f);
                tt.add("JS").width(50.0f);
                tt.add("\u6309\u94ae\u663e\u793a\n(\u5efa\u8bae\u5355\u4e2a\u5b57\u7b26)").width(100.0f);
                tt.add("              \u8f93\u5165\u4fe1\u606f").width(400.0f).center().row();
                int i = 0;
                while (i < Core.settings.getInt("arcQuickMsg", 0)) {
                    tt.add(i + "  ");
                    int finalI = i++;
                    tt.check("", Core.settings.getBool(this.getArcQuickMsgJs(finalI)), js -> Core.settings.put(this.getArcQuickMsgJs(finalI), js));
                    tt.field(Core.settings.getString(this.getArcQuickMsgShortName(finalI), "?"), text -> Core.settings.put(this.getArcQuickMsgShortName(finalI), text)).maxTextLength(10);
                    tt.field(Core.settings.getString(this.getArcQuickMsgName(finalI), "\u672a\u8f93\u5165\u6307\u4ee4"), text -> Core.settings.put(this.getArcQuickMsgName(finalI), text)).maxTextLength(300).width(350.0f);
                    tt.row();
                }
            });
        });
        dialog.addCloseButton();
        dialog.show();
    }

    public void forceHideUnit() {
        this.unitTransparency = ARCVars.unitHide ? this.unitTransparency : Core.settings.getInt("unitTransparency");
        ARCVars.unitHide = !ARCVars.unitHide;
        Core.settings.put("unitTransparency", ARCVars.unitHide ? 0 : this.unitTransparency);
    }

    private String getArcQuickMsgShortName(int i) {
        return "arcQuickMsgShort" + i;
    }

    private String getArcQuickMsgName(int i) {
        return "arcQuickMsg" + i;
    }

    private String getArcQuickMsgJs(int i) {
        return "arcQuickMsgJs" + i;
    }

    public Seq<Setting> getSettings() {
        return this.list;
    }

    public void pref(Setting setting) {
        this.list.add(setting);
        this.rebuild();
    }

    public SliderSettingF sliderPref(String name, String title, int def, int min, int max, StringProcessor s) {
        return this.sliderPref(name, title, def, min, max, 1, s);
    }

    public SliderSettingF sliderPref(String name, String title, int def, int min, int max, int step, StringProcessor s) {
        SliderSettingF res = new SliderSettingF(name, title, def, min, max, step, s);
        this.list.add(res);
        Core.settings.defaults(name, def);
        return res;
    }

    public SliderSettingF sliderPref(String name, int def, int min, int max, StringProcessor s) {
        return this.sliderPref(name, def, min, max, 1, s);
    }

    public SliderSettingF sliderPref(String name, int def, int min, int max, int step, StringProcessor s) {
        SliderSettingF res = new SliderSettingF(name, Core.bundle.get("setting." + name + ".name"), def, min, max, step, s);
        this.list.add(res);
        Core.settings.defaults(name, def);
        return res;
    }

    public void checkPref(String name, String title, boolean def) {
        this.list.add(new CheckSettingF(name, title, def, null));
        Core.settings.defaults(name, def);
    }

    public void checkPref(String name, String title, boolean def, Boolc changed) {
        this.list.add(new CheckSettingF(name, title, def, changed));
        Core.settings.defaults(name, def);
    }

    public void checkPref(String name, boolean def) {
        this.list.add(new CheckSettingF(name, Core.bundle.get("setting." + name + ".name"), def, null));
        Core.settings.defaults(name, def);
    }

    public void checkPref(String name, boolean def, Boolc changed) {
        this.list.add(new CheckSettingF(name, Core.bundle.get("setting." + name + ".name"), def, changed));
        Core.settings.defaults(name, def);
    }

    public static interface StringProcessor {
        public String get(int var1);
    }

    public static class SliderSettingF
    extends Setting {
        int def;
        int min;
        int max;
        int step;
        StringProcessor sp;
        float[] values = null;

        SliderSettingF(String name, String title, int def, int min, int max, int step, StringProcessor s) {
            this.name = name;
            this.title = title;
            this.def = def;
            this.min = min;
            this.max = max;
            this.step = step;
            this.sp = s;
        }

        @Override
        public void add(Table table) {
            Slider slider = new Slider(this.min, this.max, this.step, false);
            slider.setValue(Core.settings.getInt(this.name));
            Label value = new Label("", Styles.outlineLabel);
            Table content = new Table();
            content.add((CharSequence)this.title, Styles.outlineLabel).left().growX().wrap();
            content.add(value).padLeft(10.0f).right();
            content.margin(3.0f, 33.0f, 3.0f, 33.0f);
            content.touchable = Touchable.disabled;
            slider.changed(() -> {
                Core.settings.put(this.name, (int)slider.getValue());
                value.setText(this.sp.get((int)slider.getValue()));
            });
            slider.change();
            table.stack(slider, content).width(Math.min((float)Core.graphics.getWidth() / 1.2f, 300.0f)).left().padTop(4.0f).get();
            table.row();
        }
    }

    public static abstract class Setting {
        public String name;
        public String title;

        public abstract void add(Table var1);
    }

    public static class CheckSettingF
    extends Setting {
        boolean def;
        Boolc changed;

        CheckSettingF(String name, String title, boolean def, Boolc changed) {
            this.name = name;
            this.title = title;
            this.def = def;
            this.changed = changed;
        }

        @Override
        public void add(Table table) {
            CheckBox box = new CheckBox(this.title);
            box.update(() -> box.setChecked(Core.settings.getBool(this.name)));
            box.changed(() -> {
                Core.settings.put(this.name, box.isChecked());
                if (this.changed != null) {
                    this.changed.get(box.isChecked());
                }
            });
            box.left();
            table.add(box).left().padTop(0.5f);
            table.row();
        }
    }
}

