/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.quickTool;

import arc.Core;
import arc.Events;
import arc.func.Cons;
import arc.func.Floatf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.geom.Geometry;
import arc.math.geom.Rect;
import arc.scene.ui.Dialog;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.ElementUtils;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.arcModule.ui.dialogs.BlockSelectDialog;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.content.UnitTypes;
import mindustry.entities.units.BuildPlan;
import mindustry.game.EventType;
import mindustry.game.Schematic;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.graphics.Pal;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.power.ThermalGenerator;
import mindustry.world.blocks.production.Drill;
import mindustry.world.blocks.storage.CoreBlock;

public class AdvanceBuildTool
extends ElementUtils.ToolTable {
    BuildRange placement = BuildRange.player;
    Rect selection = new Rect();
    private Block original = Blocks.conveyor;
    private Block newBlock = Blocks.titaniumConveyor;
    private Block autoBuild = Blocks.turbineCondenser;
    private Block searchBlock = Blocks.itemSource;
    private Building searchBuild = null;
    public Seq<Building> buildingSeq = new Seq();
    private int searchBlockIndex = -1;
    public BuildTiles buildTiles = new BuildTiles();
    private boolean shadowBuild = false;
    public static boolean buildPlansConstrain = true;

    public AdvanceBuildTool() {
        this.icon = Blocks.buildTower.emoji();
        Events.on(EventType.WorldLoadEvent.class, e -> {
            buildPlansConstrain = true;
            this.rebuild();
        });
        Events.run((Object)EventType.Trigger.update, () -> {
            if (this.shadowBuild && Vars.player.unit() != null && Vars.player.unit().plans != null && Vars.player.unit().activelyBuilding()) {
                if (Vars.player.unit().buildPlan().progress == 0.0f) {
                    return;
                }
                Vars.player.unit().plans.remove(Vars.player.unit().buildPlan());
                Call.deletePlans(Vars.player, new int[]{Vars.player.unit().plans.indexOf(Vars.player.unit().buildPlan(), true)});
            }
        });
    }

    @Override
    protected void buildTable() {
        this.table((Table t) -> {
            t.setBackground(Styles.black6);
            t.table((Table tt) -> {
                tt.button((this.placement == BuildRange.global ? "[cyan]" : "[gray]") + "\ue827", ElementUtils.NCtextStyle, () -> {
                    this.placement = BuildRange.global;
                    this.rebuild();
                }).tooltip("[cyan]\u5168\u5c40\u68c0\u67e5").size(30.0f);
                tt.button((this.placement == BuildRange.zone ? "[cyan]" : "[gray]") + "\ue818", ElementUtils.NCtextStyle, () -> {
                    this.selection = Vars.control.input.lastSelection;
                    if (this.selection.area() < 10.0f) {
                        return;
                    }
                    this.placement = BuildRange.zone;
                    this.rebuild();
                }).tooltip("[cyan]\u9009\u62e9\u8303\u56f4").size(30.0f);
                tt.button((this.placement == BuildRange.team ? "" : "[gray]") + Blocks.coreShard.emoji(), ElementUtils.NCtextStyle, () -> {
                    this.placement = BuildRange.team;
                    this.rebuild();
                }).tooltip("[cyan]\u961f\u4f0d\u533a\u57df").size(30.0f);
                tt.button((this.placement == BuildRange.player ? "" : "[gray]") + UnitTypes.gamma.emoji(), ElementUtils.NCtextStyle, () -> {
                    this.placement = BuildRange.player;
                    this.rebuild();
                }).tooltip("[cyan]\u73a9\u5bb6\u5efa\u9020\u533a").size(30.0f);
                tt.update(() -> {
                    if (this.placement != BuildRange.zone) {
                        return;
                    }
                    DrawUtilities.arcDrawText("\u5efa\u9020\u533a\u57df", 0.2f, this.selection.x * 8.0f + this.selection.width * 8.0f * 0.5f, this.selection.y * 8.0f + this.selection.height * 8.0f, 1);
                    Draw.color(Pal.stat, 0.7f);
                    Draw.z(109.0f);
                    Lines.stroke(Math.min(Math.abs(this.width), Math.abs(this.height)) / 8.0f / 10.0f);
                    Lines.rect(this.selection.x * 8.0f - 4.0f, this.selection.y * 8.0f - 4.0f, this.selection.width * 8.0f + 8.0f, this.selection.height * 8.0f + 8.0f);
                    Draw.reset();
                });
            }).fillX().row();
            t.table((Table tt) -> {
                tt.button("R", ElementUtils.NCtextStyle, this::replaceBlock).tooltip("[cyan]\u66ff\u6362\u65b9\u5757").size(30.0f);
                tt.button(this.replaceBlockName(), ElementUtils.NCtextStyle, this::replaceBlockSetting).tooltip("[acid]\u8bbe\u7f6e\u66ff\u6362").width(100.0f).height(30.0f);
            }).fillX().row();
            t.table((Table tt) -> {
                tt.button(this.autoBuild.emoji(), ElementUtils.NCtextStyle, () -> this.blockAutoPlacer(this.autoBuild)).size(30.0f);
                tt.button("\ue87c", ElementUtils.NCtextStyle, () -> {
                    new BlockSelectDialog(Block::isPlaceable, block -> {
                        this.autoBuild = block;
                    }, block -> this.autoBuild == block).show();
                    this.rebuild();
                }).size(30.0f);
                tt.update(() -> {
                    if (Vars.control.input.selectedBlock()) {
                        this.autoBuild = Vars.control.input.block;
                        this.rebuild();
                    }
                });
            }).fillX().row();
            t.table((Table tt) -> {
                tt.button("S", ElementUtils.NCtextStyle, this::searchBlock).update((T button) -> {
                    this.buildingSeq = Vars.player.team().data().buildings.select(building1 -> building1.block == this.searchBlock);
                    if (this.searchBlock.privileged) {
                        for (Team team : Team.all) {
                            if (team == Vars.player.team()) continue;
                            this.buildingSeq.add(team.data().buildings.select(building1 -> building1.block == this.searchBlock));
                        }
                    }
                    if (this.buildingSeq.contains(this.searchBuild)) {
                        this.searchBlockIndex = this.buildingSeq.indexOf(this.searchBuild);
                    } else {
                        this.searchBuild = null;
                        this.searchBlockIndex = -1;
                    }
                    if (this.buildingSeq.isEmpty() || this.searchBlockIndex == -1) {
                        button.setText("[lightgray]\ue88a");
                    } else {
                        button.setText("\ue88a" + (this.searchBlockIndex + 1) + "/" + this.buildingSeq.size);
                    }
                }).tooltip("[cyan]\u641c\u7d22\u65b9\u5757").growX().height(30.0f);
                tt.button(this.searchBlock.emoji(), ElementUtils.NCtextStyle, () -> {
                    new BlockSelectDialog(Block::isPlaceable, block -> {
                        this.searchBlock = block;
                    }, block -> this.searchBlock == block).show().hidden(this::rebuild);
                    this.searchBlockIndex = 0;
                }).tooltip("[acid]\u641c\u7d22\u66ff\u6362").width(30.0f).height(30.0f);
                tt.update(() -> {
                    if (Vars.control.input.selectedBlock()) {
                        this.searchBlock = Vars.control.input.block;
                        this.rebuild();
                    }
                });
            }).fillX().row();
            t.table((Table tt) -> {
                tt.button(Blocks.worldMessage.emoji(), ElementUtils.textStyle, () -> Core.settings.put("displayallmessage", !Core.settings.getBool("displayallmessage", false))).checked(a -> Core.settings.getBool("displayallmessage")).size(30.0f, 30.0f).tooltip("\u5f00\u5173\u4fe1\u606f\u677f\u5168\u663e\u793a");
                tt.button(Blocks.worldProcessor.emoji(), ElementUtils.NCtextStyle, () -> {
                    RFuncs.worldProcessor();
                    this.searchBlock = Blocks.worldProcessor;
                    this.rebuild();
                }).size(30.0f).tooltip("\u5730\u56fe\u4e16\u5904\u4fe1\u606f");
            }).fillX().row();
            t.table((Table tt) -> tt.button("\ue817", ElementUtils.textStyle, () -> {
                this.shadowBuild = !this.shadowBuild;
            }).checked(a -> this.shadowBuild).size(30.0f, 30.0f).tooltip("\u865a\u5f71\u5efa\u9020\u6a21\u5f0f\n[red]\u6709\u4e9b\u670d\u9650\u5236\u53d1\u5305\u6570\u8f83\u4f4e\uff0c\u5efa\u7b51\u8f83\u591a\u65f6\u4f1a\u88ab\u8e22\u51fa\u3002\u8bf7\u914c\u60c5\u4f7f\u7528")).fillX().row();
            if (!Vars.net.client()) {
                t.table((Table tt) -> {
                    tt.button("\uf8c9", ElementUtils.textStyle, () -> {
                        buildPlansConstrain = !buildPlansConstrain;
                        boolean bl = AdvanceToolTable.forcePlacement = !buildPlansConstrain;
                        if (Vars.mobile) {
                            ARCVars.arcui.arcInfo("\u5141\u8bb8\u84dd\u56fe\u5efa\u9020\u5730\u5f62");
                        }
                    }).checked(a -> !buildPlansConstrain).size(30.0f, 30.0f).tooltip("\u5141\u8bb8\u84dd\u56fe\u5efa\u9020\u5730\u5f62");
                    tt.button("\ue800", ElementUtils.NCtextStyle, () -> {
                        this.instantBuild();
                        if (Vars.mobile) {
                            ARCVars.arcui.arcInfo("\u77ac\u95f4\u5efa\u9020\n[cyan]\u5f3a\u5236\u77ac\u95f4\u5efa\u9020[acid]\u9009\u62e9\u8303\u56f4\u5185[cyan]\u5185\u89c4\u5212\u4e2d\u7684\u6240\u6709\u5efa\u7b51\n[orange]\u53ef\u80fd\u51fa\u73b0bug");
                        }
                    }).size(30.0f, 30.0f).tooltip("\u77ac\u95f4\u5efa\u9020\n[cyan]\u5f3a\u5236\u77ac\u95f4\u5efa\u9020[acid]\u9009\u62e9\u8303\u56f4\u5185[cyan]\u89c4\u5212\u4e2d\u7684\u6240\u6709\u5efa\u7b51\n[orange]\u53ef\u80fd\u51fa\u73b0bug");
                    tt.button("\uf8d2", ElementUtils.NCtextStyle, () -> {
                        if (buildPlansConstrain) {
                            ARCVars.arcui.arcInfo("\u8bf7\u5f00\u542f\u5141\u8bb8\u84dd\u56fe\u5efa\u9020\u5730\u5f62 \uf8c9");
                        } else {
                            this.saveTerrain(true);
                        }
                    }).size(30.0f, 30.0f).tooltip("\u590d\u5236\u6240\u9009\u8303\u56f4\u5185\u7684\u5730\u677f\u4f5c\u4e3a\u84dd\u56fe");
                    tt.button("\uf8c4", ElementUtils.NCtextStyle, () -> {
                        if (buildPlansConstrain) {
                            ARCVars.arcui.arcInfo("\u8bf7\u5f00\u542f\u5141\u8bb8\u84dd\u56fe\u5efa\u9020\u5730\u5f62 \uf8c9");
                        } else {
                            this.saveTerrain(false);
                        }
                    }).size(30.0f, 30.0f).tooltip("\u590d\u5236\u6240\u9009\u8303\u56f4\u5185\u7684\u4fee\u9970\u4f5c\u4e3a\u84dd\u56fe");
                }).fillX().row();
            }
        });
    }

    void replaceBlockSetting() {
        BaseDialog dialog = new BaseDialog("\u65b9\u5757\u66ff\u6362\u5668");
        dialog.cont.table((Table t) -> {
            t.table((Table tt) -> tt.label(() -> "\u5f53\u524d\u9009\u62e9\uff1a" + this.replaceBlockName())).row();
            t.image().color(ARCVars.getThemeColor()).fillX().row();
            t.table((Table tt) -> {
                this.replaceBlockGroup(dialog, (Table)tt, Blocks.conveyor, Blocks.titaniumConveyor);
                this.replaceBlockGroup(dialog, (Table)tt, Blocks.conveyor, Blocks.duct);
                this.replaceBlockGroup(dialog, (Table)tt, Blocks.conduit, Blocks.pulseConduit);
                this.replaceBlockGroup(dialog, (Table)tt, Blocks.conduit, Blocks.reinforcedConduit);
            }).padTop(5.0f).row();
            t.image().color(ARCVars.getThemeColor()).padTop(5.0f).fillX().row();
            t.table((Table tt) -> {
                tt.button("\u6e90\u65b9\u5757", () -> new BlockSelectDialog(block -> block.replaceable, block -> {
                    this.original = block;
                }, block -> this.original == block).show()).width(100.0f).height(30.0f).row();
                tt.button("\u65b0\u65b9\u5757", () -> new BlockSelectDialog(block -> this.original.canReplace((Block)block), block -> {
                    this.newBlock = block;
                }, block -> this.newBlock == block).show()).width(100.0f).height(30.0f).row();
            }).padTop(5.0f).row();
        });
        dialog.hidden(this::rebuild);
        dialog.addCloseButton();
        dialog.show();
    }

    void replaceBlockGroup(Dialog dialog, Table t, Block ori, Block re) {
        t.button(this.replaceBlockName(ori, re), () -> {
            this.original = ori;
            this.newBlock = re;
            dialog.hide();
        }).width(100.0f).height(30.0f);
    }

    String replaceBlockName() {
        return this.replaceBlockName(this.original, this.newBlock);
    }

    String replaceBlockName(Block ori, Block re) {
        return ori.emoji() + "\ue803" + re.emoji();
    }

    void replaceBlock() {
        this.replaceBlock(this.original, this.newBlock);
    }

    void replaceBlock(Block ori, Block re) {
        Vars.player.team().data().buildings.each(building -> building.block == ori && this.contain(building.tile), building -> Vars.player.unit().addBuild(new BuildPlan(building.tile.x, building.tile.y, building.rotation, re, building.config())));
    }

    void blockAutoPlacer(Block block) {
        this.buildTiles.buildBlock(block, tile -> this.getBlockEff(block, (Tile)tile));
    }

    float getBlockEff(Block block, Tile tile) {
        if (block instanceof ThermalGenerator) {
            return block.sumAttribute(((ThermalGenerator)block).attribute, tile);
        }
        if (block instanceof Drill) {
            return ((Drill)block).countOreArc(tile);
        }
        return 1.0f;
    }

    boolean contain(Tile tile) {
        if (this.placement == BuildRange.global) {
            return true;
        }
        if (this.placement == BuildRange.zone) {
            return this.selection.contains(tile.x, tile.y);
        }
        if (this.placement == BuildRange.player) {
            return tile.within(Vars.player.x, Vars.player.y, 220.0f);
        }
        if (this.placement == BuildRange.team) {
            if (Vars.state.rules.polygonCoreProtection) {
                float mindst = Float.MAX_VALUE;
                CoreBlock.CoreBuild closest = null;
                for (Teams.TeamData data : Vars.state.teams.active) {
                    for (CoreBlock.CoreBuild tiles : data.cores) {
                        float dst = tiles.dst2(tile.x * 8, tile.y * 8);
                        if (!(dst < mindst)) continue;
                        closest = tiles;
                        mindst = dst;
                    }
                }
                return closest == null || closest.team == Vars.player.team();
            }
            return !Vars.state.teams.anyEnemyCoresWithin(Vars.player.team(), tile.x * 8, tile.y * 8, Vars.state.rules.enemyCoreBuildRadius + 8.0f);
        }
        return true;
    }

    void searchBlock() {
        if (this.buildingSeq.size == 0) {
            ARCVars.arcui.arcInfo("[violet]\u65b9\u5757\u641c\u7d22\n[acid]\u672a\u627e\u5230\u6b64\u65b9\u5757");
            return;
        }
        this.searchBlockIndex = (this.searchBlockIndex + 1) % this.buildingSeq.size;
        this.searchBuild = this.buildingSeq.get(this.searchBlockIndex);
        RFuncs.arcSetCamera(this.searchBuild);
        ARCVars.arcui.arcInfo("[violet]\u65b9\u5757\u641c\u7d22\n[acid]\u627e\u5230\u65b9\u5757[cyan]" + (this.searchBlockIndex + 1) + "[acid]/[cyan]" + this.buildingSeq.size + "[white]" + this.searchBlock.emoji());
    }

    void instantBuild() {
        Vars.player.unit().plans.each(buildPlan -> {
            if (!this.contain(buildPlan.tile())) {
                return;
            }
            this.forceBuildBlock(buildPlan.block, buildPlan.tile(), Vars.player.team(), buildPlan.rotation, buildPlan.config);
        });
    }

    void saveTerrain(boolean floor) {
        this.buildTiles.updateTiles();
        Seq<Schematic.Stile> tiles = new Seq<Schematic.Stile>();
        this.buildTiles.validTile.each(tile -> {
            if (!floor && tile.overlay() == Blocks.air) {
                return;
            }
            tiles.add(new Schematic.Stile(floor ? tile.floor() : tile.overlay(), tile.x - this.buildTiles.minx, tile.y - this.buildTiles.miny));
        });
        Vars.control.input.lastSchematic = new Schematic(tiles, new StringMap(), this.buildTiles.width, this.buildTiles.height);
        Vars.control.input.useSchematic(Vars.control.input.lastSchematic);
    }

    void forceBuildBlock(Block block, Tile tile, Team team, int rotation, Object config) {
        if (block == Blocks.cliff) {
            this.buildCliff(tile);
        } else if (block instanceof OverlayFloor) {
            tile.setOverlay(block);
        } else if (block instanceof Floor) {
            Floor floor = (Floor)block;
            tile.setFloor(floor);
        } else {
            tile.setBlock(block, team, rotation);
            tile.build.configure(config);
        }
        Vars.pathfinder.updateTile(tile);
    }

    void buildCliff(Tile tile) {
        int rotation = 0;
        for (int i = 0; i < 8; ++i) {
            Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
            if (other == null || other.floor().hasSurface()) continue;
            rotation |= 1 << i;
        }
        if (rotation != 0) {
            tile.setBlock(Blocks.cliff);
        }
        tile.data = (byte)rotation;
    }

    static enum BuildRange {
        global,
        zone,
        team,
        player;

    }

    public class BuildTiles {
        Seq<Tile> validTile = new Seq();
        Seq<Float> eff = new Seq();
        float efficiency = 0.0f;
        Block block;
        boolean canBuild = true;
        public int minx;
        public int miny;
        public int maxx;
        public int maxy;
        public int width;
        public int height;

        void buildBlock(Block buildBlock, Floatf<Tile> tilef) {
            this.block = buildBlock;
            this.updateTiles();
            this.checkValid();
            this.calBlockEff(tilef);
            this.eff.sort().reverse().remove(Float.valueOf(0.0f));
            this.eff.each(this::buildEff);
        }

        public void updateTiles() {
            this.minx = 9999;
            this.miny = 9999;
            this.maxx = -999;
            this.maxy = -999;
            this.validTile.clear();
            this.eff.clear();
            Vars.world.tiles.eachTile(tile -> {
                if (tile == null) {
                    return;
                }
                if (!AdvanceBuildTool.this.contain((Tile)tile)) {
                    return;
                }
                this.validTile.add((Tile)tile);
                this.minx = Math.min(this.minx, tile.x);
                this.miny = Math.min(this.miny, tile.y);
                this.maxx = Math.max(this.maxx, tile.x);
                this.maxy = Math.max(this.maxy, tile.y);
            });
            this.validTile.each(tile -> {
                tile.buildEff = 0.0f;
            });
            this.width = this.maxx - this.minx;
            this.height = this.maxy - this.miny;
        }

        void checkValid() {
            this.validTile.each(tile -> {
                block4: {
                    block2: {
                        block3: {
                            if (this.block.size == 2 && Vars.world.getDarkness(tile.x, tile.y) >= 3.0f || Vars.state.rules.staticFog && Vars.state.rules.fog && !Vars.fogControl.isDiscovered(Vars.player.team(), tile.x, tile.y) || tile.floor().isDeep() && !this.block.floating && !this.block.requiresWater && !this.block.placeableLiquid || this.block == tile.block() && tile.build != null && AdvanceBuildTool.this.rotation == (float)tile.build.rotation && this.block.rotate || !tile.interactable(Vars.player.team()) || !tile.floor().placeableOn) break block2;
                            if (this.block.canReplace(tile.block())) break block3;
                            Building patt18009$temp = tile.build;
                            if (!(patt18009$temp instanceof ConstructBlock.ConstructBuild)) break block2;
                            ConstructBlock.ConstructBuild build = (ConstructBlock.ConstructBuild)patt18009$temp;
                            if (build.current != this.block || tile.centerX() != tile.x || tile.centerY() != tile.y) break block2;
                        }
                        if (this.block.bounds(tile.x, tile.y, Tmp.r1).grow(0.01f).contains(tile.block().bounds(tile.centerX(), tile.centerY(), Tmp.r2)) && (!this.block.requiresWater || tile.floor().liquidDrop == Liquids.water)) break block4;
                    }
                    tile.buildEff = -1.0f;
                }
            });
        }

        void calBlockEff(Floatf<Tile> tilef) {
            this.validTile.each(tile -> {
                this.canBuild = true;
                this.getLinkedTiles((Tile)tile, tile1 -> {
                    this.canBuild = tile1.buildEff != -1.0f && this.canBuild;
                });
                if (this.canBuild) {
                    tile.buildEff = this.efficiency = tilef.get((Tile)tile);
                    if (!this.eff.contains(Float.valueOf(this.efficiency))) {
                        this.eff.add(Float.valueOf(this.efficiency));
                    }
                } else {
                    tile.buildEff = 0.0f;
                }
            });
        }

        void buildEff(float e) {
            if (e == 0.0f) {
                return;
            }
            this.validTile.each(tile -> {
                if (tile.buildEff != e) {
                    return;
                }
                if (!this.block.canPlaceOn((Tile)tile, Vars.player.team(), 0)) {
                    return;
                }
                Vars.player.unit().addBuild(new BuildPlan(tile.x, tile.y, 0, this.block));
                this.getFullLinkedTiles((Tile)tile, tile1 -> {
                    tile1.buildEff = 0.0f;
                });
            });
        }

        private void getLinkedTiles(Tile tile, Cons<Tile> cons) {
            if (this.block.isMultiblock()) {
                int size = this.block.size;
                int o = this.block.sizeOffset;
                for (int dx = 0; dx < size; ++dx) {
                    for (int dy = 0; dy < size; ++dy) {
                        Tile other = Vars.world.tile(tile.x + dx + o, tile.y + dy + o);
                        if (other == null) continue;
                        cons.get(other);
                    }
                }
            } else {
                cons.get(tile);
            }
        }

        private void getFullLinkedTiles(Tile tile, Cons<Tile> cons) {
            if (this.block.isMultiblock()) {
                int size = this.block.size;
                int o = 0;
                for (int dx = -size + 1; dx < size; ++dx) {
                    for (int dy = -size + 1; dy < size; ++dy) {
                        Tile other = Vars.world.tile(tile.x + dx + o, tile.y + dy + o);
                        if (other == null) continue;
                        cons.get(other);
                    }
                }
            } else {
                cons.get(tile);
            }
        }
    }
}

