/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.dialogs;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.toolpack.ARCTeam;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class ResourceGraph
extends Table {
    public Seq<SpawnGroup> groups = new Seq();
    public int from = 0;
    public int to = 20;
    private int max;
    private Table colors;
    private Seq<Team> showTeams;
    private Seq<Item> showRes;
    private Seq<Item> removeRes;

    public ResourceGraph() {
        this.showTeams = ARCVars.arcTeam.activeTeam.copy();
        this.showRes = Vars.content.items().copy();
        this.removeRes = new Seq();
        this.background(Tex.pane);
        this.rect((x, y, width, height) -> {
            if (ARCTeam.statisticsCounter == 0) {
                return;
            }
            Lines.stroke(Scl.scl(3.0f));
            GlyphLayout lay = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
            Font font = Fonts.outline;
            lay.setText(font, "1");
            int maxY = this.max;
            float fh = lay.height;
            float offsetX = Scl.scl(lay.width * (float)(maxY + "").length() * 2.0f);
            float offsetY = Scl.scl(22.0f) + fh + Scl.scl(5.0f);
            float graphX = x + offsetX;
            float graphY = y + offsetY;
            float graphW = width - offsetX - 30.0f;
            float graphH = height - offsetY;
            float spacing = graphW / (float)(ARCTeam.statisticsCounter - 1);
            for (Team team : this.showTeams) {
                for (Item item : this.showRes) {
                    if (this.showTeams.size == 1) {
                        Draw.color(item.color);
                    } else {
                        Draw.color(team.color);
                    }
                    Draw.alpha(this.parentAlpha);
                    Lines.beginLine();
                    for (int i = 0; i < ARCTeam.statisticsCounter; ++i) {
                        int val = team.arcTeamData.resStatistics[i][item.id];
                        float cx = graphX + (float)i * spacing;
                        float cy = graphY + (float)val * graphH / (float)maxY;
                        Lines.linePoint(cx, cy);
                    }
                    Lines.endLine();
                }
            }
            for (Team team : this.showTeams) {
                for (Item item : this.showRes) {
                    String name = "";
                    name = this.showTeams.size == 1 ? item.emoji() : (this.showRes.size == 1 ? item.emoji() : team.coloredName() + "|" + item.emoji());
                    font.draw(name, graphX + (float)(ARCTeam.statisticsCounter - 1) * spacing + 15.0f, graphY + (float)team.arcTeamData.resStatistics[ARCTeam.statisticsCounter - 1][item.id] * graphH / (float)maxY, 1);
                }
            }
            float totalMarks = Mathf.clamp(maxY, 1, 10);
            int markSpace = Math.max(1, Mathf.ceil((float)maxY / totalMarks));
            Draw.color(Color.lightGray);
            Draw.alpha(0.1f);
            for (int i = 0; i < maxY; i += markSpace) {
                float cy = graphY + (float)i * graphH / (float)maxY;
                float cx = graphX;
                Lines.line(cx, cy, cx + graphW, cy);
                lay.setText(font, "" + i);
                font.draw("" + i, cx, cy + lay.height / 2.0f, 16);
            }
            Draw.alpha(1.0f);
            float len = Scl.scl(4.0f);
            font.setColor(Color.lightGray);
            for (int i = 0; i < ARCTeam.statisticsCounter; ++i) {
                float cy = y + fh;
                float cx = graphX + (float)i * spacing;
                Lines.line(cx, cy, cx, cy + len);
                int time = i * ARCTeam.statisticsInterval;
                int min = time / 60;
                int sec = time % 60;
                if (ARCTeam.statisticsCounter * ARCTeam.statisticsInterval / 60 >= 2 && (sec != 0 || ARCTeam.statisticsCounter * ARCTeam.statisticsInterval >= 60 && min % 5 != 0)) continue;
                font.draw(min + "'" + sec, cx, cy - Scl.scl(2.0f), 1);
            }
            font.setColor(Color.white);
            Pools.free(lay);
            Draw.reset();
        }).pad(4.0f).padBottom(10.0f).grow();
        this.row();
        this.table((Table t) -> {
            this.colors = t;
        }).growX();
    }

    public void rebuild() {
        this.max = 1;
        this.removeRes.clear();
        for (Item item2 : this.showRes) {
            boolean showItem = false;
            block1: for (int i = 0; i <= ARCTeam.statisticsCounter; ++i) {
                for (Team team : this.showTeams) {
                    if (team.arcTeamData.resStatistics[i][item2.id] <= 0) continue;
                    showItem = true;
                    continue block1;
                }
            }
            if (showItem) continue;
            this.removeRes.add(item2);
        }
        this.removeRes.each(item -> this.showRes.remove((Item)item));
        for (Item item2 : this.showRes) {
            for (int i = 0; i <= ARCTeam.statisticsCounter; ++i) {
                for (Team team : this.showTeams) {
                    this.max = Math.max(this.max, team.arcTeamData.resStatistics[i][item2.id]);
                }
            }
        }
        this.colors.clear();
        this.colors.left();
        this.colors.pane((Table t) -> {
            t.pane((Table ts) -> {
                ts.left();
                ts.button("[green]+", Styles.fullTogglet, this::rebuild).checked(false).height(35.0f).width(50.0f);
                for (Team team : ARCVars.arcTeam.activeTeam) {
                    ts.button(team.coloredName(), Styles.fullTogglet, () -> {
                        if (this.showTeams.contains(team)) {
                            this.showTeams.remove(team);
                        } else {
                            this.showTeams.add(team);
                        }
                        this.rebuild();
                    }).height(35.0f).checked(i -> this.showTeams.contains(team)).width(50.0f);
                }
            }).scrollY(false).growX();
            t.row();
            t.pane((Table ts) -> {
                ts.left();
                for (Item item : Vars.content.items()) {
                    ts.button(item.emoji(), Styles.fullTogglet, () -> {
                        if (this.showRes.contains(item)) {
                            this.showRes.remove(item);
                        } else {
                            this.showRes.add(item);
                        }
                        this.rebuild();
                    }).height(35.0f).checked(i -> this.showRes.contains(item)).width(50.0f);
                }
            }).scrollY(false).growX();
        });
    }

    int nextStep(float value) {
        int order = 1;
        while ((float)order < value) {
            if ((float)(order * 2) > value) {
                return order * 2;
            }
            if ((float)(order * 5) > value) {
                return order * 5;
            }
            if ((float)(order * 10) > value) {
                return order * 10;
            }
            order *= 10;
        }
        return order;
    }
}

