/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.audio.Music;
import arc.files.Fi;
import arc.func.Cons;
import arc.func.Cons2;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.input.KeyCode;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Button;
import arc.scene.ui.CheckBox;
import arc.scene.ui.Dialog;
import arc.scene.ui.Slider;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Http;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Timer;
import arc.util.Tmp;
import arc.util.serialization.Base64Coder;
import arc.util.serialization.JsonReader;
import arc.util.serialization.JsonValue;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Date;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.dialogs.MessageDialog;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class MusicDialog
extends BaseDialog {
    public static final String version = "1.2.4";
    public static final String ShareType = "[pink]<Music>";
    public float vol;
    public Music player;
    public Music sounds;
    private static final String E = "UTF-8";
    private static final Seq<MusicApi> apis = new Seq();
    private final Seq<MusicList> lists = new Seq();
    private Table lrcTable;
    private MusicApi api;
    private Runnable loadStatus;
    private float progress;
    private Slider progressBar;
    private MusicInfo nowMusic;
    private boolean loaded;
    private boolean updating;
    private boolean paused;
    private boolean playing;
    private BaseDialog switchDialog;
    private float fontScale = 1.0f;
    private String lrcColor;
    private String nextLrcColor;
    private String lrcLine1 = "\u677e\u9f20\u97f3\u4e50";
    private String lrcLine2 = "\u677e\u9f20\u97f3\u4e50";
    private LYRIC lyric;
    private Dialog settingsDialog;
    private ListDialog listDialog;
    private MusicList list;
    private MessageDigest md5;
    private Fi tmpDir;

    public MusicDialog() {
        super("\u677e\u9f20\u97f3\u4e50");
        try {
            this.md5 = MessageDigest.getInstance("MD5");
            this.nowMusic = new MusicInfo();
            this.progress = 0.0f;
            this.addApi(null);
            this.addApi(new Squirrel());
            this.addApi(new KuGouWeb());
            try {
                this.addApi(new NetEaseMusic());
            }
            catch (Exception ignored) {
                this.addApi(null);
            }
            this.api = apis.get(2);
            this.list = this.lists.get(2);
            this.addCloseButton();
            this.settingsDialog = new SettingsDialog();
            this.listDialog = new ListDialog();
            this.buttons.button("\u5207\u6362api", this::switchApi);
            this.buttons.button("\u7acb\u5373\u7ed3\u675f\u97f3\u4e50", Icon.cancel, () -> {
                this.player.stop();
                this.player.setVolume(0.0f);
                this.player.pause(true);
                this.player.setPosition(0.0f);
                this.player.dispose();
                this.sounds.stop();
                this.sounds.setVolume(0.0f);
                this.sounds.pause(true);
                this.sounds.setPosition(0.0f);
                this.sounds.dispose();
                this.player = new Music();
                this.sounds = new Music();
            });
            this.buttons.row();
            this.buttons.button("\u4e0a\u4f20\u672c\u5730\u97f3\u4e50", this::upload).disabled(b -> !this.api.canUpload);
            this.buttons.button("\u6b4c\u5355", () -> this.listDialog.show());
            this.buttons.button(Icon.settings, () -> this.settingsDialog.show());
            this.onResize(this::setup);
            this.shown(() -> {
                if (this.check()) {
                    this.setup();
                }
            });
            this.player = new Music();
            this.sounds = new Music();
            this.vol = Core.settings.getFloat("musicVolume", 100.0f);
            this.player.setVolume(this.vol / 100.0f * 2.0f);
            this.sounds.setVolume(this.vol / 100.0f * 2.0f);
            this.loaded = true;
            this.setup();
            this.switchDialog = new BaseDialog("\u5207\u6362api");
            this.switchDialog.cont.label(() -> "\u5f53\u524dapi: (" + this.api.thisId + ")" + this.api.name);
            this.switchDialog.cont.row();
            this.switchDialog.cont.pane((Table p) -> {
                for (MusicApi a : apis) {
                    if (a == null) continue;
                    byte id = a.thisId;
                    String name = a.name;
                    p.button("(" + id + ")" + name, () -> {
                        this.api = apis.get(id);
                        this.list = this.lists.get(id);
                        this.setup();
                        this.switchDialog.hide();
                    }).width(200.0f);
                    p.row();
                }
            }).growX().growY();
            this.switchDialog.addCloseButton();
            this.fontScale = Core.settings.getFloat("lrcFontScale", 1.0f);
            this.lrcColor = "[" + Core.settings.getString("lrcColor", "blue") + "]";
            this.nextLrcColor = "[" + Core.settings.getString("nextLrcColor", "white") + "]";
            this.buildLRC();
            Events.run((Object)EventType.Trigger.update, this::updateProgress);
            Vars.netClient.addPacketHandler("forceAudio", url -> {
                if (Core.settings.getBool("arcShareMedia") && MessageDialog.arcMsgType.music.show.booleanValue()) {
                    Http.get(url, r -> {
                        try {
                            Fi tmp = this.tmpDir.child("server.mp3");
                            tmp.writeBytes(r.getResult());
                            this.sounds.load(tmp);
                            this.sounds.play();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            });
            Vars.netClient.addPacketHandler("stopAudio", url -> this.sounds.stop());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addApi(MusicApi api) {
        apis.add(api);
        this.lists.add(api == null ? null : new MusicList(api.thisId));
    }

    private void buildLRC() {
        if (this.lrcTable != null) {
            this.lrcTable.remove();
        }
        if (Core.settings.getBool("showLRC")) {
            this.lrcTable = new LRCTable();
            Core.scene.add(this.lrcTable);
        }
    }

    private void switchApi() {
        this.switchDialog.show();
    }

    private boolean check() {
        if (!this.loaded) {
            this.cont.clear();
            this.cont.add("[red]\u677e\u9f20\u97f3\u4e50\u52a0\u8f7d\u5931\u8d25");
        }
        return this.loaded;
    }

    private void play(MusicInfo info) {
        this.stop();
        this.nowMusic = info;
        this.api = apis.get(info.src);
        this.list = this.lists.get(info.src);
        this.list.add(info);
        this.list.set(this.list.indexOf(info));
        try {
            this.lyric = info.lrc != null ? info.lrc : null;
            Http.get(info.url, r -> {
                Fi tmp = this.tmpDir.child("squirrel.mp3");
                tmp.writeBytes(r.getResult());
                this.player.stop();
                this.player.pause(false);
                this.player.load(tmp);
                this.player.play();
                Timer.schedule(() -> {
                    this.playing = true;
                }, 0.5f);
                this.loadStatus.run();
            });
        }
        catch (Exception e) {
            Vars.ui.showException("\u53d1\u751f\u4e86\u4e00\u4e2a\u9519\u8bef", e);
            this.playNext();
        }
    }

    private void playDirectly(Fi f) throws Exception {
        this.player.stop();
        this.player.pause(false);
        this.player.load(f);
        this.player.play();
        Timer.schedule(() -> {
            this.playing = true;
        }, 1.0f);
        this.loadStatus.run();
    }

    private void setup() {
        if (!this.loaded) {
            return;
        }
        this.tmpDir = Vars.tmpDirectory.child("music");
        this.tmpDir.mkdirs();
        this.tmpDir.emptyDirectory();
        this.cont.top();
        this.cont.clear();
        this.api.build(this.cont);
        this.cont.row();
        this.cont.table((Table t) -> {
            this.loadStatus = () -> {
                t.clear();
                t.bottom();
                float width = (float)Core.graphics.getWidth() / Scl.scl() * 0.9f;
                t.table((Table tt) -> {
                    tt.left();
                    Table[] img = new Table[]{null};
                    tt.table((Table ttt) -> {
                        img[0] = ttt;
                    }).size(64.0f).pad(2.0f);
                    if (this.nowMusic.imgBuf == null && this.nowMusic.img != null) {
                        Http.get(this.nowMusic.img, r -> {
                            Pixmap pix = new Pixmap(r.getResult());
                            Core.app.post(() -> {
                                TextureRegion cache;
                                this.nowMusic.imgBuf = cache = new TextureRegion(new Texture(pix));
                                pix.dispose();
                                img[0].image(cache).size(64.0f);
                            });
                        });
                    }
                    if (this.nowMusic.imgBuf != null) {
                        img[0].image(this.nowMusic.imgBuf).size(64.0f);
                    }
                    tt.table((Table ms) -> {
                        ms.table((Table ttt) -> {
                            ttt.add(this.nowMusic.name == null ? "\u677e\u9f20\u97f3\u4e50" : this.nowMusic.author + " - " + this.nowMusic.name).left().wrap().style(Styles.outlineLabel).growX();
                            ttt.button((Drawable)Icon.leftSmall, RStyles.clearLineNonei, this::prev).margin(3.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.rightSmall, RStyles.clearLineNonei, this::playNext).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.play, RStyles.clearLineNonei, this::play).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.pause, RStyles.clearLineNonei, this::pause).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.downloadSmall, RStyles.clearLineNonei, () -> {
                                if (this.nowMusic.url != null) {
                                    this.download(this.nowMusic);
                                }
                            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.label(() -> "\u97f3\u91cf:" + (byte)this.vol);
                            ttt.button((Drawable)Icon.upSmall, RStyles.clearLineNonei, () -> {
                                this.vol = Math.min(this.vol + 10.0f, 100.0f);
                                Core.settings.put("musicVolume", Float.valueOf(this.vol));
                                this.player.setVolume(this.vol / 100.0f * 2.0f);
                                this.sounds.setVolume(this.vol / 100.0f * 2.0f);
                            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.downSmall, RStyles.clearLineNonei, () -> {
                                this.vol = Math.max(this.vol - 10.0f, 0.0f);
                                Core.settings.put("musicVolume", Float.valueOf(this.vol));
                                this.player.setVolume(this.vol / 100.0f * 2.0f);
                                this.sounds.setVolume(this.vol / 100.0f * 2.0f);
                            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                            ttt.button((Drawable)Icon.refreshSmall, RStyles.clearLineNoneTogglei, () -> {
                                this.player.setLooping(!this.player.isLooping());
                                Vars.ui.announce("\u5355\u66f2\u5faa\u73af\u5df2" + (this.player.isLooping() ? "\u5f00\u542f" : "\u5173\u95ed"), 1.0f);
                            }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().checked(b -> this.player.isLooping()).size(32.0f);
                            ttt.button((Drawable)Icon.linkSmall, RStyles.clearLineNonei, () -> {
                                if (this.nowMusic.url != null) {
                                    apis.get(this.nowMusic.src).share(this.nowMusic);
                                }
                            }).margin(3.0f).pad(2.0f).pad(6.0f).top().right().size(32.0f);
                        }).growX();
                        ms.row();
                        this.progressBar = ms.slider(0.01f, (double)this.nowMusic.length == 0.0 ? 0.01f : (float)this.nowMusic.length, 0.01f, f -> {
                            if (!this.updating) {
                                this.player.setPosition(0.0f);
                                this.player.setPosition(f);
                                this.player.pause(false);
                                this.paused = false;
                            }
                        }).growX().disabled(s -> this.nowMusic.length == 0).get();
                        ms.row();
                        ms.label(() -> (int)(this.progress / 60.0f) + ":" + (int)(this.progress % 60.0f) + (this.nowMusic.length == 0 ? "" : "/" + this.nowMusic.length / 60 + ":" + this.nowMusic.length % 60));
                    }).growX().growY();
                }).width(width).height(100.0f);
            };
        });
        this.loadStatus.run();
    }

    private void updateLRC(double pos) {
        if (this.lyric == null) {
            this.lrcLine2 = "\u677e\u9f20\u97f3\u4e50";
            this.lrcLine1 = "\u677e\u9f20\u97f3\u4e50";
            return;
        }
        this.lyric.get(pos, (s1, s2) -> {
            this.lrcLine1 = s1;
            this.lrcLine2 = s2;
        });
    }

    private void play() {
        if (!this.player.isPlaying()) {
            Fi f;
            if (this.paused) {
                this.player.pause(false);
                this.paused = false;
                this.playing = true;
            } else if (this.nowMusic.url != null && (f = this.tmpDir.child("squirrel.mp3")).exists()) {
                try {
                    this.playing = false;
                    this.playDirectly(f);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void pause() {
        this.player.pause(true);
        this.paused = true;
        this.playing = false;
    }

    private void updateProgress() {
        float pos;
        if (!this.loaded) {
            return;
        }
        this.updating = true;
        this.progress = pos = this.player.getPosition();
        this.progressBar.setValue(this.progress);
        this.updating = false;
        this.updateLRC(pos * 1000.0f);
        if (pos == 0.0f && this.playing && !this.player.isLooping()) {
            this.playing = false;
            this.playNext();
        }
    }

    private void download(MusicInfo info) {
        Vars.platform.showFileChooser(false, "\u4e0b\u8f7d\u97f3\u4e50", "mp3", fi -> this.api.getInfoOrCall(info, fullInfo -> Http.get(fullInfo.url, r -> {
            fi.writeBytes(r.getResult());
            Core.app.post(() -> Vars.ui.showInfo("\u4e0b\u8f7d\u6210\u529f"));
        })));
    }

    private void upload() {
        Vars.platform.showFileChooser(true, "\u9009\u62e9\u97f3\u4e50\u6587\u4ef6", "mp3", f -> {
            Vars.ui.announce("\u6b63\u5728\u4e0a\u4f20...\n\u5f88\u6162!(1-2\u5206\u949f)\n\u4e0a\u4f20\u5b8c\u6210\u540e\u4f1a\u81ea\u52a8\u64ad\u653e");
            this.api.upload((Fi)f, info -> this.api.getInfoOrCall((MusicInfo)info, this::play));
        });
    }

    private void loadList(MusicList list) {
        if (list == null) {
            return;
        }
        this.list = list;
        list.set(0);
        this.playNext(false);
        this.listDialog.build();
    }

    private void stop() {
        this.player.stop();
        this.playing = false;
        this.paused = false;
    }

    private void playNext() {
        this.playNext(true);
    }

    private void playNext(boolean next) {
        this.stop();
        MusicInfo info = next ? this.list.getNext() : this.list.currentMusic;
        this.playOrStop(info);
    }

    private void prev() {
        this.stop();
        MusicInfo info = this.list.getPrev();
        this.playOrStop(info);
    }

    private void playOrStop(MusicInfo info) {
        if (info == null) {
            this.nowMusic = new MusicInfo();
            this.playing = false;
            this.loadStatus.run();
            return;
        }
        if (info.url == null) {
            apis.get(info.src).getInfoOrCall(info, this::play);
        } else {
            this.play(info);
        }
    }

    public boolean resolveMsg(String msg) {
        return this.resolveMsg(msg, null);
    }

    public boolean resolveMsg(String msg, @Nullable Player sender) {
        if (!Core.settings.getBool("arcShareMedia")) {
            return false;
        }
        if (!(msg.contains(ShareType) && this.loaded && MessageDialog.arcMsgType.music.show.booleanValue())) {
            return false;
        }
        try {
            MessageDialog.addMsg(new MessageDialog.advanceMsg(MessageDialog.arcMsgType.music, msg));
            int start = msg.indexOf(32, msg.indexOf(ShareType) + ShareType.length());
            int split = msg.indexOf(77, start);
            String mark = msg.substring(start + 1, split);
            if (mark.equals("$")) {
                Core.app.post(() -> Vars.ui.showConfirm("\u677e\u9f20\u97f3\u4e50", (sender == null ? "" : sender.name) + "\u5206\u4eab\u4e86\u4e00\u4e2a\u6b4c\u5355\n\u64ad\u653e?", () -> Http.get("https://pastebin.com/raw/" + msg.substring(split + 1), r -> MusicList.parse(URLDecoder.decode(r.getResultAsString(), E), this::loadList), e -> Core.app.post(() -> Vars.ui.showException((Throwable)e)))));
            } else {
                byte src = Byte.parseByte(mark);
                String id = msg.substring(split + 1);
                if (src < 0 || src > MusicDialog.apis.size || apis.get(src) == null && src != 0) {
                    Core.app.post(() -> ARCVars.arcui.arcInfo("[red]\u65e0\u6cd5\u627e\u5230api!\n\u53ef\u80fd\u662f\u5b66\u672f\u7248\u672c\u592a\u65e7"));
                    return false;
                }
                MusicApi current = apis.get(src);
                current.getMusicInfo(id, info -> Core.app.post(() -> Vars.ui.showConfirm("\u677e\u9f20\u97f3\u4e50", (sender == null ? "" : sender.name) + "\u5206\u4eab\u4e86\u4e00\u9996\u6765\u81ea" + current.name + "\u7684\u97f3\u4e50" + (info.name == null ? "" : ":\n" + info.author + " - " + info.name) + "\n\u64ad\u653e?", () -> current.getInfoOrCall((MusicInfo)info, this::play))));
            }
        }
        catch (Exception e) {
            Log.err(e);
            Core.app.post(() -> ARCVars.arcui.arcInfo("[orange]\u97f3\u4e50\u8bfb\u53d6\u5931\u8d25"));
        }
        return true;
    }

    public static abstract class MusicApi {
        public String name;
        public byte thisId;
        public boolean canUpload;

        public void getMusicInfo(String id, Cons<MusicInfo> callback, MusicInfo src) {
            this.getMusicInfo(id, callback, false, src);
        }

        public void getMusicInfo(String str, Cons<MusicInfo> callback) {
            this.getMusicInfo(str, callback, null);
        }

        public abstract void getMusicInfo(String var1, Cons<MusicInfo> var2, boolean var3, MusicInfo var4);

        public void upload(Fi file, Cons<MusicInfo> callback) {
        }

        public abstract void build(Table var1);

        public void getInfoOrCall(MusicInfo info, Cons<MusicInfo> cb) {
            this.getInfoOrCall(info, cb, false);
        }

        public void getInfoOrCall(MusicInfo info, Cons<MusicInfo> cb, boolean noTip) {
            if (info.url != null) {
                cb.get(info);
                return;
            }
            this.getMusicInfo(info.id, c -> Core.app.post(() -> cb.get((MusicInfo)c)), noTip, info);
        }

        public void share(MusicInfo info) {
            Vars.ui.showConfirm("\u5206\u4eab", "\u786e\u8ba4\u5206\u4eab\u5230\u804a\u5929\u6846?", () -> this.getInfoOrCall(info, fullInfo -> RFuncs.shareString(RFuncs.getPrefix("pink", "Music") + " " + fullInfo.src + "M" + fullInfo.id), true));
        }

        public void share(MusicList list) {
            if (list.size() == 0) {
                return;
            }
            Vars.ui.showConfirm("\u5206\u4eab", "\u786e\u8ba4\u5206\u4eab\u5230\u804a\u5929\u6846?", () -> {
                try {
                    Http.HttpRequest req = Http.post("https://pastebin.com/api/api_post.php", "api_dev_key=sdBDjI5mWBnHl9vBEDMNiYQ3IZe0LFEk&api_option=paste&api_paste_expire_date=10M&api_paste_code=" + URLEncoder.encode(list.build(), MusicDialog.E));
                    req.submit(r -> {
                        String code = r.getResultAsString();
                        RFuncs.shareString(RFuncs.getPrefix("pink", "Music") + " $M" + code.substring(code.lastIndexOf(47) + 1));
                    });
                    req.error(e -> Core.app.post(() -> Vars.ui.showException("\u5206\u4eab\u5931\u8d25", (Throwable)e)));
                }
                catch (Exception e2) {
                    Vars.ui.showException("\u5206\u4eab\u5931\u8d25", e2);
                }
            });
        }

        public void loadList(String str, Cons<MusicList> cb) {
            String[] all = str.split("\\$");
            MusicList list = new MusicList(this.thisId);
            this.getMusicInfo(all[0], info -> {
                list.add((MusicInfo)info);
                for (int i = 1; i < all.length; ++i) {
                    this.getMusicInfo(all[i], list::add, true, (MusicInfo)info);
                }
                cb.get(list);
            }, true, null);
        }

        public String buildList(MusicList list) {
            return list.build();
        }
    }

    public static class MusicList {
        public final Seq<MusicInfo> list = new Seq();
        public byte api;
        public int current = 0;
        public MusicInfo currentMusic = new MusicInfo();

        public MusicList(byte api) {
            this.api = api;
        }

        public static void parse(String input, Cons<MusicList> cb) {
            try {
                MusicApi api = (MusicApi)apis.get(Byte.parseByte(input.substring(0, input.indexOf("$"))));
                api.loadList(input.substring(input.indexOf("$") + 1), cb);
            }
            catch (Exception e) {
                Vars.ui.showException(e);
            }
        }

        public void add(MusicInfo info) {
            if (this.indexOf(info) == -1) {
                this.list.add(info);
            }
        }

        public boolean remove(int id) {
            this.list.remove(id);
            if (id < this.current) {
                --this.current;
            }
            return id == this.current;
        }

        public boolean remove(MusicInfo info) {
            return this.remove(this.indexOf(info));
        }

        public int size() {
            return this.list.size;
        }

        public String build() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.api).append("$");
            for (MusicInfo musicInfo : this.list) {
                sb.append(musicInfo.id).append("$");
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        public MusicInfo get(int id) {
            return this.list.get(id);
        }

        public MusicInfo getNext() {
            if (++this.current >= this.list.size) {
                return null;
            }
            this.current = Math.min(this.current, this.list.size - 1);
            return this.update();
        }

        public MusicInfo getPrev() {
            this.current = Math.max(this.current - 1, 0);
            return this.update();
        }

        public void set(int id) {
            if (id >= this.list.size) {
                return;
            }
            this.current = id;
            this.update();
        }

        private MusicInfo update() {
            this.currentMusic = this.current >= this.size() ? null : this.list.get(this.current);
            return this.currentMusic;
        }

        public int indexOf(MusicInfo info) {
            for (int i = 0; i < this.list.size; ++i) {
                if (!Objects.equals(this.list.get((int)i).id, info.id)) continue;
                return i;
            }
            return -1;
        }
    }

    public static class MusicInfo {
        public String name;
        public String author;
        public String url;
        public String img;
        public TextureRegion imgBuf;
        public String id;
        public byte src;
        public int length;
        public LRC lrc;
    }

    private static class Squirrel
    extends MusicApi {
        private Squirrel() {
            this.name = "\u677e\u9f20\u7ad9";
            this.canUpload = true;
            this.thisId = 1;
        }

        @Override
        public void getMusicInfo(final String rid, Cons<MusicInfo> callback, boolean noTip, MusicInfo src) {
            callback.get(new MusicInfo(){
                {
                    this.src = thisId;
                    this.url = "http://124.220.46.174/api/get?id=" + rid;
                    this.id = rid;
                }
            });
        }

        @Override
        public void upload(Fi file, Cons<MusicInfo> callback) {
            RFuncs.uploadToWebID(file, s -> {
                Core.app.post(() -> Vars.ui.announce("\u4e0a\u4f20\u6210\u529f"));
                callback.get(new MusicInfo((String)s){
                    final /* synthetic */ String val$s;
                    {
                        this.val$s = string;
                        this.src = thisId;
                        this.id = String.valueOf(this.val$s);
                    }
                });
            });
        }

        @Override
        public void build(Table root) {
        }
    }

    private class KuGouWeb
    extends NetApi {
        String uuid;

        private KuGouWeb() {
            this.name = "\u9177\u72d7\u7f51\u9875\u7248";
            this.canUpload = false;
            this.thisId = (byte)2;
            this.uuid = Core.settings.getString("kguuid");
            if (this.uuid == null) {
                byte[] result;
                byte[] buf = new byte[8];
                new Rand().nextBytes(buf);
                StringBuilder sb = new StringBuilder();
                for (byte b : result = MusicDialog.this.md5.digest(buf)) {
                    sb.append(String.format("%02x", b));
                }
                this.uuid = sb.toString();
                Core.settings.put("kguuid", sb.toString());
            }
        }

        @Override
        public void getMusicInfo(String id, Cons<MusicInfo> callback, boolean noTip, MusicInfo src) {
            try {
                long timestamp = new Date().getTime();
                String d = "NVPh5oo715z5DIWAeQlhMDsWXXQV4hwtappid=1014clienttime=" + timestamp + "clientver=20000dfid=-encode_album_audio_id=" + id + "mid=" + this.uuid + "platid=4srcappid=2919token=userid=0uuid=" + this.uuid + "NVPh5oo715z5DIWAeQlhMDsWXXQV4hwt";
                byte[] result = MusicDialog.this.md5.digest(d.getBytes(MusicDialog.E));
                StringBuilder sb = new StringBuilder();
                for (byte b : result) {
                    sb.append(String.format("%02x", b));
                }
                Http.HttpRequest req = Http.get("https://wwwapi.kugou.com/play/songinfo?srcappid=2919&clientver=20000&clienttime=" + timestamp + "&mid=" + this.uuid + "&uuid=" + this.uuid + "&dfid=-&appid=1014&platid=4&encode_album_audio_id=" + id + "&token=&userid=0&signature=" + sb);
                req.submit(res -> {
                    JsonValue j = new JsonReader().parse(res.getResultAsString());
                    if (j.getByte("status") == 0) {
                        Core.app.post(() -> Vars.ui.showErrorMessage("\u6b64\u6b4c\u66f2\u65e0\u6cd5\u64ad\u653e:\nKuGou Error: (" + j.getLong("error_code", -1L) + ") " + j.getString("msg")));
                        return;
                    }
                    final JsonValue data = j.get("data");
                    if (data.getString("play_url").contains("clip") && !noTip) {
                        Core.app.post(() -> Vars.ui.showConfirm("\u6b64\u6b4c\u66f2\u4e3avip\u6b4c\u66f2 \u4ec5\u652f\u6301\u64ad\u653e\u90e8\u5206", () -> callback.get(new MusicInfo(){
                            {
                                this.name = data.getString("song_name");
                                this.author = data.getString("author_name");
                                this.url = data.getString("play_url");
                                this.img = data.getString("img");
                                this.id = data.getString("encode_album_audio_id");
                                this.src = KuGouWeb.this.thisId;
                                this.length = data.getInt("timelength") / 1000;
                                this.lrc = LRCParser.parse(data.getString("lyrics"));
                            }
                        })));
                    } else {
                        callback.get(new MusicInfo(){
                            {
                                this.name = data.getString("song_name");
                                this.author = data.getString("author_name");
                                this.url = data.getString("play_url");
                                this.img = data.getString("img");
                                this.id = data.getString("encode_album_audio_id");
                                this.src = KuGouWeb.this.thisId;
                                this.length = data.getInt("timelength") / 1000;
                                this.lrc = LRCParser.parse(data.getString("lyrics"));
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                Core.app.post(() -> Vars.ui.showException("\u641c\u7d22\u51fa\u9519!", e));
            }
        }

        @Override
        public void search(String name, int page, Cons<MusicSet> callback) {
            try {
                long timestamp = new Date().getTime();
                String data = "NVPh5oo715z5DIWAeQlhMDsWXXQV4hwtappid=1014bitrate=0clienttime=" + timestamp + "clientver=1000dfid=-filter=10inputtype=0iscorrection=1isfuzzy=0keyword=" + name + "mid=" + this.uuid + "page=" + page + "pagesize=10platform=WebFilterprivilege_filter=0srcappid=2919userid=0uuid=" + this.uuid + "NVPh5oo715z5DIWAeQlhMDsWXXQV4hwt";
                byte[] result = MusicDialog.this.md5.digest(data.getBytes(MusicDialog.E));
                StringBuilder sb = new StringBuilder();
                for (byte b : result) {
                    sb.append(String.format("%02x", b));
                }
                Http.get("https://complexsearch.kugou.com/v2/search/song?appid=1014&bitrate=0&clienttime=" + timestamp + "&clientver=1000&dfid=-&filter=10&inputtype=0&iscorrection=1&isfuzzy=0&keyword=" + URLEncoder.encode(name, MusicDialog.E) + "&mid=" + this.uuid + "&page=" + page + "&pagesize=10&platform=WebFilter&privilege_filter=0&srcappid=2919&userid=0&uuid=" + this.uuid + "&signature=" + sb, res -> {
                    JsonValue thisMusic;
                    JsonValue j = new JsonReader().parse(res.getResultAsString());
                    if (j.getLong("error_code") != 0L) {
                        Core.app.post(() -> Vars.ui.showErrorMessage("\u641c\u7d22\u51fa\u9519:\nKuGou Error: (" + j.getLong("error_code") + ") " + j.getString("error_msg")));
                        return;
                    }
                    JsonValue lists = j.get("data").get("lists");
                    this.allPage = j.get("data").getInt("total") / 10 + 1;
                    MusicSet set = new MusicSet(10);
                    for (int i = 0; i < 10 && (thisMusic = lists.get(i)) != null; i = (int)((byte)(i + 1))) {
                        set.add(new MusicInfo(){
                            {
                                this.name = thisMusic.getString("SongName");
                                this.author = thisMusic.getString("SingerName");
                                this.id = thisMusic.getString("EMixSongID");
                                this.src = KuGouWeb.this.thisId;
                            }
                        });
                    }
                    callback.get(set);
                });
            }
            catch (Exception e) {
                Core.app.post(() -> Vars.ui.showException("\u641c\u7d22\u51fa\u9519!", e));
            }
        }

        @Override
        public void getTips(String str, Cons<String[]> cb) {
            try {
                Http.get("https://searchtip.kugou.com/getSearchTip?MusicTipCount=10&MVTipCount=0&albumcount=0&keyword=" + URLEncoder.encode(str, MusicDialog.E), r -> {
                    JsonValue j = new JsonReader().parse(r.getResultAsString());
                    if (j.getByte("status") != 1) {
                        return;
                    }
                    int count = j.get("data").get(0).getInt("RecordCount");
                    JsonValue all = j.get("data").get(0).get("RecordDatas");
                    String[] list = new String[count];
                    for (int i = 0; i < count; ++i) {
                        list[i] = all.get(i).getString("HintInfo");
                    }
                    cb.get(list);
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class NetEaseMusic
    extends NetApi {
        private NetEaseMusic() {
            this.name = "\u7f51\u6613\u4e91\u7f51\u9875\u7248";
            this.canUpload = false;
            this.thisId = (byte)3;
        }

        @Override
        public void getMusicInfo(String id, Cons<MusicInfo> callback, boolean noTip, final MusicInfo raw) {
            Http.HttpRequest req = Http.get("https://zm.armoe.cn/song/url?id=" + id);
            req.submit(r -> {
                JsonValue j = new JsonReader().parse(r.getResultAsString());
                if (j.getInt("code") != 200) {
                    Core.app.post(() -> Vars.ui.showErrorMessage("\u7f51\u6613\u4e91\u72b6\u6001\u7801\u9519\u8bef:\n" + j.getInt("code")));
                    return;
                }
                final JsonValue data = j.get("data").get(0);
                if (data.get("url") == null) {
                    Core.app.post(() -> Vars.ui.showInfo("\u6b64\u6b4c\u66f2\u4e3avip\u4e13\u5c5e\u6216\u65e0\u6cd5\u64ad\u653e"));
                    return;
                }
                Http.HttpRequest lr = Http.get("https://zm.armoe.cn/lyric?id=" + id);
                lr.submit(rr -> {
                    final JsonValue lrcData = new JsonReader().parse(rr.getResultAsString());
                    if (raw == null) {
                        callback.get(new MusicInfo(){
                            {
                                this.name = data.getString("name");
                                this.url = data.getString("url");
                                this.id = data.getString("id");
                                this.src = NetEaseMusic.this.thisId;
                                this.lrc = LRCParser.parse(lrcData.get("lrc").getString("lyric"));
                                this.length = data.getInt("time") / 1000;
                            }
                        });
                    } else {
                        callback.get(new MusicInfo(){
                            {
                                this.name = raw.name;
                                this.author = raw.author;
                                this.url = data.getString("url");
                                this.id = data.getString("id");
                                this.src = NetEaseMusic.this.thisId;
                                this.lrc = LRCParser.parse(lrcData.get("lrc").getString("lyric"));
                                this.length = data.getInt("time") / 1000;
                            }
                        });
                    }
                });
            });
        }

        @Override
        public void search(String name, int page, Cons<MusicSet> callback) {
            String encodeName;
            try {
                encodeName = URLEncoder.encode(name, MusicDialog.E);
            }
            catch (Exception e) {
                e.printStackTrace();
                Core.app.post(() -> Vars.ui.showErrorMessage("\u6b4c\u66f2\u540d\u79f0\u7f16\u7801\u9519\u8bef"));
                return;
            }
            Http.HttpRequest req = Http.get("https://zm.armoe.cn/search?keywords=" + encodeName + "&limit=30&offset=" + (page - 1) * 30);
            req.submit(res -> {
                JsonValue thisMusic;
                JsonValue j = new JsonReader().parse(res.getResultAsString());
                if (j.getInt("code") != 200) {
                    Core.app.post(() -> Vars.ui.showErrorMessage("\u641c\u7d22\u51fa\u9519:\n\u7f51\u6613\u4e91 Error: (" + j.getInt("code") + ") "));
                    return;
                }
                JsonValue lists = j.get("result").get("songs");
                MusicSet set = new MusicSet(30);
                for (int i = 0; i < lists.size && (thisMusic = lists.get(i)) != null; i = (int)((byte)(i + 1))) {
                    final StringBuilder sb = new StringBuilder();
                    JsonValue artists = thisMusic.get("artists");
                    for (int k = 0; k < artists.size; ++k) {
                        sb.append(artists.get(k).getString("name")).append("/");
                    }
                    if (sb.length() != 0) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    set.add(new MusicInfo(){
                        {
                            this.name = thisMusic.getString("name");
                            this.author = sb.toString();
                            this.id = thisMusic.getString("id");
                            this.src = NetEaseMusic.this.thisId;
                        }
                    });
                }
                callback.get(set);
            });
        }

        @Override
        public void getTips(String query, Cons<String[]> callback) {
            callback.get(new String[0]);
        }

        @Override
        public void loadList(String str, Cons<MusicList> cb) {
            String[] all = str.split("\uf71d");
            MusicList list = new MusicList(this.thisId);
            for (String s : all) {
                final String[] args = s.split("\uf6aa");
                try {
                    list.add(new MusicInfo(){
                        {
                            this.src = NetEaseMusic.this.thisId;
                            this.id = args[0];
                            this.name = URLDecoder.decode(args[1], MusicDialog.E);
                            this.author = URLDecoder.decode(args[2], MusicDialog.E);
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            cb.get(list);
        }

        @Override
        public String buildList(MusicList list) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.thisId).append("$");
            try {
                for (MusicInfo musicInfo : list.list) {
                    sb.append(musicInfo.id).append("\uf6aa").append(URLEncoder.encode(musicInfo.name, MusicDialog.E)).append("\uf6aa").append(URLEncoder.encode(musicInfo.author, MusicDialog.E)).append("\uf71d");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }

        @Override
        public void share(MusicInfo info) {
            Vars.ui.showConfirm("\u5206\u4eab", "\u786e\u8ba4\u5206\u4eab\u5230\u804a\u5929\u6846?", () -> this.getInfoOrCall(info, fullInfo -> {
                try {
                    RFuncs.shareString(RFuncs.getPrefix("pink", "Music") + " " + fullInfo.src + "M" + fullInfo.id + "\uf6aa" + URLEncoder.encode(fullInfo.name, MusicDialog.E) + "\uf6aa" + URLEncoder.encode(fullInfo.author, MusicDialog.E));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }

        @Override
        public void share(MusicList list) {
            if (list.size() == 0) {
                return;
            }
            Vars.ui.showConfirm("\u5206\u4eab", "\u786e\u8ba4\u5206\u4eab\u5230\u804a\u5929\u6846?", () -> {
                try {
                    Http.HttpRequest req = Http.post("https://pastebin.com/api/api_post.php", "api_dev_key=sdBDjI5mWBnHl9vBEDMNiYQ3IZe0LFEk&api_option=paste&api_paste_expire_date=10M&api_paste_code=" + URLEncoder.encode(this.buildList(list), MusicDialog.E));
                    req.submit(r -> {
                        String code = r.getResultAsString();
                        RFuncs.shareString(RFuncs.getPrefix("pink", "Music") + " $M" + code.substring(code.lastIndexOf(47) + 1));
                    });
                    req.error(e -> Core.app.post(() -> Vars.ui.showException("\u5206\u4eab\u5931\u8d25", (Throwable)e)));
                }
                catch (Exception e2) {
                    Vars.ui.showException("\u5206\u4eab\u5931\u8d25", e2);
                }
            });
        }

        @Override
        public void getMusicInfo(String str, Cons<MusicInfo> callback) {
            final String[] n = str.split("\uf6aa");
            try {
                this.getMusicInfo(n[0], callback, new MusicInfo(){
                    {
                        this.name = URLDecoder.decode(n[1], MusicDialog.E);
                        this.author = URLDecoder.decode(n[2], MusicDialog.E);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        class NetEastEncryptor {
            IvParameterSpec iv = new IvParameterSpec(new byte[]{48, 49, 48, 50, 48, 51, 48, 52, 48, 53, 48, 54, 48, 55, 48, 56});
            BigInteger modulus = new BigInteger("157794750267131502212476817800345498121872783333389747424011531025366277535262539913701806290766479189477533597854989606803194253978660329941980786072432806427833685472618792592200595694346872951301770580765135349259590167490536138082469680638514416594216629258349130257685001248172188325316586707301643237607");
            BigInteger pk = new BigInteger("65537");

            NetEastEncryptor() {
            }

            public void encryptRequest(Http.HttpRequest req, String str) throws Exception {
                req.header("content-type", "application/x-www-form-urlencoded");
                NetMusicData data = this.encryptParams(str);
                req.content("params=" + URLEncoder.encode(data.params, MusicDialog.E) + "&encSecKey=" + URLEncoder.encode(data.encSecKey, MusicDialog.E));
            }

            public NetMusicData encryptParams(String raw) throws Exception {
                String rnd = this.rndString();
                String enc = this.encrypt(raw, "0CoJUm6Qyw8W8jud");
                enc = this.encrypt(enc, rnd);
                NetMusicData o = new NetMusicData();
                o.params = enc;
                rnd = new StringBuilder(rnd).reverse().toString();
                Cipher cipher = Cipher.getInstance("RSA/ECB/nopadding");
                RSAPublicKeySpec publicSpec = new RSAPublicKeySpec(this.modulus, this.pk);
                RSAPublicKey key = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(publicSpec);
                cipher.init(1, key);
                byte[] result = cipher.doFinal(rnd.getBytes());
                StringBuilder sb = new StringBuilder();
                for (byte b : result) {
                    sb.append(String.format("%02x", b));
                }
                o.encSecKey = sb.toString();
                return o;
            }

            public String encrypt(String raw, String key) throws Exception {
                Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                byte[] bytes = key.getBytes(MusicDialog.E);
                SecretKeySpec s = new SecretKeySpec(bytes, "AES");
                cipher.init(1, (Key)s, this.iv);
                byte[] e = cipher.doFinal(raw.getBytes(MusicDialog.E));
                return String.valueOf(Base64Coder.encode(e));
            }

            public String rndString() {
                String keys = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < 16; ++i) {
                    sb.append(keys.charAt((int)Math.floor(Math.random() * 62.0)));
                }
                return sb.toString();
            }

            class NetMusicData {
                public String params;
                public String encSecKey;

                NetMusicData() {
                }
            }
        }
    }

    private class SettingsDialog
    extends BaseDialog {
        public SettingsDialog() {
            super("\u677e\u9f20\u97f3\u4e50\u8bbe\u7f6e");
            CheckBox box = new CheckBox("\u663e\u793a\u6b4c\u8bcd");
            box.update(() -> box.setChecked(Core.settings.getBool("showLRC")));
            box.changed(() -> {
                Core.settings.put("showLRC", !Core.settings.getBool("showLRC"));
                MusicDialog.this.buildLRC();
            });
            this.cont.add(box).row();
            this.cont.add("\u6b4c\u8bcd\u989c\u8272\uff08\u6b63\u5728\u64ad\u653e\uff09");
            this.cont.row();
            this.cont.field(Core.settings.getString("lrcColor", "blue"), s -> {
                Core.settings.put("lrcColor", s);
                MusicDialog.this.lrcColor = "[" + s + "]";
            }).size(128.0f, 32.0f);
            this.cont.row();
            this.cont.add("\u6b4c\u8bcd\u989c\u8272\uff08\u4e0b\u4e00\u884c\uff09");
            this.cont.row();
            this.cont.field(Core.settings.getString("nextLrcColor", "white"), s -> {
                Core.settings.put("nextLrcColor", s);
                MusicDialog.this.nextLrcColor = "[" + s + "]";
            }).size(128.0f, 32.0f);
            this.cont.row();
            this.cont.add("\u6b4c\u8bcd\u5b57\u53f7\uff1a");
            this.cont.slider(0.4f, 4.0f, 0.2f, 1.0f, fs -> {
                MusicDialog.this.fontScale = fs;
                Core.settings.put("lrcFontScale", Float.valueOf(fs));
            }).size(512.0f, 40.0f);
            this.cont.label(() -> String.valueOf(MusicDialog.this.fontScale));
            this.cont.row();
            this.cont.table((Table tt) -> {
                tt.add("\u9884\u89c8\u6548\u679c\uff1a");
                tt.row();
                tt.label(() -> "").update((T l) -> {
                    l.setFontScale(MusicDialog.this.fontScale);
                    l.setText(MusicDialog.this.lrcColor + MusicDialog.this.lrcLine1);
                });
                tt.row();
                tt.label(() -> "").update((T l) -> {
                    l.setFontScale(MusicDialog.this.fontScale);
                    l.setText(MusicDialog.this.nextLrcColor + MusicDialog.this.lrcLine2);
                });
            });
            this.cont.row();
            this.cont.button("\u91cd\u7f6e\u6b4c\u8bcd\u4f4d\u7f6e", () -> {
                Core.settings.put("lrcX", Float.valueOf(200.0f));
                Core.settings.put("lrcY", Float.valueOf(200.0f));
                MusicDialog.this.buildLRC();
            }).size(256.0f, 48.0f);
            this.cont.row();
            this.cont.add("[pink]\u677e\u9f20\u97f3\u4e50v1.2.4\n[gold]\u677e\u9f20\u5236\u4f5c\n[cyan]\u677e\u9f20\u7ad9:squi2rel.tk");
            this.addCloseButton();
        }
    }

    private class ListDialog
    extends BaseDialog {
        public ListDialog() {
            super("\u6b4c\u5355\u5217\u8868");
            this.buttons.button(Icon.trash, () -> Vars.ui.showConfirm("\u677e\u9f20\u97f3\u4e50", "\u662f\u5426\u6e05\u7a7a\u6b4c\u5355", () -> {
                MusicDialog.this.list = new MusicList(0);
                this.build();
            }));
            this.build();
            this.buttons.button(Icon.link, () -> ((MusicApi)apis.get(((MusicDialog)MusicDialog.this).list.api)).share(MusicDialog.this.list)).disabled(b -> MusicDialog.this.list.size() == 0);
            this.buttons.button(Icon.download, () -> Vars.platform.showFileChooser(false, "\u4fdd\u5b58\u6b4c\u5355\u6587\u4ef6", "list", f -> f.writeString(MusicDialog.this.api.buildList(MusicDialog.this.list)))).disabled(b -> MusicDialog.this.list.size() == 0);
            this.buttons.button(Icon.upload, () -> Vars.platform.showFileChooser(true, "\u52a0\u8f7d\u6b4c\u5355\u6587\u4ef6", "list", f -> MusicList.parse(f.readString(), i -> Core.app.post(() -> MusicDialog.this.loadList(i)))));
            this.addCloseButton();
            this.onResize(this::build);
            this.shown(this::build);
        }

        public void build() {
            this.cont.clear();
            float width = (float)Core.graphics.getWidth() / Scl.scl() * 0.9f;
            for (MusicInfo info : ((MusicDialog)MusicDialog.this).list.list) {
                Button[] buttons = new Button[]{null};
                Button button = buttons[0] = this.cont.button((Button b) -> {}, (Button.ButtonStyle)RStyles.clearLineNonei, () -> {
                    if (!buttons[0].childrenPressed()) {
                        MusicDialog.this.play(info);
                    }
                }).width(width).pad(2.0f).get();
                Table inner = new Table(Tex.whiteui);
                inner.setColor(Color.black);
                button.clearChildren();
                button.add(inner).growX();
                inner.add(info.author + " - " + info.name).left().padLeft(10.0f).wrap().style(Styles.outlineLabel).growX();
                inner.button((Drawable)Icon.trash, RStyles.clearLineNonei, () -> {
                    if (MusicDialog.this.list.remove(info)) {
                        MusicDialog.this.playNext();
                    }
                    this.build();
                }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
                inner.button((Drawable)Icon.download, RStyles.clearLineNonei, () -> MusicDialog.this.download(info)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
                inner.button((Drawable)Icon.link, RStyles.clearLineNonei, () -> ((MusicApi)apis.get(info.src)).share(info)).margin(3.0f).pad(2.0f).pad(6.0f).top().right();
                button.row();
                button.update(() -> button.setChecked(Objects.equals(((MusicDialog)MusicDialog.this).list.currentMusic.id, ((MusicDialog)MusicDialog.this).nowMusic.id)));
                this.cont.row();
            }
        }
    }

    private class LRCTable
    extends Table {
        public LRCTable() {
            this.setColor(new Color(127.0f, 127.0f, 127.0f, 255.0f));
            this.margin(0.0f);
            this.touchable = Touchable.enabled;
            this.table(Styles.black3, t -> {
                t.color.set(new Color(127.0f, 127.0f, 127.0f, 255.0f));
                t.addListener(new HandCursorListener());
                t.margin(6.0f);
                t.touchable = Touchable.enabled;
                t.table((Table tt) -> {
                    tt.label(() -> ((MusicDialog)MusicDialog.this).nowMusic.name == null ? "\u677e\u9f20\u97f3\u4e50" : ((MusicDialog)MusicDialog.this).nowMusic.author + " - " + ((MusicDialog)MusicDialog.this).nowMusic.name);
                    tt.button((Drawable)Icon.leftSmall, RStyles.clearLineNonei, () -> MusicDialog.this.prev()).margin(3.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.rightSmall, RStyles.clearLineNonei, () -> MusicDialog.this.playNext()).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.play, RStyles.clearLineNonei, () -> MusicDialog.this.play()).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.pause, RStyles.clearLineNonei, () -> MusicDialog.this.pause()).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.downloadSmall, RStyles.clearLineNonei, () -> {
                        if (((MusicDialog)MusicDialog.this).nowMusic.url != null) {
                            MusicDialog.this.download(MusicDialog.this.nowMusic);
                        }
                    }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.label(() -> "\u97f3\u91cf:" + (byte)MusicDialog.this.vol);
                    tt.button((Drawable)Icon.upSmall, RStyles.clearLineNonei, () -> {
                        MusicDialog.this.vol = Math.min(MusicDialog.this.vol + 10.0f, 100.0f);
                        Core.settings.put("musicVolume", Float.valueOf(MusicDialog.this.vol));
                        MusicDialog.this.player.setVolume(MusicDialog.this.vol / 100.0f * 2.0f);
                        MusicDialog.this.sounds.setVolume(MusicDialog.this.vol / 100.0f * 2.0f);
                    }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.downSmall, RStyles.clearLineNonei, () -> {
                        MusicDialog.this.vol = Math.max(MusicDialog.this.vol - 10.0f, 0.0f);
                        Core.settings.put("musicVolume", Float.valueOf(MusicDialog.this.vol));
                        MusicDialog.this.player.setVolume(MusicDialog.this.vol / 100.0f * 2.0f);
                        MusicDialog.this.sounds.setVolume(MusicDialog.this.vol / 100.0f * 2.0f);
                    }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.refreshSmall, RStyles.clearLineNoneTogglei, () -> {
                        MusicDialog.this.player.setLooping(!MusicDialog.this.player.isLooping());
                        Vars.ui.announce("\u5355\u66f2\u5faa\u73af\u5df2" + (MusicDialog.this.player.isLooping() ? "\u5f00\u542f" : "\u5173\u95ed"), 1.0f);
                    }).margin(3.0f).pad(2.0f).padTop(6.0f).top().right().checked(b -> MusicDialog.this.player.isLooping()).size(32.0f);
                    tt.button((Drawable)Icon.linkSmall, RStyles.clearLineNonei, () -> {
                        if (((MusicDialog)MusicDialog.this).nowMusic.url != null) {
                            ((MusicApi)apis.get(((MusicDialog)MusicDialog.this).nowMusic.src)).share(MusicDialog.this.nowMusic);
                        }
                    }).margin(3.0f).pad(2.0f).pad(6.0f).top().right().size(32.0f);
                    tt.button((Drawable)Icon.homeSmall, RStyles.clearLineNonei, MusicDialog.this::show).margin(3.0f).padTop(6.0f).top().right().size(32.0f);
                });
                t.add().growX();
                this.translation.set(Core.settings.getFloat("lrcX", 200.0f), Core.settings.getFloat("lrcY", 200.0f));
                t.addListener(new InputListener(){
                    float lastx;
                    float lasty;

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        Vec2 v = LRCTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LRCTable.this.toFront();
                        return true;
                    }

                    @Override
                    public void touchDragged(InputEvent event, float x, float y, int pointer) {
                        Vec2 v = LRCTable.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        LRCTable.this.translation.add(v.x - this.lastx, v.y - this.lasty);
                        Core.settings.put("lrcX", Float.valueOf(LRCTable.this.translation.x));
                        Core.settings.put("lrcY", Float.valueOf(LRCTable.this.translation.y));
                        this.lastx = v.x;
                        this.lasty = v.y;
                    }
                });
                t.row();
                t.table((Table tt) -> {
                    t.label(() -> "").update((T l) -> {
                        l.setFontScale(MusicDialog.this.fontScale);
                        l.setText(MusicDialog.this.lrcColor + MusicDialog.this.lrcLine1);
                    }).center();
                    t.row();
                    t.label(() -> "").update((T l) -> {
                        l.setFontScale(MusicDialog.this.fontScale);
                        l.setText(MusicDialog.this.nextLrcColor + MusicDialog.this.lrcLine2);
                    }).center();
                });
            });
        }
    }

    public static class LRC
    extends LYRIC {
        Seq<Double> timeList = new Seq();
        Seq<String> lrcList = new Seq();
        int size;
        int cached = 0;
        double last = 0.0;

        @Override
        public void add(double time, String line) {
            this.timeList.add(time);
            this.lrcList.add(line);
            ++this.size;
        }

        @Override
        public void get(double now, Cons2<String, String> callback) {
            int i;
            int n = i = now > this.last ? this.cached : 0;
            while (i < this.size) {
                if (now > this.timeList.get(i)) {
                    this.cached = i;
                    callback.get(this.lrcList.get(i), i + 1 == this.size ? "" : this.lrcList.get(i + 1));
                }
                ++i;
            }
            this.last = now;
        }
    }

    public static abstract class LYRIC {
        public abstract void add(double var1, String var3);

        public abstract void get(double var1, Cons2<String, String> var3);
    }

    public abstract class NetApi
    extends MusicApi {
        int searchPage = 1;
        int allPage = 1;
        Table menu;
        String queryString = "";
        TextField searchUI;

        public abstract void getTips(String var1, Cons<String[]> var2);

        @Override
        public void build(Table root) {
            root.table(s -> {
                s.top();
                this.searchUI = s.field(this.queryString, res -> {
                    this.queryString = res;
                    this.getTips(this.queryString, st -> Core.app.post(() -> this.loadSearchTips((String[])st)));
                }).growX().get();
                s.button(Icon.zoom, () -> {
                    this.searchPage = 1;
                    this.search();
                });
            }).fillX().padBottom(4.0f);
            root.row();
            this.menu = root.table().growY().get();
        }

        public abstract void search(String var1, int var2, Cons<MusicSet> var3);

        private void search() {
            this.search(this.queryString, this.searchPage, s -> Core.app.post(() -> this.loadSearchResult((MusicSet)s)));
        }

        private void loadSearchTips(String[] tips) {
            this.menu.clear();
            this.menu.pane(t -> {
                float width = (float)Core.graphics.getWidth() / Scl.scl() * 0.9f;
                t.top();
                for (String str : tips) {
                    t.button(str, RStyles.flatt, () -> {
                        this.queryString = str;
                        this.searchUI.setText(this.queryString);
                        this.search();
                    }).width(width);
                    t.row();
                }
            });
        }

        private void loadSearchResult(MusicSet m) {
            this.menu.clear();
            this.menu.pane(t -> {
                t.top();
                if (m.count > 0) {
                    float width = (float)Core.graphics.getWidth() / Scl.scl() * 0.9f;
                    t.clear();
                    for (byte i = 0; i < m.count; i = (byte)(i + 1)) {
                        MusicInfo info = m.list[i];
                        Button[] buttons = new Button[]{null};
                        Button button = buttons[0] = t.button(b -> {}, () -> {
                            if (!buttons[0].childrenPressed()) {
                                MusicDialog.this.api.getInfoOrCall(info, x$0 -> MusicDialog.this.play(x$0));
                            }
                        }).width(width).pad(2.0f).get();
                        Table inner = new Table(Tex.whiteui);
                        inner.setColor(Color.black);
                        button.clearChildren();
                        button.add(inner).growX();
                        inner.add(info.author + " - " + info.name).left().padLeft(10.0f).wrap().style(Styles.outlineLabel).growX();
                        inner.button((Drawable)Icon.download, RStyles.clearLineNonei, () -> MusicDialog.this.download(info)).margin(3.0f).pad(2.0f).padTop(6.0f).top().right();
                        inner.button((Drawable)Icon.link, RStyles.clearLineNonei, () -> this.share(info)).margin(3.0f).pad(2.0f).pad(6.0f).top().right();
                        button.row();
                        t.row();
                    }
                    t.table(tt -> {
                        tt.button(Icon.left, () -> {
                            --this.searchPage;
                            this.search();
                        }).height(50.0f).width(150.0f).disabled(b -> this.searchPage <= 1);
                        tt.add(this.searchPage + "/" + this.allPage);
                        tt.button(Icon.right, () -> {
                            ++this.searchPage;
                            this.search();
                        }).height(50.0f).width(150.0f).disabled(b -> this.searchPage >= this.allPage);
                    });
                }
            }).growY();
        }
    }

    private static class LRCParser {
        private LRCParser() {
        }

        public static LRC parse(String input) {
            String[] lrcs = input.replace("\r", "").split("\\n");
            LRC output = new LRC();
            if (!input.contains("[00:")) {
                output.add(0.0, "\u6682\u65e0\u6b4c\u8bcd");
                return output;
            }
            for (String now : lrcs) {
                try {
                    output.add(LRCParser.parseTime(now), now.substring(10));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return output;
        }

        private static double parseTime(String raw) {
            double sum = 60.0 * Math.floor(Double.parseDouble(raw.substring(1, 3))) * 1000.0;
            sum += 1000.0 * Math.floor(Double.parseDouble(raw.substring(4, 6)));
            if (Double.isNaN(sum += 10.0 * Math.floor(Double.parseDouble(raw.substring(7, 9))))) {
                sum = 0.0;
            }
            return sum;
        }
    }

    public static class MusicSet {
        public byte count;
        public MusicInfo[] list;

        public MusicSet(byte length) {
            this.list = new MusicInfo[length];
        }

        public void add(MusicInfo m) {
            byte by = this.count;
            this.count = (byte)(by + 1);
            this.list[by] = m;
        }
    }
}

