/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.dialogs;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.func.Boolf2;
import arc.graphics.Color;
import arc.math.geom.Vec2;
import arc.scene.style.Drawable;
import arc.scene.ui.CheckBox;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Strings;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.District;
import mindustry.arcModule.Marker;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.toolpack.arcChatPicture;
import mindustry.content.Fx;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Tex;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.storage.CoreBlock;

public class MessageDialog
extends BaseDialog {
    private int msgInit;
    private int msgFinal;
    private boolean ignoreMark = false;
    private int maxMsgRecorded = Math.max(Core.settings.getInt("maxMsgRecorded"), 20);
    public static Seq<advanceMsg> msgList = new Seq();
    private Table historyTable;
    private Boolean fieldMode = false;
    public Seq<Boolf<String>> handlers = new Seq();
    public Seq<Boolf2<String, Player>> handlers2 = new Seq();

    public MessageDialog() {
        super("ARC-\u4e2d\u592e\u76d1\u63a7\u5ba4");
        this.cont.pane((Table t) -> {
            this.historyTable = t;
        }).growX().scrollX(false);
        this.addCloseButton();
        this.buttons.button("\u8bbe\u7f6e", Icon.settings, this::arcMsgSettingTable);
        this.buttons.button("\u533a\u57df\u89c4\u5212\u5668", District::districtSettingDialog);
        this.buttons.row();
        this.buttons.button("\u6e05\u7a7a", Icon.trash, () -> {
            this.clearMsg();
            this.build();
        });
        this.buttons.button("\u5bfc\u51fa", Icon.upload, this::exportMsg).name("\u5bfc\u51fa\u804a\u5929\u8bb0\u5f55");
        this.buttons.button("\u56fe\u7247\u5206\u4eab\u5668", Icon.image, arcChatPicture::arcSharePicture);
        this.buttons.button("\u677e\u9f20\u97f3\u4e50", () -> ARCVars.arcui.MusicDialog.show());
        this.shown(this::build);
        this.onResize(this::build);
        Events.on(EventType.WorldLoadEvent.class, e -> {
            MessageDialog.addMsg(new advanceMsg(arcMsgType.eventWorldLoad, "\u8f7d\u5165\u5730\u56fe\uff1a " + Vars.state.map.name()));
            MessageDialog.addMsg(new advanceMsg(arcMsgType.eventWorldLoad, "\u7b80\u4ecb\uff1a " + Vars.state.map.description()));
            this.limitMsg(this.maxMsgRecorded);
        });
        Events.on(EventType.WaveEvent.class, e -> {
            if (Vars.state.wavetime < 60.0f) {
                return;
            }
            MessageDialog.addMsg(new advanceMsg(arcMsgType.eventWave, "\u6ce2\u6b21\uff1a " + Vars.state.wave + " | " + RFuncs.arcWaveInfo(Vars.state.wave - 1)));
        });
        Events.on(EventType.BlockDestroyEvent.class, e -> {
            if (e.tile.build instanceof CoreBlock.CoreBuild) {
                MessageDialog.addMsg(new advanceMsg(arcMsgType.eventCoreDestory, "\u6838\u5fc3\u6467\u6bc1\uff1a (" + e.tile.x + "," + e.tile.y + ")", new Vec2(e.tile.x * 8, e.tile.y * 8)));
            }
        });
    }

    void build() {
        this.historyTable.clear();
        this.historyTable.setWidth(800.0f);
        if (MessageDialog.msgList.size == 0) {
            return;
        }
        for (int i = MessageDialog.msgList.size - 1; i >= 0; --i) {
            int finalI = i;
            if (!MessageDialog.msgList.get((int)finalI).msgType.show.booleanValue()) continue;
            this.historyTable.table(Tex.whiteui, t -> {
                advanceMsg thisMsg = msgList.get(finalI);
                t.background(Tex.whitePane);
                t.setColor(thisMsg.msgType.color);
                t.marginTop(5.0f);
                t.table(Tex.whiteui, tt -> {
                    tt.color.set(thisMsg.msgType.color);
                    if (MessageDialog.msgList.get((int)finalI).msgType == arcMsgType.chat) {
                        tt.add("" + this.getPlayerName(thisMsg)).style(Styles.outlineLabel).left().width(300.0f);
                    } else {
                        tt.add(thisMsg.msgType.name).style(Styles.outlineLabel).color(thisMsg.msgType.color).left().width(300.0f);
                    }
                    tt.add(this.formatTime(thisMsg.time)).style(Styles.outlineLabel).color(thisMsg.msgType.color).left().padLeft(20.0f).width(100.0f);
                    if (thisMsg.msgLoc.x != -1.0f) {
                        tt.button("\u2650\uff1a " + (int)(thisMsg.msgLoc.x / 8.0f) + "," + (int)(thisMsg.msgLoc.y / 8.0f), Styles.logicButton, () -> {
                            InputHandler patt4481$temp = Vars.control.input;
                            if (patt4481$temp instanceof DesktopInput) {
                                DesktopInput input = (DesktopInput)patt4481$temp;
                                input.panning = true;
                            }
                            Core.camera.position.set(thisMsg.msgLoc);
                            Fx.arcMarker.arcCreate(thisMsg.msgLoc.x, thisMsg.msgLoc.y, 0.0f, this.color, null);
                            this.hide();
                        }).padLeft(50.0f).height(24.0f).width(150.0f);
                    }
                    tt.add().growX();
                    tt.add("    " + (MessageDialog.msgList.size - finalI) + "").style(Styles.outlineLabel).color(thisMsg.msgType.color).padRight(10.0f);
                    tt.button((Drawable)Icon.copy, Styles.logici, () -> {
                        Core.app.setClipboardText(thisMsg.message);
                        Vars.ui.announce("\u5df2\u5bfc\u51fa\u672c\u6761\u804a\u5929\u8bb0\u5f55");
                    }).size(24.0f).padRight(6.0f);
                    tt.button((Drawable)Icon.cancel, Styles.logici, () -> {
                        msgList.remove(finalI);
                        this.build();
                    }).size(24.0f);
                }).growX().height(30.0f);
                t.row();
                t.table((Table tt) -> {
                    tt.left();
                    tt.marginLeft(4.0f);
                    tt.setColor(thisMsg.msgType.color);
                    if (this.fieldMode.booleanValue()) {
                        tt.field(thisMsg.message, Styles.nodeArea, (String text) -> {}).growX();
                    } else {
                        tt.labelWrap(this.getPlayerMsg(thisMsg)).growX();
                    }
                }).pad(4.0f).padTop(2.0f).growX().grow();
                t.marginBottom(7.0f);
            }).growX().maxWidth(1000.0f).padBottom(15.0f).row();
        }
    }

    private String getPlayerName(advanceMsg msgElement) {
        int typeStart = msgElement.message.indexOf("[coral][");
        int typeEnd = msgElement.message.indexOf("[coral]]");
        if (typeStart == -1 || typeEnd == -1 || typeEnd <= typeStart) {
            return msgElement.msgType.name;
        }
        return msgElement.message.substring(typeStart + 20, typeEnd);
    }

    private String getPlayerMsg(advanceMsg msgElement) {
        if (msgElement.msgType != arcMsgType.normal) {
            return msgElement.message;
        }
        int typeStart = msgElement.message.indexOf("[coral][");
        int typeEnd = msgElement.message.indexOf("[coral]]");
        if (typeStart == -1 || typeEnd == -1 || typeEnd <= typeStart) {
            return msgElement.message;
        }
        return msgElement.message.substring(typeEnd + 9);
    }

    private void arcMsgSettingTable() {
        BaseDialog setDialog = new BaseDialog("\u4e2d\u592e\u76d1\u63a7\u5ba4-\u8bbe\u7f6e");
        if (Core.settings.getInt("maxMsgRecorded") == 0) {
            Core.settings.put("maxMsgRecorded", 500);
        }
        setDialog.cont.table((Table t) -> {
            t.check("\u505c\u6b62\u8bc6\u522b\u6807\u8bb0\u7b49\u4ea4\u4e92\u4fe1\u606f", this.ignoreMark, a -> {
                this.ignoreMark = !this.ignoreMark;
            }).left().width(300.0f);
            t.row();
            t.check("\u4fe1\u606f\u7f16\u8f91\u6a21\u5f0f", this.fieldMode, a -> {
                this.fieldMode = a;
                this.build();
            }).left().width(200.0f);
            t.row();
            t.add("\u8c03\u6574\u663e\u793a\u7684\u4fe1\u606f").height(50.0f);
            t.row();
            t.table((Table tt) -> {
                tt.button("\u5173\u95ed\u5168\u90e8", Styles.cleart, () -> {
                    for (arcMsgType type : arcMsgType.values()) {
                        type.show = false;
                    }
                }).width(200.0f).height(50.0f);
                tt.button("\u9ed8\u8ba4", Styles.cleart, () -> {
                    for (arcMsgType type : arcMsgType.values()) {
                        type.show = true;
                    }
                    arcMsgType.serverTips.show = false;
                }).width(200.0f).height(50.0f);
            });
            t.row();
            t.table(Tex.button, tt -> tt.pane((Table tp) -> {
                for (arcMsgType type : arcMsgType.values()) {
                    CheckBox box = new CheckBox("[#" + type.color.toString() + "]" + type.name);
                    box.update(() -> box.setChecked(type.show));
                    box.changed(() -> {
                        type.show = type.show == false;
                        this.build();
                    });
                    box.left();
                    tp.add(box).left().padTop(3.0f).row();
                }
            }).maxHeight(500.0f).width(400.0f));
        });
        setDialog.cont.row();
        setDialog.cont.table((Table t) -> {
            t.add("\u6700\u5927\u50a8\u5b58\u804a\u5929\u8bb0\u5f55(\u8fc7\u9ad8\u53ef\u80fd\u5bfc\u81f4\u5361\u987f)\uff1a");
            t.field(this.maxMsgRecorded + "", text -> {
                int record;
                this.maxMsgRecorded = record = Math.min(Math.max(Integer.parseInt(text), 1), 9999);
                Core.settings.put("maxMsgRecorded", record);
            }).valid(Strings::canParsePositiveInt).width(200.0f).get();
            t.row();
            t.add("\u8d85\u51fa\u9650\u5236\u7684\u804a\u5929\u8bb0\u5f55\u5c06\u5728\u8f7d\u5165\u5730\u56fe\u65f6\u6e05\u9664");
        });
        setDialog.addCloseButton();
        setDialog.button("\u5237\u65b0", Icon.refresh, this::build);
        setDialog.show();
    }

    public String formatTime(Date time) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("HH:mm:ss");
        return sdf.format(time);
    }

    public boolean resolveMsg(String message) {
        if (!this.ignoreMark) {
            if (Marker.resolveMessage(message)) {
                return true;
            }
            if (District.resolveMessage(message)) {
                return true;
            }
            if (this.resolveMarkMsg(message, null)) {
                return true;
            }
            if (this.resolveServerMsg(message)) {
                return true;
            }
            if (ARCVars.arcui.MusicDialog.resolveMsg(message)) {
                return true;
            }
            for (Boolf<String> handler : this.handlers) {
                if (!handler.get(message)) continue;
                return true;
            }
        }
        MessageDialog.addMsg(new advanceMsg(arcMsgType.normal, message));
        return false;
    }

    public void resolveMsg(String message, @Nullable Player playersender) {
        if (!this.ignoreMark) {
            if (Marker.resolveMessage(message)) {
                return;
            }
            if (District.resolveMessage(message)) {
                return;
            }
            if (this.resolveMarkMsg(message, playersender)) {
                return;
            }
            if (arcChatPicture.resolveMessage(message, playersender)) {
                return;
            }
            if (ARCVars.arcui.MusicDialog.resolveMsg(message, playersender)) {
                return;
            }
            if (Vars.ui.schematics.resolveSchematic(message, playersender)) {
                return;
            }
            for (Boolf2<String, Player> handler : this.handlers2) {
                if (!handler.get(message, playersender)) continue;
                return;
            }
            if (playersender != null) {
                MessageDialog.addMsg(new advanceMsg(arcMsgType.chat, message, playersender.name(), new Vec2(playersender.x, playersender.y)));
                return;
            }
            if (this.resolveServerMsg(message)) {
                return;
            }
        }
        MessageDialog.addMsg(new advanceMsg(arcMsgType.normal, message));
    }

    public boolean resolveMarkMsg(String message, @Nullable Player playersender) {
        if (message.contains("<ARC")) {
            if (message.contains("\u6807\u8bb0\u4e86") && message.contains("Wave")) {
                MessageDialog.addMsg(new advanceMsg(arcMsgType.markWave, message));
                return true;
            }
            if (message.contains("\u6807\u8bb0\u4e86") && message.contains("Content")) {
                MessageDialog.addMsg(new advanceMsg(arcMsgType.markContent, message));
                return true;
            }
            if (message.contains("<AT>")) {
                MessageDialog.addMsg(new advanceMsg(arcMsgType.markPlayer, message));
                if (message.substring(message.indexOf("AT")).contains(Vars.player.name)) {
                    if (playersender != null) {
                        Vars.ui.announce("[gold]\u4f60\u88ab[white] " + playersender.name + " [gold]\u6233\u4e86\u4e00\u4e0b\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u4fe1\u606f\u6846\u54e6~", 10.0f);
                    } else {
                        Vars.ui.announce("[orange]\u4f60\u88ab\u6233\u4e86\u4e00\u4e0b\uff0c\u8bf7\u6ce8\u610f\u67e5\u770b\u4fe1\u606f\u6846\u54e6~", 10.0f);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean resolveServerMsg(String message) {
        Seq<String> serverMsg = Seq.with("\u52a0\u5165\u4e86\u670d\u52a1\u5668", "\u79bb\u5f00\u4e86\u670d\u52a1\u5668", "\u81ea\u52a8\u5b58\u6863\u5b8c\u6210", "\u767b\u5f55\u6210\u529f", "\u7ecf\u9a8c+", "[YELLOW]\u672c\u5c40\u6e38\u620f\u65f6\u957f:", "[YELLOW]\u5355\u4eba\u5feb\u901f\u6295\u7968", "[GREEN]\u56de\u6863\u6210\u529f", "[YELLOW]PVP\u4fdd\u62a4\u65f6\u95f4, \u5168\u529b\u8fdb\u653b\u5427", "[YELLOW]\u53d1\u8d77", "[YELLOW]\u4f60\u53ef\u4ee5\u5728\u6295\u7968\u7ed3\u675f\u524d\u4f7f\u7528", "[GREEN]\u6295\u7968\u6210\u529f", "[GREEN]\u6362\u56fe\u6210\u529f,\u5f53\u524d\u5730\u56fe", "[RED]\u672c\u5730\u56fe\u7981\u7528\u5355\u4f4d", "[RED]\u8be5\u5730\u56fe\u9650\u5236\u7a7a\u519b,\u7981\u6b62\u8fdb\u5165\u654c\u65b9\u9886\u7a7a", "[yellow]\u672c\u5730\u56fe\u9650\u5236\u7a7a\u519b", "[YELLOW]\u706b\u7130\u8fc7\u591a\u9020\u6210\u670d\u52a1\u5668\u5361\u987f,\u81ea\u52a8\u5173\u95ed\u706b\u7130", " [GREEN]====", "[RED]\u65e0\u6548\u6307\u4ee4", "[RED]\u8be5\u6280\u80fd", "\u5207\u6362\u6210\u529f", "[violet][\u6295\u7968\u7cfb\u7edf][]", "[coral][-]\u91ce\u751f\u7684", "[CYAN][+]\u91ce\u751f\u7684");
        for (int i = 0; i < serverMsg.size; ++i) {
            if (!message.contains(serverMsg.get(i))) continue;
            MessageDialog.addMsg(new advanceMsg(arcMsgType.serverMsg, message));
            return true;
        }
        if (message.contains("\u5c0f\u8d34\u58eb")) {
            MessageDialog.addMsg(new advanceMsg(arcMsgType.serverTips, message));
            return true;
        }
        if (message.contains("[acid][\u516c\u5c4f][white]")) {
            MessageDialog.addMsg(new advanceMsg(arcMsgType.serverToast, message));
            return true;
        }
        if (message.contains("[YELLOW][\u6280\u80fd]")) {
            MessageDialog.addMsg(new advanceMsg(arcMsgType.serverSkill, message));
            return true;
        }
        return false;
    }

    public static void addMsg(advanceMsg msg) {
        msgList.add(msg);
    }

    private void clearMsg() {
        msgList.clear();
        this.msgInit = 0;
        this.msgFinal = 0;
    }

    private void limitMsg(int maxMsg) {
        while (MessageDialog.msgList.size >= maxMsg) {
            msgList.remove(0);
        }
        return;
    }

    void exportMsg() {
        StringBuilder messageHis = new StringBuilder();
        messageHis.append("\u4e0b\u9762\u662f[ARC").append(ARCVars.arcVersion).append("] \u5bfc\u51fa\u7684\u6e38\u620f\u5185\u804a\u5929\u8bb0\u5f55").append("\n");
        messageHis.append("*** \u5f53\u524d\u5730\u56fe\u540d\u79f0: ").append(Vars.state.map.name()).append("\uff08\u6a21\u5f0f\uff1a").append(Vars.state.rules.modeName).append("\uff09\n");
        messageHis.append("*** \u5f53\u524d\u6ce2\u6b21: ").append(Vars.state.wave).append("\n");
        StringBuilder messageLs = new StringBuilder();
        int messageCount = 0;
        for (int i = 0; i < MessageDialog.msgList.size; ++i) {
            String msg = MessageDialog.msgList.get((int)i).message;
            messageLs.insert(0, msg + "\n");
            ++messageCount;
        }
        messageHis.append("\u6210\u529f\u9009\u53d6\u5171 ").append(messageCount).append(" \u6761\u8bb0\u5f55\uff0c\u5982\u4e0b\uff1a\n");
        messageHis.append((CharSequence)messageLs);
        Core.app.setClipboardText(Strings.stripGlyphs(Strings.stripColors(messageHis.toString())));
    }

    public static class advanceMsg {
        public arcMsgType msgType;
        public String message;
        public Date time;
        public String sender;
        public boolean selected;
        public Vec2 msgLoc;

        public advanceMsg(arcMsgType msgType, String message, Date time, String sender, Vec2 msgLoc) {
            this.msgType = msgType;
            this.message = message;
            this.time = time;
            this.sender = sender;
            this.msgLoc = new Vec2().set(msgLoc);
        }

        public advanceMsg(arcMsgType msgType, String message, String sender, Vec2 msgLoc) {
            this(msgType, message, new Date(), sender, msgLoc);
        }

        public advanceMsg(arcMsgType msgType, String message, Vec2 msgLoc) {
            this(msgType, message, "null", msgLoc);
        }

        public advanceMsg(arcMsgType msgType, String message) {
            this(msgType, message, new Vec2(-1.0f, -1.0f));
        }
    }

    public static enum arcMsgType {
        normal("\u6d88\u606f", Color.gray),
        chat("\u804a\u5929", Color.valueOf("#778899")),
        console("\u6307\u4ee4", Color.gold),
        markLoc("\u6807\u8bb0", "\u5750\u6807", Color.valueOf("#7FFFD4")),
        markWave("\u6807\u8bb0", "\u6ce2\u6b21", Color.valueOf("#7FFFD4")),
        markContent("\u6807\u8bb0", "\u5185\u5bb9", Color.valueOf("#7FFFD4")),
        markPlayer("\u6807\u8bb0", "\u73a9\u5bb6", Color.valueOf("#7FFFD4")),
        arcChatPicture("\u5206\u4eab", "\u56fe\u7247", Color.yellow),
        music("\u5206\u4eab", "\u97f3\u4e50", Color.pink),
        schematic("\u5206\u4eab", "\u84dd\u56fe", Color.blue),
        district("\u89c4\u5212\u533a", "", Color.violet),
        serverTips("\u670d\u52a1\u5668", "\u5c0f\u8d34\u58eb", Color.valueOf("#98FB98"), false),
        serverMsg("\u670d\u52a1\u5668", "\u4fe1\u606f", Color.valueOf("#cefdce")),
        serverToast("\u670d\u52a1\u5668", "\u901a\u62a5", Color.valueOf("#00FA9A")),
        serverSkill("\u670d\u52a1\u5668", "\u6280\u80fd", Color.valueOf("#e6ffcc")),
        logicNotify("\u903b\u8f91", "\u901a\u62a5", Color.valueOf("#ffccff")),
        logicAnnounce("\u903b\u8f91", "\u516c\u544a", Color.valueOf("#ffccff")),
        eventWorldLoad("\u4e8b\u4ef6", "\u8f7d\u5165\u5730\u56fe", Color.valueOf("#ff9999")),
        eventCoreDestory("\u4e8b\u4ef6", "\u6838\u5fc3\u6467\u6bc1", Color.valueOf("#ffcccc")),
        eventWave("\u4e8b\u4ef6", "\u6ce2\u6b21", Color.valueOf("#ffcc99"));

        public String name;
        public String type;
        public String subClass;
        public Color color = Color.gray;
        public Boolean show = true;

        private arcMsgType(String type, String subClass, Color color, Boolean show) {
            this.name = subClass == "" ? type : type + "~" + subClass;
            this.type = type;
            this.subClass = subClass;
            this.color = color;
            this.show = show;
        }

        private arcMsgType(String type, String subClass, Color color) {
            this(type, subClass, color, true);
        }

        private arcMsgType(String type, Color color) {
            this(type, "", color);
        }

        private arcMsgType(String type) {
            this(type, Color.gray);
        }

        private arcMsgType(String type, String subClass) {
            this(type, subClass, Color.gray);
        }

        public String arcMsgPreFix() {
            return "[#" + this.color.toString() + "][" + this.name + "][]";
        }
    }
}

