/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.dialogs;

import arc.func.Boolf;
import arc.func.Cons;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ui.AdvanceToolTable;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.meta.BlockGroup;

public class BlockSelectDialog
extends BaseDialog {
    private String searchBlock = "";
    private final Table blockTable = new Table();

    public BlockSelectDialog(Boolf<Block> condition, Cons<Block> cons, Boolf<Block> checked) {
        this(condition, cons, checked, true);
    }

    public BlockSelectDialog(Boolf<Block> condition, Cons<Block> cons, Boolf<Block> checked, boolean autoHide) {
        super("\u65b9\u5757\u9009\u62e9\u5668");
        this.rebuild(condition, cons, checked, autoHide);
        this.cont.pane((Table td) -> {
            td.field("", t -> {
                this.searchBlock = !t.isEmpty() ? t.toLowerCase() : "";
                this.rebuild(condition, cons, checked, autoHide);
            }).maxTextLength(50).growX().get().setMessageText("\u641c\u7d22...");
            td.row();
            td.add(this.blockTable);
        });
        this.addCloseButton();
    }

    private void rebuild(Boolf<Block> condition, Cons<Block> cons, Boolf<Block> checked, boolean autoHide) {
        this.blockTable.clear();
        this.blockTable.table((Table td) -> {
            Seq<Block> blocks = Vars.content.blocks().select(block -> !(!condition.get((Block)block) || !this.searchBlock.isEmpty() && !block.name.contains(this.searchBlock) && !block.localizedName.contains(this.searchBlock) || !block.privileged && !AdvanceToolTable.allBlocksReveal && block.isHidden())).sort(block -> block.group.ordinal());
            Seq<BlockGroup> blockGroups = blocks.map(block -> block.group).distinct();
            blockGroups.each(blockGroup -> {
                td.row();
                td.add(blockGroup.toString()).row();
                td.image().color(ARCVars.getThemeColor()).fillX().row();
                td.table((Table ttd) -> blocks.select(block1 -> block1.group == blockGroup).each(block1 -> {
                    ttd.button(new TextureRegionDrawable(block1.uiIcon), Styles.cleari, 24.0f, () -> {
                        cons.get((Block)block1);
                        if (autoHide) {
                            this.hide();
                        }
                    }).tooltip(block1.localizedName).pad(3.0f).checked(b -> checked.get((Block)block1)).size(50.0f);
                    if (ttd.getChildren().size % 10 == 0) {
                        ttd.row();
                    }
                }));
            });
        });
    }
}

