/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.dialogs;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.Button;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.service.Achievement;
import mindustry.service.SStat;
import mindustry.ui.BorderImage;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class AchievementsDialog
extends BaseDialog {
    private ObjectMap<String, TextureRegion> textureCache = new ObjectMap();
    private String searchTxt = "";
    private Table browserTable;
    private Table SStatTable;

    public AchievementsDialog() {
        super("ARC-\u7edf\u8ba1\u4e0e\u6210\u5c31");
        this.cont.pane((Table t) -> {
            this.SStatTable = t;
            t.row();
            this.browserTable = t;
        }).scrollX(false);
        this.addCloseButton();
        this.shown(this::rebuildBrowser);
        this.onResize(this::rebuildBrowser);
    }

    private void rebuildBrowser() {
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl(480.0f), 1.0f);
        this.SStatTable.clear();
        this.browserTable.clear();
        this.SStatTable.add("\u7edf\u8ba1").color(ARCVars.getThemeColor()).pad(cols / 2).center().row();
        this.SStatTable.image().color(ARCVars.getThemeColor()).fillX().row();
        this.SStatTable.table((Table t) -> {
            for (SStat stat : SStat.values()) {
                String name = Core.bundle.get("sstat." + stat.name() + ".name");
                t.add(name).left();
                if (stat.name() == "arcPlayTime") {
                    t.add("                 " + this.formatTime(stat.get())).left();
                } else {
                    t.add("                 " + stat.get()).left();
                }
                t.row();
            }
        });
        this.browserTable.row();
        this.browserTable.add("\u6210\u5c31").color(ARCVars.getThemeColor()).pad(cols / 2).center().row();
        this.browserTable.image().color(ARCVars.getThemeColor()).fillX().row();
        this.browserTable.table((Table t) -> {
            int i = 0;
            float s = 64.0f;
            for (final Achievement ach : Achievement.all) {
                String name = Core.bundle.get("achievement." + ach.name() + ".name");
                String desc = (ach.isAchieved() ? "[stat]" : "") + Core.bundle.get("achievement." + ach.name() + ".desc");
                t.button((Button con) -> {
                    con.setColor(ach.isAchieved() ? Pal.accent : Color.lightGray);
                    con.margin(0.0f);
                    con.left();
                    con.add(new BorderImage(){
                        TextureRegion last;
                        {
                            this.border(ach.isAchieved() ? Pal.accent : Color.lightGray);
                            this.setDrawable(Tex.nomap);
                            this.pad = Scl.scl(4.0f);
                        }

                        @Override
                        public void draw() {
                            super.draw();
                        }
                    }).size(s).pad(8.0f);
                    con.add("[accent]" + name + "\n[lightgray]" + desc).width(358.0f).wrap().grow().pad(4.0f, 2.0f, 4.0f, 6.0f).top().left().labelAlign(10);
                }, (Button.ButtonStyle)Styles.flatBordert, () -> {}).padRight(4.0f);
                if (++i % cols != 0) continue;
                t.row();
            }
        });
        this.browserTable.row();
        this.browserTable.table((Table t) -> {
            t.button("[red]\u91cd\u7f6e\u6210\u5c31", () -> Vars.ui.showConfirm("\u4f60\u786e\u5b9a\u8981\u91cd\u7f6e\u6240\u6709\u6210\u5c31\u5417", () -> {
                for (Achievement ach : Achievement.all) {
                    ach.removeAchieve();
                }
                ARCVars.arcui.arcInfo("\u5df2\u79fb\u9664\u6240\u6709\u6210\u5c31");
                this.rebuildBrowser();
            })).height(50.0f).width(200.0f);
            if (Core.settings.getBool("otherCheat")) {
                t.button("[red]\u4e00\u952e\u5b8c\u6210", () -> Vars.ui.showConfirm("\u4f60\u786e\u5b9a\u8981\u4e00\u952e\u5b8c\u6210\u6240\u6709\u6210\u5c31\u5417", () -> {
                    for (Achievement ach : Achievement.all) {
                        ach.complete();
                    }
                    ARCVars.arcui.arcInfo("\u5df2\u5b8c\u6210\u6240\u6709\u6210\u5c31");
                    this.rebuildBrowser();
                })).height(50.0f).width(200.0f);
            }
        });
    }

    private String formatTime(int time) {
        StringBuilder outTime = new StringBuilder();
        int h = time / 3600;
        int m = time / 60 % 60;
        int s = time % 60;
        outTime.append(h).append(" : ").append(m).append(" : ").append(s);
        return outTime.toString();
    }
}

