/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.Events;
import arc.scene.style.Drawable;
import arc.scene.ui.Dialog;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.content.StatusEffects;
import mindustry.core.UI;
import mindustry.editor.arcWaveInfoDialog;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.gen.Icon;
import mindustry.type.StatusEffect;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;

public class WaveInfoTable
extends BaseToolsTable {
    private float fontScl = 0.8f;
    private int waveOffset = 0;
    private Table waveInfo = new Table();
    private arcWaveInfoDialog arcWaveInfoDialog = new arcWaveInfoDialog();
    private int showWaves = 0;
    private final int maxWavesShow = 8;

    public WaveInfoTable() {
        super(Icon.waves);
        Events.on(EventType.WorldLoadEvent.class, e -> {
            this.waveOffset = 0;
            this.rebuildWaveInfo();
        });
        Events.on(EventType.WaveEvent.class, e -> this.rebuildWaveInfo());
    }

    @Override
    protected void setup() {
        this.button((Drawable)Icon.waves, RStyles.clearAccentNonei, () -> this.arcWaveInfoDialog.show()).size(40.0f).tooltip("\u6ce2\u6b21\u4fe1\u606f");
        this.table((Table buttons) -> {
            buttons.defaults().size(40.0f);
            buttons.button("<", RStyles.clearLineNonet, () -> {
                --this.waveOffset;
                if (Vars.state.wave + this.waveOffset - 1 < 0) {
                    this.waveOffset = -Vars.state.wave + 1;
                }
                this.rebuildWaveInfo();
            });
            buttons.button("O", RStyles.clearLineNonet, () -> {
                this.waveOffset = 0;
                this.rebuildWaveInfo();
            });
            buttons.button(">", RStyles.clearLineNonet, () -> {
                ++this.waveOffset;
                this.rebuildWaveInfo();
            });
            buttons.button("Go", RStyles.clearLineNonet, () -> {
                Vars.state.wave += this.waveOffset;
                this.waveOffset = 0;
                this.rebuildWaveInfo();
            });
            buttons.button("\u2650", RStyles.clearLineNonet, () -> {
                String message = RFuncs.arcShareWaveInfo(Vars.state.wave + this.waveOffset);
                int seperator = 145;
                int i = 0;
                while ((float)i < (float)message.length() / (float)seperator) {
                    RFuncs.shareString(message.substring(i * seperator, Math.min(message.length(), (i + 1) * seperator)));
                    ++i;
                }
            }).get().setDisabled(() -> !Vars.state.rules.waves && !Core.settings.getBool("arcShareWaveInfo"));
        }).left().row();
        this.table((Table setWave) -> {
            setWave.label(() -> "" + (Vars.state.wave + this.waveOffset)).get().setFontScale(this.fontScl);
            setWave.button("\u2227", Styles.cleart, () -> {
                this.showWaves = Math.min(this.showWaves + 5, Math.max(0, Vars.state.rules.spawns.size - 8));
                this.rebuildWaveInfo();
            }).size(30.0f);
            setWave.row();
            setWave.button(Icon.settingsSmall, RStyles.clearAccentNonei, 30.0f, () -> {
                BaseDialog lsSet = new BaseDialog("\u6ce2\u6b21\u8bbe\u5b9a");
                lsSet.cont.add("\u8bbe\u5b9a\u67e5\u8be2\u6ce2\u6b21").padRight(5.0f).left();
                TextField field = lsSet.cont.field(Vars.state.wave + this.waveOffset + "", text -> {
                    this.waveOffset = Integer.parseInt(text) - Vars.state.wave;
                }).size(320.0f, 54.0f).valid(Strings::canParsePositiveInt).maxTextLength(100).get();
                lsSet.cont.row();
                lsSet.cont.slider(1.0f, new arcWaveInfoDialog().calWinWave(), 1.0f, res -> {
                    this.waveOffset = (int)res - Vars.state.wave;
                    field.setText((int)res + "");
                });
                ((Dialog)lsSet).addCloseButton();
                lsSet.show();
            });
            setWave.button("\u2228", Styles.cleart, () -> {
                this.showWaves = Math.max(0, this.showWaves - 5);
                this.rebuildWaveInfo();
            }).size(30.0f);
        });
        this.add(this.waveInfo).left();
    }

    private void rebuildWaveInfo() {
        this.waveInfo.clear();
        this.waveInfo.table((Table wt) -> {
            int waveIndex = 0;
            int curInfoWave = Vars.state.wave - 1 + this.waveOffset;
            for (SpawnGroup group : Vars.state.rules.spawns) {
                int amount = group.getSpawned(curInfoWave);
                if (amount <= 0 || ++waveIndex < this.showWaves || waveIndex >= this.showWaves + 8) continue;
                float shield = group.getShield(curInfoWave);
                StatusEffect effect = group.effect;
                wt.table((Table groupT) -> {
                    groupT.image(group.type.uiIcon).size(20.0f).row();
                    groupT.add((CharSequence)("" + amount), this.fontScl).center().row();
                    groupT.add((CharSequence)(shield > 0.0f ? UI.formatAmount((long)shield) : ""), this.fontScl).center().row();
                    if (effect != null && effect != StatusEffects.none) {
                        groupT.image(effect.uiIcon).size(20.0f);
                    }
                }).padLeft(4.0f).top();
            }
        }).maxWidth(300.0f);
    }
}

