/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.layout.Cell;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ElementUtils;
import mindustry.arcModule.Marker;
import mindustry.arcModule.player.AutoFill;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.UnitTypes;
import mindustry.gen.Icon;
import mindustry.input.DesktopInput;
import mindustry.ui.dialogs.EffectsDialog;

public class ScriptTable
extends BaseToolsTable {
    public ScriptTable() {
        super(UnitTypes.gamma.uiIcon);
    }

    @Override
    protected void setup() {
        this.defaults().size(40.0f);
        this.scriptButton(Blocks.buildTower.uiIcon, "\u5728\u5efa\u9020\u5217\u8868\u52a0\u5165\u88ab\u6467\u6bc1\u5efa\u7b51", () -> Vars.player.buildDestroyedBlocks());
        this.scriptButton(Blocks.message.uiIcon, "\u9501\u5b9a\u4e0a\u4e2a\u6807\u8bb0\u70b9", Marker::lockonLastMark);
        this.scriptButton((Drawable)Icon.modeAttack, "\u81ea\u52a8\u653b\u51fb", () -> {
            boolean at = Core.settings.getBool("autotarget");
            Core.settings.put("autotarget", !at);
            ARCVars.arcui.arcInfo("\u5df2" + (at ? "\u5173\u95ed" : "\u5f00\u542f") + "\u81ea\u52a8\u653b\u51fb");
        }, (ImageButton b) -> Core.settings.getBool("autotarget"));
        this.scriptButton(UnitTypes.vela.uiIcon, "\u5f3a\u5236\u52a9\u63a8", () -> {
            boolean ab = Core.settings.getBool("forceBoost");
            Core.settings.put("forceBoost", !ab);
            ARCVars.arcui.arcInfo("\u5df2" + (ab ? "\u5173\u95ed" : "\u5f00\u542f") + "\u5f3a\u5236\u52a9\u63a8");
        }, (ImageButton b) -> Core.settings.getBool("forceBoost"));
        if (!Vars.mobile) {
            this.scriptButton((Drawable)Icon.eyeSmall, "\u53d6\u6d88\u8ffd\u8e2a", () -> {
                boolean ab = Core.settings.getBool("removePan");
                if (Vars.control.input instanceof DesktopInput) {
                    ((DesktopInput)Vars.control.input).panning = true;
                }
                Core.settings.put("removePan", !ab);
                ARCVars.arcui.arcInfo("\u5df2" + (ab ? "\u53d6\u6d88" : "\u5f00\u542f") + "\u5f3a\u5236\u8ffd\u8e2a\u63a7\u5236\u5355\u4f4d");
            }, (ImageButton b) -> Core.settings.getBool("removePan"));
        }
        AutoFill.INSTANCE.interval = 500L;
        this.scriptButton(Items.copper.uiIcon, "\u4e00\u952e\u653e\u7f6e", () -> {
            boolean af = Core.settings.getBool("autoFill");
            Core.settings.put("autoFill", !af);
            ARCVars.arcui.arcInfo("\u5df2" + (af ? "\u5173\u95ed" : "\u5f00\u542f") + "\u4e00\u952e\u653e\u7f6e");
        }, (ImageButton b) -> Core.settings.getBool("autoFill"));
        this.scriptButton(Icon.pencilSmall.getRegion(), "\u7279\u6548\u663e\u793a", () -> EffectsDialog.withAllEffects().show());
    }

    private void scriptButton(Drawable region, String describe, Runnable runnable, Boolf<ImageButton> checked) {
        this.scriptButton(region, RStyles.clearLineNoneTogglei, describe, runnable).checked(checked);
    }

    private void scriptButton(TextureRegion region, String describe, Runnable runnable, Boolf<ImageButton> checked) {
        this.scriptButton((Drawable)new TextureRegionDrawable(region), RStyles.clearLineNoneTogglei, describe, runnable).checked(checked);
    }

    private Cell<ImageButton> scriptButton(TextureRegion region, String describe, Runnable runnable) {
        return this.scriptButton((Drawable)new TextureRegionDrawable(region), RStyles.clearLineNonei, describe, runnable);
    }

    private Cell<ImageButton> scriptButton(Drawable icon, ImageButton.ImageButtonStyle style, String describe, Runnable runnable) {
        Cell<ImageButton> cell = this.button(icon, style, 30.0f, runnable);
        ElementUtils.tooltip(cell.get(), describe);
        return cell;
    }
}

