/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import mindustry.Vars;
import mindustry.arcModule.ElementUtils;
import mindustry.arcModule.toolpack.arcScanner;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.Icon;

public class MobileToolTable
extends BaseToolsTable {
    public MobileToolTable() {
        super(UnitTypes.emanate.uiIcon);
        if (Vars.mobile) {
            this.toggle();
        }
    }

    @Override
    protected void setup() {
        this.defaults().size(40.0f);
        this.toolButton(Icon.unitsSmall, "\u6307\u6325\u6a21\u5f0f", () -> {
            Vars.control.input.commandMode = !Vars.control.input.commandMode;
        }, (ImageButton b) -> Vars.control.input.commandMode);
        this.toolButton(Icon.pause, "\u6682\u505c\u5efa\u9020", () -> {
            Vars.control.input.isBuilding = !Vars.control.input.isBuilding;
        }, (ImageButton b) -> Vars.control.input.isBuilding);
        this.toolButton(StatusEffects.unmoving.uiIcon, "\u539f\u5730\u9759\u6b62", () -> {
            boolean view = Core.settings.getBool("viewMode");
            if (view) {
                Core.camera.position.set(Vars.player);
            }
            Core.settings.put("viewMode", !view);
        }, (ImageButton b) -> Core.settings.getBool("viewMode"));
        this.toolButton(Icon.up, "\u6361\u8d77\u8f7d\u8377", () -> Vars.control.input.tryPickupPayload());
        this.toolButton(Icon.down, "\u4e22\u4e0b\u8f7d\u8377", () -> Vars.control.input.tryDropPayload());
        this.toolButton(Blocks.payloadConveyor.uiIcon, "\u8fdb\u5165\u4f20\u9001\u5e26", () -> {
            Building build = Vars.world.buildWorld(Vars.player.unit().x, Vars.player.unit().y);
            if (build != null && Vars.player.unit().team() == build.team && build.canControlSelect(Vars.player.unit())) {
                Call.unitBuildingControlSelect(Vars.player.unit(), build);
            }
        });
        this.toolButton(Blocks.radar.uiIcon, "\u96f7\u8fbe\u626b\u63cf", () -> {
            arcScanner.mobileRadar = !arcScanner.mobileRadar;
        });
    }

    private void toolButton(TextureRegion region, String describe, Runnable runnable) {
        this.toolButton(new TextureRegionDrawable(region), describe, runnable);
    }

    private void toolButton(Drawable icon, String describe, Runnable runnable) {
        ImageButton button = this.button(icon, RStyles.clearAccentNonei, 30.0f, runnable).get();
        ElementUtils.tooltip(button, describe);
    }

    private void toolButton(TextureRegion region, String describe, Runnable runnable, Boolf<ImageButton> checked) {
        this.toolButton(new TextureRegionDrawable(region), describe, runnable, checked);
    }

    private void toolButton(Drawable icon, String describe, Runnable runnable, Boolf<ImageButton> checked) {
        ImageButton button = this.button(icon, RStyles.clearLineNoneTogglei, 30.0f, runnable).checked(checked).get();
        ElementUtils.tooltip(button, describe);
    }
}

