/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.scene.style.Drawable;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.content.Items;
import mindustry.editor.MapInfoDialog;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;

public class MapInfoTable
extends BaseToolsTable {
    private final MapInfoDialog mapInfoDialog = new MapInfoDialog();
    private int uiRowIndex = 0;

    public MapInfoTable() {
        super(Icon.map);
    }

    @Override
    protected void setup() {
        this.defaults().size(40.0f);
        this.button((Drawable)Icon.map, RStyles.clearAccentNonei, this.mapInfoDialog::show).tooltip("\u5730\u56fe\u4fe1\u606f");
        this.button(Items.copper.emoji(), RStyles.clearLineNonet, this::floorStatisticDialog).tooltip("\u77ff\u7269\u4fe1\u606f");
        this.button((Drawable)Icon.chatSmall, RStyles.clearAccentNonei, () -> ARCVars.arcui.MessageDialog.show()).tooltip("\u4e2d\u592e\u76d1\u63a7\u5ba4");
        this.button((Drawable)Icon.playersSmall, RStyles.clearAccentNonei, () -> {
            if (Vars.ui.listfrag.players.size > 1) {
                if (Vars.control.input instanceof DesktopInput) {
                    ((DesktopInput)Vars.control.input).panning = true;
                }
                if (InputHandler.follow == null) {
                    InputHandler.follow = Vars.ui.listfrag.players.get(0);
                }
                InputHandler.followIndex = InputHandler.followIndex + 1 >= Vars.ui.listfrag.players.size ? 0 : InputHandler.followIndex + 1;
                InputHandler.follow = Vars.ui.listfrag.players.get(InputHandler.followIndex);
                ARCVars.arcui.arcInfo("\u89c6\u89d2\u8ffd\u8e2a\uff1a" + InputHandler.follow.name, 3.0f);
            }
        }).tooltip("\u5207\u6362\u8ddf\u8e2a\u73a9\u5bb6");
        this.button((Drawable)Icon.starSmall, RStyles.clearAccentNonei, ARCVars.arcui.achievements::show).tooltip("\u7edf\u8ba1\u4e0e\u6210\u5c31");
        if (!Vars.mobile) {
            this.button((Drawable)Icon.editSmall, RStyles.clearAccentNonei, this::uiTable).tooltip("ui\u5927\u5168");
        }
    }

    private void floorStatisticDialog() {
        BaseDialog dialog = new BaseDialog("ARC-\u77ff\u7269\u7edf\u8ba1");
        Table table = dialog.cont;
        table.clear();
        table.table((Table c) -> {
            c.add("\u5730\u8868\u77ff").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table list) -> {
                int i = 0;
                for (Block block : Vars.content.blocks().select(b -> {
                    if (!(b instanceof Floor)) return false;
                    Floor f = (Floor)b;
                    if (f.wallOre) return false;
                    if (f.itemDrop == null) return false;
                    return true;
                })) {
                    if (Vars.indexer.floorOresCount[block.id] == 0) continue;
                    if (i++ % 4 == 0) {
                        list.row();
                    }
                    list.add(block.emoji() + " " + block.localizedName + "\n" + Vars.indexer.floorOresCount[block.id]).width(100.0f).height(50.0f);
                }
            }).row();
            c.add("\u5899\u77ff").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table list) -> {
                int i = 0;
                for (Block block : Vars.content.blocks().select(b -> {
                    block3: {
                        block2: {
                            if (!(b instanceof Floor)) break block2;
                            Floor f = (Floor)b;
                            if (f.wallOre) break block3;
                        }
                        if (!(b instanceof StaticWall)) return false;
                    }
                    if (b.itemDrop == null) return false;
                    return true;
                })) {
                    if (Vars.indexer.wallOresCount[block.id] == 0) continue;
                    if (i++ % 4 == 0) {
                        list.row();
                    }
                    list.add(block.emoji() + " " + block.localizedName + "\n" + Vars.indexer.wallOresCount[block.id]).width(100.0f).height(50.0f);
                }
            }).row();
            c.add("\u6db2\u4f53").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table list) -> {
                int i = 0;
                for (Block block : Vars.content.blocks().select(b -> {
                    if (!(b instanceof Floor)) return false;
                    Floor f = (Floor)b;
                    if (f.liquidDrop == null) return false;
                    return true;
                })) {
                    if (Vars.indexer.floorOresCount[block.id] == 0) continue;
                    if (i++ % 4 == 0) {
                        list.row();
                    }
                    list.add(block.emoji() + " " + block.localizedName + "\n" + Vars.indexer.floorOresCount[block.id]).width(100.0f).height(50.0f);
                }
            }).row();
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void uiTable() {
        BaseDialog dialog = new BaseDialog("ARC-ui\u5927\u5168");
        this.uiRowIndex = 0;
        TextField sField = dialog.cont.field("", text -> {}).fillX().get();
        dialog.cont.row();
        dialog.cont.pane((Table c) -> {
            c.add("\u989c\u8272").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table ct) -> {
                for (ObjectMap.Entry entry : Colors.getColors()) {
                    Color value = (Color)entry.value;
                    String key = (String)entry.key;
                    ct.button("[#" + value + "]" + key, Styles.cleart, () -> {
                        Core.app.setClipboardText("[#" + value + "]");
                        sField.setText(sField.getText() + "[#" + value + "]");
                    }).size(50.0f).tooltip(key);
                    ++this.uiRowIndex;
                    if (this.uiRowIndex % 15 != 0) continue;
                    ct.row();
                }
            }).row();
            c.add("\u7269\u54c1").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table ct) -> {
                this.uiRowIndex = 0;
                Fonts.stringIcons.copy().each((name, iconc) -> {
                    ct.button((String)iconc, Styles.cleart, () -> {
                        Core.app.setClipboardText((String)iconc);
                        sField.setText(sField.getText() + iconc);
                    }).size(50.0f).tooltip((String)name);
                    ++this.uiRowIndex;
                    if (this.uiRowIndex % 15 == 0) {
                        ct.row();
                    }
                });
            }).row();
            c.add("\u56fe\u6807").color(ARCVars.getThemeColor()).center().fillX().row();
            c.image().color(ARCVars.getThemeColor()).fillX().row();
            c.table((Table ct) -> {
                this.uiRowIndex = 0;
                for (ObjectIntMap.Entry entry : Iconc.codes) {
                    String icon = String.valueOf((char)entry.value);
                    String internal = (String)entry.key;
                    ct.button(icon, Styles.cleart, () -> {
                        Core.app.setClipboardText(icon);
                        sField.setText(sField.getText() + icon);
                    }).size(50.0f).tooltip(internal);
                    ++this.uiRowIndex;
                    if (this.uiRowIndex % 15 != 0) continue;
                    ct.row();
                }
            }).row();
        }).row();
        dialog.addCloseButton();
        dialog.show();
    }
}

