/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.input.KeyCode;
import arc.scene.Element;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.InputEvent;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.arcModule.District;
import mindustry.arcModule.Marker;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.AIToolsTable;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.arcModule.ui.auxilliary.MapInfoTable;
import mindustry.arcModule.ui.auxilliary.MobileToolTable;
import mindustry.arcModule.ui.auxilliary.ScriptTable;
import mindustry.arcModule.ui.auxilliary.WaveInfoTable;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.ui.fragments.ChatFragment;

public class AuxilliaryTable
extends Table {
    private boolean show = true;
    private boolean showMark = true;
    public Marker.MarkType markType = Marker.mark;
    public Element mobileHitter = new Element();
    private final BaseToolsTable[] toolsTables = new BaseToolsTable[]{new MapInfoTable(), new WaveInfoTable(), new AIToolsTable(), new ScriptTable(), new MobileToolTable()};

    public AuxilliaryTable() {
        this.setup();
        this.rebuild();
        this.mobileHitter.addListener(new ElementGestureListener(20.0f, 0.4f, 1.0f, 0.15f){

            @Override
            public boolean longPress(Element actor, float x, float y) {
                Marker.mark(AuxilliaryTable.this.markType, Core.input.mouseWorld());
                AuxilliaryTable.this.mobileHitter.remove();
                return true;
            }

            @Override
            public void fling(InputEvent event, float velocityX, float velocityY, KeyCode button) {
                AuxilliaryTable.this.mobileHitter.remove();
                Vars.ui.announce("[yellow]\u4f60\u5df2\u9000\u51fa\u6807\u8bb0\u6a21\u5f0f");
            }
        });
        this.mobileHitter.fillParent = true;
        if (!Vars.mobile) {
            this.update(() -> {
                if (Core.input.keyTap(Binding.point) && !Core.scene.hasField()) {
                    Marker.mark(this.markType, Core.input.mouseWorld());
                }
            });
        }
    }

    public void setup() {
        for (BaseToolsTable table : this.toolsTables) {
            table.setup();
        }
    }

    public void toggle() {
        this.show = !this.show;
        this.rebuild();
    }

    void rebuild() {
        this.clear();
        this.table(Styles.black3, buttons -> {
            buttons.button("[acid]\u8f85\u52a9\u5668", RStyles.clearLineNoneTogglet, this::toggle).size(80.0f, 40.0f).tooltip((this.show ? "\u5173\u95ed" : "\u5f00\u542f") + "\u8f85\u52a9\u5668");
            if (this.show) {
                for (BaseToolsTable table : this.toolsTables) {
                    table.addButton((Table)buttons);
                }
                buttons.button("\u2650", RStyles.clearLineNoneTogglet, () -> {
                    this.showMark = !this.showMark;
                    this.rebuild();
                }).checked(this.showMark).size(40.0f, 40.0f).tooltip("\u6807\u8bb0");
            }
        }).fillX();
        this.row();
        if (this.show) {
            this.table(RStyles.black1, body -> {
                for (BaseToolsTable table : this.toolsTables) {
                    body.collapser(table, table::shown).padTop(3.0f).left().row();
                }
                if (this.showMark) {
                    body.table((Table t) -> {
                        if (Vars.mobile) {
                            t.button("\u2650 >", RStyles.clearLineNonet, () -> {
                                Vars.ui.hudGroup.addChild(this.mobileHitter);
                                Vars.ui.announce("[cyan]\u4f60\u5df2\u8fdb\u5165\u6807\u8bb0\u6a21\u5f0f,\u957f\u6309\u5c4f\u5e55\u53ef\u8fdb\u884c\u4e00\u6b21\u6807\u8bb0(\u5916\u5212\u53ef\u4ee5\u9000\u51fa).");
                            }).height(40.0f).width(70.0f).tooltip("\u5f00\u542f\u624b\u673a\u6807\u8bb0");
                        }
                        for (Marker.MarkType type : Marker.markTypes) {
                            t.button(type.tinyName(), RStyles.clearLineNoneTogglet, () -> {
                                this.markType = type;
                            }).checked(b -> this.markType == type).size(40.0f).tooltip(type.describe);
                        }
                        t.button("D", RStyles.clearLineNoneTogglet, District::unitSpawnMenu).checked(b -> false).size(40.0f).tooltip("\u533a\u57df\u89c4\u5212\u5668");
                        t.button("T", RStyles.clearLineNoneTogglet, () -> Vars.ui.chatfrag.nextMode()).checked(b -> Vars.ui.chatfrag.mode == ChatFragment.ChatMode.team).size(40.0f).tooltip("\u524d\u7f00\u6dfb\u52a0/t");
                    }).left();
                }
            }).fillX().left();
        }
    }
}

