/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui.auxilliary;

import arc.Core;
import arc.Events;
import arc.graphics.g2d.TextureRegion;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.ai.types.DefenderAI;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ElementUtils;
import mindustry.arcModule.ai.ArcBuilderAI;
import mindustry.arcModule.ai.ArcMinerAI;
import mindustry.arcModule.ai.ArcRepairAI;
import mindustry.arcModule.toolpack.arcPlayerEffect;
import mindustry.arcModule.ui.RStyles;
import mindustry.arcModule.ui.auxilliary.BaseToolsTable;
import mindustry.content.UnitTypes;
import mindustry.entities.units.AIController;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;

public class AIToolsTable
extends BaseToolsTable {
    private AIController selectAI;

    public AIToolsTable() {
        super(Icon.android);
        Events.run((Object)EventType.Trigger.update, () -> {
            if (this.selectAI != null) {
                this.selectAI.unit(Vars.player.unit());
                this.selectAI.updateUnit();
            }
        });
    }

    @Override
    public void setup() {
        this.clear();
        this.button(Icon.settingsSmall, RStyles.clearLineNoneTogglei, 30.0f, this::arcAISettingDialog).checked(t -> false);
        this.aiButton(new ArcMinerAI(), UnitTypes.mono.region, "\u77ff\u673aAI");
        this.aiButton(new ArcBuilderAI(), UnitTypes.poly.region, "\u91cd\u5efaAI");
        this.aiButton(new ArcRepairAI(), UnitTypes.mega.region, "\u4fee\u590dAI");
        this.aiButton(new DefenderAI(), UnitTypes.oct.region, "\u4fdd\u62a4AI");
        if (Core.settings.getBool("vipMode")) {
            this.button((Drawable)Icon.spray1Small, RStyles.clearLineNoneTogglei, arcPlayerEffect::arcPlayerEffectSetting).checked(t -> false);
        }
    }

    private void aiButton(AIController ai, TextureRegion textureRegion, String describe) {
        ImageButton button = this.button(new TextureRegionDrawable(textureRegion), RStyles.clearLineNoneTogglei, 30.0f, () -> this.selectAI(ai)).checked(b -> this.selectAI == ai).size(40.0f).get();
        ElementUtils.tooltip(button, describe);
    }

    private void selectAI(AIController ai) {
        this.selectAI = this.selectAI == ai ? null : ai;
    }

    private void arcAISettingDialog() {
        int cols = (int)Math.max((float)Core.graphics.getWidth() / Scl.scl(480.0f), 1.0f);
        BaseDialog dialog = new BaseDialog("ARC-AI\u8bbe\u5b9a\u5668");
        dialog.cont.table((Table t) -> {
            t.add("minerAI-\u77ff\u7269\u7b5b\u9009\u5668").color(ARCVars.getThemeColor()).pad((float)cols / 2.0f).center().row();
            t.image().color(ARCVars.getThemeColor()).fillX().row();
            t.table((Table c) -> {
                c.add("\u5730\u8868\u77ff").row();
                c.table((Table list) -> {
                    int i = 0;
                    for (Block block : ArcMinerAI.oreAllList) {
                        if (Vars.indexer.floorOresCount[block.id] == 0) continue;
                        if (i++ % 3 == 0) {
                            list.row();
                        }
                        list.button(block.emoji() + "\n" + Vars.indexer.floorOresCount[block.id], Styles.flatToggleMenut, () -> {
                            if (ArcMinerAI.oreList.contains(block)) {
                                ArcMinerAI.oreList.remove(block);
                            } else if (!ArcMinerAI.oreList.contains(block)) {
                                ArcMinerAI.oreList.add(block);
                            }
                        }).tooltip(block.localizedName).checked(k -> ArcMinerAI.oreList.contains(block)).width(100.0f).height(50.0f);
                    }
                }).row();
                c.add("\u5899\u77ff").row();
                c.table((Table list) -> {
                    int i = 0;
                    for (Block block : ArcMinerAI.oreAllWallList) {
                        if (Vars.indexer.wallOresCount[block.id] == 0) continue;
                        if (i++ % 3 == 0) {
                            list.row();
                        }
                        list.button(block.emoji() + "\n" + Vars.indexer.wallOresCount[block.id], Styles.flatToggleMenut, () -> {
                            if (ArcMinerAI.oreWallList.contains(block)) {
                                ArcMinerAI.oreWallList.remove(block);
                            } else if (!ArcMinerAI.oreWallList.contains(block)) {
                                ArcMinerAI.oreWallList.add(block);
                            }
                        }).tooltip(block.localizedName).checked(k -> ArcMinerAI.oreWallList.contains(block)).width(100.0f).height(50.0f);
                    }
                }).row();
            }).growX();
        }).growX();
        dialog.cont.row();
        dialog.cont.table((Table t) -> {
            t.add("builderAI").color(ARCVars.getThemeColor()).pad((float)cols / 2.0f).center().row();
            t.image().color(ARCVars.getThemeColor()).fillX().row();
            t.table((Table tt) -> {
                tt.add("\u91cd\u5efa\u51b7\u5374\u65f6\u95f4: ");
                TextField sField = tt.field(ArcBuilderAI.rebuildTime + "", text -> {
                    ArcBuilderAI.rebuildTime = Math.max(5.0f, Float.parseFloat(text));
                    this.setup();
                }).valid(Strings::canParsePositiveFloat).width(200.0f).get();
                tt.slider(5.0f, 200.0f, 5.0f, i -> {
                    ArcBuilderAI.rebuildTime = i;
                    sField.setText(ArcBuilderAI.rebuildTime + "");
                }).width(200.0f);
            }).growX();
        }).growX();
        dialog.addCloseButton();
        dialog.show();
    }
}

