/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.audio.Music;
import arc.graphics.Color;
import arc.graphics.Texture;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Image;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.Log;
import arc.util.Scaling;
import mindustry.Vars;
import mindustry.core.GameState;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class XiBao {
    static Music music = new Music();
    static boolean hasMusic = false;
    static TextureRegionDrawable cached;

    public void show(String tt, String text) {
        Vars.net.reset();
        Vars.state.set(GameState.State.paused);
        music.stop();
        Group root = Core.scene.root;
        WidgetGroup trans = new WidgetGroup();
        Image img = new Image((Drawable)XiBao.get(), Scaling.stretch);
        trans.addChild(img);
        img.setFillParent(true);
        Label label = new Label("\u4f60\u88ab\u8e22\u51fa\u4e86\u670d\u52a1\u5668\uff01", new Label.LabelStyle(Fonts.outline, Color.gold));
        trans.addChild(label);
        label.update(() -> {
            label.setPosition((trans.getWidth() - label.getPrefWidth()) / 2.0f, (trans.getHeight() - label.getPrefHeight()) * 0.77f);
            label.setFontScale(Math.max(trans.getHeight() * 0.006f, 1.0E-5f));
        });
        trans.addChild(new Table(t -> {
            t.setFillParent(true);
            t.table(t2 -> {
                t2.setBackground(Styles.black3);
                t2.table(t3 -> t3.add(tt).left()).row();
                t2.table(t3 -> t3.add(text)).left().minWidth(200.0f).row();
                t2.button("@ok", () -> {
                    Vars.logic.reset();
                    trans.touchable = Touchable.disabled;
                    trans.update(() -> music.setVolume(trans.color.a));
                    Action[] actionArray = new Action[3];
                    actionArray[0] = Actions.alpha(0.0f, 0.6f);
                    actionArray[1] = Actions.run(music::stop);
                    actionArray[2] = Actions.remove();
                    trans.actions(actionArray);
                }).size(110.0f, 50.0f).pad(4.0f);
            }).pad(10.0f).get().pack();
            t.marginTop(20.0f);
        }));
        trans.setTransform(true);
        trans.touchable = Touchable.enabled;
        trans.setScale(1.0E-5f);
        trans.actions(Actions.scaleTo(1.0f, 1.0f, 3.0f));
        trans.update(() -> {
            float scale = 1.0f - trans.scaleX;
            trans.setPosition((float)Core.graphics.getWidth() / 2.0f * scale, (float)Core.graphics.getHeight() / 2.0f * scale);
            if (scale == 0.0f) {
                trans.update(null);
            }
        });
        if (hasMusic) {
            music.setVolume(Core.settings.getInt("arcvol"));
            music.setPosition(0.0f);
            music.play();
        }
        ((Element)trans).setFillParent(true);
        root.addChild(trans);
    }

    public static TextureRegionDrawable get() {
        if (cached != null) {
            return cached;
        }
        cached = new TextureRegionDrawable(new TextureRegion(new Texture(Core.files.internal("icons/xibao.png"))));
        try {
            music.load(Core.files.internal("music/haoyunlai.ogg"));
            hasMusic = true;
        }
        catch (Exception e) {
            Log.err(e);
        }
        return cached;
    }
}

