/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.func.Boolf;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectSet;
import arc.util.Interval;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.entities.Units;
import mindustry.type.Category;
import mindustry.type.Item;
import mindustry.type.ItemSeq;
import mindustry.type.ItemStack;
import mindustry.type.UnitType;
import mindustry.ui.CoreItemsDisplay;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.power.BeamNode;
import mindustry.world.blocks.power.PowerNode;
import mindustry.world.blocks.storage.CoreBlock;

public class RCoreItemsDisplay
extends CoreItemsDisplay {
    private Interval timer = new Interval();
    private Interval timer2 = new Interval();
    private final ObjectSet<Item> usedItems = new ObjectSet();
    private final ObjectSet<UnitType> usedUnits = new ObjectSet();
    private int[] updateItems;
    private int[] lastItems;
    private ItemSeq planItems;
    private CoreBlock.CoreBuild core;
    private int arccoreitems;
    private ObjectIntMap<Block> planBlock;
    private Boolf<Block> planBlockFilter;

    public RCoreItemsDisplay() {
        this.updateItems = new int[Vars.content.items().size];
        this.lastItems = new int[Vars.content.items().size];
        this.planItems = new ItemSeq();
        this.arccoreitems = -1;
        this.planBlock = new ObjectIntMap();
        this.planBlockFilter = b -> b.category != Category.distribution && b.category != Category.liquid && !(b instanceof PowerNode) && !(b instanceof BeamNode);
        this.arccoreitems = Core.settings.getInt("arccoreitems");
        this.rebuild();
    }

    @Override
    public void resetUsed() {
        this.usedItems.clear();
        this.usedUnits.clear();
        this.background(null);
    }

    public void updateItems() {
        if (this.core == null) {
            return;
        }
        for (Item item : Vars.content.items()) {
            if (this.lastItems != null) {
                this.updateItems[item.id] = this.core.items.get(item) - this.lastItems[item.id];
            }
            this.lastItems[item.id] = this.core.items.get(item);
        }
    }

    private ItemSeq updatePlanItems() {
        this.planItems = new ItemSeq();
        Vars.control.input.allPlans().each(plan -> {
            if (plan.block instanceof CoreBlock) {
                return;
            }
            for (ItemStack stack : plan.block.requirements) {
                int planAmount = (int)(plan.breaking ? -1.0f * Vars.state.rules.buildCostMultiplier * Vars.state.rules.deconstructRefundMultiplier * (float)stack.amount * plan.progress : Vars.state.rules.buildCostMultiplier * (float)stack.amount * (1.0f - plan.progress));
                this.planItems.add(stack.item, planAmount);
            }
        });
        return this.planItems;
    }

    void rebuild() {
        this.clear();
        if (this.usedItems.size > 0 || this.usedUnits.size > 0) {
            this.background(Styles.black3);
            this.margin(4.0f);
        }
        this.update(() -> {
            this.core = Vars.player.team().core();
            if (this.timer.get(60.0f)) {
                this.updateItems();
            }
            this.updatePlanItems();
            if (this.arccoreitems != Core.settings.getInt("arccoreitems")) {
                this.arccoreitems = Core.settings.getInt("arccoreitems");
                this.rebuild();
            }
            if (Vars.content.items().contains((Item)((Object)((Boolf<Item>)item -> this.core != null && this.core.items.get((Item)item) > 0 && this.usedItems.add((Item)item))))) {
                this.rebuild();
            }
            if (Vars.content.items().contains((Item)((Object)((Boolf<Item>)item -> this.core != null && this.core.items.get((Item)item) > 0 && this.usedItems.add((Item)item)))) || Vars.content.units().contains((UnitType)((Object)((Boolf<UnitType>)unit -> Vars.player.team().data().countType((UnitType)unit) > 0 && this.usedUnits.add((UnitType)unit))))) {
                this.rebuild();
            }
            if (this.timer2.get(2.0f)) {
                this.rebuild();
            }
            this.touchable = Touchable.disabled;
        });
        int i = 0;
        if (this.arccoreitems == 1 || this.arccoreitems == 3) {
            for (Item item : Vars.content.items()) {
                if (!this.usedItems.contains(item)) continue;
                if (Vars.mobile) {
                    this.stack(new Table(t -> t.image(item.uiIcon).size(24.0f).padRight(3.0f).tooltip(tooltip -> tooltip.background(Styles.black6).margin(4.0f).add(item.localizedName).style(Styles.outlineLabel))), new Table(t -> t.label(() -> {
                        int update = this.updateItems[item.id];
                        if (update == 0) {
                            return "";
                        }
                        return (update < 0 ? "[red]" : "[green]+") + update;
                    }).get().setFontScale(0.85f)).top().left());
                } else {
                    this.stack(new Table(t -> t.image(item.uiIcon).size(24.0f).padRight(3.0f).tooltip(tooltip -> tooltip.background(Styles.black6).margin(4.0f).add(item.localizedName).style(Styles.outlineLabel))), new Table(t -> t.label(() -> {
                        int update = this.updateItems[item.id];
                        if (update == 0) {
                            return "";
                        }
                        return (update < 0 ? "[red]" : "[green]+") + update;
                    }).get().setFontScale(0.85f)).top().left());
                }
                this.label(() -> {
                    String planColor;
                    if (this.core == null) {
                        return "";
                    }
                    int planAmount = this.planItems.get(item);
                    int amount = this.core.items.get(item);
                    if (planAmount == 0) {
                        return ((double)amount >= (double)Vars.player.team().core().storageCapacity * 0.99 ? "[stat]" : "") + UI.formatAmount(amount);
                    }
                    String string = planColor = planAmount > 0 ? "[scarlet]" : "[green]";
                    String amountColor = amount < planAmount / 2 ? "[scarlet]" : (amount < planAmount ? "[stat]" : "[green]");
                    return amountColor + UI.formatAmount(amount) + "[white]/" + planColor + UI.formatAmount(Math.abs(planAmount));
                }).padRight(3.0f).minWidth(52.0f).left();
                if (++i % Core.settings.getInt("arcCoreItemsCol") != 0) continue;
                this.row();
            }
        }
        if (this.arccoreitems == 2 || this.arccoreitems == 3) {
            this.row();
            i = 0;
            for (UnitType unit : Vars.content.units()) {
                if (!this.usedUnits.contains(unit)) continue;
                this.image(unit.uiIcon).size(24.0f).padRight(3.0f).tooltip(t -> t.background(Styles.black6).margin(4.0f).add(unit.localizedName).style(Styles.outlineLabel));
                this.label(() -> {
                    int typeCount = Vars.player.team().data().countType(unit);
                    return (typeCount == Units.getCap(Vars.player.team()) ? "[stat]" : "") + typeCount;
                }).padRight(3.0f).minWidth(52.0f).left();
                if (++i % Core.settings.getInt("arcCoreItemsCol") != 0) continue;
                this.row();
            }
        }
        i = 0;
        this.row();
        this.planBlock.clear();
        Vars.control.input.allPlans().each(p -> this.planBlock.put(p.block, this.planBlock.get(p.block, 0) + (p.breaking ? -1 : 1)));
        for (Block block : Vars.content.blocks().select(this.planBlockFilter)) {
            int count = this.planBlock.get(block, 0);
            if (count == 0) continue;
            this.image(block.uiIcon).size(32.0f).padRight(3.0f);
            this.label(() -> (count > 0 ? "[green]+" : "[red]") + count).padRight(3.0f).minWidth(52.0f).left();
            if (++i % Core.settings.getInt("arcCoreItemsCol") != 0) continue;
            this.row();
        }
    }

    public boolean hadItem(Item item) {
        return this.usedItems.contains(item);
    }
}

