/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.Events;
import arc.input.KeyBind;
import arc.input.KeyCode;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.RStyles;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.gen.BlockUnitc;
import mindustry.gen.Unit;
import mindustry.input.Binding;

public class QuickCameraTable
extends Table {
    private static int quickHudSize = Core.settings.getInt("quickHudSize", 0);
    private static SingleHud[] hudList = new SingleHud[10];
    boolean hoverMode = Core.settings.getBool("arcCameraHoverMode", false);
    boolean saveScale = Core.settings.getBool("arcCameraSaveScale", true);
    KeyBind[] cameraSelect = new KeyBind[]{Binding.camera_select_01, Binding.camera_select_02, Binding.camera_select_03, Binding.camera_select_04, Binding.camera_select_05, Binding.camera_select_06, Binding.camera_select_07, Binding.camera_select_08, Binding.camera_select_09, Binding.camera_select_10};

    private void init() {
        if (quickHudSize == 0) {
            return;
        }
        hudList = new SingleHud[quickHudSize];
        for (int i = 0; i < quickHudSize; ++i) {
            QuickCameraTable.hudList[i] = new SingleHud();
        }
        this.rebuild();
    }

    public QuickCameraTable() {
        this.init();
        Events.on(EventType.WorldLoadEvent.class, event -> this.init());
        Events.run((Object)EventType.Trigger.update, () -> {
            if (quickHudSize != Core.settings.getInt("quickHudSize", 0)) {
                quickHudSize = Core.settings.getInt("quickHudSize", 0);
                this.init();
            }
            if (quickHudSize == 0) {
                return;
            }
            if (!hudList[0].isValid() && Vars.player.unit() != null) {
                QuickCameraTable.hudList[0] = new SingleHud(Vars.player.unit());
                QuickCameraTable.hudList[0].showScale = false;
            }
            for (int i = 0; i < quickHudSize; ++i) {
                if (!Core.input.keyTap(this.cameraSelect[i])) continue;
                hudList[i].getHud();
            }
        });
        if (quickHudSize == 0) {
            return;
        }
        this.rebuild();
    }

    private void rebuild() {
        quickHudSize = Core.settings.getInt("quickHudSize", 0);
        this.clear();
        this.table((Table t) -> {
            t.button(Blocks.radar.emoji(), RStyles.clearLineNonet, () -> ARCVars.arcui.arcInfo("[acid]ARC-\u5feb\u6377\u7a97\u53e3[white]\n\u9644\u8eab\u70ae\u53f0\u4e0b\u70b9\u4f1a\u9501\u5b9a\u70ae\u53f0\uff0c\u6307\u6325\u6a21\u5f0f\u63a7\u5175\u4e0b\u4f1a\u9501\u5b9a\u5175\uff0c\u5176\u4f59\u60c5\u51b5\u4e0b\u9501\u5b9a\u5f53\u524d\u754c\u9762"));
            if (!Vars.mobile) {
                t.button("\ue88e", RStyles.clearLineNoneTogglet, () -> {
                    this.hoverMode = !this.hoverMode;
                    ARCVars.arcui.arcInfo("[acid]\u5f53\u524d\u4e3a" + (this.hoverMode ? "\u60ac\u6d6e" : "\u70b9\u51fb") + "\u5207\u6362\u89c6\u89d2\u6a21\u5f0f");
                    Core.settings.put("arcCameraHoverMode", this.hoverMode);
                    this.rebuild();
                }).checked(this.hoverMode).width(50.0f);
            }
            t.button("\ue80b", RStyles.clearLineNoneTogglet, () -> {
                this.saveScale = !this.saveScale;
                ARCVars.arcui.arcInfo("[acid]\u5f53\u524d" + (this.saveScale ? "" : "\u4e0d") + "\u4fdd\u5b58\u89c6\u89d2\u7f29\u653e");
                Core.settings.put("arcCameraSaveScale", this.saveScale);
            }).checked(this.saveScale).width(50.0f);
            for (int i = 0; i < quickHudSize; ++i) {
                this.hudButton((Table)t, i);
            }
        }).height(50.0f);
    }

    private void hudButton(Table table, int index) {
        table.table((Table t) -> {
            Label field = t.label(() -> (this.cameraSelect[index].value.key == KeyCode.unknown ? "" : "[cyan]" + this.cameraSelect[index].value.key.toString()) + hudList[index].getName()).get();
            if (this.hoverMode) {
                field.hovered(() -> hudList[index].getHud());
            } else {
                field.clicked(() -> hudList[index].getHud());
            }
            if (hudList[index].isValid()) {
                t.button("\ue815", RStyles.clearLineNonet, () -> {
                    QuickCameraTable.hudList[index] = new SingleHud();
                    this.rebuild();
                });
            } else {
                t.button("\ue813", RStyles.clearLineNonet, () -> {
                    this.addHud(index);
                    this.rebuild();
                });
            }
        }).padRight(30.0f);
    }

    private void addHud(int index) {
        Unit unit = Vars.player.unit();
        if (unit instanceof BlockUnitc) {
            BlockUnitc unitc = (BlockUnitc)((Object)unit);
            QuickCameraTable.hudList[index] = new SingleHud(unitc.tileX(), unitc.tileY());
        } else {
            QuickCameraTable.hudList[index] = Vars.control.input.commandMode && Vars.control.input.selectedUnits.size > 0 ? new SingleHud(Vars.control.input.selectedUnits.first()) : new SingleHud((int)(Core.camera.position.x / 8.0f), (int)(Core.camera.position.y / 8.0f));
        }
        QuickCameraTable.hudList[index].showScale = this.saveScale;
    }

    static class SingleHud {
        int x = -1;
        int y = -1;
        float scale = 1.0f;
        boolean showScale = true;
        @Nullable
        Unit unit;

        public SingleHud() {
        }

        public SingleHud(int x1, int y1) {
            this.x = x1;
            this.y = y1;
            this.scale = Vars.renderer.getScale();
        }

        public SingleHud(Unit unit1) {
            this.unit = unit1;
            this.scale = Vars.renderer.getScale();
        }

        public boolean isValid() {
            return this.x != -1 || this.unit != null || this.y != -1;
        }

        public String getName() {
            if (!this.isValid()) {
                return "[lightgray]\ue815";
            }
            StringBuilder name = new StringBuilder();
            if (this.unit != null) {
                return name.append("[white]").append(this.unit.type.emoji()).append("[white]([acid]").append(this.unit.tileX()).append("[white],[acid]").append(this.unit.tileY()).append("[white])").toString();
            }
            return name.append("[white]([acid]").append(this.x).append("[white],[acid]").append(this.y).append("[white])").toString();
        }

        public void getHud() {
            if (!this.isValid()) {
                return;
            }
            if (this.showScale) {
                Vars.renderer.setScale(this.scale);
            }
            if (this.unit != null) {
                RFuncs.arcSetCamera(this.unit.x, this.unit.y, false);
            } else {
                RFuncs.arcSetCamera(this.x * 8, this.y * 8, false);
            }
        }
    }
}

