/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.core.UI;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.ui.Bar;

public class PowerInfo {
    private static PowerInfo info = new PowerInfo();
    public float powerbal;
    public float stored;
    public float capacity;
    public float produced;
    public float need;

    public void add(float powerbal, float stored, float cap, float produced, float need) {
        this.powerbal += powerbal;
        this.stored += stored;
        this.capacity += cap;
        this.produced += produced;
        this.need += need;
    }

    public void clear() {
        this.powerbal = 0.0f;
        this.stored = 0.0f;
        this.capacity = 0.0f;
        this.produced = 0.0f;
        this.need = 0.0f;
    }

    public int getPowerBalance() {
        return (int)(this.powerbal * 60.0f);
    }

    public float getStored() {
        return this.stored;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public float getSatisfaction() {
        if (Mathf.zero(this.produced)) {
            return 0.0f;
        }
        if (Mathf.zero(this.need)) {
            return 1.0f;
        }
        return this.produced / this.need;
    }

    public static Element getBars() {
        Table power = new Table(Tex.wavepane).marginTop(6.0f);
        info = Vars.player.team().arcTeamData.powerInfo;
        Bar powerBar = new Bar(() -> Core.bundle.format("bar.powerbalance", (info.getPowerBalance() >= 0 ? "+" : "") + UI.formatAmount(info.getPowerBalance())) + (info.getSatisfaction() >= 1.0f ? "" : " [gray]" + (int)(info.getSatisfaction() * 100.0f) + "%"), () -> Pal.powerBar, () -> info.getSatisfaction());
        Bar batteryBar = new Bar(() -> Core.bundle.format("bar.powerstored", UI.formatAmount((long)info.getStored()), UI.formatAmount((long)info.getCapacity())), () -> Pal.powerBar, () -> info.getStored() / info.getCapacity());
        power.clicked(() -> {
            int arccoreitems = Core.settings.getInt("arccoreitems");
            Core.settings.put("arccoreitems", (arccoreitems + 1) % 4);
        });
        power.margin(0.0f);
        power.add(powerBar).height(18.0f).growX().padBottom(1.0f);
        power.row();
        power.add(batteryBar).height(18.0f).growX().padBottom(1.0f);
        power.update(() -> {
            info = Vars.player.team().arcTeamData.powerInfo;
        });
        return power;
    }
}

