/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.func.Boolf;
import arc.func.Floatf;
import arc.graphics.Color;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.TextButton;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.NumberFormat;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.ui.dialogs.MapStatisticsDialog;
import mindustry.arcModule.ui.dialogs.TeamSelectDialog;
import mindustry.content.Blocks;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Tex;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;

public class OtherCoreItemDisplay
extends Table {
    public Seq<Teams.TeamData> teams = new Seq();
    private float lastUpd = 0.0f;
    private float fontScl = 0.8f;
    private boolean show = false;
    private boolean showStat = true;
    private boolean showPower = true;
    private boolean showItem = true;
    private boolean showUnit = true;
    private Table teamsTable;
    private TextButton.TextButtonStyle textStyle;
    private ShowType showType = ShowType.period;
    private float showPeriod = 1200.0f;

    public OtherCoreItemDisplay() {
        this.textStyle = new TextButton.TextButtonStyle(){
            {
                this.down = Styles.flatOver;
                this.up = Tex.pane;
                this.over = Tex.flatDownBase;
                this.font = Fonts.def;
                this.fontColor = Color.white;
                this.disabledFontColor = Color.gray;
                this.checked = Styles.flatDown;
            }
        };
        this.teamsTable = new Table();
        this.rebuild();
    }

    void rebuild() {
        this.clear();
        if (!this.show) {
            this.button("[red]+", this.textStyle, () -> {
                this.show = !this.show;
                this.rebuild();
            }).left().width(40.0f).fillY().get().left();
        } else {
            this.table((Table t) -> {
                t.table((Table buttons) -> {
                    buttons.button("[red]\u00d7", this.textStyle, () -> {
                        this.show = !this.show;
                        this.rebuild();
                    }).size(40.0f).row();
                    buttons.button("T", this.textStyle, () -> new TeamSelectDialog(team -> {
                        if (this.teams.contains(team.data())) {
                            ARCVars.arcTeam.updateTeam.remove((Team)team);
                            ARCVars.arcTeam.forceUpdateTeam.remove((Team)team);
                        } else {
                            ARCVars.arcTeam.updateTeam.add((Team)team);
                            ARCVars.arcTeam.forceUpdateTeam.add((Team)team);
                        }
                        this.updateTeamList();
                        this.teamsRebuild();
                    }, team -> this.teams.contains(team.data()), false).show()).checked(gg -> false).size(40.0f).row();
                    buttons.button(Blocks.worldProcessor.emoji(), this.textStyle, () -> {
                        this.showStat = !this.showStat;
                        this.teamsRebuild();
                    }).checked(a -> this.showStat).size(40.0f).row();
                    buttons.button(Blocks.powerNode.emoji(), this.textStyle, () -> {
                        this.showPower = !this.showPower;
                        this.teamsRebuild();
                    }).checked(a -> this.showPower).size(40.0f).row();
                    buttons.button(Vars.content.items().get(0).emoji(), this.textStyle, () -> {
                        this.showItem = !this.showItem;
                        this.teamsRebuild();
                    }).checked(a -> this.showItem).size(40.0f).row();
                    buttons.button(UnitTypes.mono.emoji(), this.textStyle, () -> {
                        this.showUnit = !this.showUnit;
                        this.teamsRebuild();
                    }).checked(a -> this.showUnit).size(40.0f).row();
                    buttons.button(this.showType.getString(), this.textStyle, () -> {
                        this.showType = this.showType.next();
                        this.teamsRebuild();
                    }).checked(gg -> false).size(40.0f).row();
                    buttons.button(String.valueOf('\ue827'), this.textStyle, () -> new MapStatisticsDialog().show()).checked(gg -> false).size(40.0f);
                }).left();
                this.teamsRebuild();
                t.add(this.teamsTable).left();
            }).left();
        }
    }

    private void teamsRebuild() {
        boolean show;
        this.teamsTable.clear();
        this.teamsTable.background(Styles.black6);
        this.teamsTable.update(() -> {
            if (Time.time - this.lastUpd > 120.0f) {
                this.lastUpd = Time.time;
                this.updateTeamList();
                this.teamsRebuild();
            }
        });
        this.teams.sort(teamData -> -teamData.cores.size);
        this.teamsTable.add();
        this.addTeamData(this.teamsTable, team -> team.team.id < 6 ? team.team.localized() : String.valueOf(team.team.id));
        this.addTeamData(this.teamsTable, Blocks.coreNucleus.uiIcon, (Teams.TeamData team) -> UI.formatAmount(team.cores.size));
        this.addTeamData(this.teamsTable, UnitTypes.mono.uiIcon, (Teams.TeamData team) -> UI.formatAmount(team.units.size));
        this.addTeamData(this.teamsTable, UnitTypes.gamma.uiIcon, (Teams.TeamData team) -> String.valueOf(team.players.size));
        if (this.showStat) {
            this.teamsTable.image().color(ARCVars.getThemeColor()).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            this.addTeamDataCheck(this.teamsTable, Blocks.siliconSmelter.uiIcon, (Teams.TeamData team) -> team.team.rules().cheat, false);
            this.addTeamDataCheck(this.teamsTable, Blocks.arc.uiIcon, team -> Vars.state.rules.blockDamage(team.team));
            this.addTeamDataCheck(this.teamsTable, Blocks.titaniumWall.uiIcon, team -> Vars.state.rules.blockHealth(team.team));
            this.addTeamDataCheck(this.teamsTable, Blocks.buildTower.uiIcon, team -> Vars.state.rules.buildSpeed(team.team));
            this.addTeamDataCheck(this.teamsTable, UnitTypes.corvus.uiIcon, team -> Vars.state.rules.unitDamage(team.team));
            this.addTeamDataCheck(this.teamsTable, UnitTypes.oct.uiIcon, team -> Vars.state.rules.unitHealth(team.team));
            this.addTeamDataCheck(this.teamsTable, UnitTypes.zenith.uiIcon, team -> Vars.state.rules.unitCrashDamage(team.team));
            this.addTeamDataCheck(this.teamsTable, Blocks.tetrativeReconstructor.uiIcon, team -> Vars.state.rules.unitBuildSpeed(team.team));
            this.addTeamDataCheck(this.teamsTable, Blocks.basicAssemblerModule.uiIcon, team -> Vars.state.rules.unitCost(team.team));
            this.teamsTable.row();
        }
        if (this.showPower) {
            this.teamsTable.image().color(ARCVars.getThemeColor()).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            this.addTeamData(this.teamsTable, Blocks.powerNode.uiIcon, (Teams.TeamData team) -> NumberFormat.formatFloat(team.team.arcTeamData.powerInfo.getPowerBalance()));
            this.addTeamData(this.teamsTable, Blocks.battery.uiIcon, (Teams.TeamData team) -> NumberFormat.formatFloat(team.team.arcTeamData.powerInfo.getStored()));
        }
        if (this.showItem) {
            this.teamsTable.image().color(ARCVars.getThemeColor()).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            for (Item item : Vars.content.items()) {
                show = false;
                for (Teams.TeamData team2 : this.teams) {
                    if (team2.team.arcTeamData.currentItems[item.id] <= 0) continue;
                    show = true;
                    break;
                }
                if (!show) continue;
                this.addTeamData(this.teamsTable, item.uiIcon, (Teams.TeamData team) -> this.formatTeamItem(team.team, item));
            }
        }
        if (this.showUnit) {
            this.teamsTable.image().color(ARCVars.getThemeColor()).fillX().height(1.0f).colspan(999).padTop(3.0f).padBottom(3.0f).row();
            for (UnitType unit : Vars.content.units()) {
                show = false;
                for (Teams.TeamData team2 : this.teams) {
                    if (team2.countType(unit) <= 0) continue;
                    show = true;
                }
                if (!show) continue;
                this.addTeamData(this.teamsTable, unit.uiIcon, (Teams.TeamData team) -> team.countType(unit) > 0 ? String.valueOf(team.countType(unit)) : "-");
            }
        }
    }

    private String formatTeamItem(Team team, Item item) {
        if (team.arcTeamData.currentItems[item.id] == 0) {
            return "-";
        }
        StringBuilder s = new StringBuilder();
        if (this.showType == ShowType.current || this.showType == ShowType.binary || this.showType == ShowType.period && Time.time % this.showPeriod / this.showPeriod > 0.5f) {
            s.append(NumberFormat.formatInteger(team.arcTeamData.currentItems[item.id]));
        }
        if (this.showType == ShowType.increment || this.showType == ShowType.binary || this.showType == ShowType.period && Time.time % this.showPeriod / this.showPeriod < 0.5f) {
            s.append((int)team.arcTeamData.updateItems[item.id] > 0 ? "[acid]+" : "[orange]").append(NumberFormat.formatInteger((int)team.arcTeamData.updateItems[item.id]));
        }
        return s.toString();
    }

    private void updateTeamList() {
        this.teams = ARCVars.arcTeam.updateTeam.map(Team::data).copy();
    }

    private void addTeamDataCheck(Table table, TextureRegion icon, Floatf<Teams.TeamData> checked) {
        this.addTeamDataCheck(table, icon, checked, 1.0f);
    }

    private void addTeamDataCheck(Table table, TextureRegion icon, Floatf<Teams.TeamData> checked, float defaultValue) {
        boolean show = false;
        boolean sameValue = true;
        float value = -1.0f;
        for (Teams.TeamData teamData : this.teams) {
            if (checked.get(teamData) != defaultValue) {
                show = true;
            }
            if (value == -1.0f) {
                value = checked.get(teamData);
                continue;
            }
            if (value == checked.get(teamData)) continue;
            sameValue = false;
        }
        if (show) {
            if (sameValue) {
                this.addTeamData(table, icon, NumberFormat.autoFixed(value));
            } else {
                this.addTeamData(table, icon, (Teams.TeamData team) -> NumberFormat.autoFixed(checked.get((Teams.TeamData)team)));
            }
        }
    }

    private void addTeamDataCheck(Table table, TextureRegion icon, Boolf<Teams.TeamData> checked, Boolean defaultValue) {
        boolean show = false;
        boolean sameRevert = true;
        for (Teams.TeamData teamData : this.teams) {
            if (checked.get(teamData) != defaultValue.booleanValue()) {
                show = true;
                continue;
            }
            sameRevert = false;
        }
        if (show) {
            if (sameRevert) {
                this.addTeamData(table, icon, sameRevert ? " +" : " x");
            } else {
                this.addTeamData(table, icon, (Teams.TeamData team) -> checked.get((Teams.TeamData)team) ? "+" : "\u00d7");
            }
        }
    }

    private void addTeamData(Table table, TextureRegion icon, String value) {
        table.image(icon).size(15.0f, 15.0f).left();
        table.label(() -> ARCVars.getThemeColorCode() + " ~" + value).get().setFontScale(this.fontScl);
        table.row();
    }

    private void addTeamData(Table table, TextureRegion icon, RFuncs.Stringf<Teams.TeamData> teamDataStringf) {
        table.image(icon).size(15.0f, 15.0f).left();
        this.addTeamData(table, teamDataStringf);
    }

    private void addTeamData(Table table, RFuncs.Stringf<Teams.TeamData> teamDataStringf) {
        for (Teams.TeamData teamData : this.teams) {
            table.label(() -> "[#" + teamData.team.color + "]" + teamDataStringf.get(teamData)).get().setFontScale(this.fontScl);
        }
        table.row();
    }

    static enum ShowType {
        current,
        increment,
        period,
        binary;

        private static final ShowType[] vals;

        public ShowType next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        public String getString() {
            String string;
            switch (this) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case current: {
                    string = "\u73b0";
                    break;
                }
                case increment: {
                    string = "\u53d8";
                    break;
                }
                case period: {
                    string = "\u5207";
                    break;
                }
                case binary: {
                    string = "\u5168";
                }
            }
            return string;
        }

        static {
            vals = ShowType.values();
        }
    }
}

