/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.Events;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import java.util.ArrayList;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Tex;
import mindustry.ui.Styles;

public class LabelController {
    Table t = new Table();
    ScrollPane sp = new ScrollPane((Element)this.t);
    String showing = "\u5e7f\u544a\u4f4d\u62db\u79df";
    Label l = new Label(this.showing, Styles.outlineLabel);
    float lastWidth = 0.0f;
    boolean playing = false;
    ArrayList<String> buffer = new ArrayList();

    public LabelController() {
        Events.on(EventType.ClientLoadEvent.class, e -> this.init());
    }

    private void init() {
        this.t.setBackground(((TextureRegionDrawable)Tex.whiteui).tint(0.0f, 0.0f, 0.0f, 0.4f));
        this.t.add(this.l);
        this.sp.setScrollBarPositions(false, false);
        this.sp.visible = false;
        this.sp.color.a(0.0f);
        this.sp.touchable = Touchable.disabled;
        this.sp.update(this::pos);
        Core.scene.add(this.sp);
        Vars.netClient.addPacketHandler("arcFloatText", str -> this.start("[violet]\u6765\u81ea\u670d\u52a1\u5668\u7684\u6d88\u606f\uff1a" + str));
    }

    private void pos() {
        float width = Core.graphics.getWidth();
        float height = (float)Core.graphics.getHeight() - Core.scene.marginTop - 75.0f;
        this.sp.setWidth(width * 0.8f);
        this.t.setHeight(this.l.getHeight());
        this.sp.x = width * 0.1f;
        this.sp.y = height;
        this.sp.toFront();
        if (!this.playing) {
            return;
        }
        if (width != this.lastWidth) {
            this.l.setText(this.pad(this.showing));
            this.lastWidth = width;
        }
        float textWidth = this.l.getPrefWidth() - this.sp.getWidth();
        this.sp.setScrollXForce(this.sp.getScrollX() + Math.max(Math.min((textWidth - this.sp.getWidth()) / this.sp.getWidth(), 6.0f), Core.scene.getWidth() / 1000.0f) * Time.delta * 2.0f);
        if (this.sp.getScrollX() > textWidth) {
            this.end();
        }
    }

    public void start(String str) {
        if (this.playing) {
            this.buffer.add(str);
            return;
        }
        this.showing = str;
        this.prepareStart();
    }

    private void start() {
        this.showing = this.buffer.get(0);
        this.buffer.remove(0);
        this.prepareStart();
    }

    public void clear() {
        this.buffer.clear();
        this.end();
    }

    private void prepareStart() {
        this.sp.visible = true;
        this.playing = true;
        this.sp.actions(Actions.sequence((Action)Actions.run(() -> {
            this.l.setText(this.pad(this.showing));
            this.sp.setScrollX(0.0f);
            this.pos();
        }), (Action)Actions.fadeIn(0.5f)));
    }

    public void end() {
        if (this.buffer.size() != 0) {
            this.start();
            return;
        }
        if (!this.playing) {
            return;
        }
        this.playing = false;
        this.sp.actions(Actions.sequence((Action)Actions.fadeOut(0.5f), (Action)Actions.run(() -> {
            this.sp.visible = this.playing;
        })));
    }

    private String pad(String str) {
        StringBuilder sb = new StringBuilder();
        int count = (int)(this.sp.getWidth() / new Label(" ").getWidth() + 5.0f);
        for (int i = 0; i < count; ++i) {
            sb.append(' ');
        }
        return sb + str + sb;
    }
}

