/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Slider;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Table;
import arc.struct.OrderedSet;
import arc.struct.Seq;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Objects;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.Marker;
import mindustry.arcModule.TimeControl;
import mindustry.arcModule.ui.dialogs.TeamSelectDialog;
import mindustry.content.Blocks;
import mindustry.content.Items;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.core.World;
import mindustry.entities.units.StatusEntry;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Tex;
import mindustry.gen.Unit;
import mindustry.input.DesktopInput;
import mindustry.input.InputHandler;
import mindustry.input.MobileInput;
import mindustry.type.Item;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;

public class AdvanceToolTable
extends Table {
    private boolean show = false;
    private boolean showGameMode = false;
    private boolean showEntities = false;
    private boolean showTeamChange = false;
    private boolean showTimeControl = false;
    private boolean showCreator = false;
    private final boolean enableRTSCode = false;
    private int unitCount = 1;
    private float unitRandDst = 1.0f;
    private final Vec2 unitLoc = new Vec2(0.0f, 0.0f);
    private final OrderedSet<StatusEntry> unitStatus = new OrderedSet();
    private final float[] statusTime = new float[]{10.0f, 30.0f, 60.0f, 120.0f, 180.0f, 300.0f, 600.0f, 900.0f, 1200.0f, 1500.0f, 1800.0f, 2700.0f, 3600.0f, Float.MAX_VALUE};
    private final Unit spawnUnit = UnitTypes.emanate.create(Team.sharded);
    private boolean showUnitSelect = false;
    private boolean showUnitPro = false;
    private boolean showStatesEffect = false;
    private boolean showItems = false;
    private boolean showPayload = false;
    private boolean showSelectPayload = false;
    private boolean showPayloadBlock = false;
    private boolean elevation = false;
    private float chatTime = 0.0f;
    public static boolean worldCreator;
    public static boolean forcePlacement;
    public static boolean allBlocksReveal;
    private final Vec2 initA = new Vec2(0.0f, 0.0f);
    private final Vec2 initB = new Vec2(0.0f, 0.0f);
    private final Vec2 finalA = new Vec2(0.0f, 0.0f);

    public AdvanceToolTable() {
        this.rebuild();
        Events.on(EventType.ResetEvent.class, e -> {
            if (!Vars.state.rules.editor) {
                worldCreator = false;
                forcePlacement = false;
                allBlocksReveal = false;
            }
        });
    }

    void rebuild() {
        this.clear();
        if (Vars.mobile) {
            this.table((Table tBox) -> {
                tBox.background(Tex.buttonEdge3);
                tBox.button("\u6307\u6325", Styles.cleart, () -> {
                    Vars.control.input.commandMode = !Vars.control.input.commandMode;
                }).width(80.0f);
                tBox.button("\u53d6\u6d88", Styles.cleart, () -> {
                    InputHandler patt3294$temp = Vars.control.input;
                    if (patt3294$temp instanceof MobileInput) {
                        MobileInput input = (MobileInput)patt3294$temp;
                        input.arcClearPlans();
                    }
                }).width(80.0f);
            }).left().row();
        }
        if (!this.show) {
            this.table((Table t) -> {
                t.background(Tex.buttonEdge3);
                t.button("[cyan]\u5de5\u5177\u7bb1", Styles.cleart, () -> {
                    this.show = !this.show;
                    this.rebuild();
                }).left().width(70.0f).expandX();
            }).left();
        } else {
            this.table((Table t) -> {
                if (this.showEntities) {
                    t.table((Table tt) -> {
                        tt.table((Table tBox) -> {
                            tBox.background(Tex.pane);
                            tBox.button(Items.copper.emoji() + "[acid]+", Styles.cleart, () -> {
                                for (Item item : Vars.content.items()) {
                                    Vars.player.core().items.set(item, Vars.player.core().storageCapacity);
                                }
                            }).width(40.0f).tooltip("[acid]\u586b\u6ee1\u6838\u5fc3\u7684\u6240\u6709\u8d44\u6e90");
                            tBox.button(Items.copper.emoji() + "[red]-", Styles.cleart, () -> {
                                for (Item item : Vars.content.items()) {
                                    Vars.player.core().items.set(item, 0);
                                }
                            }).width(40.0f).tooltip("[acid]\u6e05\u7a7a\u6838\u5fc3\u7684\u6240\u6709\u8d44\u6e90");
                        }).left();
                        tt.table((Table tBox) -> {
                            tBox.background(Tex.buttonEdge3);
                            tBox.button(UnitTypes.gamma.emoji() + "[acid]+", Styles.cleart, () -> {
                                Unit cloneUnit = this.cloneExactUnit(Vars.player.unit());
                                cloneUnit.set(Vars.player.x + Mathf.range(8.0f), Vars.player.y + Mathf.range(8.0f));
                                cloneUnit.add();
                            }).width(40.0f).tooltip("[acid]\u514b\u9686");
                            tBox.button(UnitTypes.gamma.emoji() + "[red]\u00d7", Styles.cleart, () -> Vars.player.unit().kill()).width(40.0f).tooltip("[red]\u81ea\u6740");
                            tBox.button((Drawable)Icon.waves, Styles.clearNonei, this::unitSpawnMenu).width(40.0f).tooltip("[acid]\u5355\u4f4d\u5de5\u5382-ARC");
                        }).left();
                    }).left().row();
                }
                if (this.showTimeControl) {
                    t.table((Table tt) -> tt.table((Table tBox) -> {
                        tBox.background(Tex.buttonEdge3);
                        tBox.add("\u6c99\u6f0f\uff1a").left();
                        tBox.button("/2", Styles.cleart, () -> TimeControl.changeGameSpeed(0.5f)).tooltip("[acid]\u5c06\u65f6\u95f4\u6d41\u901f\u653e\u6162\u5230\u4e00\u534a").size(40.0f, 30.0f);
                        tBox.button("\u00d72", Styles.cleart, () -> TimeControl.changeGameSpeed(2.0f)).tooltip("[acid]\u5c06\u65f6\u95f4\u6d41\u901f\u52a0\u5feb\u5230\u4e24\u500d").size(40.0f, 30.0f);
                        tBox.button("[red]S", Styles.cleart, () -> TimeControl.setGameSpeed(0.0f)).tooltip("[acid]\u6682\u505c\u65f6\u95f4").size(30.0f, 30.0f);
                        tBox.button("[green]N", Styles.cleart, () -> TimeControl.setGameSpeed(1.0f)).tooltip("[acid]\u6062\u590d\u539f\u901f").size(30.0f, 30.0f);
                        tBox.button("[white]F", Styles.cleart, TimeControl::lockFps).tooltip("[acid]\u5e27\u7387\u6a21\u62df").size(30.0f, 30.0f);
                        tBox.field(Integer.toString(TimeControl.targetFps), s -> {
                            int num = Integer.parseInt(s);
                            TimeControl.setTargetFps(2 <= num && num < 10000 ? num : 60);
                        }).valid(s -> {
                            if (!Strings.canParsePositiveInt(s)) {
                                return false;
                            }
                            int num = Integer.parseInt(s);
                            return 2 <= num && num < 10000;
                        }).tooltip("\u5141\u8bb8\u7684\u8303\u56f4\uff1a2~9999").size(90.0f, 30.0f);
                    }).left()).left().row();
                }
                if (this.showCreator) {
                    t.table((Table tt) -> tt.table((Table tBox) -> {
                        tBox.background(Tex.pane);
                        tBox.button("\u521b\u4e16\u795e", Styles.flatToggleMenut, () -> {
                            worldCreator = !worldCreator;
                        }).checked(b -> worldCreator).size(70.0f, 30.0f);
                        tBox.button("\u5f3a\u5236\u653e\u7f6e", Styles.flatToggleMenut, () -> {
                            forcePlacement = !forcePlacement;
                        }).checked(b -> forcePlacement).size(70.0f, 30.0f);
                        tBox.button("\u89e3\u7981", Styles.flatToggleMenut, () -> {
                            allBlocksReveal = !allBlocksReveal;
                            Vars.ui.hudfrag.blockfrag.rebuild();
                        }).checked(b -> allBlocksReveal).tooltip("[acid]\u663e\u793a\u5e76\u5141\u8bb8\u5efa\u9020\u6240\u6709\u7269\u54c1").size(50.0f, 30.0f);
                        tBox.button("[orange]\u590d\u5236\u5730\u5f62", Styles.flatToggleMenut, this::tileCopier).tooltip("[acid]\u590d\u5236\u7279\u5b9a\u5730\u5f62").size(70.0f, 30.0f).checked(jb -> false);
                    }).left()).left().row();
                }
                if (this.showTeamChange) {
                    t.table((Table tBox) -> {
                        tBox.background(Tex.buttonEdge3);
                        tBox.add("\u961f\u4f0d\uff1a").left();
                        for (Team team : Team.baseTeams) {
                            tBox.button(String.format("[#%s]%s", team.color, team.localized()), Styles.flatToggleMenut, () -> Vars.player.team(team)).checked(b -> Vars.player.team() == team).size(30.0f, 30.0f);
                        }
                        tBox.button("[violet]+", Styles.flatToggleMenut, () -> new TeamSelectDialog(team -> Vars.player.team((Team)team), Vars.player.team()).show()).checked(b -> !Seq.with(Team.baseTeams).contains(Vars.player.team())).tooltip("[acid]\u66f4\u591a\u961f\u4f0d\u9009\u62e9").size(30.0f, 30.0f);
                    }).left().row();
                }
                if (this.showGameMode) {
                    t.table((Table tBox) -> {
                        tBox.background(Tex.buttonEdge3);
                        tBox.add("\u89c4\u5219\uff1a").left();
                        tBox.button("\u65e0\u9650\u706b\u529b", Styles.flatToggleMenut, () -> {
                            Vars.player.team().rules().cheat = !Vars.player.team().rules().cheat;
                        }).checked(b -> Vars.player.team().rules().cheat).tooltip("[acid]\u5f00\u5173\u81ea\u5df1\u961f\u7684\u65e0\u9650\u706b\u529b").size(90.0f, 30.0f);
                        tBox.button("\u7f16\u8f91\u5668", Styles.flatToggleMenut, () -> {
                            Vars.state.rules.editor = !Vars.state.rules.editor;
                        }).checked(b -> Vars.state.rules.editor).size(70.0f, 30.0f);
                        tBox.button("\u6c99\u76d2", Styles.flatToggleMenut, () -> {
                            Vars.state.rules.infiniteResources = !Vars.state.rules.infiniteResources;
                        }).checked(b -> Vars.state.rules.infiniteResources).size(50.0f, 30.0f);
                    }).left().row();
                }
                t.row();
                t.table((Table mainBox) -> {
                    mainBox.background(Tex.buttonEdge3);
                    mainBox.button("[red]\u5de5\u5177\u7bb1", Styles.cleart, () -> {
                        this.show = !this.show;
                        this.rebuild();
                    }).width(70.0f);
                    mainBox.button(Items.copper.emoji() + UnitTypes.gamma.emoji(), Styles.cleart, () -> {
                        this.showEntities = !this.showEntities;
                        this.rebuild();
                    }).width(50.0f);
                    mainBox.button(Blocks.worldProcessor.emoji(), Styles.cleart, () -> {
                        this.showCreator = !this.showCreator;
                        this.rebuild();
                    }).width(50.0f);
                    mainBox.button(Blocks.overdriveProjector.emoji(), Styles.cleart, () -> {
                        this.showTimeControl = !this.showTimeControl;
                        this.rebuild();
                    }).width(50.0f);
                    mainBox.button((this.showGameMode ? "[cyan]" : "[acid]") + "\u89c4\u5219", Styles.cleart, () -> {
                        this.showGameMode = !this.showGameMode;
                        this.rebuild();
                    }).width(50.0f);
                    mainBox.button((this.showTeamChange ? "[cyan]" : "[acid]") + "\u961f\u4f0d", Styles.cleart, () -> {
                        this.showTeamChange = !this.showTeamChange;
                        this.rebuild();
                    }).width(50.0f);
                }).left();
            }).left();
        }
    }

    private void tileCopier() {
        BaseDialog dialog = new BaseDialog("\u5730\u5757\u590d\u5236\u5668");
        dialog.cont.table((Table t) -> {
            t.table((Table tt) -> {
                tt.add("\u590d\u5236\u533a\u89d2A\uff1ax= ");
                TextField x = tt.field(Strings.autoFixed(this.initA.x, 2), text -> {
                    this.initA.x = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.add("  ,y= ");
                TextField y = tt.field(Strings.autoFixed(this.initA.y, 2), text -> {
                    this.initA.y = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.button(StatusEffects.blasted.emoji(), () -> {
                    if (Marker.markList.size == 0) {
                        return;
                    }
                    this.initA.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                    x.setText(World.toTile(Marker.markList.peek().markPos.x) + "");
                    y.setText(World.toTile(Marker.markList.peek().markPos.y) + "");
                }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
            }).row();
            t.table((Table tt) -> {
                tt.add("\u590d\u5236\u533a\u89d2B\uff1ax= ");
                TextField x = tt.field(Strings.autoFixed(this.initB.x, 2), text -> {
                    this.initB.x = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.add("  ,y= ");
                TextField y = tt.field(Strings.autoFixed(this.initB.y, 2), text -> {
                    this.initB.y = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.button(StatusEffects.blasted.emoji(), () -> {
                    if (Marker.markList.size == 0) {
                        return;
                    }
                    this.initB.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                    x.setText(World.toTile(Marker.markList.peek().markPos.x) + "");
                    y.setText(World.toTile(Marker.markList.peek().markPos.y) + "");
                }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
            }).row();
            t.table((Table tt) -> {
                tt.add("\u7c98\u8d34\u533a\u5de6\u4e0b\u5750\u6807\uff1ax= ");
                TextField x = tt.field(Strings.autoFixed(this.finalA.x, 2), text -> {
                    this.finalA.x = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.add("  ,y= ");
                TextField y = tt.field(Strings.autoFixed(this.finalA.y, 2), text -> {
                    this.finalA.y = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                tt.button(StatusEffects.blasted.emoji(), () -> {
                    if (Marker.markList.size == 0) {
                        return;
                    }
                    this.finalA.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                    x.setText(World.toTile(Marker.markList.peek().markPos.x) + "");
                    y.setText(World.toTile(Marker.markList.peek().markPos.y) + "");
                }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
            }).row();
            t.button("\u590d\u5236\uff01", () -> {
                ARCVars.arcui.arcInfo("\u590d\u5236\u84dd\u56fe\u4e2d...\n[orange]\u6d4b\u8bd5\u4e2d\u529f\u80fd\uff0c\u8bf7\u7b49\u5f85\u540e\u7eed\u5b8c\u5584");
                Vec2 left2 = new Vec2(Math.min(this.initA.x, this.initB.x), Math.min(this.initA.y, this.initB.y));
                int x = 0;
                while ((float)x <= Math.abs(this.initA.x - this.initB.x)) {
                    int y = 0;
                    while ((float)y <= Math.abs(this.initA.y - this.initB.y)) {
                        Tile copyTile = Vars.world.tile((int)(left2.x + (float)x), (int)(left2.y + (float)y));
                        Tile thisTile = Vars.world.tile((int)(this.finalA.x + (float)x), (int)(this.finalA.y + (float)y));
                        Tile.setFloor(thisTile, copyTile.floor(), copyTile.overlay());
                        if (copyTile.build == null) {
                            thisTile.setBlock(copyTile.block());
                        } else {
                            thisTile.setBlock(copyTile.block(), copyTile.build.team, copyTile.build.rotation);
                        }
                        ++y;
                    }
                    ++x;
                }
            }).height(50.0f).fillX();
        });
        dialog.addCloseButton();
        dialog.show();
    }

    private void unitSpawnMenu() {
        BaseDialog unitFactory = new BaseDialog("\u5355\u4f4d\u5de5\u5382-ARC");
        Table table = unitFactory.cont;
        Runnable[] rebuild = new Runnable[]{null};
        rebuild[0] = () -> {
            table.clear();
            table.table((Table t) -> {
                t.add("\u76ee\u6807\u5355\u4f4d\uff1a");
                t.image(() -> this.spawnUnit.type.uiIcon);
                t.label(() -> this.spawnUnit.type.localizedName);
            });
            table.row();
            Table r = table.table().center().bottom().get();
            r.add("\u6570\u91cf\uff1a");
            r.field("" + this.unitCount, text -> {
                this.unitCount = Integer.parseInt(text);
            }).valid(Strings::canParsePositiveInt).maxTextLength(4).get();
            table.row();
            r.add("\u751f\u6210\u8303\u56f4\uff1a");
            r.field(Strings.autoFixed(this.unitRandDst, 3), text -> {
                this.unitRandDst = Float.parseFloat(text);
            }).valid(Strings::canParsePositiveFloat).tooltip("\u5728\u76ee\u6807\u70b9\u9644\u8fd1\u7684\u8fd9\u4e2a\u8303\u56f4\u5185\u968f\u673a\u751f\u6210").maxTextLength(8).get();
            r.add("\u683c");
            table.row();
            table.table((Table t) -> {
                t.add("\u5750\u6807\uff1ax= ");
                t.field(Strings.autoFixed(this.unitLoc.x, 2), text -> {
                    this.unitLoc.x = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                t.add("  ,y= ");
                t.field(Strings.autoFixed(this.unitLoc.y, 2), text -> {
                    this.unitLoc.y = Float.parseFloat(text);
                }).valid(Strings::canParseFloat).maxTextLength(8).get();
                t.button(UnitTypes.gamma.emoji(), () -> {
                    this.unitLoc.set(Vars.player.tileX(), Vars.player.tileY());
                    rebuild[0].run();
                }).tooltip("\u9009\u62e9\u73a9\u5bb6\u5f53\u524d\u4f4d\u7f6e\uff1a" + Vars.player.tileX() + "," + Vars.player.tileY()).height(50.0f);
                t.button(StatusEffects.blasted.emoji(), () -> {
                    if (Marker.markList.size == 0) {
                        return;
                    }
                    this.unitLoc.set(World.toTile(Marker.markList.peek().markPos.x), World.toTile(Marker.markList.peek().markPos.y));
                    rebuild[0].run();
                }).tooltip(Marker.markList.size == 0 ? "[red]\u672a\u6807\u8bb0" : "\u9009\u62e9\u4e0a\u4e2a\u6807\u8bb0\u70b9\uff1a" + World.toTile(Marker.markList.peek().markPos.x) + "," + World.toTile(Marker.markList.peek().markPos.y)).height(50.0f);
            });
            table.row();
            table.button(Blocks.tetrativeReconstructor.emoji() + "[cyan]\u5355\u4f4d\u72b6\u6001\u91cd\u6784\u5382", () -> this.unitFabricator(this.spawnUnit)).fillX();
            table.row();
            table.button("[orange]\u751f\u6210\uff01", Icon.modeAttack, () -> {
                for (int n = 0; n < this.unitCount; ++n) {
                    Tmp.v1.rnd(Mathf.random(this.unitRandDst * 8.0f));
                    Unit unit = this.cloneUnit(this.spawnUnit);
                    if (this.elevation) {
                        unit.elevation = 1.0f;
                    }
                    unit.set(this.unitLoc.x * 8.0f + Tmp.v1.x, this.unitLoc.y * 8.0f + Tmp.v1.y);
                    this.unitStatus.each(e -> unit.addEntry(e.effect, e.time * 60.0f));
                    unit.add();
                }
                InputHandler patt18187$temp = Vars.control.input;
                if (patt18187$temp instanceof DesktopInput) {
                    DesktopInput input = (DesktopInput)patt18187$temp;
                    input.panning = true;
                }
                Core.camera.position.set(this.unitLoc.x * 8.0f, this.unitLoc.y * 8.0f);
                unitFactory.closeOnBack();
            }).fillX();
            if (Core.settings.getBool("easyJS")) {
                table.row();
                table.button("[orange] \u751f\u6210\uff01(/js)", Icon.modeAttack, () -> {
                    if (this.chatTime > 0.0f) {
                        ARCVars.arcui.arcInfo("\u4e3a\u4e86\u9632\u6b62\u56e0ddos\u88ab\u670d\u52a1\u5668ban\uff0c\u8bf7\u52ff\u592a\u5feb\u64cd\u4f5c", 5.0f);
                        return;
                    }
                    this.chatTime = 1.0f;
                    ARCVars.arcui.arcInfo("\u5df2\u751f\u6210\u5355\u4e2a\u5355\u4f4d\u3002\n[gray]\u8bf7\u4e0d\u8981\u77ed\u65f6\u591a\u6b21\u4f7f\u7528\u672c\u529f\u80fd\uff0c\u5426\u5219\u5bb9\u6613\u56e0ddos\u88ab\u670d\u52a1\u5668ban", 5.0f);
                    Tmp.v1.rnd(Mathf.random(this.unitRandDst)).add(this.unitLoc.x, this.unitLoc.y).scl(8.0f);
                    this.sendFormatChat("/js u = UnitTypes.@.create(Team.get(@))", this.spawnUnit.type.name, this.spawnUnit.team.id);
                    this.sendFormatChat("/js u.set(@,@)", Float.valueOf(this.unitLoc.x * 8.0f), Float.valueOf(this.unitLoc.y * 8.0f));
                    if (this.spawnUnit.health != this.spawnUnit.type.health) {
                        this.sendFormatChat("/js u.health = @", Float.valueOf(this.spawnUnit.health));
                        if (this.spawnUnit.health > this.spawnUnit.type.health) {
                            this.sendFormatChat("/js u.maxHealth = @", Float.valueOf(this.spawnUnit.health));
                        }
                    }
                    if (this.spawnUnit.shield != 0.0f) {
                        this.sendFormatChat("/js u.shield = @", Float.valueOf(this.spawnUnit.shield));
                    }
                    if (this.elevation) {
                        this.sendFormatChat("/js u.elevation = 1", new Object[0]);
                    }
                    if (!this.unitStatus.isEmpty()) {
                        this.sendFormatChat("/js gs=(t,o,n)=>{try{let f=t.getDeclaredField(n);f.setAccessible(true);return f.get(o)}catch(e){let s=t.getSuperclass();return s?gs(s,o,n):null}}", new Object[0]);
                        this.sendFormatChat("/js statuses = gs(u.class,u,\"statuses\")", new Object[0]);
                        this.unitStatus.each(entry -> {
                            if (!entry.effect.reactive) {
                                this.sendFormatChat("/js {e = new StatusEntry().set(StatusEffects.@, @);statuses.add(e);statuses.size}", entry.effect.name, Float.valueOf(entry.time * 60.0f));
                            } else {
                                this.sendFormatChat("/js u.apply(StatusEffects.@)", entry.effect.name);
                            }
                        });
                        this.sendFormatChat("/js delete statuses", new Object[0]);
                    }
                    if (this.spawnUnit.hasItem()) {
                        this.sendFormatChat("/js u.addItem(Items.@, @)", this.spawnUnit.stack.item.name, this.spawnUnit.stack.amount);
                    }
                    this.sendFormatChat("/js u.add()", new Object[0]);
                    this.sendFormatChat("/js delete u", new Object[0]);
                    Time.run(this.chatTime, () -> {
                        this.chatTime = 0.0f;
                    });
                    InputHandler patt21166$temp = Vars.control.input;
                    if (patt21166$temp instanceof DesktopInput) {
                        DesktopInput input = (DesktopInput)patt21166$temp;
                        input.panning = true;
                    }
                    Core.camera.position.set(this.unitLoc.x * 8.0f, this.unitLoc.y * 8.0f);
                    unitFactory.closeOnBack();
                }).fillX();
            }
        };
        rebuild[0].run();
        unitFactory.addCloseButton();
        unitFactory.show();
    }

    private void unitFabricator(Unit unit) {
        BaseDialog rebuildFabricatorTable = new BaseDialog("\u5355\u4f4d\u52a0\u5de5\u8f66\u95f4");
        Table table = new Table();
        ScrollPane pane = new ScrollPane((Element)table);
        Runnable[] rebuildTable = new Runnable[]{null};
        rebuildTable[0] = () -> {
            table.clear();
            table.button("\u52a0\u5de5\u5355\u4f4d\uff1a" + unit.type.emoji(), (Drawable)(this.showUnitSelect ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                this.showUnitSelect = !this.showUnitSelect;
                rebuildTable[0].run();
            }).fillX().minWidth(400.0f).row();
            if (this.showUnitSelect) {
                table.table((Table list) -> {
                    int i = 0;
                    for (UnitType units : Vars.content.units()) {
                        if (i++ % 8 == 0) {
                            list.row();
                        }
                        list.button(units.emoji() + "", Styles.cleart, () -> {
                            if (unit.type != units) {
                                this.changeUnitType(unit, units);
                                rebuildTable[0].run();
                            }
                            this.showUnitSelect = !this.showUnitSelect;
                            rebuildTable[0].run();
                        }).tooltip(units.localizedName).width(50.0f).height(50.0f);
                    }
                }).row();
            }
            table.button("[#" + unit.team.color + "]\u5355\u4f4d\u5c5e\u6027", (Drawable)(this.showUnitPro ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                this.showUnitPro = !this.showUnitPro;
                rebuildTable[0].run();
            }).fillX().row();
            if (this.showUnitPro) {
                table.table((Table t) -> {
                    t.table((Table tt) -> {
                        tt.add("[red]\u8840\uff1a");
                        tt.field(Strings.autoFixed(unit.health, 1), text -> {
                            unit.health = Float.parseFloat(text);
                        }).valid(Strings::canParsePositiveFloat);
                        tt.add("[yellow]\u76fe\uff1a");
                        tt.field(Strings.autoFixed(unit.shield, 1), text -> {
                            unit.shield = Float.parseFloat(text);
                        }).valid(Strings::canParsePositiveFloat);
                    }).row();
                    t.table((Table tt) -> {
                        tt.add("\u961f\u4f0d\uff1a");
                        tt.field(String.valueOf(unit.team.id), text -> {
                            unit.team = Team.get(Integer.parseInt(text));
                        }).valid(text -> Strings.canParsePositiveInt(text) && Integer.parseInt(text) < Team.all.length).maxTextLength(4).get();
                        for (Team team : Team.baseTeams) {
                            tt.button("[#" + team.color + "]" + team.localized(), Styles.flatToggleMenut, () -> {
                                unit.team = team;
                                rebuildTable[0].run();
                            }).checked(b -> unit.team == team).size(30.0f, 30.0f);
                        }
                        tt.button("[violet]+", Styles.flatToggleMenut, () -> new TeamSelectDialog(team -> {
                            unit.team = team;
                            rebuildTable[0].run();
                        }, unit.team).show()).checked(b -> !Seq.with(Team.baseTeams).contains(unit.team)).tooltip("[acid]\u66f4\u591a\u961f\u4f0d\u9009\u62e9").center().width(50.0f).row();
                    }).row();
                    t.table((Table list) -> list.check("\u98de\u884c\u6a21\u5f0f    [orange]\u751f\u6210\u7684\u5355\u4f4d\u4f1a\u98de\u8d77\u6765", this.elevation, a -> {
                        this.elevation = !this.elevation;
                    }).center().padBottom(5.0f).padRight(10.0f));
                }).row();
            }
            StringBuilder unitStatusText = new StringBuilder("\u5355\u4f4d\u72b6\u6001 ");
            for (StatusEntry entry : this.unitStatus) {
                unitStatusText.append(entry.effect.emoji());
            }
            table.button(unitStatusText.toString(), (Drawable)(this.showStatesEffect ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                this.showStatesEffect = !this.showStatesEffect;
                rebuildTable[0].run();
            }).fillX().row();
            if (this.showStatesEffect) {
                table.table((Table t) -> {
                    t.table((Table list) -> {
                        int i = 0;
                        for (StatusEffect effects : Vars.content.statusEffects()) {
                            if (effects == StatusEffects.none) continue;
                            if (i++ % 8 == 0) {
                                list.row();
                            }
                            list.button(effects.emoji(), Styles.squareTogglet, () -> {
                                this.unitStatus.add(new StatusEntry().set(effects, this.unitStatus.isEmpty() ? 600.0f : this.unitStatus.orderedItems().peek().time));
                                rebuildTable[0].run();
                            }).size(50.0f).color(this.unitStatus.select(e -> e.effect == effects).isEmpty() ? Color.gray : Color.white).tooltip(effects.localizedName);
                        }
                    }).top().center();
                    t.row();
                    float[] status = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
                    this.unitStatus.each(s -> {
                        status[0] = status[0] * s.effect.healthMultiplier;
                        status[1] = status[1] * s.effect.damageMultiplier;
                        status[2] = status[2] * s.effect.reloadMultiplier;
                        status[3] = status[3] * s.effect.speedMultiplier;
                    });
                    Table statusText = UnitType.getStatustext(status[0], status[1], status[2], status[3]);
                    if (statusText != null) {
                        t.add(statusText).row();
                    }
                    t.table((Table list) -> {
                        for (StatusEntry entry : this.unitStatus) {
                            list.add(entry.effect.emoji() + entry.effect.localizedName + " ");
                            if (entry.effect.permanent) {
                                list.add("<\u6c38\u4e45\u72b6\u6001>");
                            } else if (entry.effect.reactive) {
                                list.add("<\u77ac\u95f4\u72b6\u6001>");
                            } else {
                                list.table((Table et) -> {
                                    TextField sField = et.field(this.checkInf(entry.time), text -> {
                                        entry.time = Objects.equals(text, "Inf") ? Float.MAX_VALUE : Float.parseFloat(text);
                                    }).valid(text -> Objects.equals(text, "Inf") || Strings.canParsePositiveFloat(text)).tooltip("buff\u6301\u7eed\u65f6\u95f4(\u5355\u4f4d\uff1a\u79d2)").maxTextLength(10).get();
                                    et.add("\u79d2");
                                    Slider sSlider = et.slider(0.0f, (float)this.statusTime.length - 1.0f, 1.0f, this.statusTimeIndex(entry.time), n -> {
                                        if ((float)this.statusTimeIndex(entry.time) != n) {
                                            sField.setText(this.checkInf(this.statusTime[(int)n]));
                                        }
                                        entry.time = this.statusTime[(int)n];
                                    }).get();
                                    sField.update(() -> sSlider.setValue(this.statusTimeIndex(entry.time)));
                                });
                            }
                            list.button(Icon.cancel, () -> {
                                this.unitStatus.remove(entry);
                                rebuildTable[0].run();
                            });
                            list.row();
                        }
                    });
                }).fillX().row();
            }
            String unitItemText = "\u5355\u4f4d\u7269\u54c1 ";
            if (unit.stack.amount > 0 && !this.showItems) {
                unitItemText = unitItemText + unit.stack.item.emoji() + " " + unit.stack.amount;
            }
            table.button(unitItemText, (Drawable)(this.showItems ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                this.showItems = !this.showItems;
                rebuildTable[0].run();
            }).fillX().row();
            if (this.showItems) {
                table.table((Table pt) -> {
                    pt.table((Table ptt) -> {
                        int i = 0;
                        for (Item item : Vars.content.items()) {
                            ptt.button(item.emoji(), Styles.cleart, () -> {
                                unit.stack.item = item;
                                if (unit.stack.amount == 0) {
                                    unit.stack.amount = unit.itemCapacity();
                                }
                                rebuildTable[0].run();
                            }).size(50.0f).left().tooltip(item.localizedName);
                            if (++i % 6 != 0) continue;
                            ptt.row();
                        }
                    });
                    if (unit.stack.amount > 0) {
                        pt.row();
                        pt.table((Table ptt) -> {
                            ptt.add(unit.stack.item.emoji() + " \u6570\u91cf\uff1a");
                            ptt.field(String.valueOf(unit.stack.amount), text -> {
                                unit.stack.amount = Integer.parseInt(text);
                            }).valid(value -> {
                                if (!Strings.canParsePositiveInt(value)) {
                                    return false;
                                }
                                int val = Integer.parseInt(value);
                                return 0 < val && val <= unit.type.itemCapacity;
                            }).maxTextLength(4);
                            ptt.add("/ " + unit.type.itemCapacity + " ");
                            ptt.button((Drawable)Icon.up, Styles.cleari, () -> {
                                unit.stack.amount = unit.type.itemCapacity;
                                rebuildTable[0].run();
                            }).tooltip("\u8bbe\u7f6e\u7269\u54c1\u6570\u91cf\u4e3a\u5355\u4f4d\u6700\u5927\u5bb9\u91cf");
                            ptt.button((Drawable)Icon.down, Styles.cleari, () -> {
                                unit.stack.amount = 0;
                                rebuildTable[0].run();
                            }).tooltip("\u6e05\u7a7a\u5355\u4f4d\u7269\u54c1");
                        });
                    }
                }).row();
            }
            if (unit instanceof Payloadc) {
                Payloadc pay = (Payloadc)((Object)unit);
                StringBuilder unitPayloadText = new StringBuilder("\u5355\u4f4d\u80cc\u5305 ");
                for (Payload payload : pay.payloads()) {
                    unitPayloadText.append(payload.content().emoji());
                }
                table.button(unitPayloadText.toString(), (Drawable)(this.showPayload ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                    this.showPayload = !this.showPayload;
                    rebuildTable[0].run();
                }).fillX().checked(this.showPayload).row();
            }
            if (this.showPayload) {
                table.table((Table p) -> {
                    if (unit instanceof Payloadc) {
                        Payloadc pay = (Payloadc)((Object)unit);
                        p.table((Table pt) -> pay.payloads().each(payload -> {
                            if (payload instanceof Payloadc) {
                                Payloadc payloadUnit = (Payloadc)((Object)payload);
                                pt.button(payload.content().emoji() + "[red]*", Styles.squareTogglet, () -> {
                                    pay.payloads().remove((Payload)payload);
                                    rebuildTable[0].run();
                                }).color(payloadUnit.team().color).size(50.0f).left();
                            } else {
                                pt.button(payload.content().emoji(), Styles.squareTogglet, () -> {
                                    pay.payloads().remove((Payload)payload);
                                    rebuildTable[0].run();
                                }).size(50.0f).left();
                            }
                            if (pay.payloads().indexOf((Payload)payload) % 8 == 7) {
                                pt.row();
                            }
                        })).row();
                        p.button("\u8f7d\u5165\u5355\u4f4d " + UnitTypes.mono.emoji(), (Drawable)(this.showSelectPayload ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                            this.showSelectPayload = !this.showSelectPayload;
                            rebuildTable[0].run();
                        }).width(300.0f).row();
                        if (this.showSelectPayload) {
                            p.table((Table list) -> {
                                int i = 0;
                                for (UnitType units : Vars.content.units()) {
                                    list.button(units.emoji(), () -> {
                                        pay.addPayload(new UnitPayload(units.create(unit.team)));
                                        rebuildTable[0].run();
                                    }).size(50.0f).tooltip(units.localizedName);
                                    if (++i % 8 != 0) continue;
                                    list.row();
                                }
                            });
                            p.row();
                            p.table((Table pt) -> {
                                pt.button("[cyan]\u81ea\u9012\u5f52", () -> {
                                    pay.pickup(this.cloneUnit(unit));
                                    rebuildTable[0].run();
                                }).width(200.0f);
                                pt.button("?", () -> Vars.ui.showInfo("\u4f7f\u7528\u8bf4\u660e\uff1a\u643a\u5e26\u7684\u5355\u4f4d\u5b58\u5728\u4e00\u4e2a\u5e8f\u5217\uff0c\u6bcf\u4e2a\u5355\u4f4d\u53ef\u4ee5\u5177\u5907\u7279\u5b9a\u7684\u5c5e\u6027\u3002\n[cyan]\u81ea\u9012\u5f52[white]\u662f\u6307\u6839\u636e\u5f53\u524d\u7684\u914d\u7f6e\u751f\u6210\u4e00\u4e2a\u5355\u4f4d\uff0c\u5e76\u50a8\u5b58\u5230\u8f7d\u8377\u5e8f\u5217\u4e0a\n\u8fd9\u4e00\u5355\u4f4d\u5177\u5907\u6240\u6709\u76ee\u524d\u8bbe\u7f6e\u7684\u5c5e\u6027\uff0c\u5305\u62ecbuff\u3001\u7269\u54c1\u548c\u8f7d\u8377\u3002\n\u5408\u7406\u4f7f\u7528\u81ea\u9012\u5f52\u53ef\u4ee5\u53d1\u6398\u65e0\u9650\u7684\u53ef\u80fd\u6027\n[orange][\u8b66\u544a]\u53ef\u80fd\u5bfc\u81f4\u5730\u56fe\u635f\u574f\uff01\u8bf7\u5907\u4efd\u5730\u56fe\u540e\u518d\u4f7f\u7528\uff01")).size(50.0f);
                            }).row();
                        }
                        p.button("\u8f7d\u5165\u5efa\u7b51 " + Blocks.surgeWallLarge.emoji(), (Drawable)(this.showPayloadBlock ? Icon.upOpen : Icon.downOpen), Styles.togglet, () -> {
                            this.showPayloadBlock = !this.showPayloadBlock;
                            rebuildTable[0].run();
                        }).width(300.0f).row();
                        if (this.showPayloadBlock) {
                            p.table((Table list) -> {
                                int i = 0;
                                for (Block payBlock : Vars.content.blocks()) {
                                    if (!payBlock.isVisible() || !payBlock.isAccessible() || payBlock.isFloor()) continue;
                                    list.button(payBlock.emoji(), () -> {
                                        pay.addPayload(new BuildPayload(payBlock, unit.team));
                                        rebuildTable[0].run();
                                    }).size(50.0f).tooltip(payBlock.localizedName);
                                    if (++i % 8 != 0) continue;
                                    list.row();
                                }
                            });
                        }
                    }
                }).fillX().row();
            }
            table.row();
            table.button("[red]\u91cd\u7f6e\u51fa\u5382\u72b6\u6001", () -> {
                this.resetUnitType(unit, unit.type);
                rebuildTable[0].run();
                rebuildFabricatorTable.closeOnBack();
            }).fillX().row();
        };
        rebuildTable[0].run();
        rebuildFabricatorTable.cont.add(pane);
        rebuildFabricatorTable.addCloseButton();
        rebuildFabricatorTable.show();
    }

    private Unit cloneExactUnit(Unit unit) {
        Unit reUnit = unit.type.create(unit.team);
        reUnit.health = unit.health;
        reUnit.shield = unit.shield;
        reUnit.stack = unit.stack.copy();
        for (StatusEffect effects : Vars.content.statusEffects()) {
            if (!(unit.getDuration(effects) > 0.0f)) continue;
            reUnit.apply(effects, unit.getDuration(effects));
        }
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            if (reUnit instanceof Payloadc) {
                Payloadc rePay = (Payloadc)((Object)reUnit);
                pay.payloads().each(rePay::addPayload);
            }
        }
        return reUnit;
    }

    private Unit cloneUnit(Unit unit) {
        Unit reUnit = unit.type.create(unit.team);
        reUnit.health = unit.health;
        reUnit.shield = unit.shield;
        reUnit.stack = unit.stack;
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            if (reUnit instanceof Payloadc) {
                Payloadc rePay = (Payloadc)((Object)reUnit);
                pay.payloads().each(rePay::addPayload);
            }
        }
        return reUnit;
    }

    private void resetUnitType(Unit unit, UnitType unitType) {
        this.elevation = false;
        unit.type = unitType;
        unit.health = unitType.health;
        unit.shield = 0.0f;
        unit.stack.amount = 0;
        if (unit instanceof Payloadc) {
            Payloadc pay = (Payloadc)((Object)unit);
            pay.payloads().clear();
        }
        this.unitStatus.clear();
    }

    private void changeUnitType(Unit unit, UnitType unitType) {
        unit.type = unitType;
        unit.health = unitType.health;
        unit.shield = 0.0f;
        if (unit.stack.amount > unit.itemCapacity()) {
            unit.stack.amount = unit.itemCapacity();
        }
        this.unitStatus.clear();
    }

    private String checkInf(float value) {
        if (value == Float.MAX_VALUE) {
            return "Inf";
        }
        return Strings.autoFixed(value, 1);
    }

    private int statusTimeIndex(float time) {
        for (int i = this.statusTime.length - 1; i >= 0; --i) {
            if (!(this.statusTime[i] <= time)) continue;
            return i;
        }
        return 0;
    }

    private void sendFormatChat(String format, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            Object object = args[i];
            if (!(object instanceof Float)) continue;
            Float f = (Float)object;
            args[i] = Strings.autoFixed(f.floatValue(), 1);
        }
        Time.run(this.chatTime, () -> Call.sendChatMessage(Strings.format(format, args)));
        this.chatTime += 10.0f;
    }

    private int getPrice(UnitType unitType) {
        return (int)(unitType.health * (1.0f + unitType.range / 8.0f / 50.0f) / 20.0f);
    }

    private void generateRTSCode() {
        StringBuilder code = new StringBuilder();
        Vars.content.units().each(unitType -> {
            code.append("set \u5355\u4f4d @").append(unitType.name).append("\n");
            code.append("set \u4ef7\u683c ").append(this.getPrice((UnitType)unitType)).append("\n");
            code.append("set \u5de5\u5382 ");
            if (unitType.flying) {
                if (unitType.health < 400.0f) {
                    code.append("\u7a7a1");
                } else {
                    code.append("\u7a7a2");
                }
            } else {
                if (unitType.allowLegStep || unitType.naval) {
                    code.append("\u6d77\u722c");
                } else {
                    code.append("\u9646");
                }
                if (unitType.health < 720.0f) {
                    code.append("1");
                } else {
                    code.append("2");
                }
            }
            code.append("\n");
            code.append("set \u540d\u79f0 \"").append(unitType.emoji()).append(" ").append(unitType.localizedName).append(" ").append(unitType.name).append("\"\n");
            code.append("set @counter c\u8fd4\u56de").append("\n");
        });
        Core.app.setClipboardText(code.toString());
    }
}

