/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.ui;

import arc.Core;
import arc.Graphics;
import arc.math.Interp;
import arc.scene.Group;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import mindustry.ClientLauncher;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.toolpack.arcWaveSpawner;
import mindustry.arcModule.ui.LabelController;
import mindustry.arcModule.ui.dialogs.AboutCN_ARCDialog;
import mindustry.arcModule.ui.dialogs.AchievementsDialog;
import mindustry.arcModule.ui.dialogs.MessageDialog;
import mindustry.arcModule.ui.dialogs.MusicDialog;
import mindustry.arcModule.ui.window.WindowManager;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.CustomRulesDialog;
import mindustry.ui.dialogs.UpdateDialog;
import mindustry.ui.fragments.FadeInFragment;
import mindustry.ui.fragments.YuanShenFragment;

public class ARCUI {
    public Graphics.Cursor resizeHorizontalCursor;
    public Graphics.Cursor resizeVerticalCursor;
    public Graphics.Cursor resizeLeftCursor;
    public Graphics.Cursor resizeRightCursor;
    public AboutCN_ARCDialog aboutcn_arc;
    public UpdateDialog updatedialog;
    public CustomRulesDialog customrules;
    public AchievementsDialog achievements;
    public MessageDialog MessageDialog;
    public MusicDialog MusicDialog;
    public WindowManager WindowManager;
    public LabelController LabelController;

    public void arcInfo(String text, float duration) {
        Table t = new Table(Styles.black3);
        t.touchable = Touchable.disabled;
        t.margin(8.0f).add(text).style(Styles.outlineLabel).labelAlign(1);
        t.update(() -> t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() / 4.0f, 1));
        t.actions(Actions.fadeOut(duration, Interp.pow4In), Actions.remove());
        t.pack();
        t.act(0.1f);
        Core.scene.add(t);
    }

    public void arcInfo(String text) {
        this.arcInfo(text, 3.0f);
    }

    public void load() {
        this.resizeHorizontalCursor = RFuncs.customCursor("resizeHorizontal", Fonts.cursorScale());
        this.resizeVerticalCursor = RFuncs.customCursor("resizeVertical", Fonts.cursorScale());
        this.resizeLeftCursor = RFuncs.customCursor("resizeLeft", Fonts.cursorScale());
        this.resizeRightCursor = RFuncs.customCursor("resizeRight", Fonts.cursorScale());
    }

    public void init(Group group) {
        this.aboutcn_arc = new AboutCN_ARCDialog();
        this.updatedialog = new UpdateDialog();
        this.customrules = new CustomRulesDialog();
        this.achievements = new AchievementsDialog();
        this.MessageDialog = new MessageDialog();
        this.MusicDialog = new MusicDialog();
        this.LabelController = new LabelController();
        this.WindowManager = new WindowManager();
        if (ClientLauncher.YuanShenLoader) {
            new YuanShenFragment().build();
        } else {
            new FadeInFragment().build(group);
        }
        Core.settings.put("yuanshen", ClientLauncher.YuanShenLoader);
        arcWaveSpawner.initArcWave();
    }
}

