/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.scene.ui.Dialog;
import arc.scene.ui.Label;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.logic.CanvasBlock;

public class picToMindustry {
    static Pixmap oriImage;
    static Pixmap image;
    static Pixmap Cimage;
    static Integer closest;
    static Table tTable;
    static Fi originFile;
    static int[] palette;
    static int canvasSize;
    static float scale;
    static float[] scaleList;
    static int colorDisFun;
    static String[] disFunList;

    public static void show() {
        picToMindustry.ptDialog().show();
    }

    public static Dialog ptDialog() {
        BaseDialog pt = new BaseDialog("arc-\u56fe\u7247\u8f6c\u6362\u5668");
        pt.cont.table(t -> {
            t.add("\u9009\u62e9\u5e76\u5bfc\u5165\u56fe\u7247\uff0c\u53ef\u5c06\u5176\u8f6c\u6210\u753b\u677f\u3001\u50cf\u7d20\u753b\u6216\u662f\u903b\u8f91\u753b").padBottom(20.0f).row();
            t.button("[cyan]\u9009\u62e9\u56fe\u7247[white](png)", () -> Vars.platform.showFileChooser(false, "png", file -> {
                try {
                    originFile = file;
                    byte[] bytes = file.readBytes();
                    oriImage = new Pixmap(bytes);
                    picToMindustry.rebuilt();
                    if (picToMindustry.oriImage.width > 500 || picToMindustry.oriImage.height > 500) {
                        ARCVars.arcui.arcInfo("[orange]\u8b66\u544a\uff1a\u56fe\u7247\u53ef\u80fd\u8fc7\u5927\uff0c\u8bf7\u5c1d\u8bd5\u538b\u7f29\u56fe\u7247", 5.0f);
                    }
                }
                catch (Throwable e) {
                    ARCVars.arcui.arcInfo("\u8bfb\u53d6\u56fe\u7247\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u56fe\u7247\n" + e);
                }
            })).size(240.0f, 50.0f).padBottom(20.0f).row();
            t.check("\u81ea\u52a8\u4fdd\u5b58\u4e3a\u84dd\u56fe", Core.settings.getBool("autoSavePTM"), ta -> Core.settings.put("autoSavePTM", ta));
        }).padBottom(20.0f).row();
        pt.cont.table(t -> {
            t.add("\u7f29\u653e: \ue815 ");
            Label zoom = t.add(String.valueOf(scale)).padRight(20.0f).get();
            t.slider(0.0f, scaleList.length - 1, 1.0f, 11.0f, s -> {
                scale = scaleList[(int)s];
                zoom.setText(Strings.fixed(scale, 2));
                picToMindustry.rebuilt();
            }).width(200.0f);
        }).padBottom(20.0f).visible(() -> oriImage != null).row();
        pt.cont.table(t -> {
            t.add("\u8272\u8c03\u51fd\u6570: ");
            Label zoom = t.add(disFunList[0]).padRight(20.0f).get();
            t.slider(0.0f, disFunList.length - 1, 1.0f, 0.0f, s -> {
                colorDisFun = (int)s;
                zoom.setText(disFunList[colorDisFun]);
            }).width(200.0f);
        }).padBottom(20.0f).visible(() -> oriImage != null).row();
        pt.cont.table(a -> {
            tTable = a;
        });
        pt.cont.row();
        pt.cont.button("\u903b\u8f91\u753b\u7f51\u7ad9 " + Blocks.logicDisplay.emoji(), () -> {
            String imageUrl = "https://buibiu.github.io/imageToMLogicPage/#/";
            if (!Core.app.openURI(imageUrl)) {
                Vars.ui.showErrorMessage("\u6253\u5f00\u5931\u8d25\uff0c\u7f51\u5740\u5df2\u590d\u5236\u5230\u7c98\u8d34\u677f\n\u8bf7\u81ea\u884c\u5728\u9605\u89c8\u5668\u6253\u5f00");
                Core.app.setClipboardText(imageUrl);
            }
        }).width(200.0f);
        ((Dialog)pt).addCloseButton();
        return pt;
    }

    private static String formatNumber(int number) {
        return picToMindustry.formatNumber(number, 1.0f);
    }

    private static String formatNumber(int number, float alert) {
        if ((float)number >= 500.0f * alert) {
            return "[red]" + number + "[]";
        }
        if ((float)number >= 200.0f * alert) {
            return "[orange]" + number + "[]";
        }
        return String.valueOf(number);
    }

    private static void rebuilt() {
        image = Pixmaps.scale(oriImage, scale);
        tTable.clear();
        tTable.table(t -> {
            t.add("\u8def\u5f84").color(ARCVars.getThemeColor()).padRight(25.0f).padBottom(10.0f);
            t.button("\ue874", () -> Core.app.setClipboardText(originFile.absolutePath()));
            t.add(originFile.absolutePath()).padBottom(10.0f).row();
            t.add("\u540d\u79f0").color(ARCVars.getThemeColor()).padRight(25.0f).padBottom(10.0f);
            t.button("\ue874", () -> Core.app.setClipboardText(originFile.name()));
            t.add(originFile.name()).padBottom(10.0f).row();
            t.add("\u539f\u59cb\u5927\u5c0f").color(ARCVars.getThemeColor()).padRight(25.0f);
            t.add(picToMindustry.formatNumber(picToMindustry.oriImage.width) + "\ue815" + picToMindustry.formatNumber(picToMindustry.oriImage.height));
        }).padBottom(20.0f).row();
        tTable.table(t -> {
            t.table(tt -> {
                tt.button("\u753b\u677f " + Blocks.canvas.emoji(), Styles.cleart, () -> {
                    Cimage = image.copy();
                    picToMindustry.create_rbg(palette);
                    picToMindustry.canvasGenerator();
                }).size(100.0f, 50.0f);
                tt.add("\u5927\u5c0f\uff1a" + picToMindustry.formatNumber(picToMindustry.image.width / canvasSize, 0.5f) + "\ue815" + picToMindustry.formatNumber(picToMindustry.image.height / canvasSize + 1, 0.5f));
            });
            t.row();
            t.table(tt -> {
                tt.button("\u753b\u677f++ " + Blocks.canvas.emoji(), Styles.cleart, () -> {
                    Cimage = image.copy();
                    picToMindustry.canvasPlus(Cimage);
                    picToMindustry.canvasGenerator();
                }).size(100.0f, 50.0f);
                tt.add("\u5927\u5c0f\uff1a" + picToMindustry.formatNumber(picToMindustry.image.width / canvasSize, 0.5f) + "\ue815" + picToMindustry.formatNumber(picToMindustry.image.height / canvasSize + 1, 0.5f));
            }).row();
            t.table(tt -> {
                tt.button("\u50cf\u7d20\u753b " + Blocks.sorter.emoji(), Styles.cleart, () -> {
                    Cimage = image.copy();
                    picToMindustry.sorterGenerator();
                }).size(100.0f, 50.0f);
                tt.add("\u5927\u5c0f\uff1a" + picToMindustry.formatNumber(picToMindustry.image.width) + "\ue815" + picToMindustry.formatNumber(picToMindustry.image.height));
            }).row();
        });
    }

    private static float diff_rbg(Integer a, Integer b) {
        int ar = a >> 24 & 0xFF;
        int ag = a >> 16 & 0xFF;
        int ab = a >> 8 & 0xFF;
        int br = b >> 24 & 0xFF;
        int bg = b >> 16 & 0xFF;
        int bb = b >> 8 & 0xFF;
        int dr = Math.abs(ar - br);
        int dg = Math.abs(ag - bg);
        int db = Math.abs(ab - bb);
        switch (colorDisFun) {
            case 1: {
                return dr * dr + dg * dg + db * db;
            }
            case 2: {
                float Rmean = (float)(ar + br) / 2.0f;
                return (float)Math.sqrt((2.0f + Rmean / 256.0f) * (float)(dr * dr) + (float)(4 * (dg * dg)) + (2.0f + (255.0f - Rmean) / 256.0f) * (float)(db * db));
            }
        }
        return dr + dg + db;
    }

    private static void create_rbg(int[] colorBar) {
        for (int x = 0; x < picToMindustry.image.width; ++x) {
            for (int y = 0; y < picToMindustry.image.height; ++y) {
                Integer pixel = image.get(x, y);
                float egg = 1000.0f;
                for (int other : colorBar) {
                    float h = picToMindustry.diff_rbg(pixel, other);
                    if (!(h < egg)) continue;
                    closest = other;
                    egg = h;
                }
                Cimage.set(x, y, closest);
            }
        }
    }

    private static void canvasGenerator() {
        int width = picToMindustry.Cimage.width / canvasSize;
        int height = picToMindustry.Cimage.height / canvasSize + 1;
        Seq<Schematic.Stile> tiles = new Seq<Schematic.Stile>();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                CanvasBlock.CanvasBuild build = (CanvasBlock.CanvasBuild)Blocks.canvas.newBuilding();
                Pixmap region = Cimage.crop(x * canvasSize, (height - y - 1) * canvasSize, canvasSize, canvasSize);
                byte[] bytes = build.packPixmap(region);
                Schematic.Stile stile = new Schematic.Stile(Blocks.canvas, x * 2, y * 2, bytes, 0);
                tiles.add(stile);
            }
        }
        StringMap tags = new StringMap();
        tags.put("name", originFile.name());
        Schematic schem = new Schematic(tiles, tags, width * 2, height * 2);
        picToMindustry.saveSchem(schem, Blocks.canvas.emoji());
    }

    private static void saveSchem(Schematic schem, String l) {
        schem.labels.add(l);
        if (Core.settings.getBool("autoSavePTM")) {
            Vars.schematics.add(schem);
            ARCVars.arcui.arcInfo("\u5df2\u4fdd\u5b58\u84dd\u56fe\uff1a" + originFile.name(), 10.0f);
        }
        if (Vars.state.isGame()) {
            Vars.ui.schematics.hide();
            Vars.control.input.useSchematic(schem);
        }
    }

    private static void sorterGenerator() {
        Seq<Schematic.Stile> tiles = new Seq<Schematic.Stile>();
        for (int y = 0; y < picToMindustry.image.height; ++y) {
            for (int x = 0; x < picToMindustry.image.width; ++x) {
                if (image.get(x, y) == 0) continue;
                Sorter.SorterBuild build = (Sorter.SorterBuild)Blocks.sorter.newBuilding();
                float[] closestItem = new float[]{99999.0f};
                int finalX = x;
                int finalY = y;
                Vars.content.items().each(t -> {
                    float dst = picToMindustry.diff_rbg(t.color.rgba(), image.get(finalX, finalY));
                    if (dst > closestItem[0]) {
                        return;
                    }
                    build.sortItem = t;
                    closestItem[0] = dst;
                });
                Schematic.Stile stile = new Schematic.Stile(Blocks.sorter, x, picToMindustry.image.height - y - 1, build.config(), 0);
                tiles.add(stile);
            }
        }
        StringMap tags = new StringMap();
        tags.put("name", originFile.name());
        Schematic schem = new Schematic(tiles, tags, picToMindustry.image.width, picToMindustry.image.height);
        picToMindustry.saveSchem(schem, Blocks.sorter.emoji());
    }

    private static int trans(RGB c1, RGB c2, int mul) {
        return c1.add(c2.cpy().mul(mul).mv(4)).rgba();
    }

    private static void canvasPlus(Pixmap image) {
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                RGB pix = new RGB(image.get(x, y));
                int nearest = picToMindustry.findNearestColor(pix);
                image.set(x, y, nearest);
                pix.sub(new RGB(nearest));
                if (x + 1 < image.width) {
                    image.set(x + 1, y, picToMindustry.trans(new RGB(image.get(x + 1, y)), pix, 7));
                }
                if (y + 1 >= image.height) continue;
                if (x - 1 > 0) {
                    image.set(x - 1, y + 1, picToMindustry.trans(new RGB(image.get(x - 1, y + 1)), pix, 3));
                }
                image.set(x, y + 1, picToMindustry.trans(new RGB(image.get(x, y + 1)), pix, 5));
                if (x + 1 >= image.width) continue;
                image.set(x + 1, y + 1, picToMindustry.trans(new RGB(image.get(x + 1, y + 1)), pix, 1));
            }
        }
    }

    private static int findNearestColor(RGB color) {
        int max = 195076;
        int output = 0;
        for (int i : palette) {
            int delta = color.cpy().sub(new RGB(i)).pow();
            if (delta >= max) continue;
            max = delta;
            output = i;
        }
        return output;
    }

    static {
        closest = null;
        scale = 1.0f;
        scaleList = new float[]{0.02f, 0.05f, 0.1f, 0.15f, 0.2f, 0.25f, 0.3f, 0.4f, 0.5f, 0.65f, 0.8f, 1.0f, 1.25f, 1.5f, 2.0f, 3.0f, 5.0f};
        colorDisFun = 0;
        disFunList = new String[]{"\u57fa\u7840\u5bf9\u6bd4", "\u5e73\u65b9\u5bf9\u6bd4", "LAB"};
        CanvasBlock canva = (CanvasBlock)Blocks.canvas;
        palette = canva.palette;
        canvasSize = canva.canvasSize;
    }

    private static class RGB {
        int r;
        int g;
        int b;

        RGB(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        RGB(int rgba) {
            this(rgba >> 24 & 0xFF, rgba >> 16 & 0xFF, rgba >> 8 & 0xFF);
        }

        public RGB sub(RGB c) {
            this.r -= c.r;
            this.g -= c.g;
            this.b -= c.b;
            return this;
        }

        public RGB add(RGB c) {
            this.r = Math.max(Math.min(c.r + this.r, 255), 0);
            this.g = Math.max(Math.min(c.g + this.g, 255), 0);
            this.b = Math.max(Math.min(c.b + this.b, 255), 0);
            return this;
        }

        public RGB mul(int m) {
            this.r *= m;
            this.g *= m;
            this.b *= m;
            return this;
        }

        public RGB mv(int s) {
            this.r >>= s;
            this.g >>= s;
            this.b >>= s;
            return this;
        }

        public int pow() {
            return this.r * this.r + this.g * this.g + this.b * this.b;
        }

        public int rgba() {
            return this.r << 24 | this.g << 16 | this.b << 8 | 0xFF;
        }

        public RGB cpy() {
            return new RGB(this.r, this.g, this.b);
        }
    }
}

