/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.Events;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.NumberFormat;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.game.EventType;
import mindustry.game.SpawnGroup;
import mindustry.world.Tile;

public class arcWaveSpawner {
    public static boolean hasFlyer = true;
    public static float flyerSpawnerRadius = 40.0f;
    static float spawnerMargin = 88.0f;
    public static Seq<waveInfo> arcWave = new Seq();

    public static void drawSpawner() {
        if (Vars.state.hasSpawns()) {
            Lines.stroke(2.0f);
            Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time, 8.0f, 1.0f));
            if (Core.settings.getBool("alwaysshowdropzone")) {
                Draw.alpha(0.8f);
                for (Tile tile : Vars.spawner.getSpawns()) {
                    DrawUtilities.arcDashCircling(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius, -flyerSpawnerRadius / Vars.state.rules.dropZoneRadius * 0.1f);
                }
            } else {
                for (Tile tile : Vars.spawner.getSpawns()) {
                    if (!tile.within(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + spawnerMargin)) continue;
                    Draw.alpha(Mathf.clamp(1.0f - (Vars.player.dst(tile) - Vars.state.rules.dropZoneRadius) / spawnerMargin));
                    Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
                }
            }
            if (hasFlyer && Core.settings.getBool("showFlyerSpawn") && Vars.spawner.countSpawns() < 20) {
                for (Tile tile : Vars.spawner.getSpawns()) {
                    float angle = Angles.angle((float)Vars.world.width() / 2.0f, (float)Vars.world.height() / 2.0f, tile.x, tile.y);
                    float trns = (float)Math.max(Vars.world.width(), Vars.world.height()) * Mathf.sqrt2 * 8.0f;
                    float spawnX = Mathf.clamp((float)(Vars.world.width() * 8) / 2.0f + Angles.trnsx(angle, trns), 0.0f, (float)(Vars.world.width() * 8));
                    float spawnY = Mathf.clamp((float)(Vars.world.height() * 8) / 2.0f + Angles.trnsy(angle, trns), 0.0f, (float)(Vars.world.height() * 8));
                    if (Core.settings.getBool("showFlyerSpawnLine")) {
                        Draw.color(Color.red, 0.5f);
                        Lines.line(tile.worldx(), tile.worldy(), spawnX, spawnY);
                    }
                    Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time, 8.0f, 1.0f));
                    Draw.alpha(0.8f);
                    DrawUtilities.arcDashCircling(spawnX, spawnY, flyerSpawnerRadius, 0.1f);
                    Draw.color();
                    Draw.alpha(0.5f);
                    Draw.rect(UnitTypes.zenith.fullIcon, spawnX, spawnY);
                }
            }
            Draw.reset();
        }
    }

    public static void checkInit() {
        if (arcWaveSpawner.arcWave.size == 0) {
            arcWaveSpawner.initArcWave();
        }
    }

    public static void initArcWave() {
        arcWaveSpawner.initArcWave((int)((float)arcWaveSpawner.calWinWave() * 1.5f));
    }

    public static void initArcWave(int wave) {
        arcWave = new Seq();
        int end = Math.min(wave, 50000);
        for (int waveN = 0; waveN < end; ++waveN) {
            arcWave.add(new waveInfo(waveN));
        }
    }

    public static int calWinWave() {
        if (Vars.state.rules.winWave >= 1) {
            return Vars.state.rules.winWave;
        }
        int maxwave = 0;
        for (SpawnGroup group : Vars.state.rules.spawns) {
            if (group.end > 99999) continue;
            maxwave = Math.max(maxwave, group.end);
        }
        if (maxwave > 5000) {
            return 200;
        }
        if (maxwave < 2 && Vars.state.rules.waveSpacing > 30.0f) {
            return (int)(1800000.0f / Vars.state.rules.waveSpacing);
        }
        return maxwave + 1;
    }

    static {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            hasFlyer = false;
            for (SpawnGroup sg : Vars.state.rules.spawns) {
                if (!sg.type.flying) continue;
                hasFlyer = true;
                break;
            }
            arcWaveSpawner.initArcWave();
        });
    }

    public static class waveInfo {
        public int waveIndex;
        public Seq<waveGroup> groups = new Seq();
        public int amount = 0;
        public int amountL = 0;
        public float health = 0.0f;
        public float effHealth = 0.0f;
        public float dps = 0.0f;
        public long healthL = 0L;
        public long effHealthL = 0L;
        public long dpsL = 0L;

        waveInfo(int waveIndex) {
            this.waveIndex = waveIndex;
            for (SpawnGroup group : Vars.state.rules.spawns) {
                int amount = group.getSpawned(waveIndex);
                if (amount == 0) continue;
                this.groups.add(new waveGroup(waveIndex, group));
            }
            this.initProperty();
        }

        private void initProperty() {
            this.groups.each(group -> {
                this.amount += group.amountT;
                this.health += group.healthT;
                this.effHealth += group.effHealthT;
                this.dps += group.dpsT;
            });
        }

        public void specLoc(int spawn, Boolf<SpawnGroup> pre) {
            this.amountL = 0;
            this.healthL = 0L;
            this.effHealthL = 0L;
            this.dpsL = 0L;
            this.groups.each(waveGroup2 -> (spawn == -1 || waveGroup2.group.spawn == -1 || waveGroup2.group.spawn == spawn) && pre.get(waveGroup2.group), group -> {
                this.amountL += group.amountT;
                this.healthL = (long)((float)this.healthL + group.healthT);
                this.effHealthL = (long)((float)this.effHealthL + group.effHealthT);
                this.dpsL = (long)((float)this.dpsL + group.dpsT);
            });
        }

        public Table proTable(boolean doesRow) {
            if (this.amountL == 0) {
                return new Table(t -> t.add("\u8be5\u6ce2\u6b21\u6ca1\u6709\u654c\u4eba"));
            }
            return new Table(t -> {
                t.add("\ue86d").width(50.0f);
                t.add("[accent]" + this.amountL).growX().padRight(50.0f);
                if (doesRow) {
                    t.row();
                }
                t.add("\ue813").width(50.0f);
                t.add("[accent]" + NumberFormat.formatInteger(this.healthL)).growX().padRight(50.0f);
                if (doesRow) {
                    t.row();
                }
                if (this.effHealthL != this.healthL) {
                    t.add("\ue810").width(50.0f);
                    t.add("[accent]" + NumberFormat.formatInteger(this.effHealthL)).growX().padRight(50.0f);
                    if (doesRow) {
                        t.row();
                    }
                }
                t.add("\ue86e").width(50.0f);
                t.add("[accent]" + NumberFormat.formatInteger(this.dpsL)).growX();
            });
        }

        public Table unitTable(int spawn, Boolf<SpawnGroup> pre) {
            return this.unitTable(spawn, pre, 10);
        }

        public Table unitTable(int spawn, Boolf<SpawnGroup> pre, int perCol) {
            int[] count = new int[1];
            return new Table(t -> this.groups.each(waveGroup2 -> (spawn == -1 || waveGroup2.group.spawn == -1 || waveGroup2.group.spawn == spawn) && pre.get(waveGroup2.group), wg -> {
                count[0] = count[0] + 1;
                if (count[0] % perCol == 0) {
                    t.row();
                }
                t.table(tt -> {
                    tt.table(ttt -> {
                        ttt.image(wg.group.type.uiIcon).size(30.0f);
                        ttt.add(wg.group.type.typeColor() + wg.amount).fillX();
                    }).row();
                    StringBuilder groupInfo = new StringBuilder();
                    if (wg.shield > 0.0f) {
                        groupInfo.append(NumberFormat.formatFloat(wg.shield));
                    }
                    groupInfo.append("\n[]");
                    if (wg.group.spawn != -1 && spawn == -1) {
                        groupInfo.append("*");
                    }
                    if (wg.group.effect != null && wg.group.effect != StatusEffects.none) {
                        groupInfo.append(wg.group.effect.emoji());
                    }
                    if (wg.group.items != null && wg.group.items.amount > 0) {
                        groupInfo.append(wg.group.items.item.emoji());
                    }
                    if (wg.group.payloads != null && wg.group.payloads.size > 0) {
                        groupInfo.append("\ue87b");
                    }
                    tt.add(groupInfo.toString()).fill();
                }).height(80.0f).width(70.0f);
            }));
        }
    }

    public static class waveGroup {
        public int waveIndex;
        public SpawnGroup group;
        public int amount;
        public int amountT;
        public float shield;
        public float health;
        public float effHealth;
        public float dps;
        public float healthT;
        public float effHealthT;
        public float dpsT;

        public waveGroup(int waveIndex, SpawnGroup group) {
            this.waveIndex = waveIndex;
            this.group = group;
            this.amount = group.getSpawned(waveIndex);
            this.shield = group.getShield(waveIndex);
            this.health = (group.type.health + this.shield) * (float)this.amount;
            this.dps = group.type.estimateDps() * (float)this.amount;
            this.effHealth = this.health;
            if (group.effect != null) {
                this.effHealth *= group.effect.healthMultiplier;
                this.dps *= group.effect.damageMultiplier * group.effect.reloadMultiplier;
            }
            int multiplier = group.spawn != -1 || Vars.spawner.countSpawns() < 2 ? 1 : Vars.spawner.countSpawns();
            this.amountT = this.amount * multiplier;
            this.healthT = this.health * (float)multiplier;
            this.effHealthT = this.effHealth * (float)multiplier;
            this.dpsT = this.dps * (float)multiplier;
        }
    }
}

