/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import mindustry.Vars;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.DrawUtilities;
import mindustry.arcModule.Marker;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Unit;
import mindustry.input.Binding;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class arcScanner {
    private static final float ratio = 10.0f;
    private static final float unitSize = 0.1f;
    private static final float markerSize = 120.0f;
    private static float sizeRate = 1.0f;
    private static float rRatio;
    private static float rUnitSize;
    private static float rMarkerSize;
    private static float radarCir;
    private static final int basicRadarCir = 25;
    private static float scanTime;
    private static float scanRate;
    private static float scanSpeed;
    private static float curScanRange;
    private static final Table t;
    private static float expandRate;
    private static float time;
    public static boolean mobileRadar;

    public static void drawScanner() {
        if (Core.settings.getInt("radarMode") == 0) {
            return;
        }
        float extendSpd = (float)Core.settings.getInt("radarMode") * 0.2f;
        Draw.reset();
        if (Vars.mobile) {
            if (extendSpd >= 6.0f) {
                arcScanner.t.visible = mobileRadar;
                scanRate = arcScanner.t.visible ? 1.0f : 0.0f;
            } else if (mobileRadar) {
                arcScanner.t.visible = true;
                if (scanRate < 1.0f) {
                    scanRate = Math.min(scanRate + 0.016666668f / scanTime * extendSpd, 1.0f);
                }
            } else {
                arcScanner.t.visible = false;
                if (scanRate > 0.0f) {
                    scanRate = Math.max(scanRate - 0.05f / scanTime * extendSpd, 0.0f);
                }
            }
        } else if (extendSpd >= 6.0f) {
            if (Core.input.keyDown(Binding.arcDetail) && Time.time - time > 60.0f) {
                time = Time.time;
                arcScanner.t.visible = !arcScanner.t.visible;
                scanRate = arcScanner.t.visible ? 1.0f : 0.0f;
            }
        } else if (Core.input.keyDown(Binding.arcDetail)) {
            arcScanner.t.visible = true;
            if (scanRate < 1.0f) {
                scanRate = Math.min(scanRate + 0.016666668f / scanTime * extendSpd, 1.0f);
            }
        } else {
            arcScanner.t.visible = false;
            if (scanRate > 0.0f) {
                scanRate = Math.max(scanRate - 0.05f / scanTime * extendSpd, 0.0f);
            }
        }
        if (scanRate <= 0.0f) {
            return;
        }
        float playerToBorder = Math.max(Math.max(Math.max(Mathf.dst(Vars.player.tileX(), Vars.player.tileY()), Mathf.dst(Vars.world.width() - Vars.player.tileX(), Vars.player.tileY())), Mathf.dst(Vars.world.width() - Vars.player.tileX(), Vars.world.height() - Vars.player.tileY())), Mathf.dst(Vars.player.tileX(), Vars.world.height() - Vars.player.tileY()));
        float worldSize = Math.min(playerToBorder, (float)((int)(Mathf.dst(Vars.world.width(), Vars.world.height()) / radarCir)) * radarCir);
        float playerSize = (float)(Math.min(Vars.world.width(), Vars.world.height()) * 8) * 0.03f;
        sizeRate = Core.settings.getInt("radarSize") == 0 ? 1.0f : (float)Core.settings.getInt("radarSize") * 0.1f / Vars.renderer.getScale();
        rRatio = 10.0f / (sizeRate *= Math.min(Core.scene.getHeight() / (float)(Vars.world.height() * 8), Core.scene.getWidth() / (float)(Vars.world.width() * 8)) * 2.0f);
        rUnitSize = 0.1f * sizeRate;
        rMarkerSize = 120.0f * sizeRate;
        expandRate = worldSize / 25.0f / 10.0f + 1.0f;
        radarCir = (int)expandRate * 25;
        curScanRange = worldSize * 8.0f * scanRate;
        expandRate *= sizeRate;
        int i = 1;
        while ((float)i < curScanRange / radarCir / 8.0f + 1.0f) {
            Draw.color(Vars.player.team().color, 0.45f);
            Lines.stroke(expandRate * 0.75f);
            Lines.circle(Vars.player.x, Vars.player.y, radarCir * (float)i * 8.0f / rRatio);
            float cirRatio = radarCir * (float)i * 8.0f / rRatio + 2.0f;
            DrawUtilities.arcDrawText(i * (int)radarCir + "", 0.2f / Scl.scl(1.0f) * expandRate, Vars.player.x, Vars.player.y + cirRatio, ARCVars.getThemeColor(), 1);
            DrawUtilities.arcDrawText(i * (int)radarCir + "", 0.2f / Scl.scl(1.0f) * expandRate, Vars.player.x + cirRatio * Mathf.cos(3.6651917f), Vars.player.y + cirRatio * Mathf.sin(3.6651917f), ARCVars.getThemeColor(), 1);
            DrawUtilities.arcDrawText(i * (int)radarCir + "", 0.2f / Scl.scl(1.0f) * expandRate, Vars.player.x + cirRatio * Mathf.cos(5.759587f), Vars.player.y + cirRatio * Mathf.sin(5.759587f), ARCVars.getThemeColor(), 1);
            ++i;
        }
        if (scanRate < 1.0f) {
            Draw.color(Vars.player.team().color, 0.8f);
            Lines.stroke(expandRate);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
            Draw.color(Vars.player.team().color, 0.1f);
            Fill.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
        } else {
            curScanRange = (float)((int)(curScanRange / radarCir / 8.0f + 1.0f)) * radarCir * 8.0f;
            Draw.color(Vars.player.team().color, 0.1f);
            Fill.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
            Draw.color(Vars.player.team().color, 0.6f);
            float curve = Mathf.curve(Time.time % 360.0f, 120.0f, 360.0f);
            Lines.stroke(expandRate * 1.5f);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange / rRatio);
            Lines.stroke(expandRate * 1.5f);
            Lines.circle(Vars.player.x, Vars.player.y, curScanRange * Interp.pow3Out.apply(curve) / rRatio);
            Lines.stroke(expandRate * 1.5f);
            Draw.color(Vars.player.team().color, 0.1f);
            Fill.rect(Vars.player.x - Vars.player.x / rRatio + (float)(Vars.world.width() * 8) / rRatio / 2.0f, Vars.player.y - Vars.player.y / rRatio + (float)(Vars.world.height() * 8) / rRatio / 2.0f, (float)(Vars.world.width() * 8) / rRatio, (float)(Vars.world.height() * 8) / rRatio);
            Draw.color(Vars.player.team().color, 0.85f);
            Lines.rect(Vars.player.x - Vars.player.x / rRatio, Vars.player.y - Vars.player.y / rRatio, (float)(Vars.world.width() * 8) / rRatio, (float)(Vars.world.height() * 8) / rRatio);
        }
        Draw.color(Vars.player.team().color, 0.8f);
        Lines.line(Vars.player.x, Vars.player.y, Vars.player.x + curScanRange * Mathf.cos(Time.time * scanSpeed) / rRatio, Vars.player.y + curScanRange * Mathf.sin(Time.time * scanSpeed) / rRatio);
        Draw.reset();
        if (Vars.spawner.countSpawns() < 25 && !Vars.state.rules.pvp) {
            for (Tile tile : Vars.spawner.getSpawns()) {
                if (scanRate < 1.0f && Mathf.dst(tile.worldx() - Vars.player.x, tile.worldy() - Vars.player.y) > curScanRange) continue;
                Draw.color(Vars.state.rules.waveTeam.color, 1.0f);
                arcScanner.arcDrawNearby(Icon.units.getRegion(), tile, Math.max(6.0f * expandRate, Vars.state.rules.dropZoneRadius / rRatio / 2.0f), Vars.state.rules.waveTeam.color);
                float curve = Mathf.curve(Time.time % 200.0f, 60.0f, 200.0f);
                Draw.color(Vars.state.rules.waveTeam.color, 1.0f);
                Lines.stroke(expandRate * 1.0f);
                Lines.circle(arcScanner.transX(tile.worldx()), arcScanner.transY(tile.worldy()), Vars.state.rules.dropZoneRadius * Interp.pow3Out.apply(curve) / rRatio);
                Draw.color(Vars.state.rules.waveTeam.color, 0.5f);
                Lines.stroke(expandRate * 0.8f);
                Lines.dashCircle(arcScanner.transX(tile.worldx()), arcScanner.transY(tile.worldy()), Vars.state.rules.dropZoneRadius / rRatio);
            }
        }
        for (Team team : Team.all) {
            for (CoreBlock.CoreBuild core : team.cores()) {
                if (Vars.state.rules.pvp && core.inFogTo(Vars.player.team()) || scanRate < 1.0f && Mathf.dst(core.x - Vars.player.x, core.y - Vars.player.y) > curScanRange) continue;
                Draw.color(core.team.color, 1.0f);
                Draw.rect(core.block.fullIcon, arcScanner.transX(core.tile.worldx()), arcScanner.transY(core.tile.worldy()), 4.0f * expandRate, 4.0f * expandRate);
            }
        }
        for (Building build : Vars.ui.hudfrag.quickToolTable.advanceBuildTool.buildingSeq) {
            if (scanRate < 1.0f && Mathf.dst(build.x - Vars.player.x, build.y - Vars.player.y) > curScanRange) continue;
            Draw.color(build.team.color, 1.0f);
            Draw.rect(build.block.fullIcon, arcScanner.transX(build.tile.worldx()), arcScanner.transY(build.tile.worldy()), 4.0f * expandRate, 4.0f * expandRate);
        }
        for (Unit unit : Groups.unit) {
            if (scanRate < 1.0f && Mathf.dst(unit.x - Vars.player.x, unit.y - Vars.player.y) > curScanRange) continue;
            Draw.color(unit.team.color, 0.6f);
            Fill.circle(arcScanner.transX(unit.x), arcScanner.transY(unit.y), unit.hitSize * rUnitSize);
        }
        for (Player unit : Groups.player) {
            if (Vars.player.dead() || Vars.player.unit().health <= 0.0f || scanRate < 1.0f && Mathf.dst(unit.x - Vars.player.x, unit.y - Vars.player.y) > curScanRange) continue;
            Draw.color(unit.team().color, 0.9f);
            float angle = unit.unit().rotation * ((float)Math.PI / 180);
            Fill.tri(arcScanner.transX(unit.x + Mathf.cos(angle) * playerSize), arcScanner.transY(unit.y + Mathf.sin(angle) * playerSize), arcScanner.transX(unit.x + Mathf.cos(angle + 2.0943952f) * playerSize * 0.75f), arcScanner.transY(unit.y + Mathf.sin(angle + 2.0943952f) * playerSize * 0.75f), arcScanner.transX(unit.x + Mathf.cos(angle + 4.1887903f) * playerSize * 0.75f), arcScanner.transY(unit.y + Mathf.sin(angle + 4.1887903f) * playerSize * 0.75f));
        }
        if (Marker.markList.size > 0) {
            Marker.markList.each(a -> {
                if (Time.time - a.time > 1800.0f) {
                    return;
                }
                Draw.color(a.markType.color);
                Lines.stroke(expandRate * (1.0f - (Time.time % 180.0f + 30.0f) / 210.0f));
                Lines.circle(arcScanner.transX(a.markPos.x), arcScanner.transY(a.markPos.y), rMarkerSize / rRatio * (Time.time % 180.0f) / 180.0f);
                Lines.stroke(expandRate);
                Lines.circle(arcScanner.transX(a.markPos.x), arcScanner.transY(a.markPos.y), rMarkerSize / rRatio);
                Lines.arc(arcScanner.transX(a.markPos.x), arcScanner.transY(a.markPos.y), (rMarkerSize - expandRate) / rRatio, 1.0f - (Time.time - a.time) / 1800.0f);
                Draw.reset();
            });
        }
    }

    public static void arcDrawNearbyRot(TextureRegion region, Tile tile, float size, boolean rotate, Color color) {
        float range = Mathf.dst(tile.worldy() - Vars.player.y, tile.worldx() - Vars.player.x);
        if (range > curScanRange) {
            return;
        }
        float rot = (float)Math.atan2(tile.worldy() - Vars.player.y, tile.worldx() - Vars.player.x);
        float nx = Vars.player.x + Mathf.cos(rot) * range / rRatio;
        float ny = Vars.player.y + Mathf.sin(rot) * range / rRatio;
        if (rotate) {
            Draw.rect(region, nx, ny, size, size, (float)Math.toDegrees(rot));
        } else {
            Draw.rect(region, nx, ny, size, size);
        }
        DrawUtilities.arcDrawText((int)(range / 8.0f) + "", 0.2f / Scl.scl(1.0f) * expandRate, nx, ny + size / 2.0f, color, 1);
    }

    public static void arcDrawNearby(TextureRegion region, Tile tile, float size, Color color) {
        float range = Mathf.dst(tile.worldy() - Vars.player.y, tile.worldx() - Vars.player.x);
        if (range > curScanRange) {
            return;
        }
        float nx = Vars.player.x + (tile.worldx() - Vars.player.x) / rRatio;
        float ny = Vars.player.y + (tile.worldy() - Vars.player.y) / rRatio;
        Draw.rect(region, nx, ny, size, size);
    }

    private static float transX(float x) {
        return Vars.player.x + (x - Vars.player.x) / rRatio;
    }

    private static float transY(float y) {
        return Vars.player.y + (y - Vars.player.y) / rRatio;
    }

    static {
        radarCir = 25.0f;
        scanTime = 5.0f;
        scanRate = 0.0f;
        scanSpeed = -0.02f;
        curScanRange = 0.0f;
        t = new Table(Styles.black3);
        expandRate = 1.0f;
        time = 0.0f;
        mobileRadar = false;
        arcScanner.t.touchable = Touchable.disabled;
        t.margin(8.0f).add(">> \u96f7\u8fbe\u626b\u63cf\u4e2d <<").color(ARCVars.getThemeColor()).style(Styles.outlineLabel).labelAlign(1);
        arcScanner.t.visible = false;
        t.update(() -> t.setPosition((float)Core.graphics.getWidth() / 2.0f, (float)Core.graphics.getHeight() * 0.1f, 1));
        t.pack();
        t.act(0.1f);
        t.update(() -> {
            arcScanner.t.visible = arcScanner.t.visible && Vars.state.isPlaying();
        });
        Core.scene.add(t);
        Events.on(EventType.WorldLoadEvent.class, event -> {
            scanTime = Math.max(Mathf.dst(Vars.world.width(), Vars.world.height()) / 20.0f, 7.5f);
        });
    }
}

