/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.func.Intc;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import java.lang.invoke.LambdaMetafactory;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.arcModule.RFuncs;
import mindustry.arcModule.draw.ARCUnits;
import mindustry.arcModule.toolpack.arcWaveSpawner;
import mindustry.content.Items;
import mindustry.entities.units.UnitController;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.input.Binding;
import mindustry.type.Item;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.distribution.ArmoredConveyor;
import mindustry.world.blocks.distribution.Conveyor;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.distribution.Duct;
import mindustry.world.blocks.distribution.DuctBridge;
import mindustry.world.blocks.distribution.DuctRouter;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.distribution.Junction;
import mindustry.world.blocks.distribution.MassDriver;
import mindustry.world.blocks.distribution.OverflowDuct;
import mindustry.world.blocks.distribution.OverflowGate;
import mindustry.world.blocks.distribution.Router;
import mindustry.world.blocks.distribution.Sorter;
import mindustry.world.blocks.distribution.StackConveyor;
import mindustry.world.blocks.liquid.LiquidBridge;
import mindustry.world.blocks.liquid.LiquidJunction;
import mindustry.world.blocks.production.GenericCrafter;
import mindustry.world.blocks.storage.CoreBlock;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.blocks.storage.Unloader;
import mindustry.world.meta.BlockGroup;

public class arcScanMode {
    private static Table st = new Table(Styles.black3);
    private static Table ct = new Table(Styles.none);
    private static Table ctTable = new Table();
    private static Table spt;
    private static Table sfpt;
    private static Table spawnerTable;
    private static Table flyerTable;
    static float thisAmount;
    static float thisHealth;
    static float thisEffHealth;
    static float thisDps;
    static int totalAmount;
    static int totalHealth;
    static int totalEffHealth;
    static int totalDps;
    static int tableCount;
    static final int maxLoop = 200;
    static int forwardIndex;
    static Seq<Building> forwardBuild;
    public static Seq<Point> path;
    public static Seq<Point> source;

    public static void arcScan() {
        arcScanMode.detailCursor();
        arcScanMode.detailSpawner();
        arcScanMode.detailTransporter2();
        arcScanMode.findLogic();
        ARCUnits.drawControlTurret();
    }

    private static void detailCursor() {
        arcScanMode.ct.visible = arcScanMode.ct.visible && Vars.state.isPlaying();
        ctTable.clear();
        if (!Vars.control.input.arcScanMode) {
            arcScanMode.ct.visible = false;
            return;
        }
        ct.setPosition(Core.input.mouseX(), Core.input.mouseY());
        arcScanMode.ct.visible = true;
        ctTable.table(ctt -> {
            ctt.add((int)(Core.input.mouseWorldX() / 8.0f) + "," + (int)(Core.input.mouseWorldY() / 8.0f));
            ctt.row();
            ctt.add("\u8ddd\u79bb\uff1a" + (int)(Mathf.dst(Vars.player.x, Vars.player.y, Core.input.mouseWorldX(), Core.input.mouseWorldY()) / 8.0f));
        });
    }

    private static void detailSpawner() {
        arcScanMode.spt.visible = arcScanMode.spt.visible && Vars.state.isPlaying();
        arcScanMode.sfpt.visible = arcScanMode.sfpt.visible && Vars.state.isPlaying();
        spawnerTable.clear();
        flyerTable.clear();
        if (!Vars.control.input.arcScanMode || arcWaveSpawner.arcWave.isEmpty()) {
            arcScanMode.spt.visible = false;
            arcScanMode.sfpt.visible = false;
            return;
        }
        totalAmount = 0;
        totalHealth = 0;
        totalEffHealth = 0;
        totalDps = 0;
        arcWaveSpawner.checkInit();
        arcWaveSpawner.waveInfo thisWave = arcWaveSpawner.arcWave.get(Math.min(Vars.state.wave - 1, Math.max(arcWaveSpawner.arcWave.size - 1, 0)));
        for (Tile tile : Vars.spawner.getSpawns()) {
            if (!(Mathf.dst(tile.worldx(), tile.worldy(), Core.input.mouseWorldX(), Core.input.mouseWorldY()) < Vars.state.rules.dropZoneRadius)) continue;
            float curve = Mathf.curve(Time.time % 240.0f, 120.0f, 240.0f);
            Draw.z(108.0f);
            Draw.color(Vars.state.rules.waveTeam.color);
            Lines.stroke(4.0f);
            float flyerAngle = Angles.angle((float)Vars.world.width() / 2.0f, (float)Vars.world.height() / 2.0f, tile.x, tile.y);
            float trns = (float)Math.max(Vars.world.width(), Vars.world.height()) * Mathf.sqrt2 * 8.0f;
            float spawnX = Mathf.clamp((float)(Vars.world.width() * 8) / 2.0f + Angles.trnsx(flyerAngle, trns), 0.0f, (float)(Vars.world.width() * 8));
            float spawnY = Mathf.clamp((float)(Vars.world.height() * 8) / 2.0f + Angles.trnsy(flyerAngle, trns), 0.0f, (float)(Vars.world.height() * 8));
            if (arcWaveSpawner.hasFlyer) {
                Lines.line(tile.worldx(), tile.worldy(), spawnX, spawnY);
                Tmp.v1.set(spawnX - tile.worldx(), spawnY - tile.worldy());
                Tmp.v1.setLength(Tmp.v1.len() * curve);
                Fill.circle(tile.worldx() + Tmp.v1.x, tile.worldy() + Tmp.v1.y, 8.0f);
                Vec2 v = Core.camera.project(spawnX, spawnY);
                sfpt.setPosition(v.x, v.y);
                arcScanMode.sfpt.visible = true;
                flyerTable.table(Styles.black3, tt -> {
                    tt.add(RFuncs.calWaveTimer()).row();
                    thisWave.specLoc(tile.pos(), group -> group.type.flying);
                    tt.add(thisWave.proTable(false));
                    tt.row();
                    tt.add(thisWave.unitTable(tile.pos(), group -> group.type.flying)).maxWidth(Vars.mobile ? 400.0f : 750.0f).growX();
                });
            }
            totalAmount = 0;
            totalHealth = 0;
            totalEffHealth = 0;
            totalDps = 0;
            if (curve > 0.0f) {
                Lines.circle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius * Interp.pow3Out.apply(curve));
            }
            Lines.circle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
            Lines.arc(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius - 3.0f, Vars.state.wavetime / Vars.state.rules.waveSpacing, 90.0f);
            float angle = 1.5707964f + Vars.state.wavetime / Vars.state.rules.waveSpacing * 2.0f * (float)Math.PI;
            Draw.color(Vars.state.rules.waveTeam.color);
            Fill.circle(tile.worldx() + Vars.state.rules.dropZoneRadius * Mathf.cos(angle), tile.worldy() + Vars.state.rules.dropZoneRadius * Mathf.sin(angle), 8.0f);
            Vec2 v = Core.camera.project(tile.worldx(), tile.worldy());
            spt.setPosition(v.x, v.y);
            arcScanMode.spt.visible = true;
            spawnerTable.table(Styles.black3, tt -> {
                tt.add(RFuncs.calWaveTimer()).row();
                thisWave.specLoc(tile.pos(), group -> !group.type.flying);
                tt.add(thisWave.proTable(false));
                tt.row();
                tt.add(thisWave.unitTable(tile.pos(), group -> !group.type.flying)).maxWidth(Vars.mobile ? 400.0f : 750.0f).growX();
            });
            return;
        }
        arcScanMode.spt.visible = false;
        spawnerTable.clear();
    }

    private static void findLogic() {
        UnitController unitController;
        Unit u;
        if (!Core.input.keyTap(Binding.select) || !Vars.control.input.arcScanMode) {
            return;
        }
        Tile hoverTile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (hoverTile != null && hoverTile.build != null && hoverTile.build.displayable() && !hoverTile.build.inFogTo(Vars.player.team()) && hoverTile.build.lastLogicController != null) {
            RFuncs.arcSetCamera(hoverTile.build.lastLogicController);
        }
        if ((u = Vars.control.input.selectedUnit()) != null && (unitController = u.controller()) instanceof LogicAI) {
            LogicAI ai = (LogicAI)unitController;
            if (ai.controller != null && ai.controller.isValid()) {
                RFuncs.arcSetCamera(ai.controller);
            }
        }
    }

    private static void forward(Building cur, Building last) {
        arcScanMode.forward(cur, last, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void forward(Building cur, Building last, int conduit) {
        MassDriver.MassDriverBuild massDriverBuild;
        if (forwardIndex == 200) return;
        if (cur == null) return;
        if (conduit == 3) {
            return;
        }
        if (last.team != cur.team) return;
        if (cur.team != Vars.player.team() && cur.inFogTo(Vars.player.team())) {
            return;
        }
        if (cur.block.itemCapacity == 0 && !cur.block.instantTransfer) {
            return;
        }
        if (cur instanceof LiquidJunction.LiquidJunctionBuild) {
            return;
        }
        ++forwardIndex;
        Draw.color(Color.gold);
        Lines.stroke(1.5f);
        float dst = Mathf.dst(last.tile.worldx(), last.tile.worldy(), cur.tile.worldx(), cur.tile.worldy());
        Lines.line(last.tile.worldx(), last.tile.worldy(), cur.tile.worldx(), cur.tile.worldy());
        Fill.circle(cur.tile.worldx(), cur.tile.worldy(), 2.0f);
        if (dst > 8.0f) {
            Draw.color(Color.orange);
            Drawf.simpleArrow(last.tile.worldx(), last.tile.worldy(), cur.tile.worldx(), cur.tile.worldy(), dst / 2.0f, 4.0f);
        }
        if (cur.block.group != BlockGroup.transportation && arcScanMode.canAccept(cur.block)) {
            Drawf.selected(cur, Tmp.c1.set(Color.red).a(Mathf.absin(4.0f, 1.0f) * 0.5f + 0.5f));
        }
        if (!forwardBuild.addUnique(cur)) {
            return;
        }
        conduit = cur.block.instantTransfer ? conduit + 1 : 0;
        byte from = cur.relativeToEdge(last.tile);
        if (cur instanceof CoreBlock.CoreBuild || cur instanceof StorageBlock.StorageBuild) {
            Drawf.selected(cur, Tmp.c1.set(Color.red).a(Mathf.absin(4.0f, 1.0f) * 0.5f + 0.5f));
            return;
        }
        if (cur instanceof OverflowGate.OverflowGateBuild || cur instanceof Router.RouterBuild || cur instanceof DuctRouter.DuctRouterBuild) {
            arcScanMode.dumpForward(cur, last, conduit);
            return;
        }
        if (cur instanceof Sorter.SorterBuild) {
            Sorter.SorterBuild sb = (Sorter.SorterBuild)cur;
            if (sb.sortItem != null || !((Sorter)sb.block).invert) {
                arcScanMode.forward(cur.nearby((from + 1) % 4), cur, conduit);
            }
            if (sb.sortItem != null || ((Sorter)sb.block).invert) {
                arcScanMode.forward(cur.nearby((from + 2) % 4), cur, conduit);
            }
            if (sb.sortItem == null) {
                if (((Sorter)sb.block).invert) return;
            }
            arcScanMode.forward(cur.nearby((from + 3) % 4), cur, conduit);
            return;
        }
        if (cur instanceof DuctBridge.DuctBridgeBuild) {
            DuctBridge.DuctBridgeBuild ductBridgeBuild = (DuctBridge.DuctBridgeBuild)cur;
            if (ductBridgeBuild.arcLinkValid()) {
                arcScanMode.forward(ductBridgeBuild.findLink(), cur);
                return;
            }
            arcScanMode.forward(cur.front(), cur);
            return;
        }
        if (cur instanceof ItemBridge.ItemBridgeBuild) {
            ItemBridge.ItemBridgeBuild itemBridgeBuild = (ItemBridge.ItemBridgeBuild)cur;
            if (!(cur instanceof LiquidBridge.LiquidBridgeBuild)) {
                if (Vars.world.tile(itemBridgeBuild.link) != null) {
                    arcScanMode.forward(Vars.world.tile((int)itemBridgeBuild.link).build, cur);
                    return;
                }
                if (itemBridgeBuild.incoming.size == 0) {
                    return;
                }
                arcScanMode.dumpNearby(cur, last, conduit);
                return;
            }
        }
        if (cur instanceof MassDriver.MassDriverBuild && (massDriverBuild = (MassDriver.MassDriverBuild)cur).arcLinkValid()) {
            arcScanMode.forward(Vars.world.tile((int)massDriverBuild.link).build, cur);
            if (massDriverBuild.state != MassDriver.DriverState.idle) {
                if (massDriverBuild.state != MassDriver.DriverState.accepting) return;
            }
            arcScanMode.dumpNearby(cur, last, conduit);
            return;
        }
        if (!(cur instanceof Conveyor.ConveyorBuild || cur instanceof Duct.DuctBuild || cur instanceof StackConveyor.StackConveyorBuild)) {
            if (!(cur instanceof Junction.JunctionBuild)) return;
            arcScanMode.forward(cur.nearby((from + 2) % 4), cur, conduit);
            return;
        }
        arcScanMode.forward(cur.front(), cur);
        if (!(cur instanceof StackConveyor.StackConveyorBuild)) return;
        StackConveyor.StackConveyorBuild stackConveyorBuild = (StackConveyor.StackConveyorBuild)cur;
        if (stackConveyorBuild.state != 2) return;
        arcScanMode.dumpForward(cur, last, conduit);
    }

    private static void dumpForward(Building cur, Building last, int conduit) {
        byte from = cur.relativeToEdge(last.tile);
        arcScanMode.forward(cur.nearby((from + 1) % 4), cur, conduit);
        arcScanMode.forward(cur.nearby((from + 2) % 4), cur, conduit);
        arcScanMode.forward(cur.nearby((from + 3) % 4), cur, conduit);
    }

    private static void dumpNearby(Building cur, Building last, int conduit) {
        cur.proximity.each(building -> {
            if (cur.canDump((Building)building, Items.copper) && building != null && arcScanMode.canAccept(building.block)) {
                arcScanMode.forward(building, cur, conduit);
            }
        });
    }

    private static boolean canAccept(Block block) {
        if (block.group == BlockGroup.transportation) {
            return true;
        }
        for (Item item : Vars.content.items()) {
            if (!block.consumesItem(item) && block.itemCapacity <= 0) continue;
            return true;
        }
        return false;
    }

    public static void detailTransporter2() {
        if (!Vars.control.input.arcScanMode) {
            return;
        }
        Tile hoverTile = Vars.world.tileWorld(Core.input.mouseWorld().x, Core.input.mouseWorld().y);
        if (hoverTile == null || hoverTile.build == null || !hoverTile.build.isDiscovered(Vars.player.team())) {
            return;
        }
        path.clear();
        source.clear();
        arcScanMode.getBackwardPath(new Point(hoverTile.build, null));
        arcScanMode.drawPath(false);
        path.clear();
        source.clear();
        arcScanMode.getForwardPath(new Point(hoverTile.build, null));
        arcScanMode.drawPath(true);
    }

    public static void getBackwardPath(Point point) {
        if (point.build == null || arcScanMode.path.size > 200) {
            return;
        }
        if (!point.trans) {
            source.add(point);
            return;
        }
        Point same = path.find(other -> point.build == other.build && (other.from == null || point.from.build == other.from.build));
        if (same != null) {
            if (point.conduit >= same.conduit) {
                return;
            }
            path.replace(same, point);
        } else {
            path.add(point);
        }
        Seq<Point> previous = arcScanMode.getPrevious(point);
        if (previous.any()) {
            previous.each(arcScanMode::getBackwardPath);
        } else {
            source.add(point);
        }
    }

    public static void getForwardPath(Point point) {
        if (point.build == null || arcScanMode.path.size > 200) {
            return;
        }
        if (!point.trans) {
            source.add(point);
            return;
        }
        Point same = path.find(other -> point.build == other.build && (other.from == null || point.from.build == other.from.build));
        if (same != null) {
            if (point.conduit >= same.conduit) {
                return;
            }
            path.replace(same, point);
        } else {
            path.add(point);
        }
        Seq<Point> next = arcScanMode.getNext(point);
        if (next.any()) {
            next.each(arcScanMode::getForwardPath);
        } else {
            source.add(point);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static Seq<Point> getPrevious(Point point) {
        block7: {
            build = point.build;
            if (build == null) {
                return new Seq<Point>();
            }
            previous = new Seq<Point>();
            if (build instanceof MassDriver.MassDriverBuild) break block7;
            if (!(build instanceof ItemBridge.ItemBridgeBuild)) ** GOTO lbl-1000
            bridge = (ItemBridge.ItemBridgeBuild)build;
            if (!(build instanceof LiquidBridge.LiquidBridgeBuild)) {
                bridge.incoming.each((Intc)LambdaMetafactory.metafactory(null, null, null, (I)V, lambda$getPrevious$13(arc.struct.Seq mindustry.arcModule.toolpack.arcScanMode$Point int ), (I)V)(previous, (Point)point));
            } else if (build instanceof DirectionBridge.DirectionBridgeBuild) {
                bridge = (DirectionBridge.DirectionBridgeBuild)build;
                for (DirectionBridge.DirectionBridgeBuild b : bridge.occupied) {
                    if (b == null) continue;
                    previous.add(new Point(b, point));
                }
            }
        }
        for (Building b : build.proximity) {
            from = new Point(b, b.relativeTo(build), b.block.instantTransfer != false ? point.conduit + 1 : 0, point);
            if (arcScanMode.canInput(point, b, true) && arcScanMode.canOutput(from, build, false)) {
                previous.add(from);
                continue;
            }
            if (!arcScanMode.canOutput(from, build, false)) continue;
            from.trans = false;
            previous.add(from);
        }
        return previous;
    }

    /*
     * Unable to fully structure code
     */
    public static Seq<Point> getNext(Point point) {
        block9: {
            block8: {
                build = point.build;
                if (build == null) {
                    return new Seq<Point>();
                }
                next = new Seq<Point>();
                if (!(build instanceof MassDriver.MassDriverBuild)) break block8;
                massDriverBuild = (MassDriver.MassDriverBuild)build;
                if (massDriverBuild.arcLinkValid()) {
                    next.add(new Point(Vars.world.build(massDriverBuild.link), point));
                }
                break block9;
            }
            if (!(build instanceof ItemBridge.ItemBridgeBuild)) ** GOTO lbl-1000
            itemBridgeBuild = (ItemBridge.ItemBridgeBuild)build;
            if (!(build instanceof LiquidBridge.LiquidBridgeBuild)) {
                if (itemBridgeBuild.arcLinkValid()) {
                    next.add(new Point(Vars.world.build(itemBridgeBuild.link), point));
                }
            } else if (build instanceof DirectionBridge.DirectionBridgeBuild && (link = (directionBridgeBuild = (DirectionBridge.DirectionBridgeBuild)build).findLink()) != null) {
                next.add(new Point(link, point));
            }
        }
        for (Building b : build.proximity) {
            to = new Point(b, build.relativeTo(b), b.block.instantTransfer != false ? point.conduit + 1 : 0, point);
            if (arcScanMode.canInput(to, build, false) && arcScanMode.canOutput(point, b, true)) {
                next.add(to);
                continue;
            }
            if (!arcScanMode.canInput(to, build, false)) continue;
            to.trans = false;
            next.add(to);
        }
        return next;
    }

    public static boolean canInput(Point point, Building from, boolean active) {
        Building build = point.build;
        if (build == null || from == null) {
            return false;
        }
        if (from.block.instantTransfer && point.conduit > 2) {
            return false;
        }
        if (build instanceof ArmoredConveyor.ArmoredConveyorBuild) {
            return from != build.front() && (from instanceof Conveyor.ConveyorBuild || from == build.back());
        }
        if (build instanceof Duct.DuctBuild) {
            Duct.DuctBuild ductBuild = (Duct.DuctBuild)build;
            if (((Duct)ductBuild.block).armored) {
                return from != build.front() && (from.block.isDuct || from == build.back());
            }
        }
        if (build instanceof Conveyor.ConveyorBuild || build instanceof Duct.DuctBuild) {
            return from != build.front();
        }
        if (build instanceof StackConveyor.StackConveyorBuild) {
            boolean bl;
            StackConveyor.StackConveyorBuild stackConveyorBuild = (StackConveyor.StackConveyorBuild)build;
            switch (stackConveyorBuild.state) {
                case 2: {
                    if (from == build.back() && from instanceof StackConveyor.StackConveyorBuild) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 1: {
                    if (from != build.front()) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = from instanceof StackConveyor.StackConveyorBuild;
                }
            }
            return bl;
        }
        if (build instanceof Junction.JunctionBuild) {
            return point.facing == -1 || from.relativeTo(build) == point.facing;
        }
        if (build instanceof Sorter.SorterBuild) {
            Sorter.SorterBuild sorterBuild = (Sorter.SorterBuild)build;
            return !active || build.relativeTo(from) != point.facing && (sorterBuild.sortItem != null || from.relativeTo(build) == point.facing == ((Sorter)sorterBuild.block).invert);
        }
        if (build instanceof OverflowGate.OverflowGateBuild) {
            return !active || build.relativeTo(from) != point.facing;
        }
        if (build instanceof DuctRouter.DuctRouterBuild || build instanceof OverflowDuct.OverflowDuctBuild) {
            return from == build.back();
        }
        if (build instanceof ItemBridge.ItemBridgeBuild) {
            ItemBridge.ItemBridgeBuild itemBridgeBuild = (ItemBridge.ItemBridgeBuild)build;
            return itemBridgeBuild.arcCheckAccept(from);
        }
        if (build instanceof DirectionBridge.DirectionBridgeBuild) {
            DirectionBridge.DirectionBridgeBuild directionBridgeBuild = (DirectionBridge.DirectionBridgeBuild)build;
            return directionBridgeBuild.arcCheckAccept(from);
        }
        if (build instanceof Router.RouterBuild) {
            return true;
        }
        if (arcScanMode.canAccept(build.block)) {
            point.trans = false;
            return true;
        }
        return false;
    }

    public static boolean canOutput(Point point, Building to, boolean active) {
        Building build = point.build;
        if (build == null || to == null) {
            return false;
        }
        if (to.block.instantTransfer && point.conduit > 2) {
            return false;
        }
        if (build instanceof Conveyor.ConveyorBuild || build instanceof Duct.DuctBuild) {
            return to == build.front();
        }
        if (build instanceof StackConveyor.StackConveyorBuild) {
            StackConveyor.StackConveyorBuild stackConveyor = (StackConveyor.StackConveyorBuild)build;
            if (stackConveyor.state == 2 && ((StackConveyor)stackConveyor.block).outputRouter) {
                return to != build.back();
            }
            return to == build.front();
        }
        if (build instanceof Junction.JunctionBuild) {
            return point.facing == -1 || build.relativeTo(to) == point.facing;
        }
        if (build instanceof Sorter.SorterBuild) {
            Sorter.SorterBuild sorterBuild = (Sorter.SorterBuild)build;
            return !active || to.relativeTo(build) != point.facing && (sorterBuild.sortItem != null || build.relativeTo(to) == point.facing == ((Sorter)sorterBuild.block).invert);
        }
        if (build instanceof OverflowGate.OverflowGateBuild) {
            return !active || to.relativeTo(build) != point.facing;
        }
        if (build instanceof DuctRouter.DuctRouterBuild || build instanceof OverflowDuct.OverflowDuctBuild) {
            return to != build.back();
        }
        if (build instanceof ItemBridge.ItemBridgeBuild) {
            ItemBridge.ItemBridgeBuild bridge = (ItemBridge.ItemBridgeBuild)build;
            return bridge.arcCheckDump(to);
        }
        if (build instanceof DirectionBridge.DirectionBridgeBuild) {
            DirectionBridge.DirectionBridgeBuild directionBridgeBuild = (DirectionBridge.DirectionBridgeBuild)build;
            DirectionBridge.DirectionBridgeBuild link = directionBridgeBuild.findLink();
            return link == null && build.relativeTo(to) == build.rotation;
        }
        if (build instanceof Router.RouterBuild || build instanceof Unloader.UnloaderBuild) {
            return true;
        }
        if (build instanceof GenericCrafter.GenericCrafterBuild) {
            point.trans = false;
            return true;
        }
        return false;
    }

    public static void drawPath(boolean forward) {
        Color mainColor = forward ? Color.valueOf("80ff00") : Color.valueOf("ff8000");
        Color highlightColor = forward ? Color.valueOf("00cc00") : Color.red;
        path.each(p -> {
            if (p.from != null && p.trans) {
                float x1 = p.build.tile.drawx();
                float y1 = p.build.tile.drawy();
                float x2 = p.from.build.tile.drawx();
                float y2 = p.from.build.tile.drawy();
                Draw.color(mainColor);
                Draw.color(Tmp.c1.set(mainColor).a(Mathf.absin(4.0f, 1.0f) * 0.4f + 0.6f));
                Lines.stroke(1.5f);
                Lines.line(x1, y1, x2, y2);
            } else {
                Drawf.selected(p.build, Tmp.c1.set(highlightColor).a(Mathf.absin(4.0f, 1.0f) * 0.5f + 0.5f));
            }
            Draw.reset();
        });
        path.each(p -> {
            if (p.from != null && p.trans) {
                float x1 = p.build.tile.drawx();
                float y1 = p.build.tile.drawy();
                float x2 = p.from.build.tile.drawx();
                float y2 = p.from.build.tile.drawy();
                float dst = Mathf.dst(x1, y1, x2, y2);
                Draw.color(highlightColor);
                Fill.circle(x1, y1, 1.8f);
                if (dst > 8.0f) {
                    Draw.color(highlightColor);
                    if (forward) {
                        Drawf.simpleArrow(x2, y2, x1, y1, dst / 2.0f, 3.0f);
                    } else {
                        Drawf.simpleArrow(x1, y1, x2, y2, dst / 2.0f, 3.0f);
                    }
                }
            }
            Draw.reset();
        });
    }

    private static /* synthetic */ void lambda$getPrevious$13(Seq previous, Point point, int pos) {
        previous.add(new Point(Vars.world.tile((int)pos).build, point));
    }

    static {
        spawnerTable = new Table();
        flyerTable = new Table();
        totalAmount = 0;
        totalHealth = 0;
        totalEffHealth = 0;
        totalDps = 0;
        tableCount = 0;
        forwardIndex = 0;
        forwardBuild = new Seq();
        arcScanMode.ct.touchable = Touchable.disabled;
        arcScanMode.ct.visible = false;
        ct.add(ctTable).margin(8.0f);
        ct.pack();
        ct.update(() -> {
            arcScanMode.ct.visible = arcScanMode.ct.visible && Vars.state.isPlaying();
        });
        Core.scene.add(ct);
        spt = new Table();
        arcScanMode.spt.touchable = Touchable.disabled;
        arcScanMode.spt.visible = false;
        spt.add(spawnerTable).margin(8.0f);
        spt.pack();
        spt.update(() -> {
            arcScanMode.spt.visible = arcScanMode.spt.visible && Vars.state.isPlaying();
        });
        Core.scene.add(spt);
        sfpt = new Table();
        arcScanMode.sfpt.touchable = Touchable.disabled;
        arcScanMode.sfpt.visible = false;
        sfpt.add(flyerTable).margin(8.0f);
        sfpt.pack();
        sfpt.update(() -> {
            arcScanMode.sfpt.visible = arcScanMode.sfpt.visible && Vars.state.isPlaying();
        });
        Core.scene.add(sfpt);
        path = new Seq();
        source = new Seq();
    }

    public static class Point {
        public Building build;
        public byte facing = (byte)-1;
        public int conduit = 0;
        public boolean trans = true;
        public Point from;

        public Point(Building build, Point from) {
            this.build = build;
            this.from = from;
        }

        public Point(Building build, byte facing, int conduit, Point from) {
            this.build = build;
            this.facing = facing;
            this.conduit = conduit;
            this.from = from;
        }
    }
}

