/*
 * Decompiled with CFR 0.152.
 */
package mindustry.arcModule.toolpack;

import arc.Core;
import arc.Events;
import arc.scene.ui.Dialog;
import java.lang.reflect.Field;
import mindustry.arcModule.ARCVars;
import mindustry.arcModule.ElementUtils;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.game.EventType;
import mindustry.ui.dialogs.BaseDialog;

public class arcPlayerEffect {
    public static Effect playerEffect = Fx.none;
    public static float effectChance = 0.0f;
    private static int effectTime = 0;
    private static int effectCooldown = 1;
    private static Effect refEffect = Fx.none;
    public static boolean show = true;
    private static int curCounter = 0;

    public static void arcPlayerEffectSetting() {
        BaseDialog efTable = new BaseDialog("\u73a9\u5bb6\u7279\u6548\u8bbe\u7f6e");
        ElementUtils.arcSliderTable(efTable.cont, "\u7279\u6548\u6982\u7387", effectChance, 0.0f, 1.0f, 0.05f, i -> (int)(i * 100.0f) + "%", s -> {
            effectChance = s.floatValue();
        });
        ElementUtils.arcSliderTableInt(efTable.cont, "\u7279\u6548\u95f4\u9694", effectCooldown, 1, 30, 1, i -> "\u6bcf" + i + "\u5e27", s -> {
            effectCooldown = s;
        });
        ElementUtils.arcSliderTableInt(efTable.cont, "\u7279\u6548\u65f6\u957f", (int)arcPlayerEffect.playerEffect.lifetime, 0, 300, 5, i -> i + "\u5e27", s -> {
            arcPlayerEffect.playerEffect.lifetime = s.intValue();
            effectTime = s;
        });
        efTable.cont.pane(tt -> {
            for (Field field : Fx.class.getDeclaredFields()) {
                Effect thisEffect;
                if (field.getGenericType() != Effect.class) continue;
                try {
                    thisEffect = (Effect)field.get(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                tt.check(field.getName(), refEffect == thisEffect, a -> {
                    playerEffect = thisEffect;
                    refEffect = thisEffect;
                    arcPlayerEffect.playerEffect.lifetime = effectTime;
                }).left().row();
            }
        });
        ((Dialog)efTable).addCloseButton();
        efTable.buttons.button("\u4fdd\u5b58", arcPlayerEffect::saveConfig);
        efTable.buttons.button("\u8bfb\u53d6", arcPlayerEffect::readConfig);
        efTable.show();
    }

    private static void saveConfig() {
        Core.settings.put("arcPlayerEffectPro", Float.valueOf(effectChance));
        Core.settings.put("arcPlayerEffectTime", Float.valueOf(arcPlayerEffect.playerEffect.lifetime));
        Core.settings.put("arcPlayerEffectType", arcPlayerEffect.refEffect.id);
        Core.settings.put("arcPlayerEffectCooldown", effectCooldown);
        ARCVars.arcui.arcInfo("[cyan]\u5df2\u4fdd\u5b58\u8bbe\u7f6e");
    }

    private static void readConfig() {
        effectChance = Core.settings.getFloat("arcPlayerEffectPro");
        playerEffect = refEffect = Effect.get(Core.settings.getInt("arcPlayerEffectType"));
        arcPlayerEffect.playerEffect.lifetime = Core.settings.getFloat("arcPlayerEffectTime");
        effectTime = (int)arcPlayerEffect.playerEffect.lifetime;
        effectCooldown = Core.settings.getInt("arcPlayerEffectCooldown");
        ARCVars.arcui.arcInfo("[cyan]\u5df2\u8bfb\u53d6\u8bbe\u7f6e");
    }

    static {
        Events.run((Object)EventType.Trigger.update, () -> {
            if (++curCounter >= effectCooldown) {
                curCounter = 0;
                show = true;
            } else {
                show = false;
            }
        });
        Events.on(EventType.WorldLoadEvent.class, event -> arcPlayerEffect.readConfig());
    }
}

